package build

import (
	"github.com/docker-slim/docker-slim/pkg/app/master/commands"

	"github.com/c-bata/go-prompt"
)

var CommandSuggestion = prompt.Suggest{
	Text:        Name,
	Description: Usage,
}

var CommandFlagSuggestions = &commands.FlagSuggestions{
	Names: []prompt.Suggest{
		{Text: commands.FullFlagName(commands.FlagTarget), Description: commands.FlagTargetUsage},
		{Text: commands.FullFlagName(commands.FlagComposeFile), Description: commands.FlagComposeFileUsage},
		{Text: commands.FullFlagName(commands.FlagTargetComposeSvc), Description: commands.FlagTargetComposeSvcUsage},
		{Text: commands.FullFlagName(commands.FlagTargetComposeSvcImage), Description: commands.FlagTargetComposeSvcImageUsage},
		{Text: commands.FullFlagName(commands.FlagComposeSvcStartWait), Description: commands.FlagComposeSvcStartWaitUsage},
		{Text: commands.FullFlagName(commands.FlagDepIncludeComposeSvc), Description: commands.FlagDepIncludeComposeSvcUsage},
		{Text: commands.FullFlagName(commands.FlagDepExcludeComposeSvc), Description: commands.FlagDepExcludeComposeSvcUsage},
		{Text: commands.FullFlagName(commands.FlagDepIncludeComposeSvcDeps), Description: commands.FlagDepIncludeComposeSvcDepsUsage},
		{Text: commands.FullFlagName(commands.FlagComposeNet), Description: commands.FlagComposeNetUsage},
		{Text: commands.FullFlagName(commands.FlagDepIncludeTargetComposeSvcDeps), Description: commands.FlagDepIncludeTargetComposeSvcDepsUsage},
		{Text: commands.FullFlagName(commands.FlagComposeEnvNoHost), Description: commands.FlagComposeEnvNoHostUsage},
		{Text: commands.FullFlagName(commands.FlagComposeEnvFile), Description: commands.FlagComposeEnvFileUsage},
		{Text: commands.FullFlagName(commands.FlagComposeProjectName), Description: commands.FlagComposeProjectNameUsage},
		{Text: commands.FullFlagName(commands.FlagComposeWorkdir), Description: commands.FlagComposeWorkdirUsage},
		{Text: commands.FullFlagName(commands.FlagContainerProbeComposeSvc), Description: commands.FlagContainerProbeComposeSvcUsage},
		{Text: commands.FullFlagName(commands.FlagTargetKubeWorkload), Description: commands.FlagTargetKubeWorkloadUsage},
		{Text: commands.FullFlagName(commands.FlagTargetKubeWorkloadNamespace), Description: commands.FlagTargetKubeWorkloadNamespaceUsage},
		{Text: commands.FullFlagName(commands.FlagTargetKubeWorkloadContainer), Description: commands.FlagTargetKubeWorkloadContainerUsage},
		{Text: commands.FullFlagName(commands.FlagTargetKubeWorkloadImage), Description: commands.FlagTargetKubeWorkloadImageUsage},
		{Text: commands.FullFlagName(commands.FlagKubeManifestFile), Description: commands.FlagKubeManifestFileUsage},
		{Text: commands.FullFlagName(commands.FlagKubeKubeconfigFile), Description: commands.FlagKubeKubeconfigFileUsage},
		{Text: commands.FullFlagName(commands.FlagPull), Description: commands.FlagPullUsage},
		{Text: commands.FullFlagName(commands.FlagShowPullLogs), Description: commands.FlagShowPullLogsUsage},
		{Text: commands.FullFlagName(commands.FlagRegistryAccount), Description: commands.FlagRegistryAccountUsage},
		{Text: commands.FullFlagName(commands.FlagRegistrySecret), Description: commands.FlagRegistrySecretUsage},
		{Text: commands.FullFlagName(commands.FlagDockerConfigPath), Description: commands.FlagDockerConfigPathUsage},
		{Text: commands.FullFlagName(FlagShowBuildLogs), Description: FlagShowBuildLogsUsage},
		{Text: commands.FullFlagName(commands.FlagShowContainerLogs), Description: commands.FlagShowContainerLogsUsage},
		{Text: commands.FullFlagName(commands.FlagCRORuntime), Description: commands.FlagCRORuntimeUsage},
		{Text: commands.FullFlagName(commands.FlagCROHostConfigFile), Description: commands.FlagCROHostConfigFileUsage},
		{Text: commands.FullFlagName(commands.FlagCROSysctl), Description: commands.FlagCROSysctlUsage},
		{Text: commands.FullFlagName(commands.FlagCROShmSize), Description: commands.FlagCROShmSizeUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeOff), Description: commands.FlagHTTPProbeOffUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbe), Description: commands.FlagHTTPProbeUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeCmd), Description: commands.FlagHTTPProbeCmdUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeCmdFile), Description: commands.FlagHTTPProbeCmdFileUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeStartWait), Description: commands.FlagHTTPProbeStartWaitUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeRetryCount), Description: commands.FlagHTTPProbeRetryCountUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeRetryWait), Description: commands.FlagHTTPProbeRetryWaitUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbePorts), Description: commands.FlagHTTPProbePortsUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeFull), Description: commands.FlagHTTPProbeFullUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeExitOnFailure), Description: commands.FlagHTTPProbeExitOnFailureUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeCrawl), Description: commands.FlagHTTPProbeCrawlUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPCrawlMaxDepth), Description: commands.FlagHTTPCrawlMaxDepthUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPCrawlMaxPageCount), Description: commands.FlagHTTPCrawlMaxPageCountUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPCrawlConcurrency), Description: commands.FlagHTTPCrawlConcurrencyUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPMaxConcurrentCrawlers), Description: commands.FlagHTTPMaxConcurrentCrawlersUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeAPISpec), Description: commands.FlagHTTPProbeAPISpecUsage},
		{Text: commands.FullFlagName(commands.FlagHTTPProbeAPISpecFile), Description: commands.FlagHTTPProbeAPISpecFileUsage},
		{Text: commands.FullFlagName(commands.FlagPublishPort), Description: commands.FlagPublishPortUsage},
		{Text: commands.FullFlagName(commands.FlagPublishExposedPorts), Description: commands.FlagPublishExposedPortsUsage},
		{Text: commands.FullFlagName(commands.FlagHostExec), Description: commands.FlagHostExecUsage},
		{Text: commands.FullFlagName(commands.FlagHostExecFile), Description: commands.FlagHostExecFileUsage},
		{Text: commands.FullFlagName(FlagKeepPerms), Description: FlagKeepPermsUsage},
		{Text: commands.FullFlagName(commands.FlagRunTargetAsUser), Description: commands.FlagRunTargetAsUserUsage},
		{Text: commands.FullFlagName(commands.FlagCopyMetaArtifacts), Description: commands.FlagCopyMetaArtifactsUsage},
		{Text: commands.FullFlagName(commands.FlagRemoveFileArtifacts), Description: commands.FlagRemoveFileArtifactsUsage},
		{Text: commands.FullFlagName(FlagTag), Description: FlagTagUsage},
		{Text: commands.FullFlagName(FlagImageOverrides), Description: FlagImageOverridesUsage},
		{Text: commands.FullFlagName(commands.FlagUser), Description: commands.FlagUserUsage},
		{Text: commands.FullFlagName(commands.FlagEntrypoint), Description: commands.FlagEntrypointUsage},
		{Text: commands.FullFlagName(commands.FlagCmd), Description: commands.FlagCmdUsage},
		{Text: commands.FullFlagName(commands.FlagWorkdir), Description: commands.FlagWorkdirUsage},
		{Text: commands.FullFlagName(commands.FlagEnv), Description: commands.FlagEnvUsage},
		{Text: commands.FullFlagName(commands.FlagLabel), Description: commands.FlagLabelUsage},
		{Text: commands.FullFlagName(commands.FlagVolume), Description: commands.FlagVolumeUsage},
		{Text: commands.FullFlagName(commands.FlagLink), Description: commands.FlagLinkUsage},
		{Text: commands.FullFlagName(commands.FlagEtcHostsMap), Description: commands.FlagEtcHostsMapUsage},
		{Text: commands.FullFlagName(commands.FlagContainerDNS), Description: commands.FlagContainerDNSUsage},
		{Text: commands.FullFlagName(commands.FlagContainerDNSSearch), Description: commands.FlagContainerDNSSearchUsage},
		{Text: commands.FullFlagName(commands.FlagNetwork), Description: commands.FlagNetworkUsage},
		{Text: commands.FullFlagName(commands.FlagHostname), Description: commands.FlagHostnameUsage},
		{Text: commands.FullFlagName(commands.FlagExpose), Description: commands.FlagExposeUsage},
		{Text: commands.FullFlagName(FlagNewEntrypoint), Description: FlagNewEntrypointUsage},
		{Text: commands.FullFlagName(FlagNewCmd), Description: FlagNewCmdUsage},
		{Text: commands.FullFlagName(FlagNewExpose), Description: FlagNewExposeUsage},
		{Text: commands.FullFlagName(FlagNewWorkdir), Description: FlagNewWorkdirUsage},
		{Text: commands.FullFlagName(FlagNewEnv), Description: FlagNewEnvUsage},
		{Text: commands.FullFlagName(FlagNewVolume), Description: FlagNewVolumeUsage},
		{Text: commands.FullFlagName(FlagNewLabel), Description: FlagNewLabelUsage},
		{Text: commands.FullFlagName(FlagRemoveExpose), Description: FlagRemoveExposeUsage},
		{Text: commands.FullFlagName(FlagRemoveEnv), Description: FlagRemoveEnvUsage},
		{Text: commands.FullFlagName(FlagRemoveLabel), Description: FlagRemoveLabelUsage},
		{Text: commands.FullFlagName(FlagRemoveVolume), Description: FlagRemoveVolumeUsage},
		{Text: commands.FullFlagName(commands.FlagExcludeMounts), Description: commands.FlagExcludeMountsUsage},
		{Text: commands.FullFlagName(commands.FlagExcludePattern), Description: commands.FlagExcludePatternUsage},
		{Text: commands.FullFlagName(FlagPathPerms), Description: FlagPathPermsUsage},
		{Text: commands.FullFlagName(FlagPathPermsFile), Description: FlagPathPermsFileUsage},
		{Text: commands.FullFlagName(FlagPreservePath), Description: FlagPreservePathUsage},
		{Text: commands.FullFlagName(FlagPreservePathFile), Description: FlagPreservePathFileUsage},
		{Text: commands.FullFlagName(FlagIncludePath), Description: FlagIncludePathUsage},
		{Text: commands.FullFlagName(FlagIncludePathFile), Description: FlagIncludePathFileUsage},
		{Text: commands.FullFlagName(FlagIncludeBin), Description: FlagIncludeBinUsage},
		{Text: commands.FullFlagName(FlagIncludeBinFile), Description: FlagIncludeBinFileUsage},
		{Text: commands.FullFlagName(FlagIncludeExe), Description: FlagIncludeExeUsage},
		{Text: commands.FullFlagName(FlagIncludeExeFile), Description: FlagIncludeExeFileUsage},
		{Text: commands.FullFlagName(FlagIncludeShell), Description: FlagIncludeShellUsage},
		{Text: commands.FullFlagName(FlagIncludeWorkdir), Description: FlagIncludeWorkdirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppImageAll), Description: FlagIncludeAppImageAllUsage},
		{Text: commands.FullFlagName(FlagAppImageStartInstGroup), Description: FlagAppImageStartInstGroupUsage},
		{Text: commands.FullFlagName(FlagAppImageStartInst), Description: FlagAppImageStartInstUsage},
		{Text: commands.FullFlagName(FlagAppImageDockerfile), Description: FlagAppImageDockerfileUsage},
		{Text: commands.FullFlagName(FlagIncludePathsCreportFile), Description: FlagIncludePathsCreportFileUsage},
		{Text: commands.FullFlagName(FlagIncludeOSLibsNet), Description: FlagIncludeOSLibsNetUsage},
		{Text: commands.FullFlagName(FlagIncludeCertAll), Description: FlagIncludeCertAllUsage},
		{Text: commands.FullFlagName(FlagIncludeCertBundles), Description: FlagIncludeCertBundlesUsage},
		{Text: commands.FullFlagName(FlagIncludeCertDirs), Description: FlagIncludeCertDirsUsage},
		{Text: commands.FullFlagName(FlagIncludeCertPKAll), Description: FlagIncludeCertPKAllUsage},
		{Text: commands.FullFlagName(FlagIncludeCertPKDirs), Description: FlagIncludeCertPKDirsUsage},
		{Text: commands.FullFlagName(FlagIncludeNew), Description: FlagIncludeNewUsage},
		{Text: commands.FullFlagName(commands.FlagMount), Description: commands.FlagMountUsage},
		{Text: commands.FullFlagName(commands.FlagContinueAfter), Description: commands.FlagContinueAfterUsage},
		{Text: commands.FullFlagName(commands.FlagUseLocalMounts), Description: commands.FlagUseLocalMountsUsage},
		{Text: commands.FullFlagName(commands.FlagUseSensorVolume), Description: commands.FlagUseSensorVolumeUsage},
		{Text: commands.FullFlagName(FlagKeepTmpArtifacts), Description: FlagKeepTmpArtifactsUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNuxtDir), Description: FlagIncludeAppNuxtDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNuxtBuildDir), Description: FlagIncludeAppNuxtBuildDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNuxtDistDir), Description: FlagIncludeAppNuxtDistDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNuxtStaticDir), Description: FlagIncludeAppNuxtStaticDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNuxtNodeModulesDir), Description: FlagIncludeAppNuxtNodeModulesDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNextDir), Description: FlagIncludeAppNextDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNextBuildDir), Description: FlagIncludeAppNextBuildDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNextDistDir), Description: FlagIncludeAppNextDistDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNextStaticDir), Description: FlagIncludeAppNextStaticDirUsage},
		{Text: commands.FullFlagName(FlagIncludeAppNextNodeModulesDir), Description: FlagIncludeAppNextNodeModulesDirUsage},
		{Text: commands.FullFlagName(FlagIncludeNodePackage), Description: FlagIncludeNodePackageUsage},
		{Text: commands.FullFlagName(FlagBuildFromDockerfile), Description: FlagBuildFromDockerfileUsage},
		{Text: commands.FullFlagName(FlagDockerfileContext), Description: FlagDockerfileContextUsage},
		{Text: commands.FullFlagName(FlagTagFat), Description: FlagTagFatUsage},
		{Text: commands.FullFlagName(FlagCBOAddHost), Description: FlagCBOAddHostUsage},
		{Text: commands.FullFlagName(FlagCBOBuildArg), Description: FlagCBOBuildArgUsage},
		{Text: commands.FullFlagName(FlagCBOLabel), Description: FlagCBOLabelUsage},
		{Text: commands.FullFlagName(FlagCBOTarget), Description: FlagCBOTargetUsage},
		{Text: commands.FullFlagName(FlagCBONetwork), Description: FlagCBONetworkUsage},
		{Text: commands.FullFlagName(FlagCBOCacheFrom), Description: FlagCBOCacheFromUsage},
		{Text: commands.FullFlagName(commands.FlagDeleteFatImage), Description: commands.FlagDeleteFatImageUsage},
		{Text: commands.FullFlagName(commands.FlagRTAOnbuildBaseImage), Description: commands.FlagRTAOnbuildBaseImageUsage},
		{Text: commands.FullFlagName(commands.FlagRTASourcePT), Description: commands.FlagRTASourcePTUsage},
		{Text: commands.FullFlagName(commands.FlagSensorIPCMode), Description: commands.FlagSensorIPCModeUsage},
		{Text: commands.FullFlagName(commands.FlagSensorIPCEndpoint), Description: commands.FlagSensorIPCEndpointUsage},
		{Text: commands.FullFlagName(FlagImageBuildEngine), Description: FlagImageBuildEngineUsage},
		{Text: commands.FullFlagName(FlagImageBuildArch), Description: FlagImageBuildArchUsage},
		{Text: commands.FullFlagName(FlagObfuscateMetadata), Description: FlagObfuscateMetadataUsage},
	},
	Values: map[string]commands.CompleteValue{
		//NOTE: with FlagPull target complete needs to check remote registries too
		commands.FullFlagName(commands.FlagPull):                           commands.CompleteBool,
		commands.FullFlagName(commands.FlagShowPullLogs):                   commands.CompleteBool,
		commands.FullFlagName(commands.FlagDockerConfigPath):               commands.CompleteFile,
		commands.FullFlagName(commands.FlagTarget):                         commands.CompleteTarget,
		commands.FullFlagName(commands.FlagComposeFile):                    commands.CompleteFile,
		commands.FullFlagName(commands.FlagDepIncludeTargetComposeSvcDeps): commands.CompleteBool,
		commands.FullFlagName(commands.FlagComposeEnvNoHost):               commands.CompleteBool,
		commands.FullFlagName(commands.FlagComposeEnvFile):                 commands.CompleteFile,
		commands.FullFlagName(commands.FlagComposeWorkdir):                 commands.CompleteFile,
		commands.FullFlagName(commands.FlagKubeManifestFile):               commands.CompleteFile,
		commands.FullFlagName(commands.FlagKubeKubeconfigFile):             commands.CompleteFile,
		commands.FullFlagName(FlagShowBuildLogs):                           commands.CompleteBool,
		commands.FullFlagName(commands.FlagShowContainerLogs):              commands.CompleteBool,
		commands.FullFlagName(commands.FlagPublishExposedPorts):            commands.CompleteBool,
		commands.FullFlagName(commands.FlagHTTPProbeOff):                   commands.CompleteBool,
		commands.FullFlagName(commands.FlagHTTPProbe):                      commands.CompleteTBool,
		commands.FullFlagName(commands.FlagHTTPProbeCmdFile):               commands.CompleteFile,
		commands.FullFlagName(commands.FlagHTTPProbeFull):                  commands.CompleteBool,
		commands.FullFlagName(commands.FlagHTTPProbeExitOnFailure):         commands.CompleteBool,
		commands.FullFlagName(commands.FlagHTTPProbeCrawl):                 commands.CompleteTBool,
		commands.FullFlagName(commands.FlagHTTPProbeAPISpecFile):           commands.CompleteFile,
		commands.FullFlagName(commands.FlagHostExecFile):                   commands.CompleteFile,
		commands.FullFlagName(FlagKeepPerms):                               commands.CompleteTBool,
		commands.FullFlagName(commands.FlagRunTargetAsUser):                commands.CompleteTBool,
		commands.FullFlagName(commands.FlagRemoveFileArtifacts):            commands.CompleteBool,
		commands.FullFlagName(commands.FlagNetwork):                        commands.CompleteNetwork,
		commands.FullFlagName(commands.FlagExcludeMounts):                  commands.CompleteTBool,
		commands.FullFlagName(FlagPathPermsFile):                           commands.CompleteFile,
		commands.FullFlagName(FlagPreservePathFile):                        commands.CompleteFile,
		commands.FullFlagName(FlagIncludePathFile):                         commands.CompleteFile,
		commands.FullFlagName(FlagIncludeBinFile):                          commands.CompleteFile,
		commands.FullFlagName(FlagIncludeExeFile):                          commands.CompleteFile,
		commands.FullFlagName(FlagIncludePathsCreportFile):                 commands.CompleteFile,
		commands.FullFlagName(FlagIncludeShell):                            commands.CompleteBool,
		commands.FullFlagName(FlagIncludeWorkdir):                          commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppImageAll):                      commands.CompleteBool,
		commands.FullFlagName(FlagIncludeOSLibsNet):                        commands.CompleteBool,
		commands.FullFlagName(FlagIncludeCertAll):                          commands.CompleteBool,
		commands.FullFlagName(FlagIncludeCertBundles):                      commands.CompleteBool,
		commands.FullFlagName(FlagIncludeCertDirs):                         commands.CompleteBool,
		commands.FullFlagName(FlagIncludeCertPKAll):                        commands.CompleteBool,
		commands.FullFlagName(FlagIncludeCertPKDirs):                       commands.CompleteBool,
		commands.FullFlagName(FlagIncludeNew):                              commands.CompleteBool,
		commands.FullFlagName(commands.FlagContinueAfter):                  commands.CompleteContinueAfter,
		//commands.FullFlagName(commands.FlagConsoleFormat):                  commands.CompleteConsoleOutput,
		commands.FullFlagName(commands.FlagUseLocalMounts):      commands.CompleteBool,
		commands.FullFlagName(commands.FlagUseSensorVolume):     commands.CompleteVolume,
		commands.FullFlagName(FlagKeepTmpArtifacts):             commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNuxtDir):            commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNuxtBuildDir):       commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNuxtDistDir):        commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNuxtStaticDir):      commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNuxtNodeModulesDir): commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNextDir):            commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNextBuildDir):       commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNextDistDir):        commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNextStaticDir):      commands.CompleteBool,
		commands.FullFlagName(FlagIncludeAppNextNodeModulesDir): commands.CompleteBool,
		commands.FullFlagName(commands.FlagCROHostConfigFile):   commands.CompleteFile,
		commands.FullFlagName(FlagDockerfileContext):            commands.CompleteFile,
		commands.FullFlagName(FlagDeleteFatImage):               commands.CompleteBool,
		commands.FullFlagName(commands.FlagRTAOnbuildBaseImage): commands.CompleteBool,
		commands.FullFlagName(commands.FlagRTASourcePT):         commands.CompleteBool,
		commands.FullFlagName(commands.FlagSensorIPCMode):       commands.CompleteIPCMode,
		commands.FullFlagName(FlagImageBuildEngine):             CompleteImageBuildEngine,
		commands.FullFlagName(FlagImageBuildArch):               CompleteImageBuildArch,
		commands.FullFlagName(FlagAppImageDockerfile):           commands.CompleteFile,
		commands.FullFlagName(FlagObfuscateMetadata):            commands.CompleteBool,
	},
}

var imageBuildEngineValues = []prompt.Suggest{
	{Text: IBENone, Description: "no image build engine (output image is not built)"},
	{Text: IBEInternal, Description: "internal image build engine"},
	{Text: IBEDocker, Description: "standard Docker image build engine"},
	{Text: IBEBuildKit, Description: "BuildKit image build engine"},
}

func CompleteImageBuildEngine(ia *commands.InteractiveApp, token string, params prompt.Document) []prompt.Suggest {
	return prompt.FilterHasPrefix(imageBuildEngineValues, token, true)
}

var imageBuildArchValues = []prompt.Suggest{
	{Text: ArchAmd64, Description: "amd64 architecture"},
	{Text: ArchArm64, Description: "arm64 architecture"},
}

func CompleteImageBuildArch(ia *commands.InteractiveApp, token string, params prompt.Document) []prompt.Suggest {
	return prompt.FilterHasPrefix(imageBuildArchValues, token, true)
}
