/*
 * Decompiled with CFR 0.152.
 */
package ork;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;
import ork.PasswordItem;

public class PasswordItemList
extends Vector {
    private int nPos = 0;

    public synchronized PasswordItem GetNextItem() {
        PasswordItem oItem = null;
        if (this.nPos == this.size()) {
            return null;
        }
        oItem = (PasswordItem)this.get(this.nPos);
        ++this.nPos;
        return oItem;
    }

    public void reset() {
        this.nPos = 0;
    }

    public boolean LoadPasswordFile(String sFilename, String sDelimiter) {
        PasswordItem oItem = null;
        LineNumberReader oReader = null;
        String sLine = null;
        try {
            oReader = new LineNumberReader(new FileReader(sFilename));
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: LoadPasswordFile() Could not find password file " + sFilename + ".");
            return false;
        }
        do {
            try {
                sLine = oReader.readLine();
            }
            catch (IOException e) {
                System.err.println("ERROR: LoadPasswordFile() Reading password file failed");
                return false;
            }
            if (sLine == null) continue;
            oItem = new PasswordItem();
            oItem.addDelimitedItem(sLine, sDelimiter);
            this.add(oItem);
        } while (sLine != null);
        return true;
    }
}

