/*
 * Decompiled with CFR 0.152.
 */
package cqure.repeng;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;

public class ReportObject
extends DefaultMutableTreeNode {
    private int m_nType = 0;
    private int m_nSeverity = 0;
    private String m_sName = null;
    private Object m_oValue = null;
    private Hashtable m_oProperties = new Hashtable();
    public static final int REPORT_ITEM = 1000;
    public static final int REPORT_PROPERTY = 1001;
    public static final int REPORT_LINK = 1002;
    public static final int SEVERITY_LEVEL_INFO = 2000;
    public static final int SEVERITY_LEVEL_WARNING = 2001;
    public static final int SEVERITY_LEVEL_CRITICAL = 2002;

    public ReportObject() {
    }

    public ReportObject(String sName) {
        this.m_sName = sName;
    }

    public ReportObject(String sName, Object oVal) {
        this.m_sName = sName;
        this.m_oValue = oVal;
    }

    public void setName(String s) {
        this.m_sName = s;
    }

    public void setType(int t) {
        this.m_nType = t;
    }

    public void setSeverity(int nLevel) {
        this.m_nSeverity = nLevel;
    }

    public void setValue(String s) {
        this.m_oValue = s;
    }

    public void addProperty(String sName, String sValue) {
        if (sValue == null) {
            sValue = "";
        }
        if (sName != null && sName.length() > 0) {
            this.m_oProperties.put(sName, sValue);
        }
    }

    public String getPropertiesAsString() {
        String sTmp = "";
        String sKey = "";
        Enumeration oE = this.m_oProperties.keys();
        while (oE.hasMoreElements()) {
            sKey = (String)oE.nextElement();
            if (this.m_oProperties.get(sKey) == null || ((String)this.m_oProperties.get(sKey)).length() <= 0) continue;
            sTmp = String.valueOf(sTmp) + sKey + ": " + this.m_oProperties.get(sKey) + "\n";
        }
        return sTmp;
    }

    public Hashtable getProperties() {
        return this.m_oProperties;
    }

    public void setProperties(Hashtable h) {
        this.m_oProperties = h;
    }

    public Object getProperty(String s) {
        return this.m_oProperties.get(s);
    }

    public int getPropertyCount() {
        return this.m_oProperties.size();
    }

    public Object getValue() {
        return this.m_oValue;
    }

    public int getSeverity() {
        return this.m_nSeverity;
    }

    public int getType() {
        return this.m_nType;
    }

    public String toString() {
        return this.m_sName;
    }

    public String getName() {
        return this.m_sName;
    }
}

