﻿#region License
//
// JoystickButton.cs
//
// Author:
//       Stefanos A. <stapostol@gmail.com>
//
// Copyright (c) 2006-2013 Stefanos Apostolopoulos
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
#endregion

using System;
using System.Collections.Generic;
using System.Text;

namespace OpenTK.Input
{
    /// <summary>
    /// Defines available JoystickDevice buttons.
    /// </summary>
    public enum JoystickButton
    {
        /// <summary>The first button of the JoystickDevice.</summary>
        Button0 = 0,
        /// <summary>The second button of the JoystickDevice.</summary>
        Button1,
        /// <summary>The third button of the JoystickDevice.</summary>
        Button2,
        /// <summary>The fourth button of the JoystickDevice.</summary>
        Button3,
        /// <summary>The fifth button of the JoystickDevice.</summary>
        Button4,
        /// <summary>The sixth button of the JoystickDevice.</summary>
        Button5,
        /// <summary>The seventh button of the JoystickDevice.</summary>
        Button6,
        /// <summary>The eighth button of the JoystickDevice.</summary>
        Button7,
        /// <summary>The ninth button of the JoystickDevice.</summary>
        Button8,
        /// <summary>The tenth button of the JoystickDevice.</summary>
        Button9,
        /// <summary>The eleventh button of the JoystickDevice.</summary>
        Button10,
        /// <summary>The twelfth button of the JoystickDevice.</summary>
        Button11,
        /// <summary>The thirteenth button of the JoystickDevice.</summary>
        Button12,
        /// <summary>The fourteenth button of the JoystickDevice.</summary>
        Button13,
        /// <summary>The fifteenth button of the JoystickDevice.</summary>
        Button14,
        /// <summary>The sixteenth button of the JoystickDevice.</summary>
        Button15,
        /// <summary>The seventeenth button of the JoystickDevice.</summary>
        Button16,
        /// <summary>The eighteenth button of the JoystickDevice.</summary>
        Button17,
        /// <summary>The nineteenth button of the JoystickDevice.</summary>
        Button18,
        /// <summary>The twentieth button of the JoystickDevice.</summary>
        Button19,
        /// <summary>The twentyfirst button of the JoystickDevice.</summary>
        Button20,
        /// <summary>The twentysecond button of the JoystickDevice.</summary>
        Button21,
        /// <summary>The twentythird button of the JoystickDevice.</summary>
        Button22,
        /// <summary>The twentyfourth button of the JoystickDevice.</summary>
        Button23,
        /// <summary>The twentyfifth button of the JoystickDevice.</summary>
        Button24,
        /// <summary>The twentysixth button of the JoystickDevice.</summary>
        Button25,
        /// <summary>The twentyseventh button of the JoystickDevice.</summary>
        Button26,
        /// <summary>The twentyeighth button of the JoystickDevice.</summary>
        Button27,
        /// <summary>The twentynineth button of the JoystickDevice.</summary>
        Button28,
        /// <summary>The thirtieth button of the JoystickDevice.</summary>
        Button29,
        /// <summary>The thirtyfirst button of the JoystickDevice.</summary>
        Button30,
        /// <summary>The thirtysecond button of the JoystickDevice.</summary>
        Button31,
        /// <summary>The last supported button of the JoystickDevice.</summary>
        Last = Button31,
    }
}
