/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class PidFileHelper {
    public static Long readPid(Path pidFile) throws IOException {
        if (Files.exists(pidFile, new LinkOption[0])) {
            try {
                return Long.parseLong(Files.readString(pidFile).trim());
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (NumberFormatException e) {
                PidFileHelper.remove(pidFile);
                return null;
            }
        }
        return null;
    }

    public static void storePid(Path pidFile, long pid) throws IOException {
        Files.createDirectories(pidFile.getParent(), new FileAttribute[0]);
        Files.write(pidFile, Long.toString(pid).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static void remove(Path pidFile) {
        try {
            Files.deleteIfExists(pidFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

