/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.function.LongPredicate;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;

public class ScoreEntityIterator
implements ValuesIterator {
    private final ValuesIterator iterator;
    private final LongPredicate predicate;
    private boolean hasNext;
    private long currentEntityId;
    private float currentScore;
    private long nextEntityId;
    private float nextScore;

    private ScoreEntityIterator(ValuesIterator sortedValuesIterator, LongPredicate predicate) {
        this.iterator = sortedValuesIterator;
        this.predicate = predicate;
        this.advanceIterator();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public long current() {
        return this.currentEntityId;
    }

    public int remaining() {
        return this.iterator.remaining() + (this.hasNext ? 1 : 0);
    }

    public float currentScore() {
        return this.currentScore;
    }

    public long next() {
        if (this.hasNext) {
            this.currentEntityId = this.nextEntityId;
            this.currentScore = this.nextScore;
            this.advanceIterator();
            return this.currentEntityId;
        }
        throw new NoSuchElementException("The iterator is exhausted.");
    }

    private void advanceIterator() {
        do {
            this.hasNext = this.iterator.hasNext();
            if (!this.hasNext) continue;
            this.nextEntityId = this.iterator.next();
            this.nextScore = this.iterator.currentScore();
        } while (this.hasNext && !this.predicate.test(this.nextEntityId));
    }

    public static ValuesIterator filter(ValuesIterator itr, LongPredicate predicate) {
        return new ScoreEntityIterator(itr, predicate);
    }

    static ValuesIterator mergeIterators(List<ValuesIterator> iterators) {
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        return new ConcatenatingScoreEntityIterator(iterators);
    }

    private static class ConcatenatingScoreEntityIterator
    implements ValuesIterator {
        private final PriorityQueue<ValuesIterator> sources = new PriorityQueue((o1, o2) -> Float.compare(o2.currentScore(), o1.currentScore()));
        private boolean hasNext;
        private long entityId;
        private float score;

        ConcatenatingScoreEntityIterator(List<? extends ValuesIterator> iterators) {
            for (ValuesIterator valuesIterator : iterators) {
                if (!valuesIterator.hasNext()) continue;
                valuesIterator.next();
                this.sources.add(valuesIterator);
                this.hasNext = true;
            }
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public int remaining() {
            return 0;
        }

        public float currentScore() {
            return this.score;
        }

        public long next() {
            if (this.hasNext) {
                ValuesIterator itr = this.sources.poll();
                assert (itr != null);
                this.entityId = itr.current();
                this.score = itr.currentScore();
                if (itr.hasNext()) {
                    itr.next();
                    this.sources.add(itr);
                }
                this.hasNext = !this.sources.isEmpty();
                return this.entityId;
            }
            throw new NoSuchElementException();
        }

        public long current() {
            return this.entityId;
        }
    }
}

