/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class FulltextIndexPopulator
extends LuceneIndexPopulator<DatabaseIndex<FulltextIndexReader>> {
    private final IndexDescriptor descriptor;
    private final String[] propertyNames;

    FulltextIndexPopulator(IndexDescriptor descriptor, DatabaseIndex<FulltextIndexReader> luceneFulltext, String[] propertyNames, IndexUpdateIgnoreStrategy ignoreStrategy) {
        super(luceneFulltext, ignoreStrategy);
        this.descriptor = descriptor;
        this.propertyNames = propertyNames;
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
        try {
            for (IndexEntryUpdate<?> update : updates) {
                ValueIndexEntryUpdate valueUpdate = (ValueIndexEntryUpdate)update;
                if (this.ignoreStrategy.ignore(valueUpdate.values())) continue;
                this.writer.updateOrDeleteDocument(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(valueUpdate.getEntityId()), this.updateAsDocument(valueUpdate));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void verifyDeferredConstraints(NodePropertyAccessor propertyAccessor) {
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, CursorContext cursorContext) {
        return new PopulatingFulltextIndexUpdater();
    }

    public void includeSample(IndexEntryUpdate<?> update) {
    }

    public IndexSample sample(CursorContext cursorContext) {
        return new IndexSample();
    }

    public Map<String, Value> indexConfig() {
        return this.descriptor.getIndexConfig().asMap();
    }

    private Document updateAsDocument(ValueIndexEntryUpdate<?> update) {
        return LuceneFulltextDocumentStructure.documentRepresentingProperties(update.getEntityId(), this.propertyNames, update.values());
    }

    private class PopulatingFulltextIndexUpdater
    implements IndexUpdater {
        private PopulatingFulltextIndexUpdater() {
        }

        public void process(IndexEntryUpdate<?> update) {
            ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
            if (FulltextIndexPopulator.this.ignoreStrategy.ignore(valueUpdate)) {
                return;
            }
            try {
                long nodeId = valueUpdate.getEntityId();
                Term term = LuceneFulltextDocumentStructure.newTermForChangeOrRemove(nodeId);
                switch (valueUpdate.updateMode()) {
                    case ADDED: 
                    case CHANGED: {
                        FulltextIndexPopulator.this.luceneIndex.getIndexWriter().updateOrDeleteDocument(term, LuceneFulltextDocumentStructure.documentRepresentingProperties(nodeId, FulltextIndexPopulator.this.propertyNames, valueUpdate.values()));
                        break;
                    }
                    case REMOVED: {
                        FulltextIndexPopulator.this.luceneIndex.getIndexWriter().deleteDocuments(term);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
        }
    }
}

