/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.DirectionWrapper;
import org.neo4j.internal.recordstorage.MappedNodeDataLookup;
import org.neo4j.internal.recordstorage.PropertyDeleter;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.internal.recordstorage.RelationshipConnection;
import org.neo4j.internal.recordstorage.RelationshipCreator;
import org.neo4j.internal.recordstorage.RelationshipGroupGetter;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;

class RelationshipDeleter {
    private final RelationshipGroupGetter relGroupGetter;
    private final PropertyDeleter propertyChainDeleter;
    private final long externalDegreesThreshold;

    RelationshipDeleter(RelationshipGroupGetter relGroupGetter, PropertyDeleter propertyChainDeleter, long externalDegreesThreshold) {
        this.relGroupGetter = relGroupGetter;
        this.propertyChainDeleter = propertyChainDeleter;
        this.externalDegreesThreshold = externalDegreesThreshold;
    }

    void relationshipDelete(RelationshipModifications.RelationshipBatch deletions, RecordAccessSet recordChanges, RelationshipGroupDegreesStore.Updater groupDegreesUpdater, MappedNodeDataLookup nodeDataLookup, ResourceLocker locks) {
        deletions.forEach((id, type, startNode, endNode, noProperties) -> {
            RelationshipRecord record = recordChanges.getRelRecords().getOrLoad(id, null).forChangingLinkage();
            this.propertyChainDeleter.deletePropertyChain(record, recordChanges.getPropertyRecords());
            this.disconnectRelationship(record, recordChanges.getRelRecords());
            this.updateNodesForDeletedRelationship(record, recordChanges, groupDegreesUpdater, nodeDataLookup, locks);
            record.setInUse(false);
            record.setType(-1);
        });
    }

    private void disconnectRelationship(RelationshipRecord rel, RecordAccess<RelationshipRecord, Void> relChanges) {
        this.disconnect(rel, RelationshipConnection.START_NEXT, relChanges);
        this.disconnect(rel, RelationshipConnection.START_PREV, relChanges);
        this.disconnect(rel, RelationshipConnection.END_NEXT, relChanges);
        this.disconnect(rel, RelationshipConnection.END_PREV, relChanges);
    }

    private void disconnect(RelationshipRecord rel, RelationshipConnection pointer, RecordAccess<RelationshipRecord, Void> relChanges) {
        long otherRelId = pointer.otherSide().get(rel);
        if (Record.isNull(otherRelId)) {
            return;
        }
        RelationshipRecord otherRel = relChanges.getOrLoad(otherRelId, null).forChangingLinkage();
        boolean changed = false;
        long newId = pointer.get(rel);
        boolean newIsFirst = pointer.isFirstInChain(rel);
        if (otherRel.getFirstNode() == pointer.compareNode(rel)) {
            pointer.start().set(otherRel, newId, newIsFirst);
            changed = true;
        }
        if (otherRel.getSecondNode() == pointer.compareNode(rel)) {
            pointer.end().set(otherRel, newId, newIsFirst);
            changed = true;
        }
        if (!changed) {
            throw new InvalidRecordException(otherRel + " don't match " + rel);
        }
    }

    private void updateNodesForDeletedRelationship(RelationshipRecord rel, RecordAccessSet recordChanges, RelationshipGroupDegreesStore.Updater groupDegreesUpdater, MappedNodeDataLookup nodeDataLookup, ResourceLocker locks) {
        boolean loop = rel.getFirstNode() == rel.getSecondNode();
        this.updateNodeForDeletedRelationship(rel, recordChanges, groupDegreesUpdater, rel.getFirstNode(), true, nodeDataLookup, locks);
        this.updateNodeForDeletedRelationship(rel, recordChanges, groupDegreesUpdater, rel.getSecondNode(), !loop, nodeDataLookup, locks);
    }

    private void updateNodeForDeletedRelationship(RelationshipRecord rel, RecordAccessSet recordChanges, RelationshipGroupDegreesStore.Updater groupDegreesUpdater, long nodeId, boolean updateDegree, MappedNodeDataLookup nodeDataLookup, ResourceLocker locks) {
        RecordAccess.RecordProxy<NodeRecord, Object> nodeProxy = recordChanges.getNodeRecords().getOrLoad(nodeId, null);
        NodeRecord node = nodeProxy.forReadingLinkage();
        if (!node.isDense()) {
            if (rel.isFirstInChain(nodeId)) {
                node = nodeProxy.forChangingLinkage();
                node.setNextRel(rel.getNextRel(nodeId));
            }
            if (updateDegree) {
                this.decrementTotalRelationshipCount(nodeId, rel, node.getNextRel(), recordChanges.getRelRecords());
            }
        } else {
            RelationshipGroupRecord group;
            DirectionWrapper direction = DirectionWrapper.wrapDirection(rel, node);
            RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> groupProxy = nodeDataLookup.group(nodeId, rel.getType(), false);
            if (rel.isFirstInChain(nodeId)) {
                group = groupProxy.forChangingData();
                direction.setNextRel(group, rel.getNextRel(nodeId));
                if (group.inUse() && RelationshipGroupGetter.groupIsEmpty(group)) {
                    boolean nodeLocked;
                    boolean nodeRelationshipsLocked = locks.tryExclusiveLock((ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, nodeId);
                    boolean bl = nodeLocked = nodeRelationshipsLocked && locks.tryExclusiveLock((ResourceType)ResourceTypes.NODE, nodeId);
                    if (nodeLocked && locks.tryExclusiveLock((ResourceType)ResourceTypes.RELATIONSHIP_GROUP, nodeId)) {
                        nodeProxy = recordChanges.getNodeRecords().getOrLoad(nodeId, null);
                        if (Record.isNull(group.getPrev())) {
                            long realPrev = this.relGroupGetter.getRelationshipGroup(nodeProxy.forReadingLinkage(), group.getType(), recordChanges.getRelGroupRecords(), RelationshipGroupGetter.RelationshipGroupMonitor.EMPTY).group().forReadingLinkage().getPrev();
                            group.setPrev(realPrev);
                        }
                        RelationshipGroupGetter.deleteGroup(nodeProxy, group, nodeDataLookup);
                    } else {
                        if (nodeLocked) {
                            locks.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{nodeId});
                        }
                        if (nodeRelationshipsLocked) {
                            locks.releaseExclusive((ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, new long[]{nodeId});
                        }
                    }
                }
            }
            if (updateDegree) {
                group = groupProxy.forReadingData();
                if (direction.hasExternalDegrees(group)) {
                    groupDegreesUpdater.increment(group.getId(), direction.direction(), -1L);
                } else {
                    long prevCount;
                    RecordAccess.RecordProxy<RelationshipRecord, Object> firstRelProxy = null;
                    if (rel.isFirstInChain(nodeId)) {
                        prevCount = rel.getPrevRel(nodeId);
                    } else {
                        firstRelProxy = recordChanges.getRelRecords().getOrLoad(direction.getNextRel(group), null);
                        prevCount = firstRelProxy.forReadingLinkage().getPrevRel(nodeId);
                    }
                    long count = prevCount - 1L;
                    if (count > this.externalDegreesThreshold) {
                        direction.setHasExternalDegrees(groupProxy.forChangingData());
                        groupDegreesUpdater.increment(groupProxy.getKey(), direction.direction(), count);
                    } else if (count > 0L) {
                        if (firstRelProxy == null) {
                            firstRelProxy = recordChanges.getRelRecords().getOrLoad(direction.getNextRel(group), null);
                        }
                        firstRelProxy.forChangingLinkage().setPrevRel(count, nodeId);
                    }
                }
            }
        }
    }

    private void decrementTotalRelationshipCount(long nodeId, RelationshipRecord rel, long firstRelId, RecordAccess<RelationshipRecord, Void> relRecords) {
        if (Record.isNull(firstRelId)) {
            return;
        }
        boolean deletingFirstInChain = rel.isFirstInChain(nodeId);
        RelationshipRecord firstRel = relRecords.getOrLoad(firstRelId, null).forChangingLinkage();
        if (nodeId == firstRel.getFirstNode()) {
            firstRel.setFirstPrevRel(deletingFirstInChain ? (long)(RelationshipCreator.relCount(nodeId, rel) - 1) : firstRel.getFirstPrevRel() - 1L);
            assert (firstRel.getFirstPrevRel() >= 0L);
            firstRel.setFirstInFirstChain(true);
        }
        if (nodeId == firstRel.getSecondNode()) {
            firstRel.setSecondPrevRel(deletingFirstInChain ? (long)(RelationshipCreator.relCount(nodeId, rel) - 1) : firstRel.getSecondPrevRel() - 1L);
            assert (firstRel.getSecondPrevRel() >= 0L);
            firstRel.setFirstInSecondChain(true);
        }
    }
}

