/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.common.EntityType;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexImporter;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.IndexWriterStep;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class LabelIndexWriterStep
extends IndexWriterStep<NodeRecord[]> {
    private static final String LABEL_INDEX_WRITE_STEP_TAG = "labelIndexWriteStep";
    private final CursorContext cursorContext;
    private final IndexImporter importer;
    private final NodeStore nodeStore;
    private final StoreCursors cachedStoreCursors;

    public LabelIndexWriterStep(StageControl control, Configuration config, BatchingNeoStores neoStores, IndexImporterFactory indexImporterFactory, MemoryTracker memoryTracker, PageCacheTracer pageCacheTracer, Function<CursorContext, StoreCursors> storeCursorsCreator) {
        super(control, "LABEL INDEX", config, 1, pageCacheTracer);
        this.cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(LABEL_INDEX_WRITE_STEP_TAG));
        this.importer = this.indexImporter(config.indexConfig(), indexImporterFactory, neoStores, EntityType.NODE, memoryTracker, this.cursorContext, storeCursorsCreator);
        this.cachedStoreCursors = storeCursorsCreator.apply(this.cursorContext);
        this.nodeStore = neoStores.getNodeStore();
    }

    protected void process(NodeRecord[] batch, BatchSender sender, CursorContext cursorContext) throws Throwable {
        this.cachedStoreCursors.reset(cursorContext);
        for (NodeRecord node : batch) {
            if (!node.inUse()) continue;
            this.importer.add(node.getId(), NodeLabelsField.get(node, this.nodeStore, this.cachedStoreCursors));
        }
        sender.send((Object)batch);
    }

    public void close() throws Exception {
        super.close();
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.importer, this.cursorContext, this.cachedStoreCursors});
    }
}

