/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponentVersion;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;

public class CommunitySecurityComponentVersion_0_35
extends KnownCommunitySecurityComponentVersion {
    private final UserRepository userRepository;

    public CommunitySecurityComponentVersion_0_35(AbstractSecurityLog securityLog, UserRepository userRepository) {
        super(UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_35, securityLog);
        this.userRepository = userRepository;
    }

    public boolean detected(Transaction tx) {
        if (CommunitySecurityComponentVersion_0_35.nodesWithLabelExist((Transaction)tx, (Label)USER_LABEL) || this.getVersion(tx) != null) {
            return false;
        }
        try {
            this.userRepository.start();
            return this.userRepository.numberOfUsers() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setupUsers(Transaction tx) {
        throw this.unsupported();
    }

    @Override
    public void updateInitialUserPassword(Transaction tx) {
        throw this.unsupported();
    }

    @Override
    public void upgradeSecurityGraph(Transaction tx, int fromVersion) throws Exception {
        this.userRepository.start();
        ListSnapshot<User> users = this.userRepository.getSnapshot();
        if (!users.values().isEmpty()) {
            for (User user : users.values()) {
                this.addUser(tx, user.name(), user.credentials(), user.passwordChangeRequired(), user.hasFlag("is_suspended"));
            }
            String userString = users.values().size() == 1 ? "user" : "users";
            this.securityLog.info(String.format("Completed migration of %s %s into system graph.", Integer.toString(users.values().size()), userString));
        } else {
            this.securityLog.info("No users migrated from auth file into system graph.");
        }
    }
}

