/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.reverse.EagerlyReversedTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.TransactionCursors;

public class DefaultTransactionCursors
implements TransactionCursors {
    private final LogFile logFile;
    private final LogPosition beginning;
    private final LogEntryReader reader;
    private final boolean failOnCorruptedLogFiles;
    private final ReversedTransactionCursorMonitor monitor;
    private long currentVersion;

    public DefaultTransactionCursors(LogFile logFile, LogPosition beginning, LogEntryReader reader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor) {
        this.logFile = logFile;
        this.beginning = beginning;
        this.reader = reader;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.monitor = monitor;
        this.currentVersion = logFile.getHighestLogVersion();
    }

    @Override
    public Optional<TransactionCursor> next() {
        if (this.currentVersion < this.beginning.getLogVersion()) {
            return Optional.empty();
        }
        try {
            LogPosition position = this.currentVersion > this.beginning.getLogVersion() ? this.logFile.extractHeader(this.currentVersion).getStartPosition() : this.beginning;
            TransactionCursor cursor = this.createCursor(this.logFile.getReader(position, LogVersionBridge.NO_MORE_CHANNELS));
            --this.currentVersion;
            return Optional.of(cursor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TransactionCursor createCursor(ReadableLogChannel channel) throws IOException {
        if (channel instanceof ReadAheadLogChannel) {
            return new ReversedSingleFileTransactionCursor((ReadAheadLogChannel)channel, this.reader, this.failOnCorruptedLogFiles, this.monitor);
        }
        return EagerlyReversedTransactionCursor.eagerlyReverse(new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)channel, this.reader));
    }

    @Override
    public void close() throws IOException {
    }
}

