/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;

public class SchemaMatcher {
    private SchemaMatcher() {
        throw new AssertionError((Object)"no instance");
    }

    static <SUPPLIER extends SchemaDescriptorSupplier, EXCEPTION extends Exception> void onMatchingSchema(Iterator<SUPPLIER> schemaSuppliers, int specialPropertyId, int[] existingPropertyIds, ThrowingConsumer<SUPPLIER, EXCEPTION> callback) throws EXCEPTION {
        while (schemaSuppliers.hasNext()) {
            SchemaDescriptorSupplier schemaSupplier = (SchemaDescriptorSupplier)schemaSuppliers.next();
            SchemaDescriptor schema = schemaSupplier.schema();
            if (!SchemaMatcher.entityHasSchemaProperties(existingPropertyIds, schema.getPropertyIds(), specialPropertyId)) continue;
            callback.accept((Object)schemaSupplier);
        }
    }

    private static boolean entityHasSchemaProperties(int[] existingPropertyIds, int[] indexPropertyIds, int changedPropertyId) {
        for (int indexPropertyId : indexPropertyIds) {
            if (indexPropertyId == changedPropertyId || SchemaMatcher.contains(existingPropertyIds, indexPropertyId)) continue;
            return false;
        }
        return true;
    }

    private static boolean contains(int[] existingPropertyIds, int indexPropertyId) {
        return Arrays.binarySearch(existingPropertyIds, indexPropertyId) >= 0;
    }
}

