/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.kernel.impl.newapi.DefaultEntityValueIndexCursor;
import org.neo4j.kernel.impl.newapi.Read;

public class PartitionedValueIndexCursorSeek<Cursor extends Cursor>
implements PartitionedScan<Cursor> {
    private final Read read;
    private final PartitionedValueSeek valueSeek;
    private final PropertyIndexQuery[] query;
    private final IndexDescriptor descriptor;

    PartitionedValueIndexCursorSeek(Read read, IndexDescriptor descriptor, PartitionedValueSeek valueSeek, PropertyIndexQuery ... query) {
        if (read.hasTxStateWithChanges()) {
            throw new IllegalStateException("Transaction contains changes; PartitionScan is only valid in Read-Only transactions.");
        }
        this.read = read;
        this.descriptor = descriptor;
        this.valueSeek = valueSeek;
        this.query = query;
    }

    public int getNumberOfPartitions() {
        return this.valueSeek.getNumberOfPartitions();
    }

    public boolean reservePartition(Cursor cursor, CursorContext cursorContext, AccessMode accessMode) {
        DefaultEntityValueIndexCursor indexCursor = (DefaultEntityValueIndexCursor)cursor;
        indexCursor.setRead(this.read);
        IndexProgressor indexProgressor = this.valueSeek.reservePartition((IndexProgressor.EntityValueClient)indexCursor, cursorContext);
        if (indexProgressor == IndexProgressor.EMPTY) {
            return false;
        }
        indexCursor.initialize(this.descriptor, indexProgressor, accessMode, false, IndexQueryConstraints.unorderedValues(), this.query);
        return true;
    }
}

