/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultEntityValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.memory.MemoryTracker;

class DefaultRelationshipValueIndexCursor
extends DefaultEntityValueIndexCursor<DefaultRelationshipValueIndexCursor>
implements RelationshipValueIndexCursor {
    private final DefaultRelationshipScanCursor securityRelationshipCursor;
    private int[] propertyIds;

    DefaultRelationshipValueIndexCursor(CursorPool<DefaultRelationshipValueIndexCursor> pool, DefaultRelationshipScanCursor securityRelationshipCursor, MemoryTracker memoryTracker) {
        super(pool, memoryTracker);
        this.securityRelationshipCursor = securityRelationshipCursor;
    }

    public void relationship(RelationshipScanCursor cursor) {
        this.readEntity(read -> read.singleRelationship(this.entityReference(), cursor));
    }

    public void sourceNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship index cursor.");
    }

    public void targetNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship index cursor.");
    }

    public int type() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship type in the relationship index cursor.");
    }

    public long relationshipReference() {
        return this.entityReference();
    }

    public long sourceNodeReference() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship index cursor.");
    }

    public long targetNodeReference() {
        throw new UnsupportedOperationException("We have not yet implemented tracking of the relationship end nodes in the relationship index cursor.");
    }

    @Override
    protected boolean canAccessAllDescribedEntities(IndexDescriptor descriptor, AccessMode accessMode) {
        this.propertyIds = descriptor.schema().getPropertyIds();
        for (int relType : descriptor.schema().getEntityTokenIds()) {
            if (accessMode.allowsTraverseRelType(relType)) continue;
            return false;
        }
        if (!accessMode.allowsTraverseAllLabels()) {
            return false;
        }
        for (int propId : this.propertyIds) {
            for (int relType : descriptor.schema().getEntityTokenIds()) {
                if (accessMode.allowsReadRelationshipProperty(() -> relType, propId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected ImmutableLongSet removed(TransactionState txState, LongSet removedFromIndex) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedRelationships().getRemoved(), (LongIterable)removedFromIndex).toImmutable();
    }

    @Override
    protected boolean allowed(long reference, AccessMode accessMode) {
        this.readEntity(read -> read.singleRelationship(reference, this.securityRelationshipCursor));
        if (!this.securityRelationshipCursor.next()) {
            return false;
        }
        int relType = this.securityRelationshipCursor.type();
        for (int prop : this.propertyIds) {
            if (accessMode.allowsReadRelationshipProperty(() -> relType, prop)) continue;
            return false;
        }
        return true;
    }

    @Override
    void traceOnEntity(KernelReadTracer tracer, long entity) {
        tracer.onRelationship(entity);
    }

    @Override
    String implementationName() {
        return "RelationshipValueIndexCursor";
    }

    public void release() {
        if (this.securityRelationshipCursor != null) {
            this.securityRelationshipCursor.close();
            this.securityRelationshipCursor.release();
        }
    }
}

