/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class MapCachingDatabaseReferenceRepository
implements DatabaseReferenceRepository.Caching {
    private final DatabaseReferenceRepository delegate;
    private volatile Map<NormalizedDatabaseName, DatabaseReference> databaseRefsByName = new ConcurrentHashMap<NormalizedDatabaseName, DatabaseReference>();

    public MapCachingDatabaseReferenceRepository(DatabaseReferenceRepository delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<DatabaseReference> getByName(NormalizedDatabaseName databaseName) {
        return Optional.ofNullable(this.databaseRefsByName.computeIfAbsent(databaseName, this::lookupReferenceOnDelegate));
    }

    private DatabaseReference lookupReferenceOnDelegate(NormalizedDatabaseName databaseName) {
        return this.delegate.getByName(databaseName).orElse(null);
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        return this.delegate.getAllDatabaseReferences();
    }

    @Override
    public Set<DatabaseReference.Internal> getInternalDatabaseReferences() {
        return this.delegate.getInternalDatabaseReferences();
    }

    @Override
    public Set<DatabaseReference.External> getExternalDatabaseReferences() {
        return this.delegate.getExternalDatabaseReferences();
    }

    @Override
    public void invalidateAll() {
        this.databaseRefsByName = new ConcurrentHashMap<NormalizedDatabaseName, DatabaseReference>();
    }
}

