/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Optional;
import java.util.Set;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public interface DatabaseReferenceRepository {
    public Optional<DatabaseReference> getByName(NormalizedDatabaseName var1);

    default public Optional<DatabaseReference.Internal> getInternalByName(NormalizedDatabaseName databaseName) {
        return this.getByName(databaseName).filter(DatabaseReference.Internal.class::isInstance).map(DatabaseReference.Internal.class::cast);
    }

    default public Optional<DatabaseReference.External> getExternalByName(NormalizedDatabaseName databaseName) {
        return this.getByName(databaseName).filter(DatabaseReference.External.class::isInstance).map(DatabaseReference.External.class::cast);
    }

    default public Optional<DatabaseReference> getByName(String databaseName) {
        return this.getByName(new NormalizedDatabaseName(databaseName));
    }

    default public Optional<DatabaseReference.Internal> getInternalByName(String databaseName) {
        return this.getInternalByName(new NormalizedDatabaseName(databaseName));
    }

    default public Optional<DatabaseReference.External> getExternalByName(String databaseName) {
        return this.getExternalByName(new NormalizedDatabaseName(databaseName));
    }

    public Set<DatabaseReference> getAllDatabaseReferences();

    public Set<DatabaseReference.Internal> getInternalDatabaseReferences();

    public Set<DatabaseReference.External> getExternalDatabaseReferences();

    public static interface Caching
    extends DatabaseReferenceRepository {
        public void invalidateAll();
    }
}

