/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.load_csv;

import inet.ipaddr.IPAddressString;
import java.io.Serializable;
import java.net.URL;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.QueryStatistics;
import org.neo4j.cypher.internal.runtime.QueryStatistics$;
import org.neo4j.cypher.internal.runtime.ResourceManagedCursorPool;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.load_csv.LoadCsvIteratorWithPeriodicCommit;
import org.neo4j.cypher.internal.runtime.interpreted.load_csv.UpdateCounter;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.Cursor;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\b\u0010\u0001yA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005K!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00036\u0001\u0011\u0005a\u0007C\u0004=\u0001\t\u0007I\u0011A\u001f\t\r\u0005\u0003\u0001\u0015!\u0003?\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCqA\u0013\u0001A\u0002\u0013\u00051\n\u0003\u0004R\u0001\u0001\u0006K\u0001\u0012\u0005\u0006%\u0002!\te\u0015\u0005\n\u0003;\u0001\u0011\u0013!C\u0001\u0003?Aq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002:\u0001!I!a\u000e\u0003;1{\u0017\rZ\"tmB+'/[8eS\u000e\u001cu.\\7ji>\u00137/\u001a:wKJT!\u0001E\t\u0002\u00111|\u0017\rZ0dgZT!AE\n\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0003)U\tqA];oi&lWM\u0003\u0002\u0017/\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u00193\u000511-\u001f9iKJT!AG\u000e\u0002\u000b9,w\u000e\u000e6\u000b\u0003q\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011a%K\u0007\u0002O)\u0011\u0001&E\u0001\u0006a&\u0004Xm]\u0005\u0003U\u001d\u00121#\u0012=uKJt\u0017\r\\\"T-J+7o\\;sG\u0016\fQBY1uG\"\u0014vn^\"pk:$\bC\u0001\u0011.\u0013\tq\u0013E\u0001\u0003M_:<\u0017!\u0003:fg>,(oY3t\u00031\tX/\u001a:z\u0007>tG/\u001a=u!\t\u00114'D\u0001\u0014\u0013\t!4C\u0001\u0007Rk\u0016\u0014\u0018pQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0005oeR4\b\u0005\u00029\u00015\tq\u0002C\u0003,\t\u0001\u0007A\u0006C\u00030\t\u0001\u0007Q\u0005C\u00031\t\u0001\u0007\u0011'A\u0007va\u0012\fG/Z\"pk:$XM]\u000b\u0002}A\u0011\u0001hP\u0005\u0003\u0001>\u0011Q\"\u00169eCR,7i\\;oi\u0016\u0014\u0018AD;qI\u0006$XmQ8v]R,'\u000fI\u0001\u0015_V$XM\u001d'pC\u0012\u001c5KV%uKJ\fGo\u001c:\u0016\u0003\u0011\u00032\u0001I#H\u0013\t1\u0015E\u0001\u0004PaRLwN\u001c\t\u0003q!K!!S\b\u0003C1{\u0017\rZ\"tm&#XM]1u_J<\u0016\u000e\u001e5QKJLw\u000eZ5d\u0007>lW.\u001b;\u00021=,H/\u001a:M_\u0006$7i\u0015,Ji\u0016\u0014\u0018\r^8s?\u0012*\u0017\u000f\u0006\u0002M\u001fB\u0011\u0001%T\u0005\u0003\u001d\u0006\u0012A!\u00168ji\"9\u0001\u000bCA\u0001\u0002\u0004!\u0015a\u0001=%c\u0005)r.\u001e;fe2{\u0017\rZ\"T-&#XM]1u_J\u0004\u0013AD4fi\u000e\u001bh/\u0013;fe\u0006$xN\u001d\u000b\u000b)^\u000bw/!\u0002\u0002\u0010\u0005e\u0001C\u0001\u0014V\u0013\t1vEA\bM_\u0006$7i\u001d<Ji\u0016\u0014\u0018\r^8s\u0011\u0015A&\u00021\u0001Z\u0003\r)(\u000f\u001c\t\u00035~k\u0011a\u0017\u0006\u00039v\u000b1A\\3u\u0015\u0005q\u0016\u0001\u00026bm\u0006L!\u0001Y.\u0003\u0007U\u0013F\nC\u0003c\u0015\u0001\u00071-A\u0006ja\ncwnY6mSN$\bc\u00013m_:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Qv\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0012\n\u0005-\f\u0013a\u00029bG.\fw-Z\u0005\u0003[:\u0014A\u0001T5ti*\u00111.\t\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fa!\u001b9bI\u0012\u0014(\"\u0001;\u0002\t%tW\r^\u0005\u0003mF\u0014q\"\u0013)BI\u0012\u0014Xm]:TiJLgn\u001a\u0005\u0006q*\u0001\r!_\u0001\u0010M&,G\u000e\u001a+fe6Lg.\u0019;peB\u0019\u0001%\u0012>\u0011\u0005m|hB\u0001?~!\t1\u0017%\u0003\u0002\u007fC\u00051\u0001K]3eK\u001aLA!!\u0001\u0002\u0004\t11\u000b\u001e:j]\u001eT!A`\u0011\t\u000f\u0005\u001d!\u00021\u0001\u0002\n\u00051B.Z4bGf\u001c5O^)v_R,Wi]2ba&tw\rE\u0002!\u0003\u0017I1!!\u0004\"\u0005\u001d\u0011un\u001c7fC:Dq!!\u0005\u000b\u0001\u0004\t\u0019\"\u0001\u0006ck\u001a4WM]*ju\u0016\u00042\u0001IA\u000b\u0013\r\t9\"\t\u0002\u0004\u0013:$\b\"CA\u000e\u0015A\u0005\t\u0019AA\u0005\u0003\u001dAW-\u00193feN\f\u0001dZ3u\u0007N4\u0018\n^3sCR|'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t\tC\u000b\u0003\u0002\n\u0005\r2FAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0012%\u0001\u0006b]:|G/\u0019;j_:LA!a\r\u0002*\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\r=tg*\u001a=u)\u0005a\u0015AE2p[6LG/\u00118e%\u0016\u001cH/\u0019:u)b\u0004")
public class LoadCsvPeriodicCommitObserver
implements ExternalCSVResource {
    private final long batchRowCount;
    private final ExternalCSVResource resources;
    private final QueryContext queryContext;
    private final UpdateCounter updateCounter;
    private Option<LoadCsvIteratorWithPeriodicCommit> outerLoadCSVIterator;

    public UpdateCounter updateCounter() {
        return this.updateCounter;
    }

    public Option<LoadCsvIteratorWithPeriodicCommit> outerLoadCSVIterator() {
        return this.outerLoadCSVIterator;
    }

    public void outerLoadCSVIterator_$eq(Option<LoadCsvIteratorWithPeriodicCommit> x$1) {
        this.outerLoadCSVIterator = x$1;
    }

    @Override
    public LoadCsvIterator getCsvIterator(URL url, List<IPAddressString> ipBlocklist, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        LoadCsvIterator loadCsvIterator;
        LoadCsvIterator innerIterator = this.resources.getCsvIterator(url, ipBlocklist, fieldTerminator, legacyCsvQuoteEscaping, bufferSize, headers);
        if (this.outerLoadCSVIterator().isEmpty()) {
            if (headers) {
                this.updateCounter().offsetForHeaders();
            }
            LoadCsvIteratorWithPeriodicCommit iterator = new LoadCsvIteratorWithPeriodicCommit(innerIterator, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.onNext());
            this.outerLoadCSVIterator_$eq((Option<LoadCsvIteratorWithPeriodicCommit>)new Some((Object)iterator));
            loadCsvIterator = iterator;
        } else {
            loadCsvIterator = innerIterator;
        }
        return loadCsvIterator;
    }

    @Override
    public boolean getCsvIterator$default$6() {
        return false;
    }

    private void onNext() {
        this.updateCounter().resetIfPastLimit(this.batchRowCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.commitAndRestartTx());
        this.updateCounter().$plus$eq(1L);
    }

    private void commitAndRestartTx() {
        ArrayBuffer trackedResources = new ArrayBuffer();
        ArrayBuffer cursorPools = new ArrayBuffer();
        this.queryContext.resources().allResources().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            AutoCloseablePlus autoCloseablePlus = x0$1;
            if (autoCloseablePlus instanceof Cursor) {
                Cursor cursor = (Cursor)autoCloseablePlus;
                cursor.closeInternal();
                boxedUnit = BoxedUnit.UNIT;
            } else if (autoCloseablePlus instanceof ResourceManagedCursorPool) {
                ResourceManagedCursorPool resourceManagedCursorPool = (ResourceManagedCursorPool)autoCloseablePlus;
                cursorPools.$plus$eq((Object)resourceManagedCursorPool);
                resourceManagedCursorPool.closeCursors();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = trackedResources.$plus$eq((Object)autoCloseablePlus);
            }
            return boxedUnit;
        });
        trackedResources.$plus$plus$eq((TraversableOnce)cursorPools);
        ResourceManager resourceManager = this.queryContext.resources();
        trackedResources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            resourceManager.untrace(resource);
            return BoxedUnit.UNIT;
        });
        this.queryContext.transactionalContext().commitAndRestartTx();
        int x$12 = 1;
        int x$22 = QueryStatistics$.MODULE$.apply$default$1();
        int x$3 = QueryStatistics$.MODULE$.apply$default$2();
        int x$4 = QueryStatistics$.MODULE$.apply$default$3();
        int x$5 = QueryStatistics$.MODULE$.apply$default$4();
        int x$6 = QueryStatistics$.MODULE$.apply$default$5();
        int x$7 = QueryStatistics$.MODULE$.apply$default$6();
        int x$8 = QueryStatistics$.MODULE$.apply$default$7();
        int x$9 = QueryStatistics$.MODULE$.apply$default$8();
        int x$10 = QueryStatistics$.MODULE$.apply$default$9();
        int x$11 = QueryStatistics$.MODULE$.apply$default$10();
        int x$122 = QueryStatistics$.MODULE$.apply$default$11();
        int x$13 = QueryStatistics$.MODULE$.apply$default$12();
        int x$14 = QueryStatistics$.MODULE$.apply$default$13();
        int x$15 = QueryStatistics$.MODULE$.apply$default$14();
        int x$16 = QueryStatistics$.MODULE$.apply$default$15();
        int x$17 = QueryStatistics$.MODULE$.apply$default$16();
        int x$18 = QueryStatistics$.MODULE$.apply$default$18();
        QueryStatistics statistics = new QueryStatistics(x$22, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$12, x$18);
        this.queryContext.addStatistics(statistics);
        cursorPools.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.setCursorFactoryAndContext(this.queryContext.transactionalContext().cursors(), this.queryContext.transactionalContext().cursorContext());
            return BoxedUnit.UNIT;
        });
        ResourceManager resourceManager2 = this.queryContext.resources();
        trackedResources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            resourceManager2.trace(resource);
            return BoxedUnit.UNIT;
        });
        this.outerLoadCSVIterator().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.notifyCommit();
            return BoxedUnit.UNIT;
        });
    }

    public LoadCsvPeriodicCommitObserver(long batchRowCount, ExternalCSVResource resources, QueryContext queryContext) {
        this.batchRowCount = batchRowCount;
        this.resources = resources;
        this.queryContext = queryContext;
        this.updateCounter = new UpdateCounter();
        this.outerLoadCSVIterator = None$.MODULE$;
    }
}

