/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.util.Collections;
import java.util.List;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.neo4j.shell.parser.StatementParser;
import org.neo4j.shell.terminal.CypherShellTerminal;

public class CypherJlineParser
implements Parser {
    private final StatementParser parser;
    private boolean enableStatementParsing;

    public CypherJlineParser(StatementParser parser) {
        this.parser = parser;
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
        return this.enableStatementParsing ? this.doParse(line, cursor) : new ParsedLineImpl(line, cursor);
    }

    private ParsedCypher doParse(String line, int cursor) {
        this.parser.reset();
        this.parser.parseMoreText(line);
        if (!this.parser.hasStatements() || this.parser.incompleteStatement().isPresent()) {
            throw new EOFError(-1, cursor, "Incomplete statement");
        }
        return new ParsedCypher(this.parser.consumeStatements(), line, cursor);
    }

    public void setEnableStatementParsing(boolean enable) {
        this.enableStatementParsing = enable;
    }

    @Override
    public boolean isEscapeChar(char ch) {
        return false;
    }

    @Override
    public boolean validCommandName(String name) {
        return false;
    }

    @Override
    public boolean validVariableName(String name) {
        return false;
    }

    @Override
    public String getCommand(String line) {
        return "";
    }

    @Override
    public String getVariable(String line) {
        return null;
    }

    static class ParsedLineImpl
    implements CompletingParsedLine {
        private final String line;
        private final int cursor;

        ParsedLineImpl(String line, int cursor) {
            this.line = line;
            this.cursor = cursor;
        }

        @Override
        public String word() {
            return "";
        }

        @Override
        public int wordCursor() {
            return 0;
        }

        @Override
        public int wordIndex() {
            return 0;
        }

        @Override
        public List<String> words() {
            return Collections.emptyList();
        }

        @Override
        public String line() {
            return this.line;
        }

        @Override
        public int cursor() {
            return this.cursor;
        }

        @Override
        public CharSequence escape(CharSequence candidate, boolean complete) {
            return candidate;
        }

        @Override
        public int rawWordCursor() {
            return 0;
        }

        @Override
        public int rawWordLength() {
            return 0;
        }
    }

    public static class ParsedCypher
    extends ParsedLineImpl
    implements CypherShellTerminal.ParsedStatement {
        private final List<String> statements;

        public ParsedCypher(List<String> statements, String line, int cursor) {
            super(line, cursor);
            this.statements = statements;
        }

        @Override
        public String unparsed() {
            return this.line();
        }

        @Override
        public List<String> parsed() {
            return this.statements;
        }
    }
}

