/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.internal.CLibrary;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DiscoveryException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.exception.AnsiFormattedException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;

public class AnsiLogger
implements Logger {
    private final PrintStream out;
    private final PrintStream err;
    private final boolean debug;
    private Format format;

    public AnsiLogger(boolean debug) {
        this(debug, Format.VERBOSE, System.out, System.err);
    }

    public AnsiLogger(boolean debug, Format format, PrintStream out, PrintStream err) {
        this.debug = debug;
        this.format = format;
        this.out = out;
        this.err = err;
        try {
            if (AnsiLogger.isOutputInteractive()) {
                Ansi.setEnabled(true);
                AnsiConsole.systemInstall();
            } else {
                Ansi.setEnabled(false);
            }
        }
        catch (Throwable t) {
            Ansi.setEnabled(false);
        }
    }

    private static Throwable getRootCause(Throwable th) {
        Throwable cause = th;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private static boolean isOutputInteractive() {
        return 1 == CLibrary.isatty(CLibrary.STDOUT_FILENO) && 1 == CLibrary.isatty(CLibrary.STDERR_FILENO);
    }

    @Override
    public PrintStream getOutputStream() {
        return this.out;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.err;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(Format format) {
        this.format = format;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public void printError(Throwable throwable) {
        this.printError(this.getFormattedMessage(throwable));
    }

    @Override
    public void printError(String s) {
        this.err.println(Ansi.ansi().render(s).toString());
    }

    @Override
    public void printOut(String msg) {
        this.out.println(Ansi.ansi().render(msg).toString());
    }

    public String getFormattedMessage(Throwable e) {
        AnsiFormattedText msg = AnsiFormattedText.s().colorRed();
        if (this.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            msg.append(new String(baos.toByteArray(), StandardCharsets.UTF_8));
        } else if (e instanceof AnsiFormattedException) {
            msg = msg.append(((AnsiFormattedException)e).getFormattedMessage());
        } else if (e instanceof ClientException && e.getMessage() != null && e.getMessage().contains("Missing username")) {
            msg = msg.append(e.getMessage()).append("\nPlease specify --username, and optionally --password, as argument(s)").append("\nor as environment variable(s), NEO4J_USERNAME, and NEO4J_PASSWORD respectively.").append("\nSee --help for more info.");
        } else {
            Throwable cause = e;
            if (e instanceof ServiceUnavailableException) {
                Throwable[] suppressed;
                for (Throwable s : suppressed = e.getSuppressed()) {
                    if (!(s instanceof DiscoveryException)) continue;
                    cause = AnsiLogger.getRootCause(s);
                    break;
                }
            }
            msg = cause.getMessage() != null ? msg.append(cause.getMessage()) : msg.append(cause.getClass().getSimpleName());
        }
        return msg.formattedString();
    }
}

