/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bolt;

import java.util.Optional;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.fabric.bolt.BoltFabricDatabaseService;
import org.neo4j.fabric.bolt.FabricBookmarkParser;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManagerFactory;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.memory.MemoryTracker;

public class BoltFabricDatabaseManagementService
implements BoltGraphDatabaseManagementServiceSPI {
    private final FabricBookmarkParser fabricBookmarkParser = new FabricBookmarkParser();
    private final FabricExecutor fabricExecutor;
    private final FabricConfig config;
    private final TransactionManager transactionManager;
    private final FabricDatabaseManager fabricDatabaseManager;
    private final LocalGraphTransactionIdTracker transactionIdTracker;
    private final TransactionBookmarkManagerFactory transactionBookmarkManagerFactory;

    public BoltFabricDatabaseManagementService(FabricExecutor fabricExecutor, FabricConfig config, TransactionManager transactionManager, FabricDatabaseManager fabricDatabaseManager, LocalGraphTransactionIdTracker transactionIdTracker, TransactionBookmarkManagerFactory transactionBookmarkManagerFactory) {
        this.fabricExecutor = fabricExecutor;
        this.config = config;
        this.transactionManager = transactionManager;
        this.fabricDatabaseManager = fabricDatabaseManager;
        this.transactionIdTracker = transactionIdTracker;
        this.transactionBookmarkManagerFactory = transactionBookmarkManagerFactory;
    }

    public BoltGraphDatabaseServiceSPI database(String databaseName, MemoryTracker memoryTracker) throws UnavailableException, DatabaseNotFoundException {
        try {
            return this.getDatabase(databaseName, memoryTracker);
        }
        catch (DatabaseShutdownException | UnavailableException e) {
            throw new UnavailableException(String.format("Database '%s' is unavailable.", databaseName));
        }
    }

    public BoltGraphDatabaseServiceSPI getDatabase(String databaseName, MemoryTracker memoryTracker) throws UnavailableException, DatabaseNotFoundException {
        memoryTracker.allocateHeap(BoltFabricDatabaseService.SHALLOW_SIZE);
        DatabaseReference database = this.fabricDatabaseManager.getDatabaseReference(databaseName);
        return new BoltFabricDatabaseService(database, this.fabricExecutor, this.config, this.transactionManager, this.transactionIdTracker, this.transactionBookmarkManagerFactory, memoryTracker);
    }

    public Optional<CustomBookmarkFormatParser> getCustomBookmarkFormatParser() {
        return Optional.of(this.fabricBookmarkParser);
    }
}

