/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.v3.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v3.messaging.request.PullAllMessage;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.bolt.v3.runtime.ResultConsumerAdaptor;
import org.neo4j.util.Preconditions;

public abstract class AbstractStreamingState
extends FailSafeBoltStateMachineState {
    protected BoltStateMachineState readyState;

    @Override
    public BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Throwable {
        context.connectionState().ensureNoPendingTerminationNotice();
        if (message instanceof PullAllMessage) {
            ResultConsumerAdaptor resultConsumer = new ResultConsumerAdaptor(context, true);
            return this.processStreamResultMessage(resultConsumer, context);
        }
        if (message instanceof DiscardAllMessage) {
            ResultConsumerAdaptor resultConsumer = new ResultConsumerAdaptor(context, false);
            return this.processStreamResultMessage(resultConsumer, context);
        }
        return null;
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    protected abstract BoltStateMachineState processStreamResultMessage(ResultConsumer var1, StateMachineContext var2) throws Throwable;

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        super.assertInitialized();
    }
}

