/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.runtime.statemachine.impl.TransactionStateMachine;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.memory.MemoryTracker;

public class StatementProcessorProvider {
    private final Clock clock;
    private final TransactionStateMachineSPIProvider spiProvider;
    private final StatementProcessorReleaseManager resourceReleaseManager;
    private final RoutingContext routingContext;
    private final MemoryTracker memoryTracker;

    public StatementProcessorProvider(TransactionStateMachineSPIProvider transactionSpiProvider, Clock clock, StatementProcessorReleaseManager releaseManager, RoutingContext routingContext, MemoryTracker memoryTracker) {
        this.spiProvider = transactionSpiProvider;
        this.clock = clock;
        this.resourceReleaseManager = releaseManager;
        this.routingContext = routingContext;
        this.memoryTracker = memoryTracker;
    }

    public StatementProcessor getStatementProcessor(LoginContext loginContext, String databaseName, String txId) throws BoltProtocolBreachFatality, BoltIOException {
        this.memoryTracker.allocateHeap(TransactionStateMachine.SHALLOW_SIZE);
        TransactionStateMachineSPI transactionSPI = this.spiProvider.getTransactionStateMachineSPI(databaseName, this.resourceReleaseManager, txId);
        return new TransactionStateMachine(databaseName, transactionSPI, loginContext, this.clock, this.routingContext, txId);
    }

    public void releaseStatementProcessor() {
        this.memoryTracker.releaseHeap(TransactionStateMachine.SHALLOW_SIZE);
        this.spiProvider.releaseTransactionStateMachineSPI();
    }
}

