/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.CommandHelpers;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.archive.CompressionFormat;
import org.neo4j.dbms.archive.DumpFormatSelector;
import org.neo4j.dbms.archive.Dumper;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import picocli.CommandLine;

@CommandLine.Command(name="dump", header={"Dump a database into a single-file archive."}, description={"Dump a database into a single-file archive. The archive can be used by the load command. <destination-path> can be a file or directory (in which case a file called <database>.dump will be created), or '-' to use standard output. It is not possible to dump a database that is mounted in a running Neo4j server."})
public class DumpCommand
extends AbstractCommand {
    public static final String STANDARD_OUTPUT = "-";
    @CommandLine.Option(names={"--database"}, description={"Name of the database to dump."}, defaultValue="neo4j", converter={Converters.DatabaseNameConverter.class})
    protected NormalizedDatabaseName database;
    @CommandLine.Option(names={"--to"}, paramLabel="<path>", required=true, description={"Destination (file or folder or '-' for stdout) of database dump."})
    private String to;
    private final Dumper dumper;

    public DumpCommand(ExecutionContext ctx, Dumper dumper) {
        super(ctx);
        this.dumper = Objects.requireNonNull(dumper);
    }

    public void execute() {
        String databaseName = this.database.name();
        EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        Config config = CommandHelpers.buildConfig(this.ctx, this.allowCommandExpansion);
        DatabaseLayout databaseLayout = Neo4jLayout.of((Config)config).databaseLayout(databaseName);
        try {
            Validators.CONTAINS_EXISTING_DATABASE.validate((Object)databaseLayout.databaseDirectory());
        }
        catch (IllegalArgumentException e) {
            throw new CommandFailedException("Database does not exist: " + databaseName, (Throwable)e);
        }
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            if (fileSystem.fileExists(databaseLayout.file("upgrade"))) {
                throw new CommandFailedException("Store migration folder detected - A dump can not be taken during a store migration. Make sure store migration is completed before trying again.");
            }
        }
        catch (IOException e) {
            DumpCommand.wrapIOException(e);
        }
        try (Closeable ignored = LockChecker.checkDatabaseLock(databaseLayout);){
            this.checkDbState(databaseLayout, config, (MemoryTracker)memoryTracker);
            this.dump(databaseLayout, databaseName);
        }
        catch (FileLockException e) {
            throw new CommandFailedException("The database is in use. Stop database '" + databaseName + "' and try again.", (Throwable)e);
        }
        catch (IOException e) {
            DumpCommand.wrapIOException(e);
        }
        catch (CannotWriteException e) {
            throw new CommandFailedException("You do not have permission to dump the database.", (Throwable)e);
        }
    }

    private static Path buildArchivePath(String database, Path to) {
        return Files.isDirectory(to, new LinkOption[0]) ? to.resolve(database + ".dump") : to;
    }

    private OutputStream openDumpStream(String databaseName, String destination) throws IOException {
        if (destination.equals(STANDARD_OUTPUT)) {
            return this.ctx.out();
        }
        Path archive = DumpCommand.buildArchivePath(databaseName, Path.of(destination, new String[0]).toAbsolutePath());
        return this.dumper.openForDump(archive);
    }

    private void dump(DatabaseLayout databaseLayout, String databaseName) {
        Path databasePath = databaseLayout.databaseDirectory();
        try {
            CompressionFormat format = DumpFormatSelector.selectFormat(this.ctx.err());
            String lockFile = databaseLayout.databaseLockFile().getFileName().toString();
            String quarantineMarkerFile = databaseLayout.quarantineMarkerFile().getFileName().toString();
            OutputStream out = this.openDumpStream(databaseName, this.to);
            this.dumper.dump(databasePath, databaseLayout.getTransactionLogsDirectory(), out, format, path -> DumpCommand.oneOf(path, lockFile, quarantineMarkerFile));
        }
        catch (FileAlreadyExistsException e) {
            throw new CommandFailedException("Archive already exists: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchFileException e) {
            if (Paths.get(e.getMessage(), new String[0]).toAbsolutePath().equals(databasePath)) {
                throw new CommandFailedException("Database does not exist: " + databaseLayout.getDatabaseName(), (Throwable)e);
            }
            DumpCommand.wrapIOException(e);
        }
        catch (IOException e) {
            DumpCommand.wrapIOException(e);
        }
    }

    private static boolean oneOf(Path path, String ... names) {
        return ArrayUtil.contains((Object[])names, (Object)path.getFileName().toString());
    }

    protected void checkDbState(DatabaseLayout databaseLayout, Config additionalConfiguration, MemoryTracker memoryTracker) {
        if (DumpCommand.checkRecoveryState(databaseLayout, additionalConfiguration, memoryTracker)) {
            throw new CommandFailedException(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database before running the dump.", "To perform recovery please start database and perform clean shutdown."}));
        }
    }

    private static boolean checkRecoveryState(DatabaseLayout databaseLayout, Config additionalConfiguration, MemoryTracker memoryTracker) {
        try {
            return Recovery.isRecoveryRequired((DatabaseLayout)databaseLayout, (Config)additionalConfiguration, (MemoryTracker)memoryTracker);
        }
        catch (Exception e) {
            throw new CommandFailedException("Failure when checking for recovery state: '%s'." + e.getMessage(), (Throwable)e);
        }
    }

    private static void wrapIOException(IOException e) {
        throw new CommandFailedException(String.format("Unable to dump database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), (Throwable)e);
    }
}

