/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;

public class SchemaDescriptorLookupSet<T extends SchemaDescriptorSupplier> {
    private final MutableIntObjectMap<PropertyMultiSet> byEntityToken = IntObjectMaps.mutable.empty();

    public boolean isEmpty() {
        return this.byEntityToken.isEmpty();
    }

    public boolean has(long[] entityTokenIds, int propertyKey) {
        if (this.isEmpty()) {
            return false;
        }
        for (long entityTokenId : entityTokenIds) {
            PropertyMultiSet set = (PropertyMultiSet)this.byEntityToken.get(Math.toIntExact(entityTokenId));
            if (set == null || !set.has(propertyKey)) continue;
            return true;
        }
        return false;
    }

    public boolean has(int entityTokenId) {
        return this.byEntityToken.containsKey(entityTokenId);
    }

    public void add(T schemaDescriptor) {
        for (int entityTokenId : schemaDescriptor.schema().getEntityTokenIds()) {
            ((PropertyMultiSet)this.byEntityToken.getIfAbsentPut(entityTokenId, (Function0 & Serializable)() -> new PropertyMultiSet())).add(schemaDescriptor);
        }
    }

    public void remove(T schemaDescriptor) {
        for (int entityTokenId : schemaDescriptor.schema().getEntityTokenIds()) {
            PropertyMultiSet any = (PropertyMultiSet)this.byEntityToken.get(entityTokenId);
            if (any == null || !any.remove(schemaDescriptor)) continue;
            this.byEntityToken.remove(entityTokenId);
        }
    }

    public void matchingDescriptorsForCompleteListOfProperties(Collection<T> into, long[] entityTokenIds, int[] sortedProperties) {
        for (long entityTokenId : entityTokenIds) {
            PropertyMultiSet first = (PropertyMultiSet)this.byEntityToken.get(Math.toIntExact(entityTokenId));
            if (first == null) continue;
            first.collectForCompleteListOfProperties(into, sortedProperties);
        }
    }

    public void matchingDescriptorsForPartialListOfProperties(Collection<T> into, long[] entityTokenIds, int[] sortedProperties) {
        for (long entityTokenId : entityTokenIds) {
            PropertyMultiSet first = (PropertyMultiSet)this.byEntityToken.get(Math.toIntExact(entityTokenId));
            if (first == null) continue;
            first.collectForPartialListOfProperties(into, sortedProperties);
        }
    }

    public void matchingDescriptors(Collection<T> into, long[] entityTokenIds) {
        for (long entityTokenId : entityTokenIds) {
            PropertyMultiSet set = (PropertyMultiSet)this.byEntityToken.get(Math.toIntExact(entityTokenId));
            if (set == null) continue;
            set.collectAll(into);
        }
    }

    private static int[] sortedPropertyKeyIds(SchemaDescriptor schemaDescriptor) {
        int[] tokenIds = schemaDescriptor.getPropertyIds();
        if (tokenIds.length > 1) {
            tokenIds = Arrays.copyOf(tokenIds, tokenIds.length);
            Arrays.sort(tokenIds);
        }
        return tokenIds;
    }

    private class PropertySet {
        private final Set<T> fullDescriptors = new HashSet();
        private final MutableIntObjectMap<PropertySet> next = IntObjectMaps.mutable.empty();

        private PropertySet() {
        }

        void add(T schemaDescriptor, int[] propertyKeyIds, int cursor) {
            if (cursor == propertyKeyIds.length - 1) {
                this.fullDescriptors.add(schemaDescriptor);
            } else {
                int nextPropertyKeyId = propertyKeyIds[++cursor];
                ((PropertySet)this.next.getIfAbsentPut(nextPropertyKeyId, (Function0 & Serializable)() -> new PropertySet())).add(schemaDescriptor, propertyKeyIds, cursor);
            }
        }

        boolean remove(T schemaDescriptor, int[] propertyKeyIds, int cursor) {
            int nextPropertyKeyId;
            PropertySet propertySet;
            if (cursor == propertyKeyIds.length - 1) {
                this.fullDescriptors.remove(schemaDescriptor);
            } else if ((propertySet = (PropertySet)this.next.get(nextPropertyKeyId = propertyKeyIds[++cursor])) != null && propertySet.remove(schemaDescriptor, propertyKeyIds, cursor)) {
                this.next.remove(nextPropertyKeyId);
            }
            return this.fullDescriptors.isEmpty() && this.next.isEmpty();
        }

        void collectForCompleteListOfProperties(Collection<T> descriptors, int[] sortedProperties, int cursor) {
            descriptors.addAll(this.fullDescriptors);
            if (!this.next.isEmpty()) {
                for (int i = cursor + 1; i < sortedProperties.length; ++i) {
                    PropertySet nextSet = (PropertySet)this.next.get(sortedProperties[i]);
                    if (nextSet == null) continue;
                    nextSet.collectForCompleteListOfProperties(descriptors, sortedProperties, i);
                }
            }
        }
    }

    private class PropertyMultiSet {
        private final Set<T> descriptors = new HashSet();
        private final MutableIntObjectMap<PropertySet> next = IntObjectMaps.mutable.empty();
        private final MutableIntObjectMap<Set<T>> byAnyProperty = IntObjectMaps.mutable.empty();

        private PropertyMultiSet() {
        }

        void add(T schemaDescriptor) {
            this.descriptors.add(schemaDescriptor);
            int[] propertyKeyIds = SchemaDescriptorLookupSet.sortedPropertyKeyIds(schemaDescriptor.schema());
            PropertySchemaType propertySchemaType = schemaDescriptor.schema().propertySchemaType();
            if (propertySchemaType == PropertySchemaType.COMPLETE_ALL_TOKENS) {
                ((PropertySet)this.next.getIfAbsentPut(propertyKeyIds[0], (Function0 & Serializable)() -> new PropertySet())).add(schemaDescriptor, propertyKeyIds, 0);
            } else if (propertySchemaType == PropertySchemaType.PARTIAL_ANY_TOKEN) {
                for (int propertyKeyId : propertyKeyIds) {
                    ((PropertySet)this.next.getIfAbsentPut(propertyKeyId, (Function0 & Serializable)() -> new PropertySet())).add(schemaDescriptor, new int[]{propertyKeyId}, 0);
                }
            } else {
                throw new UnsupportedOperationException("Unknown property schema type " + propertySchemaType);
            }
            for (int keyId : propertyKeyIds) {
                ((Set)this.byAnyProperty.getIfAbsentPut(keyId, HashSet::new)).add(schemaDescriptor);
            }
        }

        boolean remove(T schemaDescriptor) {
            this.descriptors.remove(schemaDescriptor);
            int[] propertyKeyIds = SchemaDescriptorLookupSet.sortedPropertyKeyIds(schemaDescriptor.schema());
            PropertySchemaType propertySchemaType = schemaDescriptor.schema().propertySchemaType();
            if (propertySchemaType == PropertySchemaType.COMPLETE_ALL_TOKENS) {
                int firstPropertyKeyId = propertyKeyIds[0];
                PropertySet firstPropertySet = (PropertySet)this.next.get(firstPropertyKeyId);
                if (firstPropertySet != null && firstPropertySet.remove(schemaDescriptor, propertyKeyIds, 0)) {
                    this.next.remove(firstPropertyKeyId);
                }
            } else if (propertySchemaType == PropertySchemaType.PARTIAL_ANY_TOKEN) {
                int[] nArray = propertyKeyIds;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int propertyKeyId = nArray[i];
                    PropertySet propertySet = (PropertySet)this.next.get(propertyKeyId);
                    if (propertySet == null || !propertySet.remove(schemaDescriptor, new int[]{propertyKeyId}, 0)) continue;
                    this.next.remove(propertyKeyId);
                }
            } else {
                throw new UnsupportedOperationException("Unknown property schema type " + propertySchemaType);
            }
            for (int keyId : propertyKeyIds) {
                Set byProperty = (Set)this.byAnyProperty.get(keyId);
                if (byProperty == null) continue;
                byProperty.remove(schemaDescriptor);
                if (!byProperty.isEmpty()) continue;
                this.byAnyProperty.remove(keyId);
            }
            return this.descriptors.isEmpty() && this.next.isEmpty();
        }

        void collectForCompleteListOfProperties(Collection<T> descriptors, int[] sortedProperties) {
            for (int i = 0; i < sortedProperties.length; ++i) {
                PropertySet firstSet = (PropertySet)this.next.get(sortedProperties[i]);
                if (firstSet == null) continue;
                firstSet.collectForCompleteListOfProperties(descriptors, sortedProperties, i);
            }
        }

        void collectForPartialListOfProperties(Collection<T> descriptors, int[] sortedProperties) {
            for (int propertyKeyId : sortedProperties) {
                Set propertyDescriptors = (Set)this.byAnyProperty.get(propertyKeyId);
                if (propertyDescriptors == null) continue;
                descriptors.addAll(propertyDescriptors);
            }
        }

        void collectAll(Collection<T> descriptors) {
            descriptors.addAll(this.descriptors);
        }

        boolean has(int propertyKey) {
            return this.byAnyProperty.containsKey(propertyKey);
        }
    }
}

