/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Arrays;
import org.neo4j.internal.helpers.Numbers;

public final class Preconditions {
    private Preconditions() {
        throw new AssertionError((Object)"no instances");
    }

    public static long requirePositive(long value) {
        if (value < 1L) {
            throw new IllegalArgumentException("Expected positive long value, got " + value);
        }
        return value;
    }

    public static long requireNegative(long value) {
        if (value > -1L) {
            throw new IllegalArgumentException("Expected negative long value, got " + value);
        }
        return value;
    }

    public static long requirePowerOfTwo(long value) {
        if (!Numbers.isPowerOfTwo(value)) {
            throw new IllegalArgumentException("Expected long value to be a non zero power of 2, got " + value);
        }
        return value;
    }

    public static int requirePositive(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Expected positive int value, got " + value);
        }
        return value;
    }

    public static int requireNegative(int value) {
        if (value > -1) {
            throw new IllegalArgumentException("Expected negative int value, got " + value);
        }
        return value;
    }

    public static long requireNonNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Expected non-negative long value, got " + value);
        }
        return value;
    }

    public static int requireNonNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Expected non-negative int value, got " + value);
        }
        return value;
    }

    public static int requireExactlyZero(int value) {
        if (value != 0) {
            throw new IllegalArgumentException("Expected int value equal to 0, got " + value);
        }
        return value;
    }

    public static <T> void requireNonEmpty(T[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Expected non empty array, got " + Arrays.toString(array));
        }
    }

    public static <T> void requireNoNullElements(T[] array) {
        for (T element : array) {
            if (element != null) continue;
            throw new IllegalArgumentException("Expected array without null elements, got " + Arrays.toString(array));
        }
    }

    public static void checkState(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkState(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(args.length > 0 ? String.format(message, args) : message);
        }
    }

    public static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(args.length > 0 ? String.format(message, args) : message);
        }
    }

    public static void requireBetween(int value, int lowInclusive, int highExclusive) {
        if (value < lowInclusive || value >= highExclusive) {
            throw new IllegalArgumentException(String.format("Expected int value between %d (inclusive) and %d (exclusive), got %d.", lowInclusive, highExclusive, value));
        }
    }

    public static void requireNoLongAddOverflow(long a, long b, String message) {
        long result = a + b;
        if (((a ^ result) & (b ^ result)) < 0L) {
            throw new IllegalArgumentException(String.format(message, a, b));
        }
    }
}

