/* $Id: TMgr_DisplayTrackRequest.cpp 404219 2013-06-21 11:47:14Z clausen $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'trackmgr.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/trackmgr/TMgr_DisplayTrackRequest.hpp>
#include <objects/trackmgr/TMgr_GenomeContext.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CTMgr_DisplayTrackRequest::~CTMgr_DisplayTrackRequest(void)
{
}

void
CTMgr_DisplayTrackRequest::SetClientName(const string& name)
{
    SetClient().SetClient_name(name);
}

void
CTMgr_DisplayTrackRequest::SetResourceName(const string& name)
{
    SetClient().SetContext(name);
}

void
CTMgr_DisplayTrackRequest::AddAssemblyAcc(const string& acc)
{
    SetGenome_context().SetAssembly().SetAccession(acc);
}

void
CTMgr_DisplayTrackRequest::AddAssemblyNameTax(const string& name, int tax_id)
{
    SetGenome_context().SetAssembly().SetName().SetName(name);
    SetGenome_context().SetAssembly().SetName().SetTax_id(tax_id);
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1789, CRC32: 1b46a3a */
