package com.googlecode.mp4parser.authoring.samples;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.mdat.SampleList;
import junit.framework.Assert;
import org.junit.Test;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

/**
 * Created by sannies on 1/9/14.
 */
public class DefaultMp4SampleListTest {
    @Test
    public void checkSampleList() throws IOException, NoSuchAlgorithmException {
        IsoFile isoFile = new IsoFile(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile() +
                "/com/googlecode/mp4parser/authoring/samples/1365070268951.mp4");
        SampleList sl = new SampleList(isoFile.getMovieBox().getBoxes(TrackBox.class).get(0));
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        for (int i = 0; i < sl.size(); i++) {
            //System.err.println("\"" + Hex.encodeHex(md5.digest(sl.get(i).asByteBuffer().array())) + "\",");
            byte[] sampleBytes = new byte[(int) sl.get(i).getSize()];
            sl.get(i).asByteBuffer().get(sampleBytes);
            Assert.assertEquals(sampleChecksum.get(i), Hex.encodeHex(md5.digest(sampleBytes)));
        }
    }

    List<String> sampleChecksum = Arrays.asList(
            "E8B264863D89C0AA9DA412F5A875E962",
            "4E0EB2B74685E3C67FCD06C78592DE02",
            "D8453125AD7FD1DA1A370A9F66FFEDA1",
            "DF00B2722AD61D8E874F2CD0AC83735F",
            "9F5E77FBA770ED794FC6F6C527D26C32",
            "791AB6C887F3DDD06F48B066479F7255",
            "A178B87694A0EF5208C03CFC2A6366CC",
            "365D6806D19F50C2B8601E5AD807F903",
            "B011EC24B6B692270C2A3E71B3FBB61A",
            "9B267F05B31A1E9BB1F756A56240660D",
            "B71553FCC0DAC77663C1D67E88379A61",
            "6C4D358F1DA3BB330F753A681307B388",
            "AE8CC6DAD1DB24CD5F5830B36A8F05F0",
            "03AF9011F5388F8675DE045612DB66D4",
            "F95EB3D8A23469B518E41D0DC1DCBC15",
            "6CF0ACCFC6C43E5BFFF8FE09FBEA6288",
            "6BE334D9EEA6C07D1141A0375335D684",
            "468F8491B8C6381E4F78C7C8AB5E4477",
            "CB114EDFF1054560ACD7F2656A379E63",
            "4FF39B2886282A60B371460177D1B1A8",
            "4DBC5A92CA0B36ADC7974897217A68D0",
            "752A968767D8C1993093097051EC26CC",
            "39E7EF190C00CDF5283A40A5C3DE4E24",
            "C3D1730755B987FEFCBF7D9A71551834",
            "C31948552D184EAA48380C855599CF75",
            "0DC21BBB652F02FD737A7A374C001E49",
            "97074E9DC88A0734D7879BB964E05948",
            "C445135FCD23FD5D0EF02F9F75459C7D",
            "925FE33B925640217E01456F3708DC2C",
            "EBC76CAFED17927F016753AAEC833692",
            "2BD88786CAE0E4C37B1346C3EA295E20",
            "80D563BB11C41EC345ABAF580EB8A81B",
            "980F26B9835608456127E72EF3A64665",
            "1848490B874405E743BFFDAF9CB0BE71",
            "6FA0FD07349098D6648C44B3A46A4977",
            "F1FBDB880B9D7BDDA9369DA87F5A9DB4",
            "40B64E9F0F4FF442E26F73AE5F5B0EAD",
            "A7EACE4BB146370CE94B60486E69DE78",
            "72E8FA11E30E256CE2047E7A3C92C9CE",
            "FB365B5C305FD7FF5A65EF56120A4991",
            "EBA8A19D06CD42845247BCE86188FD67",
            "4F132874DD1C2852093DE51181FC0B68",
            "63AE0891B84D3F168808D9B9001B4C26",
            "07F3AF12740441B53B2B144FD4685839",
            "797AA7BA8463C9A4F5F14659594EF2A6",
            "C8775596F10E17A6E3B62C1EB05C971D",
            "EF572014792A46B3AE88A13A2D6FD10A",
            "0AAC25197A63AC25F094AB344B67B001",
            "316E82A5C8F07DEEFF8DCC0ECAFC3AD7",
            "ADDDDEBE3565C43554D42457C523250F",
            "D40B8C664B8757E482A659FBAEE0859B",
            "0A38A2F2C29AC9A0F9E21CE65F3F5487",
            "E7B2F51154DD9265219EDD7B2FFED0D1",
            "09A880BD335D04EBFBAEBC0447C867BB",
            "7F2057FBF8A580ECC81197D3E987016F",
            "0B6226702E4E3986BB600D0AA3E5897E",
            "A8D46A169B439FA4C3A95F1DDCAF55AF",
            "96432757D95AF8135836D81C4FE06EF5",
            "B345E69C0435357EBFC5681A86C5854B",
            "51FC0F6290219DA481D8D3665C0D54E7",
            "40849235E71051F869EE3C36218A4D0F",
            "55646D0419F9368F14689060D7D5001E",
            "DE0237411074D2927DB3613546CA58E9",
            "84AD3083FB23364F146349C43A10AAE1",
            "F3F7A910689AB444373FF4DA593CFB11",
            "3E13409901D35E1A05C546836A07A404",
            "1E0B556D590BCD56872708BE817939C3",
            "828BDB499EA9D884FB9E82635F4AA403",
            "2FBC2B32D3B57D0D209D9CF5381ECDCB",
            "C2428ED5C4239A3956254C6014092E3A",
            "F8A664B4EBA87B76A1C9EECBD8D914BB",
            "031A835DBF70086E618467ABFDB8FFFF",
            "1E40FAE29059EC3095C782AB476494F5",
            "D42B3A3122CA5A82A98B7C0A95DA89D4",
            "AAB3C02A8DFD5FD51BA2BAB6C7F3E149",
            "E86BE97661630198054A0F2BCA865A4C",
            "DB0E45F01A1DE89820F4904374FB27D4",
            "6EB5B9437E7BA0FC7C7AA6DDFFE8049A",
            "AE156879D9CB9912D36DC85115565124",
            "51B9E65378E58985DBBF13A0F06AEB0C",
            "E13D0580781EB02996ED18285A4E0C7E",
            "E2A22849E3CD7595353B100D44B9B996",
            "B61303717325BB1650216765DA03DE99",
            "5D0881F262F26E060864A1357690210D",
            "B83746FD34ADFF95B3E02C406AE78155",
            "509B25A4B5F15F27B32C4E2F99C38152",
            "505B2E11AC8F7991B654FFFE0EA45F36",
            "EC6C10F67400A84FDFFBB8675F5CAFB4",
            "54DD594E1D9BDE133C3DFE43E9150ABB",
            "567A528F1DEB5701A94E7087971830F7",
            "5AB14E038D3E18C724D3B8F17F8831D6",
            "656C9378EA5FDEE17A56AD523C2F49A8",
            "B51552F3181FC1B852B5D0A5245D09E8",
            "E9247AE0E6E1182781F338063E48602B",
            "42B5B49FB44F5A6924BE746A97CCBB53",
            "F7D7CA3A0731D57A0D6C6B6656A92E53",
            "35809579C5B46A9000506DCFF2E6860E",
            "9CCBA52107222124DAC41E603012C27C",
            "90928A6B6B21B64D349CA1EA2D759FB8",
            "1CC340B4D9EF2819E71CED464111A9E3",
            "E2E70F465673829A925199BD8D64BC8A",
            "45431C3EE160B064FBC8252EB1EF43A2",
            "D1F180116F43076B515E108D48BAD0BC",
            "51D6EDAACEEC4EB11AAD18B4F2C98FD3",
            "B701BD9D7B9F557BC1B8E5A379AC3707",
            "20D03D54F5A0017A44DE46F50E0E1E64",
            "80AC926FB0B6E5BFAB9AC37D0001C033",
            "3BF894FA75C539B4EE6E7991E10869D3",
            "EF68A7A7E11E40457EE6C2C3C09686D6",
            "89B586CB2EAF9641437ECEB33415A32C",
            "545FBF4B90020F25059C28A2ED0149DC",
            "DA50EF12CBDB0662F772F4BA7F19D201",
            "5C583C2743EAE4DA219DD00B721CC8F3",
            "E3D655A991385CF3BEA7B2C99D98DD93",
            "A373C5E59911EDC9EE7EBCA12B8356FA",
            "B2ACF2D419B63D472A77A00E7F65D83E",
            "51CCE3A2E711BD30D9D4859A9885D476",
            "B9EC9F35625E1CC98D3952F5B281882D",
            "E43A9EC0619220980D1C237E10473B4A",
            "D853503269AC5B8596824E4B4D662812",
            "8DE7DEC744ECFCDFA55AE48B847648AF",
            "34BB11DF1BD020095DF9CDC4113D1728",
            "71D04F11B43AEF2315A55CEF4D2B6062",
            "74BA285C63C5328071656DEF55E1E4C6",
            "52FE252FE817A143E735C8B6EA429DA7",
            "C952EB29CE2C85D6714E8664936FB4E3",
            "BE2ECE5DF05F1E7BAC8CAF1693D4FF9B",
            "50DE4DEAB1223E8173B4BB19D323D4FD",
            "DA9BE9E5480C59C419D2388939383DE4"
    );
}
