## Data structure

MintPy uses [HDF5](https://www.hdfgroup.org) file internally. It loads files generated by various InSAR processors into HDF5 format (via `load_data.py` or `prep_*.py`). HDF5 files can exported into other format via `save_*.py`, i.e. [QGIS](../QGIS.md), [HDF-EOS5](../hdfeos5.md), GMT, ROI_PAC and [Google Earth KMZ](../google_earth.md).

### File name convention

Using the underscore `_` as the delimiter in the file name, the first part describes the file type, while the rest parts describe the additional operations. For example:

+  `timeseries.h5` is the raw time series
+  `timeseries_ERA5.h5` is the time series after the ERA5 correction;
+  `velocity.h5` is the velocity from the final displacement time series
+  `velocityERA5.h5` is the velocity from ERA5 tropospheric delay (from `inputs/ERA5.h5` file), not the displacement velocity after ERA5 correction.
+  `timeseriesResidual.h5` is the residual phase time series
+  `timeseriesResidual_ramp.h5` is the residual phase time series after deramping

### HDF5 data structure

All HDF5 files generated by MintPy have **datasets and attributes in the root level**. Files may have one or multiple datasets. Datasets in most files have the same shape (size), except for the pre-defined structure types below (presented in the most complete form):

#### timeseries

```cfg
/                Root level
Attributes       Dictionary for metadata
/date            1D array of string  in size of (n,     ) in YYYYMMDD format.
/timeseries      3D array of float32 in size of (n, l, w) in meter for cumulative displacement.
/bperp           1D array of float32 in size of (n,     ) in meter for perpendicular baseline.
```

where `n` is the number of acquisitions, `l` for length, `w` for width.

#### velocity

```cfg
/                          Root level
Attributes                 Dictionary of metadata
/velocity                  2D array of float32 in size of (l, w) in m/year         for polynomial function with the order of 1
/velocityStd               2D array of float32 in size of (l, w) in m/year         for polynomial function with the order of 1
/acceleration              2D array of float32 in size of (l, w) in m^2/year       for polynomial function with the order of 2
/accelerationStd           2D array of float32 in size of (l, w) in m^2/year       for polynomial function with the order of 2
/poly{order}               2D array of float32 in size of (l, w) in m^{order}/year for polynomial function with the order >= 3
/poly{order}Std            2D array of float32 in size of (l, w) in m^{order}/year for polynomial function with the order >= 3
...
/annualAmplitude           2D array of float32 in size of (l, w) in meter  for periodic function with period of 1     year
/annualPhase               2D array of float32 in size of (l, w) in radian for periodic function with period of 1     year
/semiAnnualAmplitude       2D array of float32 in size of (l, w) in meter  for periodic function with period of 1/2   year
/semiAnnualPhase           2D array of float32 in size of (l, w) in radian for periodic function with period of 1/2   year
/periodY{per}Amplitude     2D array of float32 in size of (l, w) in meter  for periodic function with period of {per} year
/periodY{per}Phase         2D array of float32 in size of (l, w) in radian for periodic function with period of {per} year
...
/step{YYYYMMDD}            2D array of float32 in size of (l, w) in meter for step function
/step{YYYYMMDD}Std         2D array of float32 in size of (l, w) in meter for step function
...
/velocityPost{YYYYMMDD}    2D array of float32 in size of (l, w) in m/year for a polyline function starting at {YYYYMMDD}
/velocityPost{YYYYMMDD}Std 2D array of float32 in size of (l, w) in m/year for a polyline function starting at {YYYYMMDD}
...
/exp{YYYYMMDD}Tau{tau}     2D array of float32 in size of (l, w) in meter for an exponential function starting at {YYYYMMDD} with characteristic time of {tau} days
/exp{YYYYMMDD}Tau{tau}Std  2D array of float32 in size of (l, w) in meter for an exponential function starting at {YYYYMMDD} with characteristic time of {tau} days
...
/log{YYYYMMDD}Tau{tau}     2D array of float32 in size of (l, w) in meter for a logarithmic function starting at {YYYYMMDD} with characteristic time of {tau} days
/log{YYYYMMDD}Tau{tau}Std  2D array of float32 in size of (l, w) in meter for a logarithmic function starting at {YYYYMMDD} with characteristic time of {tau} days
...
```

#### geometry

```cfg
/                        Root level
Attributes               Dictionary for metadata. 'X/Y_FIRST/STEP' attribute for geocoded.
/height                  2D array of float32 in size of (l, w   ) in meter. Height with respect to the ellipsoid (as provided by ISCE-2/topsStack) or geoid.
/latitude (azimuthCoord) 2D array of float32 in size of (l, w   ) in degree.
/longitude (rangeCoord)  2D array of float32 in size of (l, w   ) in degree.
/slantRangeDistance      2D array of float32 in size of (l, w   ) in meter.
/incidenceAngle          2D array of float32 in size of (l, w   ) in degree. Incidence angle of the LOS vector measured from vertical  at the target.
/azimuthAngle            2D array of float32 in size of (l, w   ) in degree. Azimuth   angle of the LOS vector measured from the north at the target with anti-clockwise direction as positive.
/shadowMask              2D array of bool    in size of (l, w   ). Mask with non-zero value for pixels in shadow in the LOS direction.
/waterMask               2D array of bool    in size of (l, w   ). Mask with non-zero value for pixels on land.
/bperp                   3D array of float32 in size of (n, l, w) in meter.
/date                    1D array of string  in size of (n,     ) in YYYYMMDD.
...
```

#### ifgramStack

```cfg
/                  Root level group name
Attributes         Dictionary for metadata
/date              2D array of string  in size of (m, 2   ) in YYYYMMDD format for reference and secondary date
/bperp             1D array of float32 in size of (m,     ) in meter for perpendicular baseline.
/dropIfgram        1D array of bool    in size of (m,     ) with 0/False for drop and 1/True for keep
/unwrapPhase       3D array of float32 in size of (m, l, w) in radian.
/coherence         3D array of float32 in size of (m, l, w).
/connectComponent  3D array of int16   in size of (m, l, w).
/wrapPhase         3D array of float32 in size of (m, l, w) in radian.
/azimuthOffset     3D array of float32 in size of (m, l, w) in pixel number.
/azimuthOffsetStd  3D array of float32 in size of (m, l, w) in pixel number.
/rangeOffset       3D array of float32 in size of (m, l, w) in pixel number.
/rangeOffsetStd    3D array of float32 in size of (m, l, w) in pixel number.
/offsetSNR         3D array of float32 in size of (m, l, w).
```

where `m` is the number of (interferometric / offset) pairs.

### Tips: check file structure with `info.py`

One could run `info.py` on ANY HDF5 file to display its file structure, e.g.:

```bash
yunjunz:~/data/test/FernandinaSenDT128/mintpy>$ info.py timeseries.h5
******************** Basic File Info ************************
file name: /Users/yunjunz/data/test/FernandinaSenDT128/mintpy/timeseries.h5
file type: timeseries
coordinates : RADAR

******************** Date Stat Info *************************
Start Date: 20141213
End   Date: 20180619
Number of acquisitions    : 98
Std. of acquisition times : 0.99 years
----------------------
List of dates:
['20141213', '20141225', '20150307', '20150319', '20150331', '20150412', '20150424', '20150506', '20150518', '20150530', '20150611', '20150623', '20150717', '20150729', '20150822', '20150903', '20150915', '20150927', '20151009', '20151021', '20151102', '20151114', '20151126', '20151208', '20151220', '20160101', '20160113', '20160125', '20160206', '20160218', '20160301', '20160406', '20160418', '20160430', '20160512', '20160524', '20160605', '20160629', '20160711', '20160723', '20160804', '20160816', '20160828', '20160909', '20160921', '20161003', '20161015', '20161027', '20161108', '20161120', '20161202', '20161214', '20161226', '20170107', '20170119', '20170131', '20170212', '20170224', '20170308', '20170320', '20170401', '20170413', '20170425', '20170507', '20170519', '20170531', '20170612', '20170624', '20170706', '20170718', '20170730', '20170811', '20170823', '20170904', '20170916', '20170928', '20171010', '20171022', '20171103', '20171115', '20171127', '20171209', '20171221', '20180102', '20180114', '20180126', '20180207', '20180219', '20180303', '20180315', '20180327', '20180408', '20180420', '20180502', '20180514', '20180526', '20180607', '20180619']
----------------------
...
******************** HDF5 File Structure ********************
Attributes in / level:
  ALOOKS                                          5
  ANTENNA_SIDE                                    -1
  AZIMUTH_PIXEL_SIZE                              78.08212603857966
  CENTER_LINE_UTC                                 42584.0
  DATA_TYPE                                       float32
  DATE12                                          141213-141225
  EARTH_RADIUS                                    6337286.638938101
  END_DATE                                        20180619
  FILE_LENGTH                                     450
  FILE_PATH                                       /Users/yunjunz/data/test/FernandinaSenDT128/merged/interferograms/20141213_20141225/filt_fine.unw
  FILE_TYPE                                       timeseries
  HEADING                                         -168.01821899414062
  HEIGHT                                          698834.2261352595
  LAT_REF1                                        -0.27142282744993307
  LAT_REF2                                        -0.2052012679974385
  LAT_REF3                                        -0.548154094069745
  LAT_REF4                                        -0.4814968797610026
  LENGTH                                          450
  LON_REF1                                        -91.33901754364975
  LON_REF2                                        -91.64656503719202
  ...

HDF5 dataset "/bperp               ": shape (98,)               , dtype <float32>
HDF5 dataset "/date                ": shape (98,)               , dtype <|S8>
HDF5 dataset "/timeseries          ": shape (98, 450, 600)      , dtype <float32>
```
