; ***********************************************************
; ; Adapt path if necessary:
; (define path "~/minlog/examples/tait/diplomarbeit_schlenker/")

; ; Defines the function "pload" to load files 
; ; from the path defined above
; (define pload (lambda (x) (load (string-append path x))))

; ; Used Modules:
; (pload "./initiate.scm")
; (pload "./defsLamCalc.scm")
;
; NOTICE: Uncomment modules only when file is run on its own
; ***********************************************************


; =======================================
;  Section: Definitions for Substitution
; =======================================

; Definition: "Sublist"
; ---------------------
; "Sublist" stands for "Substitution list"

(add-alg "Sublist"
	 '("Up" "nat=>Sublist")
	 '("Dot" "term=>Sublist=>Sublist"))

(add-var-name "theta" (py "Sublist"))

; Definition: "Lift"
; ------------------
; lifts terms with respect to given l and k

(add-program-constant "Lift" (py "term=>nat=>nat=>term") 1)

(add-computation-rule (pt "Lift (Var n) l k")
		      (pt "[if (n<l) (Var n) (Var(n+k))]"))
(add-computation-rule (pt "Lift (App r s) l k")
                      (pt "App (Lift r l k)(Lift s l k)"))
(add-computation-rule (pt "Lift(Abs rho r)l k")
		      (pt "Abs rho (Lift r(l+1)k)"))

; Definition: "Sublift"
; ---------------------
; lifts substitution lists

(add-program-constant "Sublift" 
 (py "Sublist=>nat=>Sublist") 1 'const 2)

(add-computation-rule (pt "Sublift(Up m)n") (pt "Up(m+n)"))
(add-computation-rule (pt "Sublift(Dot r theta)n")
		      (pt "Dot(Lift r 0 n)(Sublift theta n)"))

; Definition: "Sub"
; -----------------
; substitution of a term r by a substitution list theta

(add-program-constant "Sub" (py "term=>Sublist=>term") 1 'const 2)

(add-computation-rule (pt "Sub(Var 0)(Dot r theta)") (pt "r"))
(add-computation-rule (pt "Sub(Var(Succ n))(Dot r theta)")
                      (pt "Sub(Var n)theta"))
(add-computation-rule (pt "Sub(Var n)(Up m)") (pt "Var(n+m)"))
(add-computation-rule (pt "Sub(r s)theta") 
                      (pt "(Sub r theta)(Sub s theta)"))
(add-computation-rule (pt "Sub(Abs rho r)theta")
                      (pt "(Abs rho (Sub r(Dot(Var 0)
                           (Sublift theta 1))))"))

; Definition: Seq
; ---------------
; creates a list on natural numbers from n to (n+l)

(add-program-constant "Seq" (py "nat=>nat=>list nat") 1)

(add-computation-rule (pt "Seq n 0") (pt "(Nil nat)"))
(add-computation-rule (pt "Seq n(Succ l)") (pt "n::Seq(Succ n)l"))

; (pp (nt (pt "Seq 2 5")))
; => 2::3::4::5::6:

; Definition: Wrap
; ----------------
; wraps up a list of terms to a Sublist with a parameter for lifting

(add-program-constant "Wrap" (py "nat=>list term=>Sublist") 1)

(add-var-name "termlist" (py "list term"))

(add-computation-rule (pt "Wrap n (Nil term)")(pt "Up n"))
(add-computation-rule (pt "Wrap n (r::termlist)")
                      (pt "Dot r (Wrap n termlist)"))
