# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.tiff_reader import TIFFReader


class OMETIFFReader(TIFFReader):
    r"""
    OMETIFFReader - reader for OME TIFF files
    
    Superclass: TIFFReader
    
    OMETIFFReader supports reading OME-TIFF files. These are TIFF
    files with OME meta-data that helps interpret the contents of the
    TIFF.
    
    The OME-TIFF specification is available here:
    https://docs.openmicroscopy.org/ome-model/5.6.3/ome-tiff/specification
    .html#ome-tiff-specification
    
    The current implementation only supports single-file, multi-page
    TIFF. It will not read multi-file OME-TIFF files correctly.
    
    Unlike most image readers, this reader does not support arbitrary
    sub-extent requests. This is because the splicing of the `z`, `t`,
    and `c` planes can make it tricky to read sub-extents in `z` for
    certain dimension orders. This reader supports piece-request instead
    and satisfies such request by splitting the `XY` plane into requested
    number of pieces.
    
    The reader lets the superclass read the whole TIFF volume and then
    splice it up into channels, timesteps, and z-planes. The parts are
    then cached internally so that subsequent timestep requests can be
    served without re-reading the file.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOMETIFFReader, obj, update, **traits)
    
    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('ignore_color_map', 'GetIgnoreColorMap'), ('origin_specified_flag',
    'GetOriginSpecifiedFlag'), ('spacing_specified_flag',
    'GetSpacingSpecifiedFlag'), ('file_lower_left', 'GetFileLowerLeft'),
    ('swap_bytes', 'GetSwapBytes'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('data_byte_order', 'GetDataByteOrder'), ('orientation_type',
    'GetOrientationType'), ('data_direction', 'GetDataDirection'),
    ('data_extent', 'GetDataExtent'), ('data_origin', 'GetDataOrigin'),
    ('data_spacing', 'GetDataSpacing'), ('file_dimensionality',
    'GetFileDimensionality'), ('file_name', 'GetFileName'),
    ('file_name_slice_offset', 'GetFileNameSliceOffset'),
    ('file_name_slice_spacing', 'GetFileNameSliceSpacing'),
    ('file_pattern', 'GetFilePattern'), ('file_prefix', 'GetFilePrefix'),
    ('header_size', 'GetHeaderSize'), ('memory_buffer_length',
    'GetMemoryBufferLength'), ('number_of_scalar_components',
    'GetNumberOfScalarComponents'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'file_lower_left',
    'global_warning_display', 'ignore_color_map', 'origin_specified_flag',
    'release_data_flag', 'spacing_specified_flag', 'swap_bytes',
    'data_byte_order', 'data_direction', 'data_extent', 'data_origin',
    'data_spacing', 'file_dimensionality', 'file_name',
    'file_name_slice_offset', 'file_name_slice_spacing', 'file_pattern',
    'file_prefix', 'header_size', 'memory_buffer_length',
    'number_of_scalar_components', 'orientation_type', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OMETIFFReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OMETIFFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['file_lower_left', 'ignore_color_map', 'origin_specified_flag',
            'spacing_specified_flag', 'swap_bytes'], ['data_byte_order'],
            ['data_direction', 'data_extent', 'data_origin', 'data_spacing',
            'file_dimensionality', 'file_name', 'file_name_slice_offset',
            'file_name_slice_spacing', 'file_pattern', 'file_prefix',
            'header_size', 'memory_buffer_length', 'number_of_scalar_components',
            'orientation_type']),
            title='Edit OMETIFFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OMETIFFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

