/* WARNING: auto-generated (by autogen/speed); do not edit */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <cpucycles.h> /* -lcpucycles */
#include <ntruprime.h> /* -lntruprime */
#include <randombytes.h> /* -lrandombytes */

static const char *targeto = 0;
static const char *targetp = 0;
static const char *targeti = 0;

#include "limits.inc"

static void *callocplus(long long len)
{
  void *x = calloc(1,len + 128);
  if (!x) abort();
  return x;
}

static void *aligned(void *x)
{
  unsigned char *y = x;
  y += 63 & (-(unsigned long) x);
  return y;
}

static void longlong_sort(long long *x,long long n)
{
  long long top,p,q,r,i;

  if (n < 2) return;
  top = 1;
  while (top < n - top) top += top;

  for (p = top;p > 0;p >>= 1) {
    for (i = 0;i < n - p;++i)
      if (!(i & p))
        if (x[i] > x[i+p]) {
          long long t = x[i];
          x[i] = x[i+p];
          x[i+p] = t;
        }
    i = 0;
    for (q = top;q > p;q >>= 1) {
      for (;i < n - q;++i) {
        if (!(i & p)) {
          long long a = x[i + p];
          for (r = q;r > p;r >>= 1)
            if (a > x[i+r]) {
              long long t = a;
              a = x[i+r];
              x[i+r] = t;
            }
          x[i + p] = a;
        }
      }
    }
  }
}

#define TIMINGS 32 // must be multiple of 4
static long long t[TIMINGS+1];

static void t_print(const char *op,long long impl,long long len)
{
  long long tsort[TIMINGS];
  long long iqm = 0;

  printf("%s",op);
  if (impl >= 0)
    printf(" %lld",impl);
  else
    printf(" selected");
  printf(" %lld",len);
  for (long long i = 0;i < TIMINGS;++i)
    tsort[i] = t[i] = t[i+1]-t[i];
  longlong_sort(tsort,TIMINGS);

  for (long long j = TIMINGS/4;j < 3*TIMINGS/4;++j)
    iqm += tsort[j];
  iqm *= 2;
  iqm += TIMINGS/2;
  iqm /= TIMINGS;

  printf(" %lld ",iqm);
  for (long long i = 0;i < TIMINGS;++i)
    printf("%+lld",t[i]-iqm);
  printf("\n");
  fflush(stdout);
}

#define MAXTEST_BYTES 65536

static void measure_cpucycles(void)
{
  printf("cpucycles selected persecond %lld\n",cpucycles_persecond());
  printf("cpucycles selected implementation %s\n",cpucycles_implementation());

  for (long long i = 0;i <= TIMINGS;++i)
    t[i] = cpucycles();
  t_print("cpucycles",-1,0);
}

static void measure_randombytes(void)
{
  void *mstorage = callocplus(MAXTEST_BYTES);
  unsigned char *m = aligned(mstorage);
  long long mlen = 0;

  while (mlen < MAXTEST_BYTES) {
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      randombytes(m,mlen);
    }
    t_print("randombytes",-1,mlen);
    mlen += 1+mlen/2;
  }
  free(mstorage);
}

static void measure_verify_897(void)
{
  if (targeto && strcmp(targeto,"verify")) return;
  if (targetp && strcmp(targetp,"897")) return;
  void *xstorage = callocplus(ntruprime_verify_897_BYTES);
  unsigned char *x = aligned(xstorage);
  void *ystorage = callocplus(ntruprime_verify_897_BYTES);
  unsigned char *y = aligned(ystorage);

  for (long long impl = -1;impl < ntruprime_numimpl_verify_897();++impl) {
    int (*crypto_verify)(const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_verify_897_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_verify = ntruprime_dispatch_verify_897(impl);
      printf("verify_897 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_verify_897_implementation(impl),ntruprime_dispatch_verify_897_compiler(impl));
    } else {
      crypto_verify = ntruprime_verify_897;
      printf("verify_897 selected implementation %s compiler %s\n",ntruprime_verify_897_implementation(),ntruprime_verify_897_compiler());
    }
    randombytes(x,ntruprime_verify_897_BYTES);
    randombytes(y,ntruprime_verify_897_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_verify(x,y);
    }
    t_print("verify_897",impl,ntruprime_verify_897_BYTES);
  }
  free(ystorage);
  free(xstorage);
}

static void measure_verify_1039(void)
{
  if (targeto && strcmp(targeto,"verify")) return;
  if (targetp && strcmp(targetp,"1039")) return;
  void *xstorage = callocplus(ntruprime_verify_1039_BYTES);
  unsigned char *x = aligned(xstorage);
  void *ystorage = callocplus(ntruprime_verify_1039_BYTES);
  unsigned char *y = aligned(ystorage);

  for (long long impl = -1;impl < ntruprime_numimpl_verify_1039();++impl) {
    int (*crypto_verify)(const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_verify_1039_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_verify = ntruprime_dispatch_verify_1039(impl);
      printf("verify_1039 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_verify_1039_implementation(impl),ntruprime_dispatch_verify_1039_compiler(impl));
    } else {
      crypto_verify = ntruprime_verify_1039;
      printf("verify_1039 selected implementation %s compiler %s\n",ntruprime_verify_1039_implementation(),ntruprime_verify_1039_compiler());
    }
    randombytes(x,ntruprime_verify_1039_BYTES);
    randombytes(y,ntruprime_verify_1039_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_verify(x,y);
    }
    t_print("verify_1039",impl,ntruprime_verify_1039_BYTES);
  }
  free(ystorage);
  free(xstorage);
}

static void measure_verify_1184(void)
{
  if (targeto && strcmp(targeto,"verify")) return;
  if (targetp && strcmp(targetp,"1184")) return;
  void *xstorage = callocplus(ntruprime_verify_1184_BYTES);
  unsigned char *x = aligned(xstorage);
  void *ystorage = callocplus(ntruprime_verify_1184_BYTES);
  unsigned char *y = aligned(ystorage);

  for (long long impl = -1;impl < ntruprime_numimpl_verify_1184();++impl) {
    int (*crypto_verify)(const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_verify_1184_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_verify = ntruprime_dispatch_verify_1184(impl);
      printf("verify_1184 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_verify_1184_implementation(impl),ntruprime_dispatch_verify_1184_compiler(impl));
    } else {
      crypto_verify = ntruprime_verify_1184;
      printf("verify_1184 selected implementation %s compiler %s\n",ntruprime_verify_1184_implementation(),ntruprime_verify_1184_compiler());
    }
    randombytes(x,ntruprime_verify_1184_BYTES);
    randombytes(y,ntruprime_verify_1184_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_verify(x,y);
    }
    t_print("verify_1184",impl,ntruprime_verify_1184_BYTES);
  }
  free(ystorage);
  free(xstorage);
}

static void measure_verify_1349(void)
{
  if (targeto && strcmp(targeto,"verify")) return;
  if (targetp && strcmp(targetp,"1349")) return;
  void *xstorage = callocplus(ntruprime_verify_1349_BYTES);
  unsigned char *x = aligned(xstorage);
  void *ystorage = callocplus(ntruprime_verify_1349_BYTES);
  unsigned char *y = aligned(ystorage);

  for (long long impl = -1;impl < ntruprime_numimpl_verify_1349();++impl) {
    int (*crypto_verify)(const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_verify_1349_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_verify = ntruprime_dispatch_verify_1349(impl);
      printf("verify_1349 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_verify_1349_implementation(impl),ntruprime_dispatch_verify_1349_compiler(impl));
    } else {
      crypto_verify = ntruprime_verify_1349;
      printf("verify_1349 selected implementation %s compiler %s\n",ntruprime_verify_1349_implementation(),ntruprime_verify_1349_compiler());
    }
    randombytes(x,ntruprime_verify_1349_BYTES);
    randombytes(y,ntruprime_verify_1349_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_verify(x,y);
    }
    t_print("verify_1349",impl,ntruprime_verify_1349_BYTES);
  }
  free(ystorage);
  free(xstorage);
}

static void measure_verify_1455(void)
{
  if (targeto && strcmp(targeto,"verify")) return;
  if (targetp && strcmp(targetp,"1455")) return;
  void *xstorage = callocplus(ntruprime_verify_1455_BYTES);
  unsigned char *x = aligned(xstorage);
  void *ystorage = callocplus(ntruprime_verify_1455_BYTES);
  unsigned char *y = aligned(ystorage);

  for (long long impl = -1;impl < ntruprime_numimpl_verify_1455();++impl) {
    int (*crypto_verify)(const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_verify_1455_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_verify = ntruprime_dispatch_verify_1455(impl);
      printf("verify_1455 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_verify_1455_implementation(impl),ntruprime_dispatch_verify_1455_compiler(impl));
    } else {
      crypto_verify = ntruprime_verify_1455;
      printf("verify_1455 selected implementation %s compiler %s\n",ntruprime_verify_1455_implementation(),ntruprime_verify_1455_compiler());
    }
    randombytes(x,ntruprime_verify_1455_BYTES);
    randombytes(y,ntruprime_verify_1455_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_verify(x,y);
    }
    t_print("verify_1455",impl,ntruprime_verify_1455_BYTES);
  }
  free(ystorage);
  free(xstorage);
}

static void measure_verify_1847(void)
{
  if (targeto && strcmp(targeto,"verify")) return;
  if (targetp && strcmp(targetp,"1847")) return;
  void *xstorage = callocplus(ntruprime_verify_1847_BYTES);
  unsigned char *x = aligned(xstorage);
  void *ystorage = callocplus(ntruprime_verify_1847_BYTES);
  unsigned char *y = aligned(ystorage);

  for (long long impl = -1;impl < ntruprime_numimpl_verify_1847();++impl) {
    int (*crypto_verify)(const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_verify_1847_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_verify = ntruprime_dispatch_verify_1847(impl);
      printf("verify_1847 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_verify_1847_implementation(impl),ntruprime_dispatch_verify_1847_compiler(impl));
    } else {
      crypto_verify = ntruprime_verify_1847;
      printf("verify_1847 selected implementation %s compiler %s\n",ntruprime_verify_1847_implementation(),ntruprime_verify_1847_compiler());
    }
    randombytes(x,ntruprime_verify_1847_BYTES);
    randombytes(y,ntruprime_verify_1847_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_verify(x,y);
    }
    t_print("verify_1847",impl,ntruprime_verify_1847_BYTES);
  }
  free(ystorage);
  free(xstorage);
}

static void measure_hashblocks_sha512(void)
{
  if (targeto && strcmp(targeto,"hashblocks")) return;
  if (targetp && strcmp(targetp,"sha512")) return;
  void *hstorage = callocplus(ntruprime_hashblocks_sha512_STATEBYTES);
  unsigned char *h = aligned(hstorage);
  void *mstorage = callocplus(MAXTEST_BYTES);
  unsigned char *m = aligned(mstorage);
  long long mlen;

  for (long long impl = -1;impl < ntruprime_numimpl_hashblocks_sha512();++impl) {
    int (*crypto_hashblocks)(unsigned char *,const unsigned char *,long long);
    if (targeti && strcmp(targeti,ntruprime_dispatch_hashblocks_sha512_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_hashblocks = ntruprime_dispatch_hashblocks_sha512(impl);
      printf("hashblocks_sha512 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_hashblocks_sha512_implementation(impl),ntruprime_dispatch_hashblocks_sha512_compiler(impl));
    } else {
      crypto_hashblocks = ntruprime_hashblocks_sha512;
      printf("hashblocks_sha512 selected implementation %s compiler %s\n",ntruprime_hashblocks_sha512_implementation(),ntruprime_hashblocks_sha512_compiler());
    }
    randombytes(h,ntruprime_hashblocks_sha512_STATEBYTES);
    randombytes(m,MAXTEST_BYTES);
    mlen = 0;
    while (mlen <= MAXTEST_BYTES) {
      randombytes(m,mlen);
      for (long long i = 0;i <= TIMINGS;++i) {
        t[i] = cpucycles();
        crypto_hashblocks(h,m,mlen);
      }
      t_print("hashblocks_sha512",impl,mlen);
      mlen += 1+mlen/2;
    }
  }
  free(mstorage);
  free(hstorage);
}

static void measure_hash_sha512(void)
{
  if (targeto && strcmp(targeto,"hash")) return;
  if (targetp && strcmp(targetp,"sha512")) return;
  void *hstorage = callocplus(ntruprime_hash_sha512_BYTES);
  unsigned char *h = aligned(hstorage);
  void *mstorage = callocplus(MAXTEST_BYTES);
  unsigned char *m = aligned(mstorage);
  long long mlen;

  for (long long impl = -1;impl < ntruprime_numimpl_hash_sha512();++impl) {
    void (*crypto_hash)(unsigned char *,const unsigned char *,long long);
    if (targeti && strcmp(targeti,ntruprime_dispatch_hash_sha512_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_hash = ntruprime_dispatch_hash_sha512(impl);
      printf("hash_sha512 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_hash_sha512_implementation(impl),ntruprime_dispatch_hash_sha512_compiler(impl));
    } else {
      crypto_hash = ntruprime_hash_sha512;
      printf("hash_sha512 selected implementation %s compiler %s\n",ntruprime_hash_sha512_implementation(),ntruprime_hash_sha512_compiler());
    }
    randombytes(h,ntruprime_hash_sha512_BYTES);
    randombytes(m,MAXTEST_BYTES);
    mlen = 0;
    while (mlen <= MAXTEST_BYTES) {
      randombytes(m,mlen);
      for (long long i = 0;i <= TIMINGS;++i) {
        t[i] = cpucycles();
        crypto_hash(h,m,mlen);
      }
      t_print("hash_sha512",impl,mlen);
      mlen += 1+mlen/2;
    }
  }
  free(mstorage);
  free(hstorage);
}

static void measure_decode_653x3(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"653x3")) return;
  void *xstorage = callocplus(ntruprime_decode_653x3_ITEMS*ntruprime_decode_653x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_653x3_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_653x3();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_653x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_653x3(impl);
      printf("decode_653x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_653x3_implementation(impl),ntruprime_dispatch_decode_653x3_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_653x3;
      printf("decode_653x3 selected implementation %s compiler %s\n",ntruprime_decode_653x3_implementation(),ntruprime_decode_653x3_compiler());
    }
    randombytes(x,ntruprime_decode_653x3_ITEMS*ntruprime_decode_653x3_ITEMBYTES);
    randombytes(s,ntruprime_decode_653x3_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_653x3",impl,ntruprime_decode_653x3_ITEMS*ntruprime_decode_653x3_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_653x1541(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"653x1541")) return;
  void *xstorage = callocplus(ntruprime_decode_653x1541_ITEMS*ntruprime_decode_653x1541_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_653x1541_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_653x1541();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_653x1541_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_653x1541(impl);
      printf("decode_653x1541 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_653x1541_implementation(impl),ntruprime_dispatch_decode_653x1541_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_653x1541;
      printf("decode_653x1541 selected implementation %s compiler %s\n",ntruprime_decode_653x1541_implementation(),ntruprime_decode_653x1541_compiler());
    }
    randombytes(x,ntruprime_decode_653x1541_ITEMS*ntruprime_decode_653x1541_ITEMBYTES);
    randombytes(s,ntruprime_decode_653x1541_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_653x1541",impl,ntruprime_decode_653x1541_ITEMS*ntruprime_decode_653x1541_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_653x4621(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"653x4621")) return;
  void *xstorage = callocplus(ntruprime_decode_653x4621_ITEMS*ntruprime_decode_653x4621_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_653x4621_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_653x4621();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_653x4621_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_653x4621(impl);
      printf("decode_653x4621 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_653x4621_implementation(impl),ntruprime_dispatch_decode_653x4621_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_653x4621;
      printf("decode_653x4621 selected implementation %s compiler %s\n",ntruprime_decode_653x4621_implementation(),ntruprime_decode_653x4621_compiler());
    }
    randombytes(x,ntruprime_decode_653x4621_ITEMS*ntruprime_decode_653x4621_ITEMBYTES);
    randombytes(s,ntruprime_decode_653x4621_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_653x4621",impl,ntruprime_decode_653x4621_ITEMS*ntruprime_decode_653x4621_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_653xint16(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"653xint16")) return;
  void *xstorage = callocplus(ntruprime_decode_653xint16_ITEMS*ntruprime_decode_653xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_653xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_653xint16();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_653xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_653xint16(impl);
      printf("decode_653xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_653xint16_implementation(impl),ntruprime_dispatch_decode_653xint16_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_653xint16;
      printf("decode_653xint16 selected implementation %s compiler %s\n",ntruprime_decode_653xint16_implementation(),ntruprime_decode_653xint16_compiler());
    }
    randombytes(x,ntruprime_decode_653xint16_ITEMS*ntruprime_decode_653xint16_ITEMBYTES);
    randombytes(s,ntruprime_decode_653xint16_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_653xint16",impl,ntruprime_decode_653xint16_ITEMS*ntruprime_decode_653xint16_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_653xint32(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"653xint32")) return;
  void *xstorage = callocplus(ntruprime_decode_653xint32_ITEMS*ntruprime_decode_653xint32_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_653xint32_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_653xint32();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_653xint32_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_653xint32(impl);
      printf("decode_653xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_653xint32_implementation(impl),ntruprime_dispatch_decode_653xint32_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_653xint32;
      printf("decode_653xint32 selected implementation %s compiler %s\n",ntruprime_decode_653xint32_implementation(),ntruprime_decode_653xint32_compiler());
    }
    randombytes(x,ntruprime_decode_653xint32_ITEMS*ntruprime_decode_653xint32_ITEMBYTES);
    randombytes(s,ntruprime_decode_653xint32_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_653xint32",impl,ntruprime_decode_653xint32_ITEMS*ntruprime_decode_653xint32_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_761x3(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761x3")) return;
  void *xstorage = callocplus(ntruprime_decode_761x3_ITEMS*ntruprime_decode_761x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_761x3_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_761x3();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_761x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_761x3(impl);
      printf("decode_761x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761x3_implementation(impl),ntruprime_dispatch_decode_761x3_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_761x3;
      printf("decode_761x3 selected implementation %s compiler %s\n",ntruprime_decode_761x3_implementation(),ntruprime_decode_761x3_compiler());
    }
    randombytes(x,ntruprime_decode_761x3_ITEMS*ntruprime_decode_761x3_ITEMBYTES);
    randombytes(s,ntruprime_decode_761x3_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_761x3",impl,ntruprime_decode_761x3_ITEMS*ntruprime_decode_761x3_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_761x1531(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761x1531")) return;
  void *xstorage = callocplus(ntruprime_decode_761x1531_ITEMS*ntruprime_decode_761x1531_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_761x1531_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_761x1531();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_761x1531_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_761x1531(impl);
      printf("decode_761x1531 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761x1531_implementation(impl),ntruprime_dispatch_decode_761x1531_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_761x1531;
      printf("decode_761x1531 selected implementation %s compiler %s\n",ntruprime_decode_761x1531_implementation(),ntruprime_decode_761x1531_compiler());
    }
    randombytes(x,ntruprime_decode_761x1531_ITEMS*ntruprime_decode_761x1531_ITEMBYTES);
    randombytes(s,ntruprime_decode_761x1531_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_761x1531",impl,ntruprime_decode_761x1531_ITEMS*ntruprime_decode_761x1531_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_761x4591(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761x4591")) return;
  void *xstorage = callocplus(ntruprime_decode_761x4591_ITEMS*ntruprime_decode_761x4591_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_761x4591_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_761x4591();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_761x4591_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_761x4591(impl);
      printf("decode_761x4591 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761x4591_implementation(impl),ntruprime_dispatch_decode_761x4591_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_761x4591;
      printf("decode_761x4591 selected implementation %s compiler %s\n",ntruprime_decode_761x4591_implementation(),ntruprime_decode_761x4591_compiler());
    }
    randombytes(x,ntruprime_decode_761x4591_ITEMS*ntruprime_decode_761x4591_ITEMBYTES);
    randombytes(s,ntruprime_decode_761x4591_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_761x4591",impl,ntruprime_decode_761x4591_ITEMS*ntruprime_decode_761x4591_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_761xint16(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761xint16")) return;
  void *xstorage = callocplus(ntruprime_decode_761xint16_ITEMS*ntruprime_decode_761xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_761xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_761xint16();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_761xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_761xint16(impl);
      printf("decode_761xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761xint16_implementation(impl),ntruprime_dispatch_decode_761xint16_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_761xint16;
      printf("decode_761xint16 selected implementation %s compiler %s\n",ntruprime_decode_761xint16_implementation(),ntruprime_decode_761xint16_compiler());
    }
    randombytes(x,ntruprime_decode_761xint16_ITEMS*ntruprime_decode_761xint16_ITEMBYTES);
    randombytes(s,ntruprime_decode_761xint16_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_761xint16",impl,ntruprime_decode_761xint16_ITEMS*ntruprime_decode_761xint16_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_761xint32(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761xint32")) return;
  void *xstorage = callocplus(ntruprime_decode_761xint32_ITEMS*ntruprime_decode_761xint32_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_761xint32_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_761xint32();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_761xint32_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_761xint32(impl);
      printf("decode_761xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761xint32_implementation(impl),ntruprime_dispatch_decode_761xint32_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_761xint32;
      printf("decode_761xint32 selected implementation %s compiler %s\n",ntruprime_decode_761xint32_implementation(),ntruprime_decode_761xint32_compiler());
    }
    randombytes(x,ntruprime_decode_761xint32_ITEMS*ntruprime_decode_761xint32_ITEMBYTES);
    randombytes(s,ntruprime_decode_761xint32_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_761xint32",impl,ntruprime_decode_761xint32_ITEMS*ntruprime_decode_761xint32_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_857x3(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857x3")) return;
  void *xstorage = callocplus(ntruprime_decode_857x3_ITEMS*ntruprime_decode_857x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_857x3_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_857x3();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_857x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_857x3(impl);
      printf("decode_857x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857x3_implementation(impl),ntruprime_dispatch_decode_857x3_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_857x3;
      printf("decode_857x3 selected implementation %s compiler %s\n",ntruprime_decode_857x3_implementation(),ntruprime_decode_857x3_compiler());
    }
    randombytes(x,ntruprime_decode_857x3_ITEMS*ntruprime_decode_857x3_ITEMBYTES);
    randombytes(s,ntruprime_decode_857x3_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_857x3",impl,ntruprime_decode_857x3_ITEMS*ntruprime_decode_857x3_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_857x1723(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857x1723")) return;
  void *xstorage = callocplus(ntruprime_decode_857x1723_ITEMS*ntruprime_decode_857x1723_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_857x1723_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_857x1723();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_857x1723_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_857x1723(impl);
      printf("decode_857x1723 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857x1723_implementation(impl),ntruprime_dispatch_decode_857x1723_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_857x1723;
      printf("decode_857x1723 selected implementation %s compiler %s\n",ntruprime_decode_857x1723_implementation(),ntruprime_decode_857x1723_compiler());
    }
    randombytes(x,ntruprime_decode_857x1723_ITEMS*ntruprime_decode_857x1723_ITEMBYTES);
    randombytes(s,ntruprime_decode_857x1723_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_857x1723",impl,ntruprime_decode_857x1723_ITEMS*ntruprime_decode_857x1723_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_857x5167(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857x5167")) return;
  void *xstorage = callocplus(ntruprime_decode_857x5167_ITEMS*ntruprime_decode_857x5167_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_857x5167_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_857x5167();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_857x5167_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_857x5167(impl);
      printf("decode_857x5167 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857x5167_implementation(impl),ntruprime_dispatch_decode_857x5167_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_857x5167;
      printf("decode_857x5167 selected implementation %s compiler %s\n",ntruprime_decode_857x5167_implementation(),ntruprime_decode_857x5167_compiler());
    }
    randombytes(x,ntruprime_decode_857x5167_ITEMS*ntruprime_decode_857x5167_ITEMBYTES);
    randombytes(s,ntruprime_decode_857x5167_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_857x5167",impl,ntruprime_decode_857x5167_ITEMS*ntruprime_decode_857x5167_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_857xint16(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857xint16")) return;
  void *xstorage = callocplus(ntruprime_decode_857xint16_ITEMS*ntruprime_decode_857xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_857xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_857xint16();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_857xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_857xint16(impl);
      printf("decode_857xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857xint16_implementation(impl),ntruprime_dispatch_decode_857xint16_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_857xint16;
      printf("decode_857xint16 selected implementation %s compiler %s\n",ntruprime_decode_857xint16_implementation(),ntruprime_decode_857xint16_compiler());
    }
    randombytes(x,ntruprime_decode_857xint16_ITEMS*ntruprime_decode_857xint16_ITEMBYTES);
    randombytes(s,ntruprime_decode_857xint16_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_857xint16",impl,ntruprime_decode_857xint16_ITEMS*ntruprime_decode_857xint16_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_857xint32(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857xint32")) return;
  void *xstorage = callocplus(ntruprime_decode_857xint32_ITEMS*ntruprime_decode_857xint32_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_857xint32_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_857xint32();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_857xint32_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_857xint32(impl);
      printf("decode_857xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857xint32_implementation(impl),ntruprime_dispatch_decode_857xint32_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_857xint32;
      printf("decode_857xint32 selected implementation %s compiler %s\n",ntruprime_decode_857xint32_implementation(),ntruprime_decode_857xint32_compiler());
    }
    randombytes(x,ntruprime_decode_857xint32_ITEMS*ntruprime_decode_857xint32_ITEMBYTES);
    randombytes(s,ntruprime_decode_857xint32_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_857xint32",impl,ntruprime_decode_857xint32_ITEMS*ntruprime_decode_857xint32_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_953x3(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953x3")) return;
  void *xstorage = callocplus(ntruprime_decode_953x3_ITEMS*ntruprime_decode_953x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_953x3_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_953x3();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_953x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_953x3(impl);
      printf("decode_953x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953x3_implementation(impl),ntruprime_dispatch_decode_953x3_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_953x3;
      printf("decode_953x3 selected implementation %s compiler %s\n",ntruprime_decode_953x3_implementation(),ntruprime_decode_953x3_compiler());
    }
    randombytes(x,ntruprime_decode_953x3_ITEMS*ntruprime_decode_953x3_ITEMBYTES);
    randombytes(s,ntruprime_decode_953x3_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_953x3",impl,ntruprime_decode_953x3_ITEMS*ntruprime_decode_953x3_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_953x2115(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953x2115")) return;
  void *xstorage = callocplus(ntruprime_decode_953x2115_ITEMS*ntruprime_decode_953x2115_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_953x2115_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_953x2115();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_953x2115_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_953x2115(impl);
      printf("decode_953x2115 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953x2115_implementation(impl),ntruprime_dispatch_decode_953x2115_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_953x2115;
      printf("decode_953x2115 selected implementation %s compiler %s\n",ntruprime_decode_953x2115_implementation(),ntruprime_decode_953x2115_compiler());
    }
    randombytes(x,ntruprime_decode_953x2115_ITEMS*ntruprime_decode_953x2115_ITEMBYTES);
    randombytes(s,ntruprime_decode_953x2115_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_953x2115",impl,ntruprime_decode_953x2115_ITEMS*ntruprime_decode_953x2115_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_953x6343(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953x6343")) return;
  void *xstorage = callocplus(ntruprime_decode_953x6343_ITEMS*ntruprime_decode_953x6343_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_953x6343_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_953x6343();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_953x6343_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_953x6343(impl);
      printf("decode_953x6343 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953x6343_implementation(impl),ntruprime_dispatch_decode_953x6343_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_953x6343;
      printf("decode_953x6343 selected implementation %s compiler %s\n",ntruprime_decode_953x6343_implementation(),ntruprime_decode_953x6343_compiler());
    }
    randombytes(x,ntruprime_decode_953x6343_ITEMS*ntruprime_decode_953x6343_ITEMBYTES);
    randombytes(s,ntruprime_decode_953x6343_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_953x6343",impl,ntruprime_decode_953x6343_ITEMS*ntruprime_decode_953x6343_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_953xint16(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953xint16")) return;
  void *xstorage = callocplus(ntruprime_decode_953xint16_ITEMS*ntruprime_decode_953xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_953xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_953xint16();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_953xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_953xint16(impl);
      printf("decode_953xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953xint16_implementation(impl),ntruprime_dispatch_decode_953xint16_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_953xint16;
      printf("decode_953xint16 selected implementation %s compiler %s\n",ntruprime_decode_953xint16_implementation(),ntruprime_decode_953xint16_compiler());
    }
    randombytes(x,ntruprime_decode_953xint16_ITEMS*ntruprime_decode_953xint16_ITEMBYTES);
    randombytes(s,ntruprime_decode_953xint16_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_953xint16",impl,ntruprime_decode_953xint16_ITEMS*ntruprime_decode_953xint16_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_953xint32(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953xint32")) return;
  void *xstorage = callocplus(ntruprime_decode_953xint32_ITEMS*ntruprime_decode_953xint32_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_953xint32_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_953xint32();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_953xint32_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_953xint32(impl);
      printf("decode_953xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953xint32_implementation(impl),ntruprime_dispatch_decode_953xint32_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_953xint32;
      printf("decode_953xint32 selected implementation %s compiler %s\n",ntruprime_decode_953xint32_implementation(),ntruprime_decode_953xint32_compiler());
    }
    randombytes(x,ntruprime_decode_953xint32_ITEMS*ntruprime_decode_953xint32_ITEMBYTES);
    randombytes(s,ntruprime_decode_953xint32_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_953xint32",impl,ntruprime_decode_953xint32_ITEMS*ntruprime_decode_953xint32_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1013x3(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013x3")) return;
  void *xstorage = callocplus(ntruprime_decode_1013x3_ITEMS*ntruprime_decode_1013x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1013x3_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1013x3();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1013x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1013x3(impl);
      printf("decode_1013x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013x3_implementation(impl),ntruprime_dispatch_decode_1013x3_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1013x3;
      printf("decode_1013x3 selected implementation %s compiler %s\n",ntruprime_decode_1013x3_implementation(),ntruprime_decode_1013x3_compiler());
    }
    randombytes(x,ntruprime_decode_1013x3_ITEMS*ntruprime_decode_1013x3_ITEMBYTES);
    randombytes(s,ntruprime_decode_1013x3_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1013x3",impl,ntruprime_decode_1013x3_ITEMS*ntruprime_decode_1013x3_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1013x2393(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013x2393")) return;
  void *xstorage = callocplus(ntruprime_decode_1013x2393_ITEMS*ntruprime_decode_1013x2393_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1013x2393_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1013x2393();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1013x2393_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1013x2393(impl);
      printf("decode_1013x2393 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013x2393_implementation(impl),ntruprime_dispatch_decode_1013x2393_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1013x2393;
      printf("decode_1013x2393 selected implementation %s compiler %s\n",ntruprime_decode_1013x2393_implementation(),ntruprime_decode_1013x2393_compiler());
    }
    randombytes(x,ntruprime_decode_1013x2393_ITEMS*ntruprime_decode_1013x2393_ITEMBYTES);
    randombytes(s,ntruprime_decode_1013x2393_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1013x2393",impl,ntruprime_decode_1013x2393_ITEMS*ntruprime_decode_1013x2393_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1013x7177(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013x7177")) return;
  void *xstorage = callocplus(ntruprime_decode_1013x7177_ITEMS*ntruprime_decode_1013x7177_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1013x7177_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1013x7177();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1013x7177_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1013x7177(impl);
      printf("decode_1013x7177 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013x7177_implementation(impl),ntruprime_dispatch_decode_1013x7177_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1013x7177;
      printf("decode_1013x7177 selected implementation %s compiler %s\n",ntruprime_decode_1013x7177_implementation(),ntruprime_decode_1013x7177_compiler());
    }
    randombytes(x,ntruprime_decode_1013x7177_ITEMS*ntruprime_decode_1013x7177_ITEMBYTES);
    randombytes(s,ntruprime_decode_1013x7177_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1013x7177",impl,ntruprime_decode_1013x7177_ITEMS*ntruprime_decode_1013x7177_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1013xint16(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013xint16")) return;
  void *xstorage = callocplus(ntruprime_decode_1013xint16_ITEMS*ntruprime_decode_1013xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1013xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1013xint16();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1013xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1013xint16(impl);
      printf("decode_1013xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013xint16_implementation(impl),ntruprime_dispatch_decode_1013xint16_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1013xint16;
      printf("decode_1013xint16 selected implementation %s compiler %s\n",ntruprime_decode_1013xint16_implementation(),ntruprime_decode_1013xint16_compiler());
    }
    randombytes(x,ntruprime_decode_1013xint16_ITEMS*ntruprime_decode_1013xint16_ITEMBYTES);
    randombytes(s,ntruprime_decode_1013xint16_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1013xint16",impl,ntruprime_decode_1013xint16_ITEMS*ntruprime_decode_1013xint16_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1013xint32(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013xint32")) return;
  void *xstorage = callocplus(ntruprime_decode_1013xint32_ITEMS*ntruprime_decode_1013xint32_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1013xint32_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1013xint32();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1013xint32_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1013xint32(impl);
      printf("decode_1013xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013xint32_implementation(impl),ntruprime_dispatch_decode_1013xint32_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1013xint32;
      printf("decode_1013xint32 selected implementation %s compiler %s\n",ntruprime_decode_1013xint32_implementation(),ntruprime_decode_1013xint32_compiler());
    }
    randombytes(x,ntruprime_decode_1013xint32_ITEMS*ntruprime_decode_1013xint32_ITEMBYTES);
    randombytes(s,ntruprime_decode_1013xint32_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1013xint32",impl,ntruprime_decode_1013xint32_ITEMS*ntruprime_decode_1013xint32_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1277x3(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277x3")) return;
  void *xstorage = callocplus(ntruprime_decode_1277x3_ITEMS*ntruprime_decode_1277x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1277x3_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1277x3();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1277x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1277x3(impl);
      printf("decode_1277x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277x3_implementation(impl),ntruprime_dispatch_decode_1277x3_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1277x3;
      printf("decode_1277x3 selected implementation %s compiler %s\n",ntruprime_decode_1277x3_implementation(),ntruprime_decode_1277x3_compiler());
    }
    randombytes(x,ntruprime_decode_1277x3_ITEMS*ntruprime_decode_1277x3_ITEMBYTES);
    randombytes(s,ntruprime_decode_1277x3_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1277x3",impl,ntruprime_decode_1277x3_ITEMS*ntruprime_decode_1277x3_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1277x2627(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277x2627")) return;
  void *xstorage = callocplus(ntruprime_decode_1277x2627_ITEMS*ntruprime_decode_1277x2627_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1277x2627_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1277x2627();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1277x2627_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1277x2627(impl);
      printf("decode_1277x2627 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277x2627_implementation(impl),ntruprime_dispatch_decode_1277x2627_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1277x2627;
      printf("decode_1277x2627 selected implementation %s compiler %s\n",ntruprime_decode_1277x2627_implementation(),ntruprime_decode_1277x2627_compiler());
    }
    randombytes(x,ntruprime_decode_1277x2627_ITEMS*ntruprime_decode_1277x2627_ITEMBYTES);
    randombytes(s,ntruprime_decode_1277x2627_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1277x2627",impl,ntruprime_decode_1277x2627_ITEMS*ntruprime_decode_1277x2627_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1277x7879(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277x7879")) return;
  void *xstorage = callocplus(ntruprime_decode_1277x7879_ITEMS*ntruprime_decode_1277x7879_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1277x7879_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1277x7879();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1277x7879_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1277x7879(impl);
      printf("decode_1277x7879 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277x7879_implementation(impl),ntruprime_dispatch_decode_1277x7879_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1277x7879;
      printf("decode_1277x7879 selected implementation %s compiler %s\n",ntruprime_decode_1277x7879_implementation(),ntruprime_decode_1277x7879_compiler());
    }
    randombytes(x,ntruprime_decode_1277x7879_ITEMS*ntruprime_decode_1277x7879_ITEMBYTES);
    randombytes(s,ntruprime_decode_1277x7879_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1277x7879",impl,ntruprime_decode_1277x7879_ITEMS*ntruprime_decode_1277x7879_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1277xint16(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277xint16")) return;
  void *xstorage = callocplus(ntruprime_decode_1277xint16_ITEMS*ntruprime_decode_1277xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1277xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1277xint16();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1277xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1277xint16(impl);
      printf("decode_1277xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277xint16_implementation(impl),ntruprime_dispatch_decode_1277xint16_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1277xint16;
      printf("decode_1277xint16 selected implementation %s compiler %s\n",ntruprime_decode_1277xint16_implementation(),ntruprime_decode_1277xint16_compiler());
    }
    randombytes(x,ntruprime_decode_1277xint16_ITEMS*ntruprime_decode_1277xint16_ITEMBYTES);
    randombytes(s,ntruprime_decode_1277xint16_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1277xint16",impl,ntruprime_decode_1277xint16_ITEMS*ntruprime_decode_1277xint16_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_1277xint32(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277xint32")) return;
  void *xstorage = callocplus(ntruprime_decode_1277xint32_ITEMS*ntruprime_decode_1277xint32_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_1277xint32_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_1277xint32();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_1277xint32_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_1277xint32(impl);
      printf("decode_1277xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277xint32_implementation(impl),ntruprime_dispatch_decode_1277xint32_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_1277xint32;
      printf("decode_1277xint32 selected implementation %s compiler %s\n",ntruprime_decode_1277xint32_implementation(),ntruprime_decode_1277xint32_compiler());
    }
    randombytes(x,ntruprime_decode_1277xint32_ITEMS*ntruprime_decode_1277xint32_ITEMBYTES);
    randombytes(s,ntruprime_decode_1277xint32_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_1277xint32",impl,ntruprime_decode_1277xint32_ITEMS*ntruprime_decode_1277xint32_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_decode_int16(void)
{
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"int16")) return;
  void *xstorage = callocplus(ntruprime_decode_int16_ITEMS*ntruprime_decode_int16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);
  void *sstorage = callocplus(ntruprime_decode_int16_STRBYTES);
  unsigned char *s = aligned(sstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_decode_int16();++impl) {
    void (*crypto_decode)(void *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_decode_int16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_decode = ntruprime_dispatch_decode_int16(impl);
      printf("decode_int16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_int16_implementation(impl),ntruprime_dispatch_decode_int16_compiler(impl));
    } else {
      crypto_decode = ntruprime_decode_int16;
      printf("decode_int16 selected implementation %s compiler %s\n",ntruprime_decode_int16_implementation(),ntruprime_decode_int16_compiler());
    }
    randombytes(x,ntruprime_decode_int16_ITEMS*ntruprime_decode_int16_ITEMBYTES);
    randombytes(s,ntruprime_decode_int16_STRBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_decode(x,s);
    }
    t_print("decode_int16",impl,ntruprime_decode_int16_ITEMS*ntruprime_decode_int16_ITEMBYTES);
  }
  free(sstorage);
  free(xstorage);
}

static void measure_encode_653x3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653x3")) return;
  void *sstorage = callocplus(ntruprime_encode_653x3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_653x3_ITEMS*ntruprime_encode_653x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_653x3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_653x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_653x3(impl);
      printf("encode_653x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653x3_implementation(impl),ntruprime_dispatch_encode_653x3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_653x3;
      printf("encode_653x3 selected implementation %s compiler %s\n",ntruprime_encode_653x3_implementation(),ntruprime_encode_653x3_compiler());
    }
    randombytes(s,ntruprime_encode_653x3_STRBYTES);
    randombytes(x,ntruprime_encode_653x3_ITEMS*ntruprime_encode_653x3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_653x3",impl,ntruprime_encode_653x3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_653x1541(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653x1541")) return;
  void *sstorage = callocplus(ntruprime_encode_653x1541_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_653x1541_ITEMS*ntruprime_encode_653x1541_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_653x1541();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_653x1541_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_653x1541(impl);
      printf("encode_653x1541 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653x1541_implementation(impl),ntruprime_dispatch_encode_653x1541_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_653x1541;
      printf("encode_653x1541 selected implementation %s compiler %s\n",ntruprime_encode_653x1541_implementation(),ntruprime_encode_653x1541_compiler());
    }
    randombytes(s,ntruprime_encode_653x1541_STRBYTES);
    randombytes(x,ntruprime_encode_653x1541_ITEMS*ntruprime_encode_653x1541_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_653x1541",impl,ntruprime_encode_653x1541_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_653x1541round(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653x1541round")) return;
  void *sstorage = callocplus(ntruprime_encode_653x1541round_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_653x1541round_ITEMS*ntruprime_encode_653x1541round_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_653x1541round();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_653x1541round_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_653x1541round(impl);
      printf("encode_653x1541round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653x1541round_implementation(impl),ntruprime_dispatch_encode_653x1541round_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_653x1541round;
      printf("encode_653x1541round selected implementation %s compiler %s\n",ntruprime_encode_653x1541round_implementation(),ntruprime_encode_653x1541round_compiler());
    }
    randombytes(s,ntruprime_encode_653x1541round_STRBYTES);
    randombytes(x,ntruprime_encode_653x1541round_ITEMS*ntruprime_encode_653x1541round_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_653x1541round",impl,ntruprime_encode_653x1541round_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_653x4621(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653x4621")) return;
  void *sstorage = callocplus(ntruprime_encode_653x4621_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_653x4621_ITEMS*ntruprime_encode_653x4621_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_653x4621();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_653x4621_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_653x4621(impl);
      printf("encode_653x4621 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653x4621_implementation(impl),ntruprime_dispatch_encode_653x4621_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_653x4621;
      printf("encode_653x4621 selected implementation %s compiler %s\n",ntruprime_encode_653x4621_implementation(),ntruprime_encode_653x4621_compiler());
    }
    randombytes(s,ntruprime_encode_653x4621_STRBYTES);
    randombytes(x,ntruprime_encode_653x4621_ITEMS*ntruprime_encode_653x4621_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_653x4621",impl,ntruprime_encode_653x4621_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_653xfreeze3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653xfreeze3")) return;
  void *sstorage = callocplus(ntruprime_encode_653xfreeze3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_653xfreeze3_ITEMS*ntruprime_encode_653xfreeze3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_653xfreeze3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_653xfreeze3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_653xfreeze3(impl);
      printf("encode_653xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653xfreeze3_implementation(impl),ntruprime_dispatch_encode_653xfreeze3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_653xfreeze3;
      printf("encode_653xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_653xfreeze3_implementation(),ntruprime_encode_653xfreeze3_compiler());
    }
    randombytes(s,ntruprime_encode_653xfreeze3_STRBYTES);
    randombytes(x,ntruprime_encode_653xfreeze3_ITEMS*ntruprime_encode_653xfreeze3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_653xfreeze3",impl,ntruprime_encode_653xfreeze3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_653xint16(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653xint16")) return;
  void *sstorage = callocplus(ntruprime_encode_653xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_653xint16_ITEMS*ntruprime_encode_653xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_653xint16();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_653xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_653xint16(impl);
      printf("encode_653xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653xint16_implementation(impl),ntruprime_dispatch_encode_653xint16_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_653xint16;
      printf("encode_653xint16 selected implementation %s compiler %s\n",ntruprime_encode_653xint16_implementation(),ntruprime_encode_653xint16_compiler());
    }
    randombytes(s,ntruprime_encode_653xint16_STRBYTES);
    randombytes(x,ntruprime_encode_653xint16_ITEMS*ntruprime_encode_653xint16_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_653xint16",impl,ntruprime_encode_653xint16_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_761x3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761x3")) return;
  void *sstorage = callocplus(ntruprime_encode_761x3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_761x3_ITEMS*ntruprime_encode_761x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_761x3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_761x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_761x3(impl);
      printf("encode_761x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761x3_implementation(impl),ntruprime_dispatch_encode_761x3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_761x3;
      printf("encode_761x3 selected implementation %s compiler %s\n",ntruprime_encode_761x3_implementation(),ntruprime_encode_761x3_compiler());
    }
    randombytes(s,ntruprime_encode_761x3_STRBYTES);
    randombytes(x,ntruprime_encode_761x3_ITEMS*ntruprime_encode_761x3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_761x3",impl,ntruprime_encode_761x3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_761x1531(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761x1531")) return;
  void *sstorage = callocplus(ntruprime_encode_761x1531_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_761x1531_ITEMS*ntruprime_encode_761x1531_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_761x1531();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_761x1531_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_761x1531(impl);
      printf("encode_761x1531 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761x1531_implementation(impl),ntruprime_dispatch_encode_761x1531_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_761x1531;
      printf("encode_761x1531 selected implementation %s compiler %s\n",ntruprime_encode_761x1531_implementation(),ntruprime_encode_761x1531_compiler());
    }
    randombytes(s,ntruprime_encode_761x1531_STRBYTES);
    randombytes(x,ntruprime_encode_761x1531_ITEMS*ntruprime_encode_761x1531_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_761x1531",impl,ntruprime_encode_761x1531_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_761x1531round(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761x1531round")) return;
  void *sstorage = callocplus(ntruprime_encode_761x1531round_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_761x1531round_ITEMS*ntruprime_encode_761x1531round_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_761x1531round();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_761x1531round_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_761x1531round(impl);
      printf("encode_761x1531round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761x1531round_implementation(impl),ntruprime_dispatch_encode_761x1531round_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_761x1531round;
      printf("encode_761x1531round selected implementation %s compiler %s\n",ntruprime_encode_761x1531round_implementation(),ntruprime_encode_761x1531round_compiler());
    }
    randombytes(s,ntruprime_encode_761x1531round_STRBYTES);
    randombytes(x,ntruprime_encode_761x1531round_ITEMS*ntruprime_encode_761x1531round_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_761x1531round",impl,ntruprime_encode_761x1531round_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_761x4591(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761x4591")) return;
  void *sstorage = callocplus(ntruprime_encode_761x4591_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_761x4591_ITEMS*ntruprime_encode_761x4591_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_761x4591();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_761x4591_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_761x4591(impl);
      printf("encode_761x4591 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761x4591_implementation(impl),ntruprime_dispatch_encode_761x4591_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_761x4591;
      printf("encode_761x4591 selected implementation %s compiler %s\n",ntruprime_encode_761x4591_implementation(),ntruprime_encode_761x4591_compiler());
    }
    randombytes(s,ntruprime_encode_761x4591_STRBYTES);
    randombytes(x,ntruprime_encode_761x4591_ITEMS*ntruprime_encode_761x4591_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_761x4591",impl,ntruprime_encode_761x4591_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_761xfreeze3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761xfreeze3")) return;
  void *sstorage = callocplus(ntruprime_encode_761xfreeze3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_761xfreeze3_ITEMS*ntruprime_encode_761xfreeze3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_761xfreeze3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_761xfreeze3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_761xfreeze3(impl);
      printf("encode_761xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761xfreeze3_implementation(impl),ntruprime_dispatch_encode_761xfreeze3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_761xfreeze3;
      printf("encode_761xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_761xfreeze3_implementation(),ntruprime_encode_761xfreeze3_compiler());
    }
    randombytes(s,ntruprime_encode_761xfreeze3_STRBYTES);
    randombytes(x,ntruprime_encode_761xfreeze3_ITEMS*ntruprime_encode_761xfreeze3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_761xfreeze3",impl,ntruprime_encode_761xfreeze3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_761xint16(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761xint16")) return;
  void *sstorage = callocplus(ntruprime_encode_761xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_761xint16_ITEMS*ntruprime_encode_761xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_761xint16();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_761xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_761xint16(impl);
      printf("encode_761xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761xint16_implementation(impl),ntruprime_dispatch_encode_761xint16_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_761xint16;
      printf("encode_761xint16 selected implementation %s compiler %s\n",ntruprime_encode_761xint16_implementation(),ntruprime_encode_761xint16_compiler());
    }
    randombytes(s,ntruprime_encode_761xint16_STRBYTES);
    randombytes(x,ntruprime_encode_761xint16_ITEMS*ntruprime_encode_761xint16_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_761xint16",impl,ntruprime_encode_761xint16_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_857x3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857x3")) return;
  void *sstorage = callocplus(ntruprime_encode_857x3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_857x3_ITEMS*ntruprime_encode_857x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_857x3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_857x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_857x3(impl);
      printf("encode_857x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857x3_implementation(impl),ntruprime_dispatch_encode_857x3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_857x3;
      printf("encode_857x3 selected implementation %s compiler %s\n",ntruprime_encode_857x3_implementation(),ntruprime_encode_857x3_compiler());
    }
    randombytes(s,ntruprime_encode_857x3_STRBYTES);
    randombytes(x,ntruprime_encode_857x3_ITEMS*ntruprime_encode_857x3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_857x3",impl,ntruprime_encode_857x3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_857x1723(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857x1723")) return;
  void *sstorage = callocplus(ntruprime_encode_857x1723_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_857x1723_ITEMS*ntruprime_encode_857x1723_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_857x1723();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_857x1723_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_857x1723(impl);
      printf("encode_857x1723 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857x1723_implementation(impl),ntruprime_dispatch_encode_857x1723_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_857x1723;
      printf("encode_857x1723 selected implementation %s compiler %s\n",ntruprime_encode_857x1723_implementation(),ntruprime_encode_857x1723_compiler());
    }
    randombytes(s,ntruprime_encode_857x1723_STRBYTES);
    randombytes(x,ntruprime_encode_857x1723_ITEMS*ntruprime_encode_857x1723_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_857x1723",impl,ntruprime_encode_857x1723_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_857x1723round(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857x1723round")) return;
  void *sstorage = callocplus(ntruprime_encode_857x1723round_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_857x1723round_ITEMS*ntruprime_encode_857x1723round_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_857x1723round();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_857x1723round_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_857x1723round(impl);
      printf("encode_857x1723round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857x1723round_implementation(impl),ntruprime_dispatch_encode_857x1723round_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_857x1723round;
      printf("encode_857x1723round selected implementation %s compiler %s\n",ntruprime_encode_857x1723round_implementation(),ntruprime_encode_857x1723round_compiler());
    }
    randombytes(s,ntruprime_encode_857x1723round_STRBYTES);
    randombytes(x,ntruprime_encode_857x1723round_ITEMS*ntruprime_encode_857x1723round_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_857x1723round",impl,ntruprime_encode_857x1723round_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_857x5167(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857x5167")) return;
  void *sstorage = callocplus(ntruprime_encode_857x5167_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_857x5167_ITEMS*ntruprime_encode_857x5167_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_857x5167();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_857x5167_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_857x5167(impl);
      printf("encode_857x5167 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857x5167_implementation(impl),ntruprime_dispatch_encode_857x5167_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_857x5167;
      printf("encode_857x5167 selected implementation %s compiler %s\n",ntruprime_encode_857x5167_implementation(),ntruprime_encode_857x5167_compiler());
    }
    randombytes(s,ntruprime_encode_857x5167_STRBYTES);
    randombytes(x,ntruprime_encode_857x5167_ITEMS*ntruprime_encode_857x5167_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_857x5167",impl,ntruprime_encode_857x5167_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_857xfreeze3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857xfreeze3")) return;
  void *sstorage = callocplus(ntruprime_encode_857xfreeze3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_857xfreeze3_ITEMS*ntruprime_encode_857xfreeze3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_857xfreeze3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_857xfreeze3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_857xfreeze3(impl);
      printf("encode_857xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857xfreeze3_implementation(impl),ntruprime_dispatch_encode_857xfreeze3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_857xfreeze3;
      printf("encode_857xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_857xfreeze3_implementation(),ntruprime_encode_857xfreeze3_compiler());
    }
    randombytes(s,ntruprime_encode_857xfreeze3_STRBYTES);
    randombytes(x,ntruprime_encode_857xfreeze3_ITEMS*ntruprime_encode_857xfreeze3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_857xfreeze3",impl,ntruprime_encode_857xfreeze3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_857xint16(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"857xint16")) return;
  void *sstorage = callocplus(ntruprime_encode_857xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_857xint16_ITEMS*ntruprime_encode_857xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_857xint16();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_857xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_857xint16(impl);
      printf("encode_857xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_857xint16_implementation(impl),ntruprime_dispatch_encode_857xint16_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_857xint16;
      printf("encode_857xint16 selected implementation %s compiler %s\n",ntruprime_encode_857xint16_implementation(),ntruprime_encode_857xint16_compiler());
    }
    randombytes(s,ntruprime_encode_857xint16_STRBYTES);
    randombytes(x,ntruprime_encode_857xint16_ITEMS*ntruprime_encode_857xint16_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_857xint16",impl,ntruprime_encode_857xint16_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_953x3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953x3")) return;
  void *sstorage = callocplus(ntruprime_encode_953x3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_953x3_ITEMS*ntruprime_encode_953x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_953x3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_953x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_953x3(impl);
      printf("encode_953x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953x3_implementation(impl),ntruprime_dispatch_encode_953x3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_953x3;
      printf("encode_953x3 selected implementation %s compiler %s\n",ntruprime_encode_953x3_implementation(),ntruprime_encode_953x3_compiler());
    }
    randombytes(s,ntruprime_encode_953x3_STRBYTES);
    randombytes(x,ntruprime_encode_953x3_ITEMS*ntruprime_encode_953x3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_953x3",impl,ntruprime_encode_953x3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_953x2115(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953x2115")) return;
  void *sstorage = callocplus(ntruprime_encode_953x2115_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_953x2115_ITEMS*ntruprime_encode_953x2115_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_953x2115();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_953x2115_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_953x2115(impl);
      printf("encode_953x2115 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953x2115_implementation(impl),ntruprime_dispatch_encode_953x2115_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_953x2115;
      printf("encode_953x2115 selected implementation %s compiler %s\n",ntruprime_encode_953x2115_implementation(),ntruprime_encode_953x2115_compiler());
    }
    randombytes(s,ntruprime_encode_953x2115_STRBYTES);
    randombytes(x,ntruprime_encode_953x2115_ITEMS*ntruprime_encode_953x2115_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_953x2115",impl,ntruprime_encode_953x2115_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_953x2115round(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953x2115round")) return;
  void *sstorage = callocplus(ntruprime_encode_953x2115round_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_953x2115round_ITEMS*ntruprime_encode_953x2115round_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_953x2115round();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_953x2115round_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_953x2115round(impl);
      printf("encode_953x2115round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953x2115round_implementation(impl),ntruprime_dispatch_encode_953x2115round_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_953x2115round;
      printf("encode_953x2115round selected implementation %s compiler %s\n",ntruprime_encode_953x2115round_implementation(),ntruprime_encode_953x2115round_compiler());
    }
    randombytes(s,ntruprime_encode_953x2115round_STRBYTES);
    randombytes(x,ntruprime_encode_953x2115round_ITEMS*ntruprime_encode_953x2115round_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_953x2115round",impl,ntruprime_encode_953x2115round_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_953x6343(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953x6343")) return;
  void *sstorage = callocplus(ntruprime_encode_953x6343_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_953x6343_ITEMS*ntruprime_encode_953x6343_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_953x6343();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_953x6343_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_953x6343(impl);
      printf("encode_953x6343 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953x6343_implementation(impl),ntruprime_dispatch_encode_953x6343_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_953x6343;
      printf("encode_953x6343 selected implementation %s compiler %s\n",ntruprime_encode_953x6343_implementation(),ntruprime_encode_953x6343_compiler());
    }
    randombytes(s,ntruprime_encode_953x6343_STRBYTES);
    randombytes(x,ntruprime_encode_953x6343_ITEMS*ntruprime_encode_953x6343_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_953x6343",impl,ntruprime_encode_953x6343_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_953xfreeze3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953xfreeze3")) return;
  void *sstorage = callocplus(ntruprime_encode_953xfreeze3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_953xfreeze3_ITEMS*ntruprime_encode_953xfreeze3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_953xfreeze3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_953xfreeze3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_953xfreeze3(impl);
      printf("encode_953xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953xfreeze3_implementation(impl),ntruprime_dispatch_encode_953xfreeze3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_953xfreeze3;
      printf("encode_953xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_953xfreeze3_implementation(),ntruprime_encode_953xfreeze3_compiler());
    }
    randombytes(s,ntruprime_encode_953xfreeze3_STRBYTES);
    randombytes(x,ntruprime_encode_953xfreeze3_ITEMS*ntruprime_encode_953xfreeze3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_953xfreeze3",impl,ntruprime_encode_953xfreeze3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_953xint16(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953xint16")) return;
  void *sstorage = callocplus(ntruprime_encode_953xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_953xint16_ITEMS*ntruprime_encode_953xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_953xint16();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_953xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_953xint16(impl);
      printf("encode_953xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953xint16_implementation(impl),ntruprime_dispatch_encode_953xint16_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_953xint16;
      printf("encode_953xint16 selected implementation %s compiler %s\n",ntruprime_encode_953xint16_implementation(),ntruprime_encode_953xint16_compiler());
    }
    randombytes(s,ntruprime_encode_953xint16_STRBYTES);
    randombytes(x,ntruprime_encode_953xint16_ITEMS*ntruprime_encode_953xint16_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_953xint16",impl,ntruprime_encode_953xint16_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1013x3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013x3")) return;
  void *sstorage = callocplus(ntruprime_encode_1013x3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1013x3_ITEMS*ntruprime_encode_1013x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1013x3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1013x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1013x3(impl);
      printf("encode_1013x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013x3_implementation(impl),ntruprime_dispatch_encode_1013x3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1013x3;
      printf("encode_1013x3 selected implementation %s compiler %s\n",ntruprime_encode_1013x3_implementation(),ntruprime_encode_1013x3_compiler());
    }
    randombytes(s,ntruprime_encode_1013x3_STRBYTES);
    randombytes(x,ntruprime_encode_1013x3_ITEMS*ntruprime_encode_1013x3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1013x3",impl,ntruprime_encode_1013x3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1013x2393(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013x2393")) return;
  void *sstorage = callocplus(ntruprime_encode_1013x2393_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1013x2393_ITEMS*ntruprime_encode_1013x2393_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1013x2393();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1013x2393_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1013x2393(impl);
      printf("encode_1013x2393 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013x2393_implementation(impl),ntruprime_dispatch_encode_1013x2393_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1013x2393;
      printf("encode_1013x2393 selected implementation %s compiler %s\n",ntruprime_encode_1013x2393_implementation(),ntruprime_encode_1013x2393_compiler());
    }
    randombytes(s,ntruprime_encode_1013x2393_STRBYTES);
    randombytes(x,ntruprime_encode_1013x2393_ITEMS*ntruprime_encode_1013x2393_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1013x2393",impl,ntruprime_encode_1013x2393_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1013x2393round(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013x2393round")) return;
  void *sstorage = callocplus(ntruprime_encode_1013x2393round_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1013x2393round_ITEMS*ntruprime_encode_1013x2393round_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1013x2393round();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1013x2393round_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1013x2393round(impl);
      printf("encode_1013x2393round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013x2393round_implementation(impl),ntruprime_dispatch_encode_1013x2393round_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1013x2393round;
      printf("encode_1013x2393round selected implementation %s compiler %s\n",ntruprime_encode_1013x2393round_implementation(),ntruprime_encode_1013x2393round_compiler());
    }
    randombytes(s,ntruprime_encode_1013x2393round_STRBYTES);
    randombytes(x,ntruprime_encode_1013x2393round_ITEMS*ntruprime_encode_1013x2393round_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1013x2393round",impl,ntruprime_encode_1013x2393round_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1013x7177(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013x7177")) return;
  void *sstorage = callocplus(ntruprime_encode_1013x7177_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1013x7177_ITEMS*ntruprime_encode_1013x7177_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1013x7177();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1013x7177_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1013x7177(impl);
      printf("encode_1013x7177 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013x7177_implementation(impl),ntruprime_dispatch_encode_1013x7177_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1013x7177;
      printf("encode_1013x7177 selected implementation %s compiler %s\n",ntruprime_encode_1013x7177_implementation(),ntruprime_encode_1013x7177_compiler());
    }
    randombytes(s,ntruprime_encode_1013x7177_STRBYTES);
    randombytes(x,ntruprime_encode_1013x7177_ITEMS*ntruprime_encode_1013x7177_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1013x7177",impl,ntruprime_encode_1013x7177_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1013xfreeze3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013xfreeze3")) return;
  void *sstorage = callocplus(ntruprime_encode_1013xfreeze3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1013xfreeze3_ITEMS*ntruprime_encode_1013xfreeze3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1013xfreeze3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1013xfreeze3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1013xfreeze3(impl);
      printf("encode_1013xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013xfreeze3_implementation(impl),ntruprime_dispatch_encode_1013xfreeze3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1013xfreeze3;
      printf("encode_1013xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_1013xfreeze3_implementation(),ntruprime_encode_1013xfreeze3_compiler());
    }
    randombytes(s,ntruprime_encode_1013xfreeze3_STRBYTES);
    randombytes(x,ntruprime_encode_1013xfreeze3_ITEMS*ntruprime_encode_1013xfreeze3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1013xfreeze3",impl,ntruprime_encode_1013xfreeze3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1013xint16(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013xint16")) return;
  void *sstorage = callocplus(ntruprime_encode_1013xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1013xint16_ITEMS*ntruprime_encode_1013xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1013xint16();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1013xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1013xint16(impl);
      printf("encode_1013xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013xint16_implementation(impl),ntruprime_dispatch_encode_1013xint16_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1013xint16;
      printf("encode_1013xint16 selected implementation %s compiler %s\n",ntruprime_encode_1013xint16_implementation(),ntruprime_encode_1013xint16_compiler());
    }
    randombytes(s,ntruprime_encode_1013xint16_STRBYTES);
    randombytes(x,ntruprime_encode_1013xint16_ITEMS*ntruprime_encode_1013xint16_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1013xint16",impl,ntruprime_encode_1013xint16_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1277x3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277x3")) return;
  void *sstorage = callocplus(ntruprime_encode_1277x3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1277x3_ITEMS*ntruprime_encode_1277x3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1277x3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1277x3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1277x3(impl);
      printf("encode_1277x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277x3_implementation(impl),ntruprime_dispatch_encode_1277x3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1277x3;
      printf("encode_1277x3 selected implementation %s compiler %s\n",ntruprime_encode_1277x3_implementation(),ntruprime_encode_1277x3_compiler());
    }
    randombytes(s,ntruprime_encode_1277x3_STRBYTES);
    randombytes(x,ntruprime_encode_1277x3_ITEMS*ntruprime_encode_1277x3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1277x3",impl,ntruprime_encode_1277x3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1277x2627(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277x2627")) return;
  void *sstorage = callocplus(ntruprime_encode_1277x2627_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1277x2627_ITEMS*ntruprime_encode_1277x2627_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1277x2627();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1277x2627_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1277x2627(impl);
      printf("encode_1277x2627 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277x2627_implementation(impl),ntruprime_dispatch_encode_1277x2627_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1277x2627;
      printf("encode_1277x2627 selected implementation %s compiler %s\n",ntruprime_encode_1277x2627_implementation(),ntruprime_encode_1277x2627_compiler());
    }
    randombytes(s,ntruprime_encode_1277x2627_STRBYTES);
    randombytes(x,ntruprime_encode_1277x2627_ITEMS*ntruprime_encode_1277x2627_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1277x2627",impl,ntruprime_encode_1277x2627_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1277x2627round(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277x2627round")) return;
  void *sstorage = callocplus(ntruprime_encode_1277x2627round_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1277x2627round_ITEMS*ntruprime_encode_1277x2627round_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1277x2627round();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1277x2627round_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1277x2627round(impl);
      printf("encode_1277x2627round %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277x2627round_implementation(impl),ntruprime_dispatch_encode_1277x2627round_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1277x2627round;
      printf("encode_1277x2627round selected implementation %s compiler %s\n",ntruprime_encode_1277x2627round_implementation(),ntruprime_encode_1277x2627round_compiler());
    }
    randombytes(s,ntruprime_encode_1277x2627round_STRBYTES);
    randombytes(x,ntruprime_encode_1277x2627round_ITEMS*ntruprime_encode_1277x2627round_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1277x2627round",impl,ntruprime_encode_1277x2627round_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1277x7879(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277x7879")) return;
  void *sstorage = callocplus(ntruprime_encode_1277x7879_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1277x7879_ITEMS*ntruprime_encode_1277x7879_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1277x7879();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1277x7879_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1277x7879(impl);
      printf("encode_1277x7879 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277x7879_implementation(impl),ntruprime_dispatch_encode_1277x7879_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1277x7879;
      printf("encode_1277x7879 selected implementation %s compiler %s\n",ntruprime_encode_1277x7879_implementation(),ntruprime_encode_1277x7879_compiler());
    }
    randombytes(s,ntruprime_encode_1277x7879_STRBYTES);
    randombytes(x,ntruprime_encode_1277x7879_ITEMS*ntruprime_encode_1277x7879_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1277x7879",impl,ntruprime_encode_1277x7879_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1277xfreeze3(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277xfreeze3")) return;
  void *sstorage = callocplus(ntruprime_encode_1277xfreeze3_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1277xfreeze3_ITEMS*ntruprime_encode_1277xfreeze3_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1277xfreeze3();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1277xfreeze3_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1277xfreeze3(impl);
      printf("encode_1277xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277xfreeze3_implementation(impl),ntruprime_dispatch_encode_1277xfreeze3_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1277xfreeze3;
      printf("encode_1277xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_1277xfreeze3_implementation(),ntruprime_encode_1277xfreeze3_compiler());
    }
    randombytes(s,ntruprime_encode_1277xfreeze3_STRBYTES);
    randombytes(x,ntruprime_encode_1277xfreeze3_ITEMS*ntruprime_encode_1277xfreeze3_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1277xfreeze3",impl,ntruprime_encode_1277xfreeze3_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_1277xint16(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277xint16")) return;
  void *sstorage = callocplus(ntruprime_encode_1277xint16_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_1277xint16_ITEMS*ntruprime_encode_1277xint16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_1277xint16();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_1277xint16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_1277xint16(impl);
      printf("encode_1277xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277xint16_implementation(impl),ntruprime_dispatch_encode_1277xint16_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_1277xint16;
      printf("encode_1277xint16 selected implementation %s compiler %s\n",ntruprime_encode_1277xint16_implementation(),ntruprime_encode_1277xint16_compiler());
    }
    randombytes(s,ntruprime_encode_1277xint16_STRBYTES);
    randombytes(x,ntruprime_encode_1277xint16_ITEMS*ntruprime_encode_1277xint16_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_1277xint16",impl,ntruprime_encode_1277xint16_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_encode_int16(void)
{
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"int16")) return;
  void *sstorage = callocplus(ntruprime_encode_int16_STRBYTES);
  unsigned char *s = aligned(sstorage);
  void *xstorage = callocplus(ntruprime_encode_int16_ITEMS*ntruprime_encode_int16_ITEMBYTES);
  unsigned char *x = aligned(xstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_encode_int16();++impl) {
    void (*crypto_encode)(unsigned char *,const void *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_encode_int16_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_encode = ntruprime_dispatch_encode_int16(impl);
      printf("encode_int16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_int16_implementation(impl),ntruprime_dispatch_encode_int16_compiler(impl));
    } else {
      crypto_encode = ntruprime_encode_int16;
      printf("encode_int16 selected implementation %s compiler %s\n",ntruprime_encode_int16_implementation(),ntruprime_encode_int16_compiler());
    }
    randombytes(s,ntruprime_encode_int16_STRBYTES);
    randombytes(x,ntruprime_encode_int16_ITEMS*ntruprime_encode_int16_ITEMBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_encode(s,x);
    }
    t_print("encode_int16",impl,ntruprime_encode_int16_STRBYTES);
  }
  free(xstorage);
  free(sstorage);
}

static void measure_sort_int32(void)
{
  if (targeto && strcmp(targeto,"sort")) return;
  if (targetp && strcmp(targetp,"int32")) return;
  void *mstorage = callocplus(MAXTEST_BYTES);
  unsigned char *m = aligned(mstorage);
  long long mlen;

  for (long long impl = -1;impl < ntruprime_numimpl_sort_int32();++impl) {
    void (*crypto_sort)(void *,long long);
    if (targeti && strcmp(targeti,ntruprime_dispatch_sort_int32_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_sort = ntruprime_dispatch_sort_int32(impl);
      printf("sort_int32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_sort_int32_implementation(impl),ntruprime_dispatch_sort_int32_compiler(impl));
    } else {
      crypto_sort = ntruprime_sort_int32;
      printf("sort_int32 selected implementation %s compiler %s\n",ntruprime_sort_int32_implementation(),ntruprime_sort_int32_compiler());
    }
    randombytes(m,MAXTEST_BYTES);
    mlen = 0;
    while (ntruprime_sort_int32_BYTES*mlen <= MAXTEST_BYTES) {
      randombytes(m,ntruprime_sort_int32_BYTES*mlen);
      for (long long i = 0;i <= TIMINGS;++i) {
        t[i] = cpucycles();
        crypto_sort(m,mlen);
      }
      t_print("sort_int32",impl,mlen);
      mlen += 1+mlen/2;
    }
  }
  free(mstorage);
}

static void measure_sort_uint32(void)
{
  if (targeto && strcmp(targeto,"sort")) return;
  if (targetp && strcmp(targetp,"uint32")) return;
  void *mstorage = callocplus(MAXTEST_BYTES);
  unsigned char *m = aligned(mstorage);
  long long mlen;

  for (long long impl = -1;impl < ntruprime_numimpl_sort_uint32();++impl) {
    void (*crypto_sort)(void *,long long);
    if (targeti && strcmp(targeti,ntruprime_dispatch_sort_uint32_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_sort = ntruprime_dispatch_sort_uint32(impl);
      printf("sort_uint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_sort_uint32_implementation(impl),ntruprime_dispatch_sort_uint32_compiler(impl));
    } else {
      crypto_sort = ntruprime_sort_uint32;
      printf("sort_uint32 selected implementation %s compiler %s\n",ntruprime_sort_uint32_implementation(),ntruprime_sort_uint32_compiler());
    }
    randombytes(m,MAXTEST_BYTES);
    mlen = 0;
    while (ntruprime_sort_uint32_BYTES*mlen <= MAXTEST_BYTES) {
      randombytes(m,ntruprime_sort_uint32_BYTES*mlen);
      for (long long i = 0;i <= TIMINGS;++i) {
        t[i] = cpucycles();
        crypto_sort(m,mlen);
      }
      t_print("sort_uint32",impl,mlen);
      mlen += 1+mlen/2;
    }
  }
  free(mstorage);
}

static void measure_core_inv3sntrup653(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup653")) return;
  void *hstorage = callocplus(ntruprime_core_inv3sntrup653_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_inv3sntrup653_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_inv3sntrup653_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_inv3sntrup653_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup653();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup653_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_inv3sntrup653(impl);
      printf("core_inv3sntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup653_implementation(impl),ntruprime_dispatch_core_inv3sntrup653_compiler(impl));
    } else {
      crypto_core = ntruprime_core_inv3sntrup653;
      printf("core_inv3sntrup653 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup653_implementation(),ntruprime_core_inv3sntrup653_compiler());
    }
    randombytes(h,ntruprime_core_inv3sntrup653_OUTPUTBYTES);
    randombytes(n,ntruprime_core_inv3sntrup653_INPUTBYTES);
    randombytes(k,ntruprime_core_inv3sntrup653_KEYBYTES);
    randombytes(c,ntruprime_core_inv3sntrup653_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_inv3sntrup653",impl,ntruprime_core_inv3sntrup653_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_inv3sntrup761(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup761")) return;
  void *hstorage = callocplus(ntruprime_core_inv3sntrup761_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_inv3sntrup761_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_inv3sntrup761_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_inv3sntrup761_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup761();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup761_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_inv3sntrup761(impl);
      printf("core_inv3sntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup761_implementation(impl),ntruprime_dispatch_core_inv3sntrup761_compiler(impl));
    } else {
      crypto_core = ntruprime_core_inv3sntrup761;
      printf("core_inv3sntrup761 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup761_implementation(),ntruprime_core_inv3sntrup761_compiler());
    }
    randombytes(h,ntruprime_core_inv3sntrup761_OUTPUTBYTES);
    randombytes(n,ntruprime_core_inv3sntrup761_INPUTBYTES);
    randombytes(k,ntruprime_core_inv3sntrup761_KEYBYTES);
    randombytes(c,ntruprime_core_inv3sntrup761_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_inv3sntrup761",impl,ntruprime_core_inv3sntrup761_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_inv3sntrup857(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup857")) return;
  void *hstorage = callocplus(ntruprime_core_inv3sntrup857_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_inv3sntrup857_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_inv3sntrup857_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_inv3sntrup857_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup857();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup857_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_inv3sntrup857(impl);
      printf("core_inv3sntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup857_implementation(impl),ntruprime_dispatch_core_inv3sntrup857_compiler(impl));
    } else {
      crypto_core = ntruprime_core_inv3sntrup857;
      printf("core_inv3sntrup857 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup857_implementation(),ntruprime_core_inv3sntrup857_compiler());
    }
    randombytes(h,ntruprime_core_inv3sntrup857_OUTPUTBYTES);
    randombytes(n,ntruprime_core_inv3sntrup857_INPUTBYTES);
    randombytes(k,ntruprime_core_inv3sntrup857_KEYBYTES);
    randombytes(c,ntruprime_core_inv3sntrup857_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_inv3sntrup857",impl,ntruprime_core_inv3sntrup857_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_inv3sntrup953(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup953")) return;
  void *hstorage = callocplus(ntruprime_core_inv3sntrup953_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_inv3sntrup953_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_inv3sntrup953_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_inv3sntrup953_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup953();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup953_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_inv3sntrup953(impl);
      printf("core_inv3sntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup953_implementation(impl),ntruprime_dispatch_core_inv3sntrup953_compiler(impl));
    } else {
      crypto_core = ntruprime_core_inv3sntrup953;
      printf("core_inv3sntrup953 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup953_implementation(),ntruprime_core_inv3sntrup953_compiler());
    }
    randombytes(h,ntruprime_core_inv3sntrup953_OUTPUTBYTES);
    randombytes(n,ntruprime_core_inv3sntrup953_INPUTBYTES);
    randombytes(k,ntruprime_core_inv3sntrup953_KEYBYTES);
    randombytes(c,ntruprime_core_inv3sntrup953_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_inv3sntrup953",impl,ntruprime_core_inv3sntrup953_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_inv3sntrup1013(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup1013")) return;
  void *hstorage = callocplus(ntruprime_core_inv3sntrup1013_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_inv3sntrup1013_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_inv3sntrup1013_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_inv3sntrup1013_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup1013();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup1013_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_inv3sntrup1013(impl);
      printf("core_inv3sntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup1013_implementation(impl),ntruprime_dispatch_core_inv3sntrup1013_compiler(impl));
    } else {
      crypto_core = ntruprime_core_inv3sntrup1013;
      printf("core_inv3sntrup1013 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup1013_implementation(),ntruprime_core_inv3sntrup1013_compiler());
    }
    randombytes(h,ntruprime_core_inv3sntrup1013_OUTPUTBYTES);
    randombytes(n,ntruprime_core_inv3sntrup1013_INPUTBYTES);
    randombytes(k,ntruprime_core_inv3sntrup1013_KEYBYTES);
    randombytes(c,ntruprime_core_inv3sntrup1013_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_inv3sntrup1013",impl,ntruprime_core_inv3sntrup1013_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_inv3sntrup1277(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"inv3sntrup1277")) return;
  void *hstorage = callocplus(ntruprime_core_inv3sntrup1277_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_inv3sntrup1277_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_inv3sntrup1277_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_inv3sntrup1277_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_inv3sntrup1277();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_inv3sntrup1277_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_inv3sntrup1277(impl);
      printf("core_inv3sntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_inv3sntrup1277_implementation(impl),ntruprime_dispatch_core_inv3sntrup1277_compiler(impl));
    } else {
      crypto_core = ntruprime_core_inv3sntrup1277;
      printf("core_inv3sntrup1277 selected implementation %s compiler %s\n",ntruprime_core_inv3sntrup1277_implementation(),ntruprime_core_inv3sntrup1277_compiler());
    }
    randombytes(h,ntruprime_core_inv3sntrup1277_OUTPUTBYTES);
    randombytes(n,ntruprime_core_inv3sntrup1277_INPUTBYTES);
    randombytes(k,ntruprime_core_inv3sntrup1277_KEYBYTES);
    randombytes(c,ntruprime_core_inv3sntrup1277_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_inv3sntrup1277",impl,ntruprime_core_inv3sntrup1277_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_invsntrup653(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup653")) return;
  void *hstorage = callocplus(ntruprime_core_invsntrup653_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_invsntrup653_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_invsntrup653_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_invsntrup653_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup653();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_invsntrup653_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_invsntrup653(impl);
      printf("core_invsntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup653_implementation(impl),ntruprime_dispatch_core_invsntrup653_compiler(impl));
    } else {
      crypto_core = ntruprime_core_invsntrup653;
      printf("core_invsntrup653 selected implementation %s compiler %s\n",ntruprime_core_invsntrup653_implementation(),ntruprime_core_invsntrup653_compiler());
    }
    randombytes(h,ntruprime_core_invsntrup653_OUTPUTBYTES);
    randombytes(n,ntruprime_core_invsntrup653_INPUTBYTES);
    randombytes(k,ntruprime_core_invsntrup653_KEYBYTES);
    randombytes(c,ntruprime_core_invsntrup653_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_invsntrup653",impl,ntruprime_core_invsntrup653_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_invsntrup761(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup761")) return;
  void *hstorage = callocplus(ntruprime_core_invsntrup761_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_invsntrup761_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_invsntrup761_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_invsntrup761_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup761();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_invsntrup761_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_invsntrup761(impl);
      printf("core_invsntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup761_implementation(impl),ntruprime_dispatch_core_invsntrup761_compiler(impl));
    } else {
      crypto_core = ntruprime_core_invsntrup761;
      printf("core_invsntrup761 selected implementation %s compiler %s\n",ntruprime_core_invsntrup761_implementation(),ntruprime_core_invsntrup761_compiler());
    }
    randombytes(h,ntruprime_core_invsntrup761_OUTPUTBYTES);
    randombytes(n,ntruprime_core_invsntrup761_INPUTBYTES);
    randombytes(k,ntruprime_core_invsntrup761_KEYBYTES);
    randombytes(c,ntruprime_core_invsntrup761_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_invsntrup761",impl,ntruprime_core_invsntrup761_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_invsntrup857(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup857")) return;
  void *hstorage = callocplus(ntruprime_core_invsntrup857_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_invsntrup857_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_invsntrup857_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_invsntrup857_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup857();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_invsntrup857_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_invsntrup857(impl);
      printf("core_invsntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup857_implementation(impl),ntruprime_dispatch_core_invsntrup857_compiler(impl));
    } else {
      crypto_core = ntruprime_core_invsntrup857;
      printf("core_invsntrup857 selected implementation %s compiler %s\n",ntruprime_core_invsntrup857_implementation(),ntruprime_core_invsntrup857_compiler());
    }
    randombytes(h,ntruprime_core_invsntrup857_OUTPUTBYTES);
    randombytes(n,ntruprime_core_invsntrup857_INPUTBYTES);
    randombytes(k,ntruprime_core_invsntrup857_KEYBYTES);
    randombytes(c,ntruprime_core_invsntrup857_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_invsntrup857",impl,ntruprime_core_invsntrup857_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_invsntrup953(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup953")) return;
  void *hstorage = callocplus(ntruprime_core_invsntrup953_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_invsntrup953_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_invsntrup953_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_invsntrup953_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup953();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_invsntrup953_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_invsntrup953(impl);
      printf("core_invsntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup953_implementation(impl),ntruprime_dispatch_core_invsntrup953_compiler(impl));
    } else {
      crypto_core = ntruprime_core_invsntrup953;
      printf("core_invsntrup953 selected implementation %s compiler %s\n",ntruprime_core_invsntrup953_implementation(),ntruprime_core_invsntrup953_compiler());
    }
    randombytes(h,ntruprime_core_invsntrup953_OUTPUTBYTES);
    randombytes(n,ntruprime_core_invsntrup953_INPUTBYTES);
    randombytes(k,ntruprime_core_invsntrup953_KEYBYTES);
    randombytes(c,ntruprime_core_invsntrup953_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_invsntrup953",impl,ntruprime_core_invsntrup953_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_invsntrup1013(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup1013")) return;
  void *hstorage = callocplus(ntruprime_core_invsntrup1013_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_invsntrup1013_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_invsntrup1013_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_invsntrup1013_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup1013();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_invsntrup1013_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_invsntrup1013(impl);
      printf("core_invsntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup1013_implementation(impl),ntruprime_dispatch_core_invsntrup1013_compiler(impl));
    } else {
      crypto_core = ntruprime_core_invsntrup1013;
      printf("core_invsntrup1013 selected implementation %s compiler %s\n",ntruprime_core_invsntrup1013_implementation(),ntruprime_core_invsntrup1013_compiler());
    }
    randombytes(h,ntruprime_core_invsntrup1013_OUTPUTBYTES);
    randombytes(n,ntruprime_core_invsntrup1013_INPUTBYTES);
    randombytes(k,ntruprime_core_invsntrup1013_KEYBYTES);
    randombytes(c,ntruprime_core_invsntrup1013_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_invsntrup1013",impl,ntruprime_core_invsntrup1013_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_invsntrup1277(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup1277")) return;
  void *hstorage = callocplus(ntruprime_core_invsntrup1277_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_invsntrup1277_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_invsntrup1277_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_invsntrup1277_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup1277();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_invsntrup1277_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_invsntrup1277(impl);
      printf("core_invsntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup1277_implementation(impl),ntruprime_dispatch_core_invsntrup1277_compiler(impl));
    } else {
      crypto_core = ntruprime_core_invsntrup1277;
      printf("core_invsntrup1277 selected implementation %s compiler %s\n",ntruprime_core_invsntrup1277_implementation(),ntruprime_core_invsntrup1277_compiler());
    }
    randombytes(h,ntruprime_core_invsntrup1277_OUTPUTBYTES);
    randombytes(n,ntruprime_core_invsntrup1277_INPUTBYTES);
    randombytes(k,ntruprime_core_invsntrup1277_KEYBYTES);
    randombytes(c,ntruprime_core_invsntrup1277_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_invsntrup1277",impl,ntruprime_core_invsntrup1277_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_mult3sntrup653(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"mult3sntrup653")) return;
  void *hstorage = callocplus(ntruprime_core_mult3sntrup653_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_mult3sntrup653_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_mult3sntrup653_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_mult3sntrup653_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_mult3sntrup653();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_mult3sntrup653_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_mult3sntrup653(impl);
      printf("core_mult3sntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_mult3sntrup653_implementation(impl),ntruprime_dispatch_core_mult3sntrup653_compiler(impl));
    } else {
      crypto_core = ntruprime_core_mult3sntrup653;
      printf("core_mult3sntrup653 selected implementation %s compiler %s\n",ntruprime_core_mult3sntrup653_implementation(),ntruprime_core_mult3sntrup653_compiler());
    }
    randombytes(h,ntruprime_core_mult3sntrup653_OUTPUTBYTES);
    randombytes(n,ntruprime_core_mult3sntrup653_INPUTBYTES);
    randombytes(k,ntruprime_core_mult3sntrup653_KEYBYTES);
    randombytes(c,ntruprime_core_mult3sntrup653_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_mult3sntrup653",impl,ntruprime_core_mult3sntrup653_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_mult3sntrup761(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"mult3sntrup761")) return;
  void *hstorage = callocplus(ntruprime_core_mult3sntrup761_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_mult3sntrup761_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_mult3sntrup761_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_mult3sntrup761_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_mult3sntrup761();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_mult3sntrup761_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_mult3sntrup761(impl);
      printf("core_mult3sntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_mult3sntrup761_implementation(impl),ntruprime_dispatch_core_mult3sntrup761_compiler(impl));
    } else {
      crypto_core = ntruprime_core_mult3sntrup761;
      printf("core_mult3sntrup761 selected implementation %s compiler %s\n",ntruprime_core_mult3sntrup761_implementation(),ntruprime_core_mult3sntrup761_compiler());
    }
    randombytes(h,ntruprime_core_mult3sntrup761_OUTPUTBYTES);
    randombytes(n,ntruprime_core_mult3sntrup761_INPUTBYTES);
    randombytes(k,ntruprime_core_mult3sntrup761_KEYBYTES);
    randombytes(c,ntruprime_core_mult3sntrup761_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_mult3sntrup761",impl,ntruprime_core_mult3sntrup761_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_mult3sntrup857(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"mult3sntrup857")) return;
  void *hstorage = callocplus(ntruprime_core_mult3sntrup857_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_mult3sntrup857_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_mult3sntrup857_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_mult3sntrup857_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_mult3sntrup857();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_mult3sntrup857_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_mult3sntrup857(impl);
      printf("core_mult3sntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_mult3sntrup857_implementation(impl),ntruprime_dispatch_core_mult3sntrup857_compiler(impl));
    } else {
      crypto_core = ntruprime_core_mult3sntrup857;
      printf("core_mult3sntrup857 selected implementation %s compiler %s\n",ntruprime_core_mult3sntrup857_implementation(),ntruprime_core_mult3sntrup857_compiler());
    }
    randombytes(h,ntruprime_core_mult3sntrup857_OUTPUTBYTES);
    randombytes(n,ntruprime_core_mult3sntrup857_INPUTBYTES);
    randombytes(k,ntruprime_core_mult3sntrup857_KEYBYTES);
    randombytes(c,ntruprime_core_mult3sntrup857_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_mult3sntrup857",impl,ntruprime_core_mult3sntrup857_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_mult3sntrup953(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"mult3sntrup953")) return;
  void *hstorage = callocplus(ntruprime_core_mult3sntrup953_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_mult3sntrup953_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_mult3sntrup953_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_mult3sntrup953_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_mult3sntrup953();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_mult3sntrup953_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_mult3sntrup953(impl);
      printf("core_mult3sntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_mult3sntrup953_implementation(impl),ntruprime_dispatch_core_mult3sntrup953_compiler(impl));
    } else {
      crypto_core = ntruprime_core_mult3sntrup953;
      printf("core_mult3sntrup953 selected implementation %s compiler %s\n",ntruprime_core_mult3sntrup953_implementation(),ntruprime_core_mult3sntrup953_compiler());
    }
    randombytes(h,ntruprime_core_mult3sntrup953_OUTPUTBYTES);
    randombytes(n,ntruprime_core_mult3sntrup953_INPUTBYTES);
    randombytes(k,ntruprime_core_mult3sntrup953_KEYBYTES);
    randombytes(c,ntruprime_core_mult3sntrup953_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_mult3sntrup953",impl,ntruprime_core_mult3sntrup953_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_mult3sntrup1013(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"mult3sntrup1013")) return;
  void *hstorage = callocplus(ntruprime_core_mult3sntrup1013_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_mult3sntrup1013_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_mult3sntrup1013_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_mult3sntrup1013_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_mult3sntrup1013();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_mult3sntrup1013_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_mult3sntrup1013(impl);
      printf("core_mult3sntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_mult3sntrup1013_implementation(impl),ntruprime_dispatch_core_mult3sntrup1013_compiler(impl));
    } else {
      crypto_core = ntruprime_core_mult3sntrup1013;
      printf("core_mult3sntrup1013 selected implementation %s compiler %s\n",ntruprime_core_mult3sntrup1013_implementation(),ntruprime_core_mult3sntrup1013_compiler());
    }
    randombytes(h,ntruprime_core_mult3sntrup1013_OUTPUTBYTES);
    randombytes(n,ntruprime_core_mult3sntrup1013_INPUTBYTES);
    randombytes(k,ntruprime_core_mult3sntrup1013_KEYBYTES);
    randombytes(c,ntruprime_core_mult3sntrup1013_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_mult3sntrup1013",impl,ntruprime_core_mult3sntrup1013_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_mult3sntrup1277(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"mult3sntrup1277")) return;
  void *hstorage = callocplus(ntruprime_core_mult3sntrup1277_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_mult3sntrup1277_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_mult3sntrup1277_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_mult3sntrup1277_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_mult3sntrup1277();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_mult3sntrup1277_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_mult3sntrup1277(impl);
      printf("core_mult3sntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_mult3sntrup1277_implementation(impl),ntruprime_dispatch_core_mult3sntrup1277_compiler(impl));
    } else {
      crypto_core = ntruprime_core_mult3sntrup1277;
      printf("core_mult3sntrup1277 selected implementation %s compiler %s\n",ntruprime_core_mult3sntrup1277_implementation(),ntruprime_core_mult3sntrup1277_compiler());
    }
    randombytes(h,ntruprime_core_mult3sntrup1277_OUTPUTBYTES);
    randombytes(n,ntruprime_core_mult3sntrup1277_INPUTBYTES);
    randombytes(k,ntruprime_core_mult3sntrup1277_KEYBYTES);
    randombytes(c,ntruprime_core_mult3sntrup1277_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_mult3sntrup1277",impl,ntruprime_core_mult3sntrup1277_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_multsntrup653(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup653")) return;
  void *hstorage = callocplus(ntruprime_core_multsntrup653_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_multsntrup653_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_multsntrup653_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_multsntrup653_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup653();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_multsntrup653_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_multsntrup653(impl);
      printf("core_multsntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup653_implementation(impl),ntruprime_dispatch_core_multsntrup653_compiler(impl));
    } else {
      crypto_core = ntruprime_core_multsntrup653;
      printf("core_multsntrup653 selected implementation %s compiler %s\n",ntruprime_core_multsntrup653_implementation(),ntruprime_core_multsntrup653_compiler());
    }
    randombytes(h,ntruprime_core_multsntrup653_OUTPUTBYTES);
    randombytes(n,ntruprime_core_multsntrup653_INPUTBYTES);
    randombytes(k,ntruprime_core_multsntrup653_KEYBYTES);
    randombytes(c,ntruprime_core_multsntrup653_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_multsntrup653",impl,ntruprime_core_multsntrup653_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_multsntrup761(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup761")) return;
  void *hstorage = callocplus(ntruprime_core_multsntrup761_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_multsntrup761_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_multsntrup761_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_multsntrup761_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup761();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_multsntrup761_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_multsntrup761(impl);
      printf("core_multsntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup761_implementation(impl),ntruprime_dispatch_core_multsntrup761_compiler(impl));
    } else {
      crypto_core = ntruprime_core_multsntrup761;
      printf("core_multsntrup761 selected implementation %s compiler %s\n",ntruprime_core_multsntrup761_implementation(),ntruprime_core_multsntrup761_compiler());
    }
    randombytes(h,ntruprime_core_multsntrup761_OUTPUTBYTES);
    randombytes(n,ntruprime_core_multsntrup761_INPUTBYTES);
    randombytes(k,ntruprime_core_multsntrup761_KEYBYTES);
    randombytes(c,ntruprime_core_multsntrup761_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_multsntrup761",impl,ntruprime_core_multsntrup761_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_multsntrup857(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup857")) return;
  void *hstorage = callocplus(ntruprime_core_multsntrup857_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_multsntrup857_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_multsntrup857_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_multsntrup857_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup857();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_multsntrup857_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_multsntrup857(impl);
      printf("core_multsntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup857_implementation(impl),ntruprime_dispatch_core_multsntrup857_compiler(impl));
    } else {
      crypto_core = ntruprime_core_multsntrup857;
      printf("core_multsntrup857 selected implementation %s compiler %s\n",ntruprime_core_multsntrup857_implementation(),ntruprime_core_multsntrup857_compiler());
    }
    randombytes(h,ntruprime_core_multsntrup857_OUTPUTBYTES);
    randombytes(n,ntruprime_core_multsntrup857_INPUTBYTES);
    randombytes(k,ntruprime_core_multsntrup857_KEYBYTES);
    randombytes(c,ntruprime_core_multsntrup857_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_multsntrup857",impl,ntruprime_core_multsntrup857_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_multsntrup953(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup953")) return;
  void *hstorage = callocplus(ntruprime_core_multsntrup953_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_multsntrup953_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_multsntrup953_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_multsntrup953_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup953();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_multsntrup953_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_multsntrup953(impl);
      printf("core_multsntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup953_implementation(impl),ntruprime_dispatch_core_multsntrup953_compiler(impl));
    } else {
      crypto_core = ntruprime_core_multsntrup953;
      printf("core_multsntrup953 selected implementation %s compiler %s\n",ntruprime_core_multsntrup953_implementation(),ntruprime_core_multsntrup953_compiler());
    }
    randombytes(h,ntruprime_core_multsntrup953_OUTPUTBYTES);
    randombytes(n,ntruprime_core_multsntrup953_INPUTBYTES);
    randombytes(k,ntruprime_core_multsntrup953_KEYBYTES);
    randombytes(c,ntruprime_core_multsntrup953_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_multsntrup953",impl,ntruprime_core_multsntrup953_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_multsntrup1013(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup1013")) return;
  void *hstorage = callocplus(ntruprime_core_multsntrup1013_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_multsntrup1013_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_multsntrup1013_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_multsntrup1013_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup1013();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_multsntrup1013_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_multsntrup1013(impl);
      printf("core_multsntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup1013_implementation(impl),ntruprime_dispatch_core_multsntrup1013_compiler(impl));
    } else {
      crypto_core = ntruprime_core_multsntrup1013;
      printf("core_multsntrup1013 selected implementation %s compiler %s\n",ntruprime_core_multsntrup1013_implementation(),ntruprime_core_multsntrup1013_compiler());
    }
    randombytes(h,ntruprime_core_multsntrup1013_OUTPUTBYTES);
    randombytes(n,ntruprime_core_multsntrup1013_INPUTBYTES);
    randombytes(k,ntruprime_core_multsntrup1013_KEYBYTES);
    randombytes(c,ntruprime_core_multsntrup1013_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_multsntrup1013",impl,ntruprime_core_multsntrup1013_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_multsntrup1277(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup1277")) return;
  void *hstorage = callocplus(ntruprime_core_multsntrup1277_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_multsntrup1277_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_multsntrup1277_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_multsntrup1277_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup1277();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_multsntrup1277_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_multsntrup1277(impl);
      printf("core_multsntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup1277_implementation(impl),ntruprime_dispatch_core_multsntrup1277_compiler(impl));
    } else {
      crypto_core = ntruprime_core_multsntrup1277;
      printf("core_multsntrup1277 selected implementation %s compiler %s\n",ntruprime_core_multsntrup1277_implementation(),ntruprime_core_multsntrup1277_compiler());
    }
    randombytes(h,ntruprime_core_multsntrup1277_OUTPUTBYTES);
    randombytes(n,ntruprime_core_multsntrup1277_INPUTBYTES);
    randombytes(k,ntruprime_core_multsntrup1277_KEYBYTES);
    randombytes(c,ntruprime_core_multsntrup1277_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_multsntrup1277",impl,ntruprime_core_multsntrup1277_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_scale3sntrup653(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup653")) return;
  void *hstorage = callocplus(ntruprime_core_scale3sntrup653_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_scale3sntrup653_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_scale3sntrup653_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_scale3sntrup653_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup653();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup653_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_scale3sntrup653(impl);
      printf("core_scale3sntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup653_implementation(impl),ntruprime_dispatch_core_scale3sntrup653_compiler(impl));
    } else {
      crypto_core = ntruprime_core_scale3sntrup653;
      printf("core_scale3sntrup653 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup653_implementation(),ntruprime_core_scale3sntrup653_compiler());
    }
    randombytes(h,ntruprime_core_scale3sntrup653_OUTPUTBYTES);
    randombytes(n,ntruprime_core_scale3sntrup653_INPUTBYTES);
    randombytes(k,ntruprime_core_scale3sntrup653_KEYBYTES);
    randombytes(c,ntruprime_core_scale3sntrup653_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_scale3sntrup653",impl,ntruprime_core_scale3sntrup653_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_scale3sntrup761(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup761")) return;
  void *hstorage = callocplus(ntruprime_core_scale3sntrup761_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_scale3sntrup761_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_scale3sntrup761_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_scale3sntrup761_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup761();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup761_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_scale3sntrup761(impl);
      printf("core_scale3sntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup761_implementation(impl),ntruprime_dispatch_core_scale3sntrup761_compiler(impl));
    } else {
      crypto_core = ntruprime_core_scale3sntrup761;
      printf("core_scale3sntrup761 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup761_implementation(),ntruprime_core_scale3sntrup761_compiler());
    }
    randombytes(h,ntruprime_core_scale3sntrup761_OUTPUTBYTES);
    randombytes(n,ntruprime_core_scale3sntrup761_INPUTBYTES);
    randombytes(k,ntruprime_core_scale3sntrup761_KEYBYTES);
    randombytes(c,ntruprime_core_scale3sntrup761_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_scale3sntrup761",impl,ntruprime_core_scale3sntrup761_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_scale3sntrup857(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup857")) return;
  void *hstorage = callocplus(ntruprime_core_scale3sntrup857_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_scale3sntrup857_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_scale3sntrup857_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_scale3sntrup857_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup857();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup857_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_scale3sntrup857(impl);
      printf("core_scale3sntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup857_implementation(impl),ntruprime_dispatch_core_scale3sntrup857_compiler(impl));
    } else {
      crypto_core = ntruprime_core_scale3sntrup857;
      printf("core_scale3sntrup857 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup857_implementation(),ntruprime_core_scale3sntrup857_compiler());
    }
    randombytes(h,ntruprime_core_scale3sntrup857_OUTPUTBYTES);
    randombytes(n,ntruprime_core_scale3sntrup857_INPUTBYTES);
    randombytes(k,ntruprime_core_scale3sntrup857_KEYBYTES);
    randombytes(c,ntruprime_core_scale3sntrup857_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_scale3sntrup857",impl,ntruprime_core_scale3sntrup857_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_scale3sntrup953(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup953")) return;
  void *hstorage = callocplus(ntruprime_core_scale3sntrup953_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_scale3sntrup953_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_scale3sntrup953_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_scale3sntrup953_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup953();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup953_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_scale3sntrup953(impl);
      printf("core_scale3sntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup953_implementation(impl),ntruprime_dispatch_core_scale3sntrup953_compiler(impl));
    } else {
      crypto_core = ntruprime_core_scale3sntrup953;
      printf("core_scale3sntrup953 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup953_implementation(),ntruprime_core_scale3sntrup953_compiler());
    }
    randombytes(h,ntruprime_core_scale3sntrup953_OUTPUTBYTES);
    randombytes(n,ntruprime_core_scale3sntrup953_INPUTBYTES);
    randombytes(k,ntruprime_core_scale3sntrup953_KEYBYTES);
    randombytes(c,ntruprime_core_scale3sntrup953_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_scale3sntrup953",impl,ntruprime_core_scale3sntrup953_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_scale3sntrup1013(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup1013")) return;
  void *hstorage = callocplus(ntruprime_core_scale3sntrup1013_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_scale3sntrup1013_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_scale3sntrup1013_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_scale3sntrup1013_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup1013();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup1013_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_scale3sntrup1013(impl);
      printf("core_scale3sntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup1013_implementation(impl),ntruprime_dispatch_core_scale3sntrup1013_compiler(impl));
    } else {
      crypto_core = ntruprime_core_scale3sntrup1013;
      printf("core_scale3sntrup1013 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup1013_implementation(),ntruprime_core_scale3sntrup1013_compiler());
    }
    randombytes(h,ntruprime_core_scale3sntrup1013_OUTPUTBYTES);
    randombytes(n,ntruprime_core_scale3sntrup1013_INPUTBYTES);
    randombytes(k,ntruprime_core_scale3sntrup1013_KEYBYTES);
    randombytes(c,ntruprime_core_scale3sntrup1013_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_scale3sntrup1013",impl,ntruprime_core_scale3sntrup1013_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_scale3sntrup1277(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup1277")) return;
  void *hstorage = callocplus(ntruprime_core_scale3sntrup1277_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_scale3sntrup1277_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_scale3sntrup1277_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_scale3sntrup1277_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup1277();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup1277_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_scale3sntrup1277(impl);
      printf("core_scale3sntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup1277_implementation(impl),ntruprime_dispatch_core_scale3sntrup1277_compiler(impl));
    } else {
      crypto_core = ntruprime_core_scale3sntrup1277;
      printf("core_scale3sntrup1277 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup1277_implementation(),ntruprime_core_scale3sntrup1277_compiler());
    }
    randombytes(h,ntruprime_core_scale3sntrup1277_OUTPUTBYTES);
    randombytes(n,ntruprime_core_scale3sntrup1277_INPUTBYTES);
    randombytes(k,ntruprime_core_scale3sntrup1277_KEYBYTES);
    randombytes(c,ntruprime_core_scale3sntrup1277_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_scale3sntrup1277",impl,ntruprime_core_scale3sntrup1277_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_weightsntrup653(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"weightsntrup653")) return;
  void *hstorage = callocplus(ntruprime_core_weightsntrup653_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_weightsntrup653_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_weightsntrup653_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_weightsntrup653_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_weightsntrup653();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_weightsntrup653_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_weightsntrup653(impl);
      printf("core_weightsntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_weightsntrup653_implementation(impl),ntruprime_dispatch_core_weightsntrup653_compiler(impl));
    } else {
      crypto_core = ntruprime_core_weightsntrup653;
      printf("core_weightsntrup653 selected implementation %s compiler %s\n",ntruprime_core_weightsntrup653_implementation(),ntruprime_core_weightsntrup653_compiler());
    }
    randombytes(h,ntruprime_core_weightsntrup653_OUTPUTBYTES);
    randombytes(n,ntruprime_core_weightsntrup653_INPUTBYTES);
    randombytes(k,ntruprime_core_weightsntrup653_KEYBYTES);
    randombytes(c,ntruprime_core_weightsntrup653_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_weightsntrup653",impl,ntruprime_core_weightsntrup653_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_weightsntrup761(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"weightsntrup761")) return;
  void *hstorage = callocplus(ntruprime_core_weightsntrup761_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_weightsntrup761_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_weightsntrup761_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_weightsntrup761_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_weightsntrup761();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_weightsntrup761_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_weightsntrup761(impl);
      printf("core_weightsntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_weightsntrup761_implementation(impl),ntruprime_dispatch_core_weightsntrup761_compiler(impl));
    } else {
      crypto_core = ntruprime_core_weightsntrup761;
      printf("core_weightsntrup761 selected implementation %s compiler %s\n",ntruprime_core_weightsntrup761_implementation(),ntruprime_core_weightsntrup761_compiler());
    }
    randombytes(h,ntruprime_core_weightsntrup761_OUTPUTBYTES);
    randombytes(n,ntruprime_core_weightsntrup761_INPUTBYTES);
    randombytes(k,ntruprime_core_weightsntrup761_KEYBYTES);
    randombytes(c,ntruprime_core_weightsntrup761_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_weightsntrup761",impl,ntruprime_core_weightsntrup761_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_weightsntrup857(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"weightsntrup857")) return;
  void *hstorage = callocplus(ntruprime_core_weightsntrup857_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_weightsntrup857_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_weightsntrup857_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_weightsntrup857_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_weightsntrup857();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_weightsntrup857_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_weightsntrup857(impl);
      printf("core_weightsntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_weightsntrup857_implementation(impl),ntruprime_dispatch_core_weightsntrup857_compiler(impl));
    } else {
      crypto_core = ntruprime_core_weightsntrup857;
      printf("core_weightsntrup857 selected implementation %s compiler %s\n",ntruprime_core_weightsntrup857_implementation(),ntruprime_core_weightsntrup857_compiler());
    }
    randombytes(h,ntruprime_core_weightsntrup857_OUTPUTBYTES);
    randombytes(n,ntruprime_core_weightsntrup857_INPUTBYTES);
    randombytes(k,ntruprime_core_weightsntrup857_KEYBYTES);
    randombytes(c,ntruprime_core_weightsntrup857_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_weightsntrup857",impl,ntruprime_core_weightsntrup857_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_weightsntrup953(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"weightsntrup953")) return;
  void *hstorage = callocplus(ntruprime_core_weightsntrup953_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_weightsntrup953_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_weightsntrup953_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_weightsntrup953_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_weightsntrup953();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_weightsntrup953_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_weightsntrup953(impl);
      printf("core_weightsntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_weightsntrup953_implementation(impl),ntruprime_dispatch_core_weightsntrup953_compiler(impl));
    } else {
      crypto_core = ntruprime_core_weightsntrup953;
      printf("core_weightsntrup953 selected implementation %s compiler %s\n",ntruprime_core_weightsntrup953_implementation(),ntruprime_core_weightsntrup953_compiler());
    }
    randombytes(h,ntruprime_core_weightsntrup953_OUTPUTBYTES);
    randombytes(n,ntruprime_core_weightsntrup953_INPUTBYTES);
    randombytes(k,ntruprime_core_weightsntrup953_KEYBYTES);
    randombytes(c,ntruprime_core_weightsntrup953_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_weightsntrup953",impl,ntruprime_core_weightsntrup953_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_weightsntrup1013(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"weightsntrup1013")) return;
  void *hstorage = callocplus(ntruprime_core_weightsntrup1013_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_weightsntrup1013_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_weightsntrup1013_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_weightsntrup1013_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_weightsntrup1013();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_weightsntrup1013_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_weightsntrup1013(impl);
      printf("core_weightsntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_weightsntrup1013_implementation(impl),ntruprime_dispatch_core_weightsntrup1013_compiler(impl));
    } else {
      crypto_core = ntruprime_core_weightsntrup1013;
      printf("core_weightsntrup1013 selected implementation %s compiler %s\n",ntruprime_core_weightsntrup1013_implementation(),ntruprime_core_weightsntrup1013_compiler());
    }
    randombytes(h,ntruprime_core_weightsntrup1013_OUTPUTBYTES);
    randombytes(n,ntruprime_core_weightsntrup1013_INPUTBYTES);
    randombytes(k,ntruprime_core_weightsntrup1013_KEYBYTES);
    randombytes(c,ntruprime_core_weightsntrup1013_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_weightsntrup1013",impl,ntruprime_core_weightsntrup1013_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_weightsntrup1277(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"weightsntrup1277")) return;
  void *hstorage = callocplus(ntruprime_core_weightsntrup1277_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_weightsntrup1277_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_weightsntrup1277_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_weightsntrup1277_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_weightsntrup1277();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_weightsntrup1277_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_weightsntrup1277(impl);
      printf("core_weightsntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_weightsntrup1277_implementation(impl),ntruprime_dispatch_core_weightsntrup1277_compiler(impl));
    } else {
      crypto_core = ntruprime_core_weightsntrup1277;
      printf("core_weightsntrup1277 selected implementation %s compiler %s\n",ntruprime_core_weightsntrup1277_implementation(),ntruprime_core_weightsntrup1277_compiler());
    }
    randombytes(h,ntruprime_core_weightsntrup1277_OUTPUTBYTES);
    randombytes(n,ntruprime_core_weightsntrup1277_INPUTBYTES);
    randombytes(k,ntruprime_core_weightsntrup1277_KEYBYTES);
    randombytes(c,ntruprime_core_weightsntrup1277_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_weightsntrup1277",impl,ntruprime_core_weightsntrup1277_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_wforcesntrup653(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup653")) return;
  void *hstorage = callocplus(ntruprime_core_wforcesntrup653_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_wforcesntrup653_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_wforcesntrup653_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_wforcesntrup653_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup653();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup653_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_wforcesntrup653(impl);
      printf("core_wforcesntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup653_implementation(impl),ntruprime_dispatch_core_wforcesntrup653_compiler(impl));
    } else {
      crypto_core = ntruprime_core_wforcesntrup653;
      printf("core_wforcesntrup653 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup653_implementation(),ntruprime_core_wforcesntrup653_compiler());
    }
    randombytes(h,ntruprime_core_wforcesntrup653_OUTPUTBYTES);
    randombytes(n,ntruprime_core_wforcesntrup653_INPUTBYTES);
    randombytes(k,ntruprime_core_wforcesntrup653_KEYBYTES);
    randombytes(c,ntruprime_core_wforcesntrup653_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_wforcesntrup653",impl,ntruprime_core_wforcesntrup653_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_wforcesntrup761(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup761")) return;
  void *hstorage = callocplus(ntruprime_core_wforcesntrup761_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_wforcesntrup761_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_wforcesntrup761_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_wforcesntrup761_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup761();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup761_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_wforcesntrup761(impl);
      printf("core_wforcesntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup761_implementation(impl),ntruprime_dispatch_core_wforcesntrup761_compiler(impl));
    } else {
      crypto_core = ntruprime_core_wforcesntrup761;
      printf("core_wforcesntrup761 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup761_implementation(),ntruprime_core_wforcesntrup761_compiler());
    }
    randombytes(h,ntruprime_core_wforcesntrup761_OUTPUTBYTES);
    randombytes(n,ntruprime_core_wforcesntrup761_INPUTBYTES);
    randombytes(k,ntruprime_core_wforcesntrup761_KEYBYTES);
    randombytes(c,ntruprime_core_wforcesntrup761_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_wforcesntrup761",impl,ntruprime_core_wforcesntrup761_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_wforcesntrup857(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup857")) return;
  void *hstorage = callocplus(ntruprime_core_wforcesntrup857_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_wforcesntrup857_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_wforcesntrup857_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_wforcesntrup857_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup857();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup857_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_wforcesntrup857(impl);
      printf("core_wforcesntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup857_implementation(impl),ntruprime_dispatch_core_wforcesntrup857_compiler(impl));
    } else {
      crypto_core = ntruprime_core_wforcesntrup857;
      printf("core_wforcesntrup857 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup857_implementation(),ntruprime_core_wforcesntrup857_compiler());
    }
    randombytes(h,ntruprime_core_wforcesntrup857_OUTPUTBYTES);
    randombytes(n,ntruprime_core_wforcesntrup857_INPUTBYTES);
    randombytes(k,ntruprime_core_wforcesntrup857_KEYBYTES);
    randombytes(c,ntruprime_core_wforcesntrup857_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_wforcesntrup857",impl,ntruprime_core_wforcesntrup857_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_wforcesntrup953(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup953")) return;
  void *hstorage = callocplus(ntruprime_core_wforcesntrup953_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_wforcesntrup953_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_wforcesntrup953_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_wforcesntrup953_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup953();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup953_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_wforcesntrup953(impl);
      printf("core_wforcesntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup953_implementation(impl),ntruprime_dispatch_core_wforcesntrup953_compiler(impl));
    } else {
      crypto_core = ntruprime_core_wforcesntrup953;
      printf("core_wforcesntrup953 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup953_implementation(),ntruprime_core_wforcesntrup953_compiler());
    }
    randombytes(h,ntruprime_core_wforcesntrup953_OUTPUTBYTES);
    randombytes(n,ntruprime_core_wforcesntrup953_INPUTBYTES);
    randombytes(k,ntruprime_core_wforcesntrup953_KEYBYTES);
    randombytes(c,ntruprime_core_wforcesntrup953_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_wforcesntrup953",impl,ntruprime_core_wforcesntrup953_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_wforcesntrup1013(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup1013")) return;
  void *hstorage = callocplus(ntruprime_core_wforcesntrup1013_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_wforcesntrup1013_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_wforcesntrup1013_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_wforcesntrup1013_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup1013();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup1013_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_wforcesntrup1013(impl);
      printf("core_wforcesntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup1013_implementation(impl),ntruprime_dispatch_core_wforcesntrup1013_compiler(impl));
    } else {
      crypto_core = ntruprime_core_wforcesntrup1013;
      printf("core_wforcesntrup1013 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup1013_implementation(),ntruprime_core_wforcesntrup1013_compiler());
    }
    randombytes(h,ntruprime_core_wforcesntrup1013_OUTPUTBYTES);
    randombytes(n,ntruprime_core_wforcesntrup1013_INPUTBYTES);
    randombytes(k,ntruprime_core_wforcesntrup1013_KEYBYTES);
    randombytes(c,ntruprime_core_wforcesntrup1013_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_wforcesntrup1013",impl,ntruprime_core_wforcesntrup1013_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_core_wforcesntrup1277(void)
{
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"wforcesntrup1277")) return;
  void *hstorage = callocplus(ntruprime_core_wforcesntrup1277_OUTPUTBYTES);
  unsigned char *h = aligned(hstorage);
  void *nstorage = callocplus(ntruprime_core_wforcesntrup1277_INPUTBYTES);
  unsigned char *n = aligned(nstorage);
  void *kstorage = callocplus(ntruprime_core_wforcesntrup1277_KEYBYTES);
  unsigned char *k = aligned(kstorage);
  void *cstorage = callocplus(ntruprime_core_wforcesntrup1277_CONSTBYTES);
  unsigned char *c = aligned(cstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_core_wforcesntrup1277();++impl) {
    void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_core_wforcesntrup1277_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_core = ntruprime_dispatch_core_wforcesntrup1277(impl);
      printf("core_wforcesntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_wforcesntrup1277_implementation(impl),ntruprime_dispatch_core_wforcesntrup1277_compiler(impl));
    } else {
      crypto_core = ntruprime_core_wforcesntrup1277;
      printf("core_wforcesntrup1277 selected implementation %s compiler %s\n",ntruprime_core_wforcesntrup1277_implementation(),ntruprime_core_wforcesntrup1277_compiler());
    }
    randombytes(h,ntruprime_core_wforcesntrup1277_OUTPUTBYTES);
    randombytes(n,ntruprime_core_wforcesntrup1277_INPUTBYTES);
    randombytes(k,ntruprime_core_wforcesntrup1277_KEYBYTES);
    randombytes(c,ntruprime_core_wforcesntrup1277_CONSTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_core(h,n,k,c);
    }
    t_print("core_wforcesntrup1277",impl,ntruprime_core_wforcesntrup1277_OUTPUTBYTES);
  }
  free(cstorage);
  free(kstorage);
  free(nstorage);
  free(hstorage);
}

static void measure_kem_sntrup653(void)
{
  if (targeto && strcmp(targeto,"kem")) return;
  if (targetp && strcmp(targetp,"sntrup653")) return;
  void *pstorage = callocplus(ntruprime_kem_sntrup653_PUBLICKEYBYTES);
  unsigned char *p = aligned(pstorage);
  void *sstorage = callocplus(ntruprime_kem_sntrup653_SECRETKEYBYTES);
  unsigned char *s = aligned(sstorage);
  void *cstorage = callocplus(ntruprime_kem_sntrup653_CIPHERTEXTBYTES);
  unsigned char *c = aligned(cstorage);
  void *kstorage = callocplus(ntruprime_kem_sntrup653_BYTES);
  unsigned char *k = aligned(kstorage);
  void *Tstorage = callocplus(ntruprime_kem_sntrup653_BYTES);
  unsigned char *T = aligned(Tstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_kem_sntrup653();++impl) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *);
    void (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *);
    void (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_kem_sntrup653_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_kem_keypair = ntruprime_dispatch_kem_sntrup653_keypair(impl);
      crypto_kem_enc = ntruprime_dispatch_kem_sntrup653_enc(impl);
      crypto_kem_dec = ntruprime_dispatch_kem_sntrup653_dec(impl);
      printf("kem_sntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_kem_sntrup653_implementation(impl),ntruprime_dispatch_kem_sntrup653_compiler(impl));
    } else {
      crypto_kem_keypair = ntruprime_kem_sntrup653_keypair;
      crypto_kem_enc = ntruprime_kem_sntrup653_enc;
      crypto_kem_dec = ntruprime_kem_sntrup653_dec;
      printf("kem_sntrup653 selected implementation %s compiler %s\n",ntruprime_kem_sntrup653_implementation(),ntruprime_kem_sntrup653_compiler());
    }
    randombytes(p,ntruprime_kem_sntrup653_PUBLICKEYBYTES);
    randombytes(s,ntruprime_kem_sntrup653_SECRETKEYBYTES);
    randombytes(c,ntruprime_kem_sntrup653_CIPHERTEXTBYTES);
    randombytes(k,ntruprime_kem_sntrup653_BYTES);
    randombytes(T,ntruprime_kem_sntrup653_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_keypair(p,s);
    }
    t_print("kem_sntrup653_keypair",impl,ntruprime_kem_sntrup653_PUBLICKEYBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_enc(c,k,p);
    }
    t_print("kem_sntrup653_enc",impl,ntruprime_kem_sntrup653_CIPHERTEXTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_dec(T,c,s);
    }
    t_print("kem_sntrup653_dec",impl,ntruprime_kem_sntrup653_BYTES);
  }
  free(Tstorage);
  free(kstorage);
  free(cstorage);
  free(sstorage);
  free(pstorage);
}

static void measure_kem_sntrup761(void)
{
  if (targeto && strcmp(targeto,"kem")) return;
  if (targetp && strcmp(targetp,"sntrup761")) return;
  void *pstorage = callocplus(ntruprime_kem_sntrup761_PUBLICKEYBYTES);
  unsigned char *p = aligned(pstorage);
  void *sstorage = callocplus(ntruprime_kem_sntrup761_SECRETKEYBYTES);
  unsigned char *s = aligned(sstorage);
  void *cstorage = callocplus(ntruprime_kem_sntrup761_CIPHERTEXTBYTES);
  unsigned char *c = aligned(cstorage);
  void *kstorage = callocplus(ntruprime_kem_sntrup761_BYTES);
  unsigned char *k = aligned(kstorage);
  void *Tstorage = callocplus(ntruprime_kem_sntrup761_BYTES);
  unsigned char *T = aligned(Tstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_kem_sntrup761();++impl) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *);
    void (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *);
    void (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_kem_sntrup761_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_kem_keypair = ntruprime_dispatch_kem_sntrup761_keypair(impl);
      crypto_kem_enc = ntruprime_dispatch_kem_sntrup761_enc(impl);
      crypto_kem_dec = ntruprime_dispatch_kem_sntrup761_dec(impl);
      printf("kem_sntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_kem_sntrup761_implementation(impl),ntruprime_dispatch_kem_sntrup761_compiler(impl));
    } else {
      crypto_kem_keypair = ntruprime_kem_sntrup761_keypair;
      crypto_kem_enc = ntruprime_kem_sntrup761_enc;
      crypto_kem_dec = ntruprime_kem_sntrup761_dec;
      printf("kem_sntrup761 selected implementation %s compiler %s\n",ntruprime_kem_sntrup761_implementation(),ntruprime_kem_sntrup761_compiler());
    }
    randombytes(p,ntruprime_kem_sntrup761_PUBLICKEYBYTES);
    randombytes(s,ntruprime_kem_sntrup761_SECRETKEYBYTES);
    randombytes(c,ntruprime_kem_sntrup761_CIPHERTEXTBYTES);
    randombytes(k,ntruprime_kem_sntrup761_BYTES);
    randombytes(T,ntruprime_kem_sntrup761_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_keypair(p,s);
    }
    t_print("kem_sntrup761_keypair",impl,ntruprime_kem_sntrup761_PUBLICKEYBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_enc(c,k,p);
    }
    t_print("kem_sntrup761_enc",impl,ntruprime_kem_sntrup761_CIPHERTEXTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_dec(T,c,s);
    }
    t_print("kem_sntrup761_dec",impl,ntruprime_kem_sntrup761_BYTES);
  }
  free(Tstorage);
  free(kstorage);
  free(cstorage);
  free(sstorage);
  free(pstorage);
}

static void measure_kem_sntrup857(void)
{
  if (targeto && strcmp(targeto,"kem")) return;
  if (targetp && strcmp(targetp,"sntrup857")) return;
  void *pstorage = callocplus(ntruprime_kem_sntrup857_PUBLICKEYBYTES);
  unsigned char *p = aligned(pstorage);
  void *sstorage = callocplus(ntruprime_kem_sntrup857_SECRETKEYBYTES);
  unsigned char *s = aligned(sstorage);
  void *cstorage = callocplus(ntruprime_kem_sntrup857_CIPHERTEXTBYTES);
  unsigned char *c = aligned(cstorage);
  void *kstorage = callocplus(ntruprime_kem_sntrup857_BYTES);
  unsigned char *k = aligned(kstorage);
  void *Tstorage = callocplus(ntruprime_kem_sntrup857_BYTES);
  unsigned char *T = aligned(Tstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_kem_sntrup857();++impl) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *);
    void (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *);
    void (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_kem_sntrup857_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_kem_keypair = ntruprime_dispatch_kem_sntrup857_keypair(impl);
      crypto_kem_enc = ntruprime_dispatch_kem_sntrup857_enc(impl);
      crypto_kem_dec = ntruprime_dispatch_kem_sntrup857_dec(impl);
      printf("kem_sntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_kem_sntrup857_implementation(impl),ntruprime_dispatch_kem_sntrup857_compiler(impl));
    } else {
      crypto_kem_keypair = ntruprime_kem_sntrup857_keypair;
      crypto_kem_enc = ntruprime_kem_sntrup857_enc;
      crypto_kem_dec = ntruprime_kem_sntrup857_dec;
      printf("kem_sntrup857 selected implementation %s compiler %s\n",ntruprime_kem_sntrup857_implementation(),ntruprime_kem_sntrup857_compiler());
    }
    randombytes(p,ntruprime_kem_sntrup857_PUBLICKEYBYTES);
    randombytes(s,ntruprime_kem_sntrup857_SECRETKEYBYTES);
    randombytes(c,ntruprime_kem_sntrup857_CIPHERTEXTBYTES);
    randombytes(k,ntruprime_kem_sntrup857_BYTES);
    randombytes(T,ntruprime_kem_sntrup857_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_keypair(p,s);
    }
    t_print("kem_sntrup857_keypair",impl,ntruprime_kem_sntrup857_PUBLICKEYBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_enc(c,k,p);
    }
    t_print("kem_sntrup857_enc",impl,ntruprime_kem_sntrup857_CIPHERTEXTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_dec(T,c,s);
    }
    t_print("kem_sntrup857_dec",impl,ntruprime_kem_sntrup857_BYTES);
  }
  free(Tstorage);
  free(kstorage);
  free(cstorage);
  free(sstorage);
  free(pstorage);
}

static void measure_kem_sntrup953(void)
{
  if (targeto && strcmp(targeto,"kem")) return;
  if (targetp && strcmp(targetp,"sntrup953")) return;
  void *pstorage = callocplus(ntruprime_kem_sntrup953_PUBLICKEYBYTES);
  unsigned char *p = aligned(pstorage);
  void *sstorage = callocplus(ntruprime_kem_sntrup953_SECRETKEYBYTES);
  unsigned char *s = aligned(sstorage);
  void *cstorage = callocplus(ntruprime_kem_sntrup953_CIPHERTEXTBYTES);
  unsigned char *c = aligned(cstorage);
  void *kstorage = callocplus(ntruprime_kem_sntrup953_BYTES);
  unsigned char *k = aligned(kstorage);
  void *Tstorage = callocplus(ntruprime_kem_sntrup953_BYTES);
  unsigned char *T = aligned(Tstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_kem_sntrup953();++impl) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *);
    void (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *);
    void (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_kem_sntrup953_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_kem_keypair = ntruprime_dispatch_kem_sntrup953_keypair(impl);
      crypto_kem_enc = ntruprime_dispatch_kem_sntrup953_enc(impl);
      crypto_kem_dec = ntruprime_dispatch_kem_sntrup953_dec(impl);
      printf("kem_sntrup953 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_kem_sntrup953_implementation(impl),ntruprime_dispatch_kem_sntrup953_compiler(impl));
    } else {
      crypto_kem_keypair = ntruprime_kem_sntrup953_keypair;
      crypto_kem_enc = ntruprime_kem_sntrup953_enc;
      crypto_kem_dec = ntruprime_kem_sntrup953_dec;
      printf("kem_sntrup953 selected implementation %s compiler %s\n",ntruprime_kem_sntrup953_implementation(),ntruprime_kem_sntrup953_compiler());
    }
    randombytes(p,ntruprime_kem_sntrup953_PUBLICKEYBYTES);
    randombytes(s,ntruprime_kem_sntrup953_SECRETKEYBYTES);
    randombytes(c,ntruprime_kem_sntrup953_CIPHERTEXTBYTES);
    randombytes(k,ntruprime_kem_sntrup953_BYTES);
    randombytes(T,ntruprime_kem_sntrup953_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_keypair(p,s);
    }
    t_print("kem_sntrup953_keypair",impl,ntruprime_kem_sntrup953_PUBLICKEYBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_enc(c,k,p);
    }
    t_print("kem_sntrup953_enc",impl,ntruprime_kem_sntrup953_CIPHERTEXTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_dec(T,c,s);
    }
    t_print("kem_sntrup953_dec",impl,ntruprime_kem_sntrup953_BYTES);
  }
  free(Tstorage);
  free(kstorage);
  free(cstorage);
  free(sstorage);
  free(pstorage);
}

static void measure_kem_sntrup1013(void)
{
  if (targeto && strcmp(targeto,"kem")) return;
  if (targetp && strcmp(targetp,"sntrup1013")) return;
  void *pstorage = callocplus(ntruprime_kem_sntrup1013_PUBLICKEYBYTES);
  unsigned char *p = aligned(pstorage);
  void *sstorage = callocplus(ntruprime_kem_sntrup1013_SECRETKEYBYTES);
  unsigned char *s = aligned(sstorage);
  void *cstorage = callocplus(ntruprime_kem_sntrup1013_CIPHERTEXTBYTES);
  unsigned char *c = aligned(cstorage);
  void *kstorage = callocplus(ntruprime_kem_sntrup1013_BYTES);
  unsigned char *k = aligned(kstorage);
  void *Tstorage = callocplus(ntruprime_kem_sntrup1013_BYTES);
  unsigned char *T = aligned(Tstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_kem_sntrup1013();++impl) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *);
    void (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *);
    void (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_kem_sntrup1013_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_kem_keypair = ntruprime_dispatch_kem_sntrup1013_keypair(impl);
      crypto_kem_enc = ntruprime_dispatch_kem_sntrup1013_enc(impl);
      crypto_kem_dec = ntruprime_dispatch_kem_sntrup1013_dec(impl);
      printf("kem_sntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_kem_sntrup1013_implementation(impl),ntruprime_dispatch_kem_sntrup1013_compiler(impl));
    } else {
      crypto_kem_keypair = ntruprime_kem_sntrup1013_keypair;
      crypto_kem_enc = ntruprime_kem_sntrup1013_enc;
      crypto_kem_dec = ntruprime_kem_sntrup1013_dec;
      printf("kem_sntrup1013 selected implementation %s compiler %s\n",ntruprime_kem_sntrup1013_implementation(),ntruprime_kem_sntrup1013_compiler());
    }
    randombytes(p,ntruprime_kem_sntrup1013_PUBLICKEYBYTES);
    randombytes(s,ntruprime_kem_sntrup1013_SECRETKEYBYTES);
    randombytes(c,ntruprime_kem_sntrup1013_CIPHERTEXTBYTES);
    randombytes(k,ntruprime_kem_sntrup1013_BYTES);
    randombytes(T,ntruprime_kem_sntrup1013_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_keypair(p,s);
    }
    t_print("kem_sntrup1013_keypair",impl,ntruprime_kem_sntrup1013_PUBLICKEYBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_enc(c,k,p);
    }
    t_print("kem_sntrup1013_enc",impl,ntruprime_kem_sntrup1013_CIPHERTEXTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_dec(T,c,s);
    }
    t_print("kem_sntrup1013_dec",impl,ntruprime_kem_sntrup1013_BYTES);
  }
  free(Tstorage);
  free(kstorage);
  free(cstorage);
  free(sstorage);
  free(pstorage);
}

static void measure_kem_sntrup1277(void)
{
  if (targeto && strcmp(targeto,"kem")) return;
  if (targetp && strcmp(targetp,"sntrup1277")) return;
  void *pstorage = callocplus(ntruprime_kem_sntrup1277_PUBLICKEYBYTES);
  unsigned char *p = aligned(pstorage);
  void *sstorage = callocplus(ntruprime_kem_sntrup1277_SECRETKEYBYTES);
  unsigned char *s = aligned(sstorage);
  void *cstorage = callocplus(ntruprime_kem_sntrup1277_CIPHERTEXTBYTES);
  unsigned char *c = aligned(cstorage);
  void *kstorage = callocplus(ntruprime_kem_sntrup1277_BYTES);
  unsigned char *k = aligned(kstorage);
  void *Tstorage = callocplus(ntruprime_kem_sntrup1277_BYTES);
  unsigned char *T = aligned(Tstorage);

  for (long long impl = -1;impl < ntruprime_numimpl_kem_sntrup1277();++impl) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *);
    void (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *);
    void (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *);
    if (targeti && strcmp(targeti,ntruprime_dispatch_kem_sntrup1277_implementation(impl))) continue;
    if (impl >= 0) {
      crypto_kem_keypair = ntruprime_dispatch_kem_sntrup1277_keypair(impl);
      crypto_kem_enc = ntruprime_dispatch_kem_sntrup1277_enc(impl);
      crypto_kem_dec = ntruprime_dispatch_kem_sntrup1277_dec(impl);
      printf("kem_sntrup1277 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_kem_sntrup1277_implementation(impl),ntruprime_dispatch_kem_sntrup1277_compiler(impl));
    } else {
      crypto_kem_keypair = ntruprime_kem_sntrup1277_keypair;
      crypto_kem_enc = ntruprime_kem_sntrup1277_enc;
      crypto_kem_dec = ntruprime_kem_sntrup1277_dec;
      printf("kem_sntrup1277 selected implementation %s compiler %s\n",ntruprime_kem_sntrup1277_implementation(),ntruprime_kem_sntrup1277_compiler());
    }
    randombytes(p,ntruprime_kem_sntrup1277_PUBLICKEYBYTES);
    randombytes(s,ntruprime_kem_sntrup1277_SECRETKEYBYTES);
    randombytes(c,ntruprime_kem_sntrup1277_CIPHERTEXTBYTES);
    randombytes(k,ntruprime_kem_sntrup1277_BYTES);
    randombytes(T,ntruprime_kem_sntrup1277_BYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_keypair(p,s);
    }
    t_print("kem_sntrup1277_keypair",impl,ntruprime_kem_sntrup1277_PUBLICKEYBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_enc(c,k,p);
    }
    t_print("kem_sntrup1277_enc",impl,ntruprime_kem_sntrup1277_CIPHERTEXTBYTES);
    for (long long i = 0;i <= TIMINGS;++i) {
      t[i] = cpucycles();
      crypto_kem_dec(T,c,s);
    }
    t_print("kem_sntrup1277_dec",impl,ntruprime_kem_sntrup1277_BYTES);
  }
  free(Tstorage);
  free(kstorage);
  free(cstorage);
  free(sstorage);
  free(pstorage);
}

#include "print_cpuid.inc"

int main(int argc,char **argv)
{
  printf("ntruprime version %s\n",ntruprime_version);
  printf("ntruprime arch %s\n",ntruprime_arch);
  print_cpuid();

  if (*argv) ++argv;
  if (*argv) {
    targeto = *argv++;
    if (*argv) {
      targetp = *argv++;
      if (*argv) {
        targeti = *argv++;
      }
    }
  }

  measure_cpucycles();
  measure_randombytes();
  limits();
  measure_verify_897();
  measure_verify_1039();
  measure_verify_1184();
  measure_verify_1349();
  measure_verify_1455();
  measure_verify_1847();
  measure_hashblocks_sha512();
  measure_hash_sha512();
  measure_decode_653x3();
  measure_decode_653x1541();
  measure_decode_653x4621();
  measure_decode_653xint16();
  measure_decode_653xint32();
  measure_decode_761x3();
  measure_decode_761x1531();
  measure_decode_761x4591();
  measure_decode_761xint16();
  measure_decode_761xint32();
  measure_decode_857x3();
  measure_decode_857x1723();
  measure_decode_857x5167();
  measure_decode_857xint16();
  measure_decode_857xint32();
  measure_decode_953x3();
  measure_decode_953x2115();
  measure_decode_953x6343();
  measure_decode_953xint16();
  measure_decode_953xint32();
  measure_decode_1013x3();
  measure_decode_1013x2393();
  measure_decode_1013x7177();
  measure_decode_1013xint16();
  measure_decode_1013xint32();
  measure_decode_1277x3();
  measure_decode_1277x2627();
  measure_decode_1277x7879();
  measure_decode_1277xint16();
  measure_decode_1277xint32();
  measure_decode_int16();
  measure_encode_653x3();
  measure_encode_653x1541();
  measure_encode_653x1541round();
  measure_encode_653x4621();
  measure_encode_653xfreeze3();
  measure_encode_653xint16();
  measure_encode_761x3();
  measure_encode_761x1531();
  measure_encode_761x1531round();
  measure_encode_761x4591();
  measure_encode_761xfreeze3();
  measure_encode_761xint16();
  measure_encode_857x3();
  measure_encode_857x1723();
  measure_encode_857x1723round();
  measure_encode_857x5167();
  measure_encode_857xfreeze3();
  measure_encode_857xint16();
  measure_encode_953x3();
  measure_encode_953x2115();
  measure_encode_953x2115round();
  measure_encode_953x6343();
  measure_encode_953xfreeze3();
  measure_encode_953xint16();
  measure_encode_1013x3();
  measure_encode_1013x2393();
  measure_encode_1013x2393round();
  measure_encode_1013x7177();
  measure_encode_1013xfreeze3();
  measure_encode_1013xint16();
  measure_encode_1277x3();
  measure_encode_1277x2627();
  measure_encode_1277x2627round();
  measure_encode_1277x7879();
  measure_encode_1277xfreeze3();
  measure_encode_1277xint16();
  measure_encode_int16();
  measure_sort_int32();
  measure_sort_uint32();
  measure_core_inv3sntrup653();
  measure_core_inv3sntrup761();
  measure_core_inv3sntrup857();
  measure_core_inv3sntrup953();
  measure_core_inv3sntrup1013();
  measure_core_inv3sntrup1277();
  measure_core_invsntrup653();
  measure_core_invsntrup761();
  measure_core_invsntrup857();
  measure_core_invsntrup953();
  measure_core_invsntrup1013();
  measure_core_invsntrup1277();
  measure_core_mult3sntrup653();
  measure_core_mult3sntrup761();
  measure_core_mult3sntrup857();
  measure_core_mult3sntrup953();
  measure_core_mult3sntrup1013();
  measure_core_mult3sntrup1277();
  measure_core_multsntrup653();
  measure_core_multsntrup761();
  measure_core_multsntrup857();
  measure_core_multsntrup953();
  measure_core_multsntrup1013();
  measure_core_multsntrup1277();
  measure_core_scale3sntrup653();
  measure_core_scale3sntrup761();
  measure_core_scale3sntrup857();
  measure_core_scale3sntrup953();
  measure_core_scale3sntrup1013();
  measure_core_scale3sntrup1277();
  measure_core_weightsntrup653();
  measure_core_weightsntrup761();
  measure_core_weightsntrup857();
  measure_core_weightsntrup953();
  measure_core_weightsntrup1013();
  measure_core_weightsntrup1277();
  measure_core_wforcesntrup653();
  measure_core_wforcesntrup761();
  measure_core_wforcesntrup857();
  measure_core_wforcesntrup953();
  measure_core_wforcesntrup1013();
  measure_core_wforcesntrup1277();
  measure_kem_sntrup653();
  measure_kem_sntrup761();
  measure_kem_sntrup857();
  measure_kem_sntrup953();
  measure_kem_sntrup1013();
  measure_kem_sntrup1277();

  return 0;
}
