/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
package org.apache.jdo.tck.pc.inheritance;

/**
 * @author Michael Bouschen
 *
 * Defines constants used by the inheritance pc classes and the inheritance tck 
 * test cases.   
 */
public class Constants 
{
    //                                           0        1       2       3      4      5        6      7      8       9     10    11
	public static final int[] intA_V =        {   -1,    350,      43,    336,  -447,     1,    337,   10,      43,  -447,   20,    30};
	public static final double[] doubleB_V =  {  2.0,    9.8,    94.5,   -7.2,  -13.,   4.0,   -8.2,  -13,    94.5,   -13,   23,    33};
	public static final int[] intB_V =        {  -5 ,   3334,     -76,     28, 12497,     5,     38,   14,     -76, 12497,   24,    34};
	public static final char[] charC_V =      {  '3',    'D',     'J',    'L',   'N',   'w',    '1',  'x',     'J',   'P',  'y',   'z'};
	public static final boolean[] booleanD_V ={false,   true,    true,   true,  true, false,   true, true,    true,  true, true, false};
	public static final float[] floatE_V =    {-4.4f, -32.7f,  -21.5f, -3266f, -3.6f,  3.0f, -4266f,  12f,  -21.5f, -3.6f,  22f,   32f};
	public static final short[] shortF_V =    { 1238,    258,     394,      8,    21,     6,      9,   15,     394,    21,   25,    35};
	public static final short[] shortG_V =    { -360,  -1000,   -4321,     -6,   -44,     2,     -7,   11,    4321,   -44,   21,    31};
	public static final int[] intH_V =        {   -6,    -25, -347600,   -603, -7613,     7,   -703,   16, -347600, -7613,   26,    36};

}
