#ifndef __FUZZKANA_H__ /* file wrapper */
#define __FUZZKANA_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 *
 * Oct 1993
 *
 * "Fuzzify" a kana string such that using it as a regular expression
 * will result in a search which ignores vowel length and/or small TSUs.
 *
 * For example, the string֤Ȥwould be turned into
 * 	֤[]*[]*
 * if ignoring vowel length, such that֤Ȥand֤Ȥ礦
 * among others) would match in addition to the original֤Ȥ.
 *
 */
extern unsigned fuzzkana(
    const unsigned char *in, /* string to consider */
    unsigned char *out,      /* where to write new string */
    unsigned out_size,       /* size of output buffer */
    unsigned flags);         /* flags are from the list below */

#define FUZZ_LONG_VOWELS   0x01U
#define FUZZ_SMALL_TSU     0x02U
#define FUZZ_VOICED        0x04U
#define FUZZ_REPEATER      0x08U /* not really kana, but easy to add here */
#define FUZZ_ALL           (FUZZ_LONG_VOWELS | FUZZ_SMALL_TSU | FUZZ_VOICED)

/*
 * Returns the number of bytes written to *out if all went well, 0 otherwise
 * (buffer overflow, null input parameters, empty input string).
 * If OUT is null, simply returns the number of bytes that would be required.
 */

#endif /* file wrapper */
