; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i64 @cmpxchg_0(ptr %ptr, i64 %compare, i64 %new_value) {
; CHECK-LABEL: @cmpxchg_0(
; CHECK-NEXT:    [[T0:%.*]] = cmpxchg ptr [[PTR:%.*]], i64 [[COMPARE:%.*]], i64 [[NEW_VALUE:%.*]] seq_cst seq_cst, align 8
; CHECK-NEXT:    [[T2:%.*]] = extractvalue { i64, i1 } [[T0]], 0
; CHECK-NEXT:    ret i64 [[T2]]
;
  %t0 = cmpxchg ptr %ptr, i64 %compare, i64 %new_value seq_cst seq_cst
  %t1 = extractvalue { i64, i1 } %t0, 1
  %t2 = extractvalue { i64, i1 } %t0, 0
  %t3 = select i1 %t1, i64 %compare, i64 %t2
  ret i64 %t3
}

define i64 @cmpxchg_1(ptr %ptr, i64 %compare, i64 %new_value) {
; CHECK-LABEL: @cmpxchg_1(
; CHECK-NEXT:    [[T0:%.*]] = cmpxchg ptr [[PTR:%.*]], i64 [[COMPARE:%.*]], i64 [[NEW_VALUE:%.*]] seq_cst seq_cst, align 8
; CHECK-NEXT:    ret i64 [[COMPARE]]
;
  %t0 = cmpxchg ptr %ptr, i64 %compare, i64 %new_value seq_cst seq_cst
  %t1 = extractvalue { i64, i1 } %t0, 1
  %t2 = extractvalue { i64, i1 } %t0, 0
  %t3 = select i1 %t1, i64 %t2, i64 %compare
  ret i64 %t3
}

define i64 @cmpxchg_2(ptr %ptr, i64 %compare, i64 %new_value) {
; CHECK-LABEL: @cmpxchg_2(
; CHECK-NEXT:    [[T0:%.*]] = cmpxchg ptr [[PTR:%.*]], i64 [[COMPARE:%.*]], i64 [[NEW_VALUE:%.*]] acq_rel monotonic, align 8
; CHECK-NEXT:    ret i64 [[COMPARE]]
;
  %t0 = cmpxchg ptr %ptr, i64 %compare, i64 %new_value acq_rel monotonic
  %t1 = extractvalue { i64, i1 } %t0, 1
  %t2 = extractvalue { i64, i1 } %t0, 0
  %t3 = select i1 %t1, i64 %compare, i64 %t2
  %t4 = select i1 %t1, i64 %t3, i64 %compare
  ret i64 %t4
}
