; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -loop-reduce < %s | FileCheck %s

; Test an assertion failure from D113349, where the SCEV for the outer phi
; gets computed and registered in the value map while attempting to compute it.

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define void @test() {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[LSR_IV:%.*]] = phi ptr [ [[SCEVGEP:%.*]], [[LOOP_LATCH:%.*]] ], [ inttoptr (i64 -8 to ptr), [[ENTRY:%.*]] ]
; CHECK-NEXT:    br i1 true, label [[LOOP_EXIT:%.*]], label [[LOOP2_PREHEADER:%.*]]
; CHECK:       loop.exit:
; CHECK-NEXT:    ret void
; CHECK:       loop2.preheader:
; CHECK-NEXT:    br label [[LOOP2_HEADER:%.*]]
; CHECK:       loop2.header:
; CHECK-NEXT:    [[LSR_IV1:%.*]] = phi ptr [ [[SCEVGEP2:%.*]], [[LOOP2_HEADER]] ], [ [[LSR_IV]], [[LOOP2_PREHEADER]] ]
; CHECK-NEXT:    [[SCEVGEP2]] = getelementptr i8, ptr [[LSR_IV1]], i64 8
; CHECK-NEXT:    br i1 false, label [[LOOP2_HEADER]], label [[LOOP2_CONT:%.*]]
; CHECK:       loop2.cont:
; CHECK-NEXT:    [[V:%.*]] = load i8, ptr [[SCEVGEP2]], align 1
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[V]], 0
; CHECK-NEXT:    br i1 [[C]], label [[LOOP_EXIT]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[SCEVGEP]] = getelementptr i8, ptr [[LSR_IV]], i64 8
; CHECK-NEXT:    br label [[LOOP_HEADER]]
;
entry:
  br label %loop.header

loop.header:
  %ptr = phi ptr [ %ptr.next, %loop.latch ], [ null, %entry ]
  br i1 true, label %loop.exit, label %loop2.preheader

loop.exit:
  ret void

loop2.preheader:
  br label %loop2.header

loop2.header:
  %ptr2 = phi ptr [ %ptr, %loop2.preheader ], [ %ptr2.next, %loop2.header ]
  %ptr2.next = getelementptr inbounds i64, ptr %ptr2, i64 1
  br i1 false, label %loop2.header, label %loop2.cont

loop2.cont:
  %v = load i8, ptr %ptr2
  %c = icmp ne i8 %v, 0
  br i1 %c, label %loop.exit, label %loop.latch

loop.latch:
  %ptr.next = getelementptr inbounds i64, ptr %ptr, i64 1
  br label %loop.header
}
