from typing import Any, ClassVar, Dict, Iterable, Iterator, List, Set

from typing import overload
import lief # type: ignore
import lief.ELF # type: ignore

class ARCH:
    __members__: ClassVar[dict] = ...  # read-only
    AARCH64: ClassVar[ARCH] = ...
    ALPHA: ClassVar[ARCH] = ...
    ALTERA_NIOS2: ClassVar[ARCH] = ...
    AMDGPU: ClassVar[ARCH] = ...
    ARC: ClassVar[ARCH] = ...
    ARCA: ClassVar[ARCH] = ...
    ARCH_56800EX: ClassVar[ARCH] = ...
    ARCH_68HC05: ClassVar[ARCH] = ...
    ARCH_68HC08: ClassVar[ARCH] = ...
    ARCH_68HC11: ClassVar[ARCH] = ...
    ARCH_68HC12: ClassVar[ARCH] = ...
    ARCH_68HC16: ClassVar[ARCH] = ...
    ARCH_68K: ClassVar[ARCH] = ...
    ARCH_78KOR: ClassVar[ARCH] = ...
    ARCH_8051: ClassVar[ARCH] = ...
    ARCH_860: ClassVar[ARCH] = ...
    ARCH_88K: ClassVar[ARCH] = ...
    ARCH_960: ClassVar[ARCH] = ...
    ARC_COMPACT: ClassVar[ARCH] = ...
    ARC_COMPACT2: ClassVar[ARCH] = ...
    ARM: ClassVar[ARCH] = ...
    AVR: ClassVar[ARCH] = ...
    AVR32: ClassVar[ARCH] = ...
    BA1: ClassVar[ARCH] = ...
    BA2: ClassVar[ARCH] = ...
    BLACKFIN: ClassVar[ARCH] = ...
    BPF: ClassVar[ARCH] = ...
    C166: ClassVar[ARCH] = ...
    CDP: ClassVar[ARCH] = ...
    CE: ClassVar[ARCH] = ...
    CLOUDSHIELD: ClassVar[ARCH] = ...
    COGE: ClassVar[ARCH] = ...
    COLDFIRE: ClassVar[ARCH] = ...
    COOL: ClassVar[ARCH] = ...
    COREA_1ST: ClassVar[ARCH] = ...
    COREA_2ND: ClassVar[ARCH] = ...
    CR: ClassVar[ARCH] = ...
    CR16: ClassVar[ARCH] = ...
    CRAYNV2: ClassVar[ARCH] = ...
    CRIS: ClassVar[ARCH] = ...
    CRX: ClassVar[ARCH] = ...
    CSR_KALIMBA: ClassVar[ARCH] = ...
    CUDA: ClassVar[ARCH] = ...
    CYPRESS_M8C: ClassVar[ARCH] = ...
    D10V: ClassVar[ARCH] = ...
    D30V: ClassVar[ARCH] = ...
    DSP24: ClassVar[ARCH] = ...
    DSPIC30F: ClassVar[ARCH] = ...
    DXP: ClassVar[ARCH] = ...
    ECOG1: ClassVar[ARCH] = ...
    ECOG16: ClassVar[ARCH] = ...
    ECOG1X: ClassVar[ARCH] = ...
    ECOG2: ClassVar[ARCH] = ...
    ETPU: ClassVar[ARCH] = ...
    EXCESS: ClassVar[ARCH] = ...
    F2MC16: ClassVar[ARCH] = ...
    FIREPATH: ClassVar[ARCH] = ...
    FR20: ClassVar[ARCH] = ...
    FR30: ClassVar[ARCH] = ...
    FX66: ClassVar[ARCH] = ...
    H8S: ClassVar[ARCH] = ...
    H8_300: ClassVar[ARCH] = ...
    H8_300H: ClassVar[ARCH] = ...
    H8_500: ClassVar[ARCH] = ...
    HEXAGON: ClassVar[ARCH] = ...
    HUANY: ClassVar[ARCH] = ...
    IAMCU: ClassVar[ARCH] = ...
    IA_64: ClassVar[ARCH] = ...
    INTEL205: ClassVar[ARCH] = ...
    INTEL206: ClassVar[ARCH] = ...
    INTEL207: ClassVar[ARCH] = ...
    INTEL208: ClassVar[ARCH] = ...
    INTEL209: ClassVar[ARCH] = ...
    IP2K: ClassVar[ARCH] = ...
    JAVELIN: ClassVar[ARCH] = ...
    K10M: ClassVar[ARCH] = ...
    KM32: ClassVar[ARCH] = ...
    KMX16: ClassVar[ARCH] = ...
    KMX32: ClassVar[ARCH] = ...
    KMX8: ClassVar[ARCH] = ...
    KVARC: ClassVar[ARCH] = ...
    L10M: ClassVar[ARCH] = ...
    LATTICEMICO32: ClassVar[ARCH] = ...
    M16C: ClassVar[ARCH] = ...
    M32: ClassVar[ARCH] = ...
    M32C: ClassVar[ARCH] = ...
    M32R: ClassVar[ARCH] = ...
    MANIK: ClassVar[ARCH] = ...
    MAX: ClassVar[ARCH] = ...
    MAXQ30: ClassVar[ARCH] = ...
    MCHP_PIC: ClassVar[ARCH] = ...
    MCST_ELBRUS: ClassVar[ARCH] = ...
    ME16: ClassVar[ARCH] = ...
    METAG: ClassVar[ARCH] = ...
    MIPS: ClassVar[ARCH] = ...
    MIPS_RS3_LE: ClassVar[ARCH] = ...
    MIPS_X: ClassVar[ARCH] = ...
    MMA: ClassVar[ARCH] = ...
    MMDSP_PLUS: ClassVar[ARCH] = ...
    MMIX: ClassVar[ARCH] = ...
    MN10200: ClassVar[ARCH] = ...
    MN10300: ClassVar[ARCH] = ...
    MSP430: ClassVar[ARCH] = ...
    NCPU: ClassVar[ARCH] = ...
    NDR1: ClassVar[ARCH] = ...
    NDS32: ClassVar[ARCH] = ...
    NONE: ClassVar[ARCH] = ...
    NORC: ClassVar[ARCH] = ...
    NS32K: ClassVar[ARCH] = ...
    OPEN8: ClassVar[ARCH] = ...
    OPENRISC: ClassVar[ARCH] = ...
    PARISC: ClassVar[ARCH] = ...
    PCP: ClassVar[ARCH] = ...
    PDP10: ClassVar[ARCH] = ...
    PDP11: ClassVar[ARCH] = ...
    PDSP: ClassVar[ARCH] = ...
    PJ: ClassVar[ARCH] = ...
    PPC: ClassVar[ARCH] = ...
    PPC64: ClassVar[ARCH] = ...
    PRISM: ClassVar[ARCH] = ...
    R32C: ClassVar[ARCH] = ...
    RCE: ClassVar[ARCH] = ...
    RH32: ClassVar[ARCH] = ...
    RISCV: ClassVar[ARCH] = ...
    RL78: ClassVar[ARCH] = ...
    RS08: ClassVar[ARCH] = ...
    RX: ClassVar[ARCH] = ...
    S370: ClassVar[ARCH] = ...
    S390: ClassVar[ARCH] = ...
    SCORE7: ClassVar[ARCH] = ...
    SEP: ClassVar[ARCH] = ...
    SE_C17: ClassVar[ARCH] = ...
    SE_C33: ClassVar[ARCH] = ...
    SH: ClassVar[ARCH] = ...
    SHARC: ClassVar[ARCH] = ...
    SLE9X: ClassVar[ARCH] = ...
    SNP1K: ClassVar[ARCH] = ...
    SPARC: ClassVar[ARCH] = ...
    SPARC32PLUS: ClassVar[ARCH] = ...
    SPARCV9: ClassVar[ARCH] = ...
    SPU: ClassVar[ARCH] = ...
    ST100: ClassVar[ARCH] = ...
    ST19: ClassVar[ARCH] = ...
    ST200: ClassVar[ARCH] = ...
    ST7: ClassVar[ARCH] = ...
    ST9PLUS: ClassVar[ARCH] = ...
    STARCORE: ClassVar[ARCH] = ...
    STM8: ClassVar[ARCH] = ...
    STXP7X: ClassVar[ARCH] = ...
    SVX: ClassVar[ARCH] = ...
    TILE64: ClassVar[ARCH] = ...
    TILEGX: ClassVar[ARCH] = ...
    TILEPRO: ClassVar[ARCH] = ...
    TINYJ: ClassVar[ARCH] = ...
    TI_C2000: ClassVar[ARCH] = ...
    TI_C5500: ClassVar[ARCH] = ...
    TI_C6000: ClassVar[ARCH] = ...
    TMM_GPP: ClassVar[ARCH] = ...
    TPC: ClassVar[ARCH] = ...
    TRICORE: ClassVar[ARCH] = ...
    TRIMEDIA: ClassVar[ARCH] = ...
    TSK3000: ClassVar[ARCH] = ...
    UNICORE: ClassVar[ARCH] = ...
    V800: ClassVar[ARCH] = ...
    V850: ClassVar[ARCH] = ...
    VAX: ClassVar[ARCH] = ...
    VIDEOCORE: ClassVar[ARCH] = ...
    VIDEOCORE3: ClassVar[ARCH] = ...
    VIDEOCORE5: ClassVar[ARCH] = ...
    VPP500: ClassVar[ARCH] = ...
    XCORE: ClassVar[ARCH] = ...
    XGATE: ClassVar[ARCH] = ...
    XIMO16: ClassVar[ARCH] = ...
    XTENSA: ClassVar[ARCH] = ...
    ZSP: ClassVar[ARCH] = ...
    __entries: ClassVar[dict] = ...
    i386: ClassVar[ARCH] = ...
    x86_64: ClassVar[ARCH] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ARM_EFLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    EABI_VER1: ClassVar[ARM_EFLAGS] = ...
    EABI_VER2: ClassVar[ARM_EFLAGS] = ...
    EABI_VER3: ClassVar[ARM_EFLAGS] = ...
    EABI_VER4: ClassVar[ARM_EFLAGS] = ...
    EABI_VER5: ClassVar[ARM_EFLAGS] = ...
    SOFT_FLOAT: ClassVar[ARM_EFLAGS] = ...
    UNKNOWN: ClassVar[ARM_EFLAGS] = ...
    VFP_FLOAT: ClassVar[ARM_EFLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class AndroidNote(NoteDetails):
    ndk_build_number: str
    ndk_version: str
    sdk_version: int
    def __init__(self, *args, **kwargs) -> None: ...

class Binary(lief.Binary):
    class PHDR_RELOC:
        __members__: ClassVar[dict] = ...  # read-only
        AUTO: ClassVar[Binary.PHDR_RELOC] = ...
        BSS_END: ClassVar[Binary.PHDR_RELOC] = ...
        FILE_END: ClassVar[Binary.PHDR_RELOC] = ...
        PIE_SHIFT: ClassVar[Binary.PHDR_RELOC] = ...
        SEGMENT_GAP: ClassVar[Binary.PHDR_RELOC] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class it_dyn_static_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Symbol: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Symbol: ...

    class it_dynamic_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.DynamicEntry: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.DynamicEntry: ...

    class it_filter_relocation:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Relocation: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Relocation: ...

    class it_filter_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Symbol: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Symbol: ...

    class it_notes:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Note: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Note: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Relocation: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Relocation: ...

    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Section: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Section: ...

    class it_segments:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Segment: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Segment: ...

    class it_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Symbol: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Symbol: ...

    class it_symbols_version:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.SymbolVersion: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersion: ...

    class it_symbols_version_definition:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.SymbolVersionDefinition: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersionDefinition: ...

    class it_symbols_version_requirement:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.SymbolVersionRequirement: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersionRequirement: ...
    interpreter: Any
    overlay: List[int]
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def add(self, arg0: lief.ELF.DynamicEntry) -> lief.ELF.DynamicEntry: ...
    @overload
    def add(self, section: lief.ELF.Section, loaded: bool = ...) -> lief.ELF.Section: ...
    @overload
    def add(self, Addanew, base: int = ...) -> lief.ELF.Segment: ...
    @overload
    def add(self, note: lief.ELF.Note) -> lief.ELF.Note: ...
    def add_dynamic_relocation(self, relocation: lief.ELF.Relocation) -> lief.ELF.Relocation: ...
    def add_dynamic_symbol(self, symbol: lief.ELF.Symbol, symbol_version: lief.ELF.SymbolVersion = ...) -> lief.ELF.Symbol: ...
    def add_exported_function(self, address: int, name: str = ...) -> lief.ELF.Symbol: ...
    def add_library(self, library_name: str) -> lief.ELF.DynamicEntryLibrary: ...
    def add_object_relocation(self, relocation: lief.ELF.Relocation, section: lief.ELF.Section) -> lief.ELF.Relocation: ...
    def add_pltgot_relocation(self, relocation: lief.ELF.Relocation) -> lief.ELF.Relocation: ...
    def add_static_symbol(self, symbol: lief.ELF.Symbol) -> lief.ELF.Symbol: ...
    @overload
    def export_symbol(self, symbol: lief.ELF.Symbol) -> lief.ELF.Symbol: ...
    @overload
    def export_symbol(self, symbol_name: str, value: int = ...) -> lief.ELF.Symbol: ...
    @overload
    def extend(self, segment: lief.ELF.Segment, size: int) -> lief.ELF.Segment: ...
    @overload
    def extend(self, segment: lief.ELF.Section, size: int) -> lief.ELF.Section: ...
    @overload
    def get(self, tag: lief.ELF.DYNAMIC_TAGS) -> lief.ELF.DynamicEntry: ...
    @overload
    def get(self, type: lief.ELF.SEGMENT_TYPES) -> lief.ELF.Segment: ...
    @overload
    def get(self, type: lief.ELF.NOTE_TYPES) -> lief.ELF.Note: ...
    @overload
    def get(self, type: lief.ELF.SECTION_TYPES) -> lief.ELF.Section: ...
    def get_dynamic_symbol(self, symbol_name: str) -> lief.ELF.Symbol: ...
    def get_library(self, library_name: str) -> lief.ELF.DynamicEntryLibrary: ...
    @overload
    def get_relocation(self, symbol_name: str) -> lief.ELF.Relocation: ...
    @overload
    def get_relocation(self, symbol: lief.ELF.Symbol) -> lief.ELF.Relocation: ...
    @overload
    def get_relocation(self, address: int) -> lief.ELF.Relocation: ...
    def get_section(self, section_name: str) -> lief.ELF.Section: ...
    def get_static_symbol(self, symbol_name: str) -> lief.ELF.Symbol: ...
    def get_strings(self, min_size: int = ...) -> List[str]: ...
    @overload
    def has(self, tag: lief.ELF.DYNAMIC_TAGS) -> bool: ...
    @overload
    def has(self, type: lief.ELF.SEGMENT_TYPES) -> bool: ...
    @overload
    def has(self, type: lief.ELF.NOTE_TYPES) -> bool: ...
    @overload
    def has(self, type: lief.ELF.SECTION_TYPES) -> bool: ...
    def has_dynamic_symbol(self, symbol_name: str) -> bool: ...
    def has_library(self, library_name: str) -> bool: ...
    def has_section(self, section_name: str) -> bool: ...
    def has_section_with_offset(self, offset: int) -> bool: ...
    def has_section_with_va(self, virtual_address: int) -> bool: ...
    def has_static_symbol(self, symbol_name: str) -> bool: ...
    @overload
    def patch_pltgot(self, symbol_name: str, address: int) -> None: ...
    @overload
    def patch_pltgot(self, symbol: lief.ELF.Symbol, address: int) -> None: ...
    def permute_dynamic_symbols(self, permutation: List[int]) -> None: ...
    def relocate_phdr_table(self, type: lief.ELF.Binary.PHDR_RELOC = ...) -> int: ...
    @overload
    def remove(self, dynamic_entry: lief.ELF.DynamicEntry) -> None: ...
    @overload
    def remove(self, tag: lief.ELF.DYNAMIC_TAGS) -> None: ...
    @overload
    def remove(self, section: lief.ELF.Section, clear: bool = ...) -> None: ...
    @overload
    def remove(self, note: lief.ELF.Note) -> None: ...
    @overload
    def remove(self, type: lief.ELF.NOTE_TYPES) -> None: ...
    @overload
    def remove_dynamic_symbol(self, arg0: lief.ELF.Symbol) -> None: ...
    @overload
    def remove_dynamic_symbol(self, arg0: str) -> None: ...
    def remove_library(self, library_name: str) -> None: ...
    def remove_static_symbol(self, arg0: lief.ELF.Symbol) -> None: ...
    def replace(self, new_segment: lief.ELF.Segment, original_segment: lief.ELF.Segment, base: int = ...) -> lief.ELF.Segment: ...
    def section_from_offset(self, offset: int, skip_nobits: bool = ...) -> lief.ELF.Section: ...
    def section_from_virtual_address(self, address: int, skip_nobits: bool = ...) -> lief.ELF.Section: ...
    def segment_from_offset(self, offset: int) -> lief.ELF.Segment: ...
    def segment_from_virtual_address(self, address: int) -> lief.ELF.Segment: ...
    def strip(self) -> None: ...
    def virtual_address_to_offset(self, virtual_address: int) -> object: ...
    @overload
    def write(self, output: str) -> None: ...
    @overload
    def write(self, output: str, config: lief.ELF.Builder.config_t) -> None: ...
    @overload
    def __contains__(self, arg0: lief.ELF.SEGMENT_TYPES) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.DYNAMIC_TAGS) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.NOTE_TYPES) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.SECTION_TYPES) -> bool: ...
    @overload
    def __getitem__(self, arg0: lief.ELF.SEGMENT_TYPES) -> lief.ELF.Segment: ...
    @overload
    def __getitem__(self, arg0: lief.ELF.NOTE_TYPES) -> lief.ELF.Note: ...
    @overload
    def __getitem__(self, arg0: lief.ELF.DYNAMIC_TAGS) -> lief.ELF.DynamicEntry: ...
    @overload
    def __getitem__(self, arg0: lief.ELF.SECTION_TYPES) -> lief.ELF.Section: ...
    @overload
    def __iadd__(self, arg0: lief.ELF.Segment) -> lief.ELF.Binary: ...
    @overload
    def __iadd__(self, arg0: lief.ELF.Section) -> lief.ELF.Binary: ...
    @overload
    def __iadd__(self, arg0: lief.ELF.DynamicEntry) -> lief.ELF.Binary: ...
    @overload
    def __iadd__(self, arg0: lief.ELF.Note) -> lief.ELF.Binary: ...
    @overload
    def __isub__(self, arg0: lief.ELF.DynamicEntry) -> lief.ELF.Binary: ...
    @overload
    def __isub__(self, arg0: lief.ELF.DYNAMIC_TAGS) -> lief.ELF.Binary: ...
    @overload
    def __isub__(self, arg0: lief.ELF.Note) -> lief.ELF.Binary: ...
    @overload
    def __isub__(self, arg0: lief.ELF.NOTE_TYPES) -> lief.ELF.Binary: ...
    @property
    def dtor_functions(self) -> List[lief.Function]: ...
    @property
    def dynamic_entries(self) -> lief.ELF.Binary.it_dynamic_entries: ...
    @property
    def dynamic_relocations(self) -> lief.ELF.Binary.it_filter_relocation: ...
    @property
    def dynamic_symbols(self) -> lief.ELF.Binary.it_symbols: ...
    @property
    def eof_offset(self) -> int: ...
    @property
    def exported_symbols(self) -> lief.ELF.Binary.it_filter_symbols: ...
    @property
    def functions(self) -> List[lief.Function]: ...
    @property
    def gnu_hash(self) -> lief.ELF.GnuHash: ...
    @property
    def has_interpreter(self) -> bool: ...
    @property
    def has_notes(self) -> bool: ...
    @property
    def has_overlay(self) -> bool: ...
    @property
    def header(self) -> lief.ELF.Header: ...
    @property
    def imagebase(self) -> int: ...
    @property
    def imported_symbols(self) -> lief.ELF.Binary.it_filter_symbols: ...
    @property
    def is_pie(self) -> bool: ...
    @property
    def last_offset_section(self) -> int: ...
    @property
    def last_offset_segment(self) -> int: ...
    @property
    def next_virtual_address(self) -> int: ...
    @property
    def notes(self) -> lief.ELF.Binary.it_notes: ...
    @property
    def object_relocations(self) -> lief.ELF.Binary.it_filter_relocation: ...
    @property
    def pltgot_relocations(self) -> lief.ELF.Binary.it_filter_relocation: ...
    @property
    def relocations(self) -> lief.ELF.Binary.it_relocations: ...
    @property
    def sections(self) -> lief.ELF.Binary.it_sections: ...
    @property
    def segments(self) -> lief.ELF.Binary.it_segments: ...
    @property
    def static_symbols(self) -> lief.ELF.Binary.it_symbols: ...
    @property
    def strings(self) -> List[str]: ...
    @property
    def symbols(self) -> lief.ELF.Binary.it_dyn_static_symbols: ...
    @property
    def symbols_version(self) -> lief.ELF.Binary.it_symbols_version: ...
    @property
    def symbols_version_definition(self) -> lief.ELF.Binary.it_symbols_version_definition: ...
    @property
    def symbols_version_requirement(self) -> lief.ELF.Binary.it_symbols_version_requirement: ...
    @property
    def sysv_hash(self) -> lief.ELF.SysvHash: ...
    @property
    def type(self) -> lief.ELF.ELF_CLASS: ...
    @property
    def use_gnu_hash(self) -> bool: ...
    @property
    def use_sysv_hash(self) -> bool: ...
    @property
    def virtual_size(self) -> int: ...

class Builder:
    class config_t:
        dt_hash: bool
        dyn_str: bool
        dynamic_section: bool
        fini_array: bool
        force_relocate: bool
        init_array: bool
        interpreter: bool
        jmprel: bool
        notes: bool
        preinit_array: bool
        rela: bool
        static_symtab: bool
        sym_verdef: bool
        sym_verneed: bool
        sym_versym: bool
        symtab: bool
        def __init__(self) -> None: ...
    config: lief.ELF.Builder.config_t
    def __init__(self, elf_binary: lief.ELF.Binary) -> None: ...
    def build(self) -> None: ...
    def get_build(self) -> List[int]: ...
    def write(self, output: str) -> None: ...

class CoreAuxv(NoteDetails):
    class TYPES:
        __members__: ClassVar[dict] = ...  # read-only
        BASE: ClassVar[CoreAuxv.TYPES] = ...
        BASE_PLATFORM: ClassVar[CoreAuxv.TYPES] = ...
        CKLTCK: ClassVar[CoreAuxv.TYPES] = ...
        DCACHEBSIZE: ClassVar[CoreAuxv.TYPES] = ...
        EGID: ClassVar[CoreAuxv.TYPES] = ...
        ENTRY: ClassVar[CoreAuxv.TYPES] = ...
        EUID: ClassVar[CoreAuxv.TYPES] = ...
        EXECFD: ClassVar[CoreAuxv.TYPES] = ...
        EXECFN: ClassVar[CoreAuxv.TYPES] = ...
        FLAGS: ClassVar[CoreAuxv.TYPES] = ...
        FPUCW: ClassVar[CoreAuxv.TYPES] = ...
        GID: ClassVar[CoreAuxv.TYPES] = ...
        HWCAP: ClassVar[CoreAuxv.TYPES] = ...
        HWCAP2: ClassVar[CoreAuxv.TYPES] = ...
        ICACHEBSIZE: ClassVar[CoreAuxv.TYPES] = ...
        IGNORE: ClassVar[CoreAuxv.TYPES] = ...
        IGNOREPPC: ClassVar[CoreAuxv.TYPES] = ...
        L1D_CACHESHAPE: ClassVar[CoreAuxv.TYPES] = ...
        L1I_CACHESHAPE: ClassVar[CoreAuxv.TYPES] = ...
        NOTELF: ClassVar[CoreAuxv.TYPES] = ...
        NULL: ClassVar[CoreAuxv.TYPES] = ...
        PAGESZ: ClassVar[CoreAuxv.TYPES] = ...
        PHDR: ClassVar[CoreAuxv.TYPES] = ...
        PHENT: ClassVar[CoreAuxv.TYPES] = ...
        PHNUM: ClassVar[CoreAuxv.TYPES] = ...
        PLATFORM: ClassVar[CoreAuxv.TYPES] = ...
        RANDOM: ClassVar[CoreAuxv.TYPES] = ...
        SECURE: ClassVar[CoreAuxv.TYPES] = ...
        SYSINFO: ClassVar[CoreAuxv.TYPES] = ...
        SYSINFO_EHDR: ClassVar[CoreAuxv.TYPES] = ...
        UCACHEBSIZE: ClassVar[CoreAuxv.TYPES] = ...
        UID: ClassVar[CoreAuxv.TYPES] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    values: Dict[lief.ELF.CoreAuxv.TYPES,int]
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self, type: lief.ELF.CoreAuxv.TYPES) -> object: ...
    def has(self, type: lief.ELF.CoreAuxv.TYPES) -> bool: ...
    def set(self, type: lief.ELF.CoreAuxv.TYPES, value: int) -> bool: ...
    def __contains__(self, arg0: lief.ELF.CoreAuxv.TYPES) -> bool: ...
    def __getitem__(self, arg0: lief.ELF.CoreAuxv.TYPES) -> int: ...
    def __setitem__(self, arg0: lief.ELF.CoreAuxv.TYPES, arg1: int) -> None: ...

class CoreFile(NoteDetails):
    class files_t:
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg0: lief.ELF.CoreFile.files_t) -> None: ...
        @overload
        def __init__(self, arg0: Iterable) -> None: ...
        def append(self, x: lief.ELF.CoreFileEntry) -> None: ...
        def clear(self) -> None: ...
        @overload
        def extend(self, L: lief.ELF.CoreFile.files_t) -> None: ...
        @overload
        def extend(self, L: Iterable) -> None: ...
        def insert(self, i: int, x: lief.ELF.CoreFileEntry) -> None: ...
        @overload
        def pop(self) -> lief.ELF.CoreFileEntry: ...
        @overload
        def pop(self, i: int) -> lief.ELF.CoreFileEntry: ...
        def __bool__(self) -> bool: ...
        @overload
        def __delitem__(self, arg0: int) -> None: ...
        @overload
        def __delitem__(self, arg0: slice) -> None: ...
        @overload
        def __getitem__(self, s: slice) -> lief.ELF.CoreFile.files_t: ...
        @overload
        def __getitem__(self, arg0: int) -> lief.ELF.CoreFileEntry: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        @overload
        def __setitem__(self, arg0: int, arg1: lief.ELF.CoreFileEntry) -> None: ...
        @overload
        def __setitem__(self, arg0: slice, arg1: lief.ELF.CoreFile.files_t) -> None: ...
    files: lief.ELF.CoreFile.files_t
    def __init__(self, *args, **kwargs) -> None: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...

class CoreFileEntry:
    end: int
    file_ofs: int
    path: str
    start: int
    def __init__(self, *args, **kwargs) -> None: ...

class CorePrPsInfo(NoteDetails):
    file_name: str
    flags: int
    gid: int
    pgrp: int
    pid: int
    ppid: int
    sid: int
    uid: int
    def __init__(self, *args, **kwargs) -> None: ...

class CorePrStatus(NoteDetails):
    class REGISTERS:
        __members__: ClassVar[dict] = ...  # read-only
        AARCH64_PC: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X0: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X1: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X10: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X11: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X12: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X13: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X14: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X15: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X16: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X17: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X18: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X19: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X2: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X20: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X21: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X22: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X23: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X24: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X25: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X26: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X27: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X28: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X29: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X3: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X30: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X31: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X4: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X5: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X6: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X7: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X8: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64_X9: ClassVar[CorePrStatus.REGISTERS] = ...
        AARCH64__: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_CPSR: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R0: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R1: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R10: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R11: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R12: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R13: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R14: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R15: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R2: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R3: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R4: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R5: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R6: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R7: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R8: ClassVar[CorePrStatus.REGISTERS] = ...
        ARM_R9: ClassVar[CorePrStatus.REGISTERS] = ...
        UNKNOWN: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_CS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_EFLAGS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_R10: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_R11: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_R12: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_R13: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_R14: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_R15: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_R8: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_R9: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RAX: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RBP: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RBX: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RCX: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RDI: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RDX: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RIP: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RSI: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_RSP: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64_SS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_64__: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_CS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_DS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_EAX: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_EBP: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_EBX: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_ECX: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_EDI: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_EDX: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_EFLAGS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_EIP: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_ES: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_ESI: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_ESP: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_FS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_GS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86_SS: ClassVar[CorePrStatus.REGISTERS] = ...
        X86__: ClassVar[CorePrStatus.REGISTERS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class siginfo_t:
        errno: int
        sicode: int
        signo: int
        def __init__(self, *args, **kwargs) -> None: ...

    class timeval:
        sec: int
        usec: int
        def __init__(self, *args, **kwargs) -> None: ...
    cstime: lief.ELF.CorePrStatus.timeval
    current_sig: int
    cutime: lief.ELF.CorePrStatus.timeval
    pgrp: int
    pid: int
    ppid: int
    register_context: Any
    sid: int
    sighold: int
    siginfo: lief.ELF.CorePrStatus.siginfo_t
    sigpend: int
    stime: lief.ELF.CorePrStatus.timeval
    utime: lief.ELF.CorePrStatus.timeval
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self, register: lief.ELF.CorePrStatus.REGISTERS) -> object: ...
    def has(self, register: lief.ELF.CorePrStatus.REGISTERS) -> bool: ...
    def set(self, register: lief.ELF.CorePrStatus.REGISTERS, value: int) -> bool: ...
    def __contains__(self, arg0: lief.ELF.CorePrStatus.REGISTERS) -> bool: ...
    def __getitem__(self, arg0: lief.ELF.CorePrStatus.REGISTERS) -> int: ...
    def __setitem__(self, arg0: lief.ELF.CorePrStatus.REGISTERS, arg1: int) -> None: ...

class CoreSigInfo(NoteDetails):
    sigcode: int
    sigerrno: int
    signo: int
    def __init__(self, *args, **kwargs) -> None: ...

class DYNAMIC_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    BIND_NOW: ClassVar[DYNAMIC_FLAGS] = ...
    ORIGIN: ClassVar[DYNAMIC_FLAGS] = ...
    STATIC_TLS: ClassVar[DYNAMIC_FLAGS] = ...
    SYMBOLIC: ClassVar[DYNAMIC_FLAGS] = ...
    TEXTREL: ClassVar[DYNAMIC_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DYNAMIC_FLAGS_1:
    __members__: ClassVar[dict] = ...  # read-only
    CONFALT: ClassVar[DYNAMIC_FLAGS_1] = ...
    DIRECT: ClassVar[DYNAMIC_FLAGS_1] = ...
    DISPRELDNE: ClassVar[DYNAMIC_FLAGS_1] = ...
    DISPRELPND: ClassVar[DYNAMIC_FLAGS_1] = ...
    EDITED: ClassVar[DYNAMIC_FLAGS_1] = ...
    ENDFILTEE: ClassVar[DYNAMIC_FLAGS_1] = ...
    GLOBAL: ClassVar[DYNAMIC_FLAGS_1] = ...
    GLOBAUDIT: ClassVar[DYNAMIC_FLAGS_1] = ...
    GROUP: ClassVar[DYNAMIC_FLAGS_1] = ...
    IGNMULDEF: ClassVar[DYNAMIC_FLAGS_1] = ...
    INITFIRST: ClassVar[DYNAMIC_FLAGS_1] = ...
    INTERPOSE: ClassVar[DYNAMIC_FLAGS_1] = ...
    LOADFLTR: ClassVar[DYNAMIC_FLAGS_1] = ...
    NODEFLIB: ClassVar[DYNAMIC_FLAGS_1] = ...
    NODELETE: ClassVar[DYNAMIC_FLAGS_1] = ...
    NODIRECT: ClassVar[DYNAMIC_FLAGS_1] = ...
    NODUMP: ClassVar[DYNAMIC_FLAGS_1] = ...
    NOHDR: ClassVar[DYNAMIC_FLAGS_1] = ...
    NOKSYMS: ClassVar[DYNAMIC_FLAGS_1] = ...
    NOOPEN: ClassVar[DYNAMIC_FLAGS_1] = ...
    NORELOC: ClassVar[DYNAMIC_FLAGS_1] = ...
    NOW: ClassVar[DYNAMIC_FLAGS_1] = ...
    ORIGIN: ClassVar[DYNAMIC_FLAGS_1] = ...
    PIE: ClassVar[DYNAMIC_FLAGS_1] = ...
    SINGLETON: ClassVar[DYNAMIC_FLAGS_1] = ...
    SYMINTPOSE: ClassVar[DYNAMIC_FLAGS_1] = ...
    TRANS: ClassVar[DYNAMIC_FLAGS_1] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DYNAMIC_TAGS:
    __members__: ClassVar[dict] = ...  # read-only
    ANDROID_REL: ClassVar[DYNAMIC_TAGS] = ...
    ANDROID_RELA: ClassVar[DYNAMIC_TAGS] = ...
    ANDROID_RELASZ: ClassVar[DYNAMIC_TAGS] = ...
    ANDROID_RELSZ: ClassVar[DYNAMIC_TAGS] = ...
    ANDROID_REL_OFFSET: ClassVar[DYNAMIC_TAGS] = ...
    ANDROID_REL_SIZE: ClassVar[DYNAMIC_TAGS] = ...
    BIND_NOW: ClassVar[DYNAMIC_TAGS] = ...
    DEBUG: ClassVar[DYNAMIC_TAGS] = ...
    FINI: ClassVar[DYNAMIC_TAGS] = ...
    FINI_ARRAY: ClassVar[DYNAMIC_TAGS] = ...
    FINI_ARRAYSZ: ClassVar[DYNAMIC_TAGS] = ...
    FLAGS: ClassVar[DYNAMIC_TAGS] = ...
    FLAGS_1: ClassVar[DYNAMIC_TAGS] = ...
    GNU_HASH: ClassVar[DYNAMIC_TAGS] = ...
    HASH: ClassVar[DYNAMIC_TAGS] = ...
    INIT: ClassVar[DYNAMIC_TAGS] = ...
    INIT_ARRAY: ClassVar[DYNAMIC_TAGS] = ...
    INIT_ARRAYSZ: ClassVar[DYNAMIC_TAGS] = ...
    JMPREL: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_AUX_DYNAMIC: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_BASE_ADDRESS: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_COMPACT_SIZE: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_CONFLICT: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_CONFLICTNO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_CXX_FLAGS: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_CLASS: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_CLASSSYM: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_CLASSSYM_NO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_CLASS_NO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_INSTANCE: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_INSTANCE_NO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_RELOC: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_RELOC_NO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_SYM: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DELTA_SYM_NO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_DYNSTR_ALIGN: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_FLAGS: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_GOTSYM: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_GP_VALUE: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_HIDDEN_GOTIDX: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_HIPAGENO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_ICHECKSUM: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_INTERFACE: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_INTERFACE_SIZE: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_IVERSION: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_LIBLIST: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_LIBLISTNO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_LOCALPAGE_GOTIDX: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_LOCAL_GOTIDX: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_LOCAL_GOTNO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_MSYM: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_OPTIONS: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_PERF_SUFFIX: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_PIXIE_INIT: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_PLTGOT: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_PROTECTED_GOTIDX: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_RLD_MAP: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_RLD_TEXT_RESOLVE_ADDR: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_RLD_VERSION: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_RWPLT: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_SYMBOL_LIB: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_SYMTABNO: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_TIME_STAMP: ClassVar[DYNAMIC_TAGS] = ...
    MIPS_UNREFEXTNO: ClassVar[DYNAMIC_TAGS] = ...
    NEEDED: ClassVar[DYNAMIC_TAGS] = ...
    NULL: ClassVar[DYNAMIC_TAGS] = ...
    PLTGOT: ClassVar[DYNAMIC_TAGS] = ...
    PLTREL: ClassVar[DYNAMIC_TAGS] = ...
    PLTRELSZ: ClassVar[DYNAMIC_TAGS] = ...
    PREINIT_ARRAY: ClassVar[DYNAMIC_TAGS] = ...
    PREINIT_ARRAYSZ: ClassVar[DYNAMIC_TAGS] = ...
    REL: ClassVar[DYNAMIC_TAGS] = ...
    RELA: ClassVar[DYNAMIC_TAGS] = ...
    RELACOUNT: ClassVar[DYNAMIC_TAGS] = ...
    RELAENT: ClassVar[DYNAMIC_TAGS] = ...
    RELASZ: ClassVar[DYNAMIC_TAGS] = ...
    RELCOUNT: ClassVar[DYNAMIC_TAGS] = ...
    RELENT: ClassVar[DYNAMIC_TAGS] = ...
    RELR: ClassVar[DYNAMIC_TAGS] = ...
    RELRCOUNT: ClassVar[DYNAMIC_TAGS] = ...
    RELRENT: ClassVar[DYNAMIC_TAGS] = ...
    RELRSZ: ClassVar[DYNAMIC_TAGS] = ...
    RELSZ: ClassVar[DYNAMIC_TAGS] = ...
    RPATH: ClassVar[DYNAMIC_TAGS] = ...
    RUNPATH: ClassVar[DYNAMIC_TAGS] = ...
    SONAME: ClassVar[DYNAMIC_TAGS] = ...
    STRSZ: ClassVar[DYNAMIC_TAGS] = ...
    STRTAB: ClassVar[DYNAMIC_TAGS] = ...
    SYMBOLIC: ClassVar[DYNAMIC_TAGS] = ...
    SYMENT: ClassVar[DYNAMIC_TAGS] = ...
    SYMTAB: ClassVar[DYNAMIC_TAGS] = ...
    TEXTREL: ClassVar[DYNAMIC_TAGS] = ...
    VERDEF: ClassVar[DYNAMIC_TAGS] = ...
    VERDEFNUM: ClassVar[DYNAMIC_TAGS] = ...
    VERNEED: ClassVar[DYNAMIC_TAGS] = ...
    VERNEEDNUM: ClassVar[DYNAMIC_TAGS] = ...
    VERSYM: ClassVar[DYNAMIC_TAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DYNSYM_COUNT_METHODS:
    __members__: ClassVar[dict] = ...  # read-only
    AUTO: ClassVar[DYNSYM_COUNT_METHODS] = ...
    HASH: ClassVar[DYNSYM_COUNT_METHODS] = ...
    RELOCATIONS: ClassVar[DYNSYM_COUNT_METHODS] = ...
    SECTION: ClassVar[DYNSYM_COUNT_METHODS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DynamicEntry(lief.Object):
    tag: lief.ELF.DYNAMIC_TAGS
    value: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tag: lief.ELF.DYNAMIC_TAGS, value: int) -> None: ...

class DynamicEntryArray(DynamicEntry):
    array: List[int]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tag: lief.ELF.DYNAMIC_TAGS, value: int) -> None: ...
    def append(self, function: int) -> lief.ELF.DynamicEntryArray: ...
    def insert(self, pos: int, function: int) -> lief.ELF.DynamicEntryArray: ...
    def remove(self, function: int) -> lief.ELF.DynamicEntryArray: ...
    def __getitem__(self, arg0: int) -> int: ...
    def __iadd__(self, arg0: int) -> lief.ELF.DynamicEntryArray: ...
    def __isub__(self, arg0: int) -> lief.ELF.DynamicEntryArray: ...
    def __len__(self) -> int: ...

class DynamicEntryFlags(DynamicEntry):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tag: lief.ELF.DYNAMIC_TAGS, value: int) -> None: ...
    @overload
    def add(self, flag: lief.ELF.DYNAMIC_FLAGS) -> None: ...
    @overload
    def add(self, flag: lief.ELF.DYNAMIC_FLAGS_1) -> None: ...
    @overload
    def has(self, flag: lief.ELF.DYNAMIC_FLAGS) -> bool: ...
    @overload
    def has(self, flag: lief.ELF.DYNAMIC_FLAGS_1) -> bool: ...
    @overload
    def remove(self, flag: lief.ELF.DYNAMIC_FLAGS) -> None: ...
    @overload
    def remove(self, flag: lief.ELF.DYNAMIC_FLAGS_1) -> None: ...
    @overload
    def __contains__(self, arg0: lief.ELF.DYNAMIC_FLAGS) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.DYNAMIC_FLAGS_1) -> bool: ...
    @overload
    def __iadd__(self, arg0: lief.ELF.DYNAMIC_FLAGS) -> lief.ELF.DynamicEntryFlags: ...
    @overload
    def __iadd__(self, arg0: lief.ELF.DYNAMIC_FLAGS_1) -> lief.ELF.DynamicEntryFlags: ...
    @overload
    def __isub__(self, arg0: lief.ELF.DYNAMIC_FLAGS) -> lief.ELF.DynamicEntryFlags: ...
    @overload
    def __isub__(self, arg0: lief.ELF.DYNAMIC_FLAGS_1) -> lief.ELF.DynamicEntryFlags: ...
    @property
    def flags(self) -> Set[int]: ...

class DynamicEntryLibrary(DynamicEntry):
    name: object
    def __init__(self, library_name: str) -> None: ...

class DynamicEntryRpath(DynamicEntry):
    name: object
    paths: List[str]
    rpath: object
    @overload
    def __init__(self, path: str = ...) -> None: ...
    @overload
    def __init__(self, paths: List[str]) -> None: ...
    def append(self, path: str) -> lief.ELF.DynamicEntryRpath: ...
    def insert(self, position: int, path: str) -> lief.ELF.DynamicEntryRpath: ...
    def remove(self, path: str) -> lief.ELF.DynamicEntryRpath: ...
    def __iadd__(self, arg0: str) -> lief.ELF.DynamicEntryRpath: ...
    def __isub__(self, arg0: str) -> lief.ELF.DynamicEntryRpath: ...

class DynamicEntryRunPath(DynamicEntry):
    name: object
    paths: List[str]
    runpath: object
    @overload
    def __init__(self, path: str = ...) -> None: ...
    @overload
    def __init__(self, paths: List[str]) -> None: ...
    def append(self, path: str) -> lief.ELF.DynamicEntryRunPath: ...
    def insert(self, position: int, path: str) -> lief.ELF.DynamicEntryRunPath: ...
    def remove(self, path: str) -> lief.ELF.DynamicEntryRunPath: ...
    def __iadd__(self, arg0: str) -> lief.ELF.DynamicEntryRunPath: ...
    def __isub__(self, arg0: str) -> lief.ELF.DynamicEntryRunPath: ...

class DynamicSharedObject(DynamicEntry):
    name: object
    def __init__(self, library_name: str) -> None: ...

class ELF_CLASS:
    __members__: ClassVar[dict] = ...  # read-only
    CLASS32: ClassVar[ELF_CLASS] = ...
    CLASS64: ClassVar[ELF_CLASS] = ...
    NONE: ClassVar[ELF_CLASS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ELF_DATA:
    __members__: ClassVar[dict] = ...  # read-only
    LSB: ClassVar[ELF_DATA] = ...
    MSB: ClassVar[ELF_DATA] = ...
    NONE: ClassVar[ELF_DATA] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class E_TYPE:
    __members__: ClassVar[dict] = ...  # read-only
    CORE: ClassVar[E_TYPE] = ...
    DYNAMIC: ClassVar[E_TYPE] = ...
    EXECUTABLE: ClassVar[E_TYPE] = ...
    HIPROC: ClassVar[E_TYPE] = ...
    LOPROC: ClassVar[E_TYPE] = ...
    NONE: ClassVar[E_TYPE] = ...
    RELOCATABLE: ClassVar[E_TYPE] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class GnuHash(lief.Object):
    def __init__(self) -> None: ...
    @overload
    def check(self, symbol_name: str) -> bool: ...
    @overload
    def check(self, hash_value: int) -> bool: ...
    def check_bloom_filter(self, hash: int) -> bool: ...
    def check_bucket(self, hash: int) -> bool: ...
    @property
    def bloom_filters(self) -> List[int]: ...
    @property
    def buckets(self) -> List[int]: ...
    @property
    def hash_values(self) -> List[int]: ...
    @property
    def nb_buckets(self) -> int: ...
    @property
    def shift2(self) -> int: ...
    @property
    def symbol_index(self) -> int: ...

class HEXAGON_EFLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    ISA_MACH: ClassVar[HEXAGON_EFLAGS] = ...
    ISA_V2: ClassVar[HEXAGON_EFLAGS] = ...
    ISA_V3: ClassVar[HEXAGON_EFLAGS] = ...
    ISA_V4: ClassVar[HEXAGON_EFLAGS] = ...
    ISA_V5: ClassVar[HEXAGON_EFLAGS] = ...
    MACH_V2: ClassVar[HEXAGON_EFLAGS] = ...
    MACH_V3: ClassVar[HEXAGON_EFLAGS] = ...
    MACH_V4: ClassVar[HEXAGON_EFLAGS] = ...
    MACH_V5: ClassVar[HEXAGON_EFLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Header(lief.Object):
    entrypoint: int
    file_type: lief.ELF.E_TYPE
    header_size: int
    identity: List[int]
    identity_abi_version: int
    identity_class: lief.ELF.ELF_CLASS
    identity_data: lief.ELF.ELF_DATA
    identity_os_abi: lief.ELF.OS_ABI
    identity_version: lief.ELF.VERSION
    machine_type: lief.ELF.ARCH
    numberof_sections: int
    numberof_segments: int
    object_file_version: lief.ELF.VERSION
    processor_flag: int
    program_header_offset: int
    program_header_size: int
    section_header_offset: int
    section_header_size: int
    section_name_table_idx: int
    def __init__(self) -> None: ...
    @overload
    def __contains__(self, arg0: lief.ELF.ARM_EFLAGS) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.MIPS_EFLAGS) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.PPC64_EFLAGS) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.HEXAGON_EFLAGS) -> bool: ...
    @property
    def arm_flags_list(self) -> Set[lief.ELF.ARM_EFLAGS]: ...
    @property
    def hexagon_flags_list(self) -> Set[lief.ELF.HEXAGON_EFLAGS]: ...
    @property
    def mips_flags_list(self) -> Set[lief.ELF.MIPS_EFLAGS]: ...
    @property
    def ppc64_flags_list(self) -> Set[lief.ELF.PPC64_EFLAGS]: ...

class IDENTITY:
    __members__: ClassVar[dict] = ...  # read-only
    ABIVERSION: ClassVar[IDENTITY] = ...
    CLASS: ClassVar[IDENTITY] = ...
    DATA: ClassVar[IDENTITY] = ...
    MAG0: ClassVar[IDENTITY] = ...
    MAG1: ClassVar[IDENTITY] = ...
    MAG2: ClassVar[IDENTITY] = ...
    MAG3: ClassVar[IDENTITY] = ...
    NIDENT: ClassVar[IDENTITY] = ...
    OSABI: ClassVar[IDENTITY] = ...
    PAD: ClassVar[IDENTITY] = ...
    VERSION: ClassVar[IDENTITY] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class MIPS_EFLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    ABI2: ClassVar[MIPS_EFLAGS] = ...
    ABI_EABI32: ClassVar[MIPS_EFLAGS] = ...
    ABI_EABI64: ClassVar[MIPS_EFLAGS] = ...
    ABI_O32: ClassVar[MIPS_EFLAGS] = ...
    ABI_O64: ClassVar[MIPS_EFLAGS] = ...
    ARCH_1: ClassVar[MIPS_EFLAGS] = ...
    ARCH_2: ClassVar[MIPS_EFLAGS] = ...
    ARCH_3: ClassVar[MIPS_EFLAGS] = ...
    ARCH_32: ClassVar[MIPS_EFLAGS] = ...
    ARCH_32R2: ClassVar[MIPS_EFLAGS] = ...
    ARCH_32R6: ClassVar[MIPS_EFLAGS] = ...
    ARCH_4: ClassVar[MIPS_EFLAGS] = ...
    ARCH_5: ClassVar[MIPS_EFLAGS] = ...
    ARCH_64: ClassVar[MIPS_EFLAGS] = ...
    ARCH_64R2: ClassVar[MIPS_EFLAGS] = ...
    ARCH_64R6: ClassVar[MIPS_EFLAGS] = ...
    ARCH_ASE_M16: ClassVar[MIPS_EFLAGS] = ...
    ARCH_ASE_MDMX: ClassVar[MIPS_EFLAGS] = ...
    CPIC: ClassVar[MIPS_EFLAGS] = ...
    FP64: ClassVar[MIPS_EFLAGS] = ...
    MACH_3900: ClassVar[MIPS_EFLAGS] = ...
    MACH_4010: ClassVar[MIPS_EFLAGS] = ...
    MACH_4100: ClassVar[MIPS_EFLAGS] = ...
    MACH_4111: ClassVar[MIPS_EFLAGS] = ...
    MACH_4120: ClassVar[MIPS_EFLAGS] = ...
    MACH_4650: ClassVar[MIPS_EFLAGS] = ...
    MACH_5400: ClassVar[MIPS_EFLAGS] = ...
    MACH_5500: ClassVar[MIPS_EFLAGS] = ...
    MACH_5900: ClassVar[MIPS_EFLAGS] = ...
    MACH_9000: ClassVar[MIPS_EFLAGS] = ...
    MACH_LS2E: ClassVar[MIPS_EFLAGS] = ...
    MACH_LS2F: ClassVar[MIPS_EFLAGS] = ...
    MACH_LS3A: ClassVar[MIPS_EFLAGS] = ...
    MACH_OCTEON: ClassVar[MIPS_EFLAGS] = ...
    MACH_OCTEON2: ClassVar[MIPS_EFLAGS] = ...
    MACH_OCTEON3: ClassVar[MIPS_EFLAGS] = ...
    MACH_SB1: ClassVar[MIPS_EFLAGS] = ...
    MACH_XLR: ClassVar[MIPS_EFLAGS] = ...
    MICROMIPS: ClassVar[MIPS_EFLAGS] = ...
    NAN2008: ClassVar[MIPS_EFLAGS] = ...
    NOREORDER: ClassVar[MIPS_EFLAGS] = ...
    PIC: ClassVar[MIPS_EFLAGS] = ...
    _32BITMODE: ClassVar[MIPS_EFLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class NOTE_ABIS:
    __members__: ClassVar[dict] = ...  # read-only
    FREEBSD: ClassVar[NOTE_ABIS] = ...
    GNU: ClassVar[NOTE_ABIS] = ...
    LINUX: ClassVar[NOTE_ABIS] = ...
    NETBSD: ClassVar[NOTE_ABIS] = ...
    SOLARIS2: ClassVar[NOTE_ABIS] = ...
    SYLLABLE: ClassVar[NOTE_ABIS] = ...
    UNKNOWN: ClassVar[NOTE_ABIS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class NOTE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    ABI_TAG: ClassVar[NOTE_TYPES] = ...
    BUILD_ID: ClassVar[NOTE_TYPES] = ...
    CRASHPAD: ClassVar[NOTE_TYPES] = ...
    GNU_BUILD_ATTRIBUTE_FUNC: ClassVar[NOTE_TYPES] = ...
    GNU_BUILD_ATTRIBUTE_OPEN: ClassVar[NOTE_TYPES] = ...
    GOLD_VERSION: ClassVar[NOTE_TYPES] = ...
    HWCAP: ClassVar[NOTE_TYPES] = ...
    PROPERTY_TYPE_0: ClassVar[NOTE_TYPES] = ...
    UNKNOWN: ClassVar[NOTE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class NOTE_TYPES_CORE:
    __members__: ClassVar[dict] = ...  # read-only
    ARM_HW_BREAK: ClassVar[NOTE_TYPES_CORE] = ...
    ARM_HW_WATCH: ClassVar[NOTE_TYPES_CORE] = ...
    ARM_SVE: ClassVar[NOTE_TYPES_CORE] = ...
    ARM_SYSTEM_CALL: ClassVar[NOTE_TYPES_CORE] = ...
    ARM_TLS: ClassVar[NOTE_TYPES_CORE] = ...
    ARM_VFP: ClassVar[NOTE_TYPES_CORE] = ...
    AUXV: ClassVar[NOTE_TYPES_CORE] = ...
    FILE: ClassVar[NOTE_TYPES_CORE] = ...
    I386_IOPERM: ClassVar[NOTE_TYPES_CORE] = ...
    I386_TLS: ClassVar[NOTE_TYPES_CORE] = ...
    I386_XSTATE: ClassVar[NOTE_TYPES_CORE] = ...
    PRFPREG: ClassVar[NOTE_TYPES_CORE] = ...
    PRPSINFO: ClassVar[NOTE_TYPES_CORE] = ...
    PRSTATUS: ClassVar[NOTE_TYPES_CORE] = ...
    SIGINFO: ClassVar[NOTE_TYPES_CORE] = ...
    TASKSTRUCT: ClassVar[NOTE_TYPES_CORE] = ...
    UNKNOWN: ClassVar[NOTE_TYPES_CORE] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Note(lief.Object):
    description: List[int]
    name: str
    type: lief.ELF.NOTE_TYPES
    type_core: lief.ELF.NOTE_TYPES_CORE
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, type: lief.ELF.NOTE_TYPES, description: List[int]) -> None: ...
    @property
    def details(self) -> lief.ELF.NoteDetails: ...
    @property
    def is_android(self) -> bool: ...
    @property
    def is_core(self) -> bool: ...
    @property
    def size(self) -> int: ...

class NoteAbi(NoteDetails):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def abi(self) -> lief.ELF.NOTE_ABIS: ...
    @property
    def version(self) -> List[int]: ...

class NoteDetails(lief.Object):
    def __init__(self) -> None: ...

class OS_ABI:
    __members__: ClassVar[dict] = ...  # read-only
    AIX: ClassVar[OS_ABI] = ...
    AMDGPU_HSA: ClassVar[OS_ABI] = ...
    ARM: ClassVar[OS_ABI] = ...
    AROS: ClassVar[OS_ABI] = ...
    C6000_ELFABI: ClassVar[OS_ABI] = ...
    C6000_LINUX: ClassVar[OS_ABI] = ...
    CLOUDABI: ClassVar[OS_ABI] = ...
    FENIXOS: ClassVar[OS_ABI] = ...
    FREEBSD: ClassVar[OS_ABI] = ...
    GNU: ClassVar[OS_ABI] = ...
    HPUX: ClassVar[OS_ABI] = ...
    HURD: ClassVar[OS_ABI] = ...
    IRIX: ClassVar[OS_ABI] = ...
    LINUX: ClassVar[OS_ABI] = ...
    MODESTO: ClassVar[OS_ABI] = ...
    NETBSD: ClassVar[OS_ABI] = ...
    NSK: ClassVar[OS_ABI] = ...
    OPENBSD: ClassVar[OS_ABI] = ...
    OPENVMS: ClassVar[OS_ABI] = ...
    SOLARIS: ClassVar[OS_ABI] = ...
    STANDALONE: ClassVar[OS_ABI] = ...
    SYSTEMV: ClassVar[OS_ABI] = ...
    TRU64: ClassVar[OS_ABI] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PPC64_EFLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    ABI: ClassVar[PPC64_EFLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_AARCH64:
    __members__: ClassVar[dict] = ...  # read-only
    ABS16: ClassVar[RELOCATION_AARCH64] = ...
    ABS32: ClassVar[RELOCATION_AARCH64] = ...
    ABS64: ClassVar[RELOCATION_AARCH64] = ...
    ADD_ABS_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    ADR_GOT_PAGE: ClassVar[RELOCATION_AARCH64] = ...
    ADR_PREL_LO21: ClassVar[RELOCATION_AARCH64] = ...
    ADR_PREL_PG_HI21: ClassVar[RELOCATION_AARCH64] = ...
    ADR_PREL_PG_HI21_NC: ClassVar[RELOCATION_AARCH64] = ...
    CALL26: ClassVar[RELOCATION_AARCH64] = ...
    CONDBR19: ClassVar[RELOCATION_AARCH64] = ...
    COPY: ClassVar[RELOCATION_AARCH64] = ...
    GLOB_DAT: ClassVar[RELOCATION_AARCH64] = ...
    GOTREL32: ClassVar[RELOCATION_AARCH64] = ...
    GOTREL64: ClassVar[RELOCATION_AARCH64] = ...
    GOT_LD_PREL19: ClassVar[RELOCATION_AARCH64] = ...
    IRELATIVE: ClassVar[RELOCATION_AARCH64] = ...
    JUMP26: ClassVar[RELOCATION_AARCH64] = ...
    JUMP_SLOT: ClassVar[RELOCATION_AARCH64] = ...
    LD64_GOTOFF_LO15: ClassVar[RELOCATION_AARCH64] = ...
    LD64_GOTPAGE_LO15: ClassVar[RELOCATION_AARCH64] = ...
    LD64_GOT_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    LDST128_ABS_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    LDST16_ABS_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    LDST32_ABS_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    LDST64_ABS_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    LDST8_ABS_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    LD_PREL_LO19: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_GOTOFF_G0: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_GOTOFF_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_GOTOFF_G1: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_GOTOFF_G1_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_GOTOFF_G2: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_GOTOFF_G2_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_GOTOFF_G3: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_PREL_G0: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_PREL_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_PREL_G1: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_PREL_G1_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_PREL_G2: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_PREL_G2_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_PREL_G3: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_SABS_G0: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_SABS_G1: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_SABS_G2: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_UABS_G0: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_UABS_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_UABS_G1: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_UABS_G1_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_UABS_G2: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_UABS_G2_NC: ClassVar[RELOCATION_AARCH64] = ...
    MOVW_UABS_G3: ClassVar[RELOCATION_AARCH64] = ...
    NONE: ClassVar[RELOCATION_AARCH64] = ...
    PREL16: ClassVar[RELOCATION_AARCH64] = ...
    PREL32: ClassVar[RELOCATION_AARCH64] = ...
    PREL64: ClassVar[RELOCATION_AARCH64] = ...
    RELATIVE: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_ADD: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_ADD_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_ADR_PAGE21: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_ADR_PREL21: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_CALL: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_LD64_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_LDR: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_LD_PREL19: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_OFF_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSDESC_OFF_G1: ClassVar[RELOCATION_AARCH64] = ...
    TLSGD_ADD_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSGD_ADR_PAGE21: ClassVar[RELOCATION_AARCH64] = ...
    TLSGD_ADR_PREL21: ClassVar[RELOCATION_AARCH64] = ...
    TLSGD_MOVW_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSGD_MOVW_G1: ClassVar[RELOCATION_AARCH64] = ...
    TLSIE_ADR_GOTTPREL_PAGE21: ClassVar[RELOCATION_AARCH64] = ...
    TLSIE_LD64_GOTTPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSIE_LD_GOTTPREL_PREL19: ClassVar[RELOCATION_AARCH64] = ...
    TLSIE_MOVW_GOTTPREL_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSIE_MOVW_GOTTPREL_G1: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_ADD_DTPREL_HI12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_ADD_DTPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_ADD_DTPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_ADD_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_ADR_PAGE21: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_ADR_PREL21: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST128_DTPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST128_DTPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST16_DTPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST16_DTPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST32_DTPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST32_DTPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST64_DTPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST64_DTPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST8_DTPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LDST8_DTPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_LD_PREL19: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_MOVW_DTPREL_G0: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_MOVW_DTPREL_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_MOVW_DTPREL_G1: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_MOVW_DTPREL_G1_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_MOVW_DTPREL_G2: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_MOVW_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLD_MOVW_G1: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_ADD_TPREL_HI12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_ADD_TPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_ADD_TPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST128_TPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST128_TPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST16_TPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST16_TPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST32_TPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST32_TPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST64_TPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST64_TPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST8_TPREL_LO12: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_LDST8_TPREL_LO12_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_MOVW_TPREL_G0: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_MOVW_TPREL_G0_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_MOVW_TPREL_G1: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_MOVW_TPREL_G1_NC: ClassVar[RELOCATION_AARCH64] = ...
    TLSLE_MOVW_TPREL_G2: ClassVar[RELOCATION_AARCH64] = ...
    TLS_DTPMOD64: ClassVar[RELOCATION_AARCH64] = ...
    TLS_DTPREL64: ClassVar[RELOCATION_AARCH64] = ...
    TLS_TPREL64: ClassVar[RELOCATION_AARCH64] = ...
    TSTBR14: ClassVar[RELOCATION_AARCH64] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_ARM:
    __members__: ClassVar[dict] = ...  # read-only
    ABS12: ClassVar[RELOCATION_ARM] = ...
    ABS16: ClassVar[RELOCATION_ARM] = ...
    ABS32: ClassVar[RELOCATION_ARM] = ...
    ABS32_NOI: ClassVar[RELOCATION_ARM] = ...
    ABS8: ClassVar[RELOCATION_ARM] = ...
    ALU_PCREL_15_8: ClassVar[RELOCATION_ARM] = ...
    ALU_PCREL_23_15: ClassVar[RELOCATION_ARM] = ...
    ALU_PCREL_7_0: ClassVar[RELOCATION_ARM] = ...
    ALU_PC_G0: ClassVar[RELOCATION_ARM] = ...
    ALU_PC_G0_NC: ClassVar[RELOCATION_ARM] = ...
    ALU_PC_G1: ClassVar[RELOCATION_ARM] = ...
    ALU_PC_G1_NC: ClassVar[RELOCATION_ARM] = ...
    ALU_PC_G2: ClassVar[RELOCATION_ARM] = ...
    ALU_SBREL_19_12_NC: ClassVar[RELOCATION_ARM] = ...
    ALU_SBREL_27_20_CK: ClassVar[RELOCATION_ARM] = ...
    ALU_SB_G0: ClassVar[RELOCATION_ARM] = ...
    ALU_SB_G0_NC: ClassVar[RELOCATION_ARM] = ...
    ALU_SB_G1: ClassVar[RELOCATION_ARM] = ...
    ALU_SB_G1_NC: ClassVar[RELOCATION_ARM] = ...
    ALU_SB_G2: ClassVar[RELOCATION_ARM] = ...
    BASE_ABS: ClassVar[RELOCATION_ARM] = ...
    BASE_PREL: ClassVar[RELOCATION_ARM] = ...
    BREL_ADJ: ClassVar[RELOCATION_ARM] = ...
    CALL: ClassVar[RELOCATION_ARM] = ...
    COPY: ClassVar[RELOCATION_ARM] = ...
    GLOB_DAT: ClassVar[RELOCATION_ARM] = ...
    GNU_VTENTRY: ClassVar[RELOCATION_ARM] = ...
    GNU_VTINHERIT: ClassVar[RELOCATION_ARM] = ...
    GOTOFF12: ClassVar[RELOCATION_ARM] = ...
    GOTOFF32: ClassVar[RELOCATION_ARM] = ...
    GOTRELAX: ClassVar[RELOCATION_ARM] = ...
    GOT_ABS: ClassVar[RELOCATION_ARM] = ...
    GOT_BREL: ClassVar[RELOCATION_ARM] = ...
    GOT_BREL12: ClassVar[RELOCATION_ARM] = ...
    GOT_PREL: ClassVar[RELOCATION_ARM] = ...
    IRELATIVE: ClassVar[RELOCATION_ARM] = ...
    JUMP24: ClassVar[RELOCATION_ARM] = ...
    JUMP_SLOT: ClassVar[RELOCATION_ARM] = ...
    LDC_PC_G0: ClassVar[RELOCATION_ARM] = ...
    LDC_PC_G1: ClassVar[RELOCATION_ARM] = ...
    LDC_PC_G2: ClassVar[RELOCATION_ARM] = ...
    LDC_SB_G0: ClassVar[RELOCATION_ARM] = ...
    LDC_SB_G1: ClassVar[RELOCATION_ARM] = ...
    LDC_SB_G2: ClassVar[RELOCATION_ARM] = ...
    LDRS_PC_G0: ClassVar[RELOCATION_ARM] = ...
    LDRS_PC_G1: ClassVar[RELOCATION_ARM] = ...
    LDRS_PC_G2: ClassVar[RELOCATION_ARM] = ...
    LDRS_SB_G0: ClassVar[RELOCATION_ARM] = ...
    LDRS_SB_G1: ClassVar[RELOCATION_ARM] = ...
    LDRS_SB_G2: ClassVar[RELOCATION_ARM] = ...
    LDR_PC_G0: ClassVar[RELOCATION_ARM] = ...
    LDR_PC_G1: ClassVar[RELOCATION_ARM] = ...
    LDR_PC_G2: ClassVar[RELOCATION_ARM] = ...
    LDR_SBREL_11_0_NC: ClassVar[RELOCATION_ARM] = ...
    LDR_SB_G0: ClassVar[RELOCATION_ARM] = ...
    LDR_SB_G1: ClassVar[RELOCATION_ARM] = ...
    LDR_SB_G2: ClassVar[RELOCATION_ARM] = ...
    ME_TOO: ClassVar[RELOCATION_ARM] = ...
    MOVT_ABS: ClassVar[RELOCATION_ARM] = ...
    MOVT_BREL: ClassVar[RELOCATION_ARM] = ...
    MOVT_PREL: ClassVar[RELOCATION_ARM] = ...
    MOVW_ABS_NC: ClassVar[RELOCATION_ARM] = ...
    MOVW_BREL: ClassVar[RELOCATION_ARM] = ...
    MOVW_BREL_NC: ClassVar[RELOCATION_ARM] = ...
    MOVW_PREL_NC: ClassVar[RELOCATION_ARM] = ...
    NONE: ClassVar[RELOCATION_ARM] = ...
    PC24: ClassVar[RELOCATION_ARM] = ...
    PLT32: ClassVar[RELOCATION_ARM] = ...
    PLT32_ABS: ClassVar[RELOCATION_ARM] = ...
    PREL31: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_0: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_1: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_10: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_11: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_12: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_13: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_14: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_15: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_2: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_3: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_4: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_5: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_6: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_7: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_8: ClassVar[RELOCATION_ARM] = ...
    PRIVATE_9: ClassVar[RELOCATION_ARM] = ...
    RBASE: ClassVar[RELOCATION_ARM] = ...
    REL32: ClassVar[RELOCATION_ARM] = ...
    REL32_NOI: ClassVar[RELOCATION_ARM] = ...
    RELATIVE: ClassVar[RELOCATION_ARM] = ...
    RPC24: ClassVar[RELOCATION_ARM] = ...
    RREL32: ClassVar[RELOCATION_ARM] = ...
    RSBREL32: ClassVar[RELOCATION_ARM] = ...
    RXPC25: ClassVar[RELOCATION_ARM] = ...
    SBREL31: ClassVar[RELOCATION_ARM] = ...
    SBREL32: ClassVar[RELOCATION_ARM] = ...
    TARGET1: ClassVar[RELOCATION_ARM] = ...
    TARGET2: ClassVar[RELOCATION_ARM] = ...
    THM_ABS5: ClassVar[RELOCATION_ARM] = ...
    THM_ALU_PREL_11_0: ClassVar[RELOCATION_ARM] = ...
    THM_CALL: ClassVar[RELOCATION_ARM] = ...
    THM_JUMP11: ClassVar[RELOCATION_ARM] = ...
    THM_JUMP19: ClassVar[RELOCATION_ARM] = ...
    THM_JUMP24: ClassVar[RELOCATION_ARM] = ...
    THM_JUMP6: ClassVar[RELOCATION_ARM] = ...
    THM_JUMP8: ClassVar[RELOCATION_ARM] = ...
    THM_MOVT_ABS: ClassVar[RELOCATION_ARM] = ...
    THM_MOVT_BREL: ClassVar[RELOCATION_ARM] = ...
    THM_MOVT_PREL: ClassVar[RELOCATION_ARM] = ...
    THM_MOVW_ABS_NC: ClassVar[RELOCATION_ARM] = ...
    THM_MOVW_BREL: ClassVar[RELOCATION_ARM] = ...
    THM_MOVW_BREL_NC: ClassVar[RELOCATION_ARM] = ...
    THM_MOVW_PREL_NC: ClassVar[RELOCATION_ARM] = ...
    THM_PC12: ClassVar[RELOCATION_ARM] = ...
    THM_PC8: ClassVar[RELOCATION_ARM] = ...
    THM_RPC22: ClassVar[RELOCATION_ARM] = ...
    THM_SWI8: ClassVar[RELOCATION_ARM] = ...
    THM_TLS_CALL: ClassVar[RELOCATION_ARM] = ...
    THM_TLS_DESCSEQ16: ClassVar[RELOCATION_ARM] = ...
    THM_TLS_DESCSEQ32: ClassVar[RELOCATION_ARM] = ...
    THM_XPC22: ClassVar[RELOCATION_ARM] = ...
    TLS_CALL: ClassVar[RELOCATION_ARM] = ...
    TLS_DESC: ClassVar[RELOCATION_ARM] = ...
    TLS_DESCSEQ: ClassVar[RELOCATION_ARM] = ...
    TLS_DTPMOD32: ClassVar[RELOCATION_ARM] = ...
    TLS_DTPOFF32: ClassVar[RELOCATION_ARM] = ...
    TLS_GD32: ClassVar[RELOCATION_ARM] = ...
    TLS_GOTDESC: ClassVar[RELOCATION_ARM] = ...
    TLS_IE12GP: ClassVar[RELOCATION_ARM] = ...
    TLS_IE32: ClassVar[RELOCATION_ARM] = ...
    TLS_LDM32: ClassVar[RELOCATION_ARM] = ...
    TLS_LDO12: ClassVar[RELOCATION_ARM] = ...
    TLS_LDO32: ClassVar[RELOCATION_ARM] = ...
    TLS_LE12: ClassVar[RELOCATION_ARM] = ...
    TLS_LE32: ClassVar[RELOCATION_ARM] = ...
    TLS_TPOFF32: ClassVar[RELOCATION_ARM] = ...
    V4BX: ClassVar[RELOCATION_ARM] = ...
    XPC25: ClassVar[RELOCATION_ARM] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_MIPS:
    __members__: ClassVar[dict] = ...  # read-only
    MIPS16_16: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_26: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_CALL16: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_GOT16: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_GPREL: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_TLS_DTPREL_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_TLS_DTPREL_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_TLS_GD: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_TLS_GOTTPREL: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_TLS_LDM: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_TLS_TPREL_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS16_TLS_TPREL_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_26: ClassVar[RELOCATION_MIPS] = ...
    MIPS_32: ClassVar[RELOCATION_MIPS] = ...
    MIPS_64: ClassVar[RELOCATION_MIPS] = ...
    MIPS_ADD_IMMEDIATE: ClassVar[RELOCATION_MIPS] = ...
    MIPS_CALL16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_CALL_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_CALL_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_COPY: ClassVar[RELOCATION_MIPS] = ...
    MIPS_DELETE: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GLOB_DAT: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GOT16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GOT_DISP: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GOT_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GOT_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GOT_OFST: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GOT_PAGE: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GPREL16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_GPREL32: ClassVar[RELOCATION_MIPS] = ...
    MIPS_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_HIGHER: ClassVar[RELOCATION_MIPS] = ...
    MIPS_HIGHEST: ClassVar[RELOCATION_MIPS] = ...
    MIPS_INSERT_A: ClassVar[RELOCATION_MIPS] = ...
    MIPS_INSERT_B: ClassVar[RELOCATION_MIPS] = ...
    MIPS_JALR: ClassVar[RELOCATION_MIPS] = ...
    MIPS_JUMP_SLOT: ClassVar[RELOCATION_MIPS] = ...
    MIPS_LITERAL: ClassVar[RELOCATION_MIPS] = ...
    MIPS_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_NONE: ClassVar[RELOCATION_MIPS] = ...
    MIPS_PC16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_PC18_S3: ClassVar[RELOCATION_MIPS] = ...
    MIPS_PC19_S2: ClassVar[RELOCATION_MIPS] = ...
    MIPS_PC21_S2: ClassVar[RELOCATION_MIPS] = ...
    MIPS_PC26_S2: ClassVar[RELOCATION_MIPS] = ...
    MIPS_PCHI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_PCLO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_PJUMP: ClassVar[RELOCATION_MIPS] = ...
    MIPS_REL16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_REL32: ClassVar[RELOCATION_MIPS] = ...
    MIPS_RELGOT: ClassVar[RELOCATION_MIPS] = ...
    MIPS_SCN_DISP: ClassVar[RELOCATION_MIPS] = ...
    MIPS_SHIFT5: ClassVar[RELOCATION_MIPS] = ...
    MIPS_SHIFT6: ClassVar[RELOCATION_MIPS] = ...
    MIPS_SUB: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_DTPMOD32: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_DTPMOD64: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_DTPREL32: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_DTPREL64: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_DTPREL_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_DTPREL_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_GD: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_GOTTPREL: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_LDM: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_TPREL32: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_TPREL64: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_TPREL_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_TLS_TPREL_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIPS_UNUSED1: ClassVar[RELOCATION_MIPS] = ...
    MIPS_UNUSED2: ClassVar[RELOCATION_MIPS] = ...
    MIPS_UNUSED3: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_26_S1: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_CALL16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_CALL_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_CALL_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_GOT16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_GOT_DISP: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_GOT_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_GOT_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_GOT_OFST: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_GOT_PAGE: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_GPREL16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_GPREL7_S2: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_HI0_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_HIGHER: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_HIGHEST: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_JALR: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_LITERAL: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_PC10_S1: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_PC16_S1: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_PC18_S3: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_PC19_S2: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_PC21_S2: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_PC23_S2: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_PC26_S2: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_PC7_S1: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_SCN_DISP: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_SUB: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_TLS_DTPREL_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_TLS_DTPREL_LO16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_TLS_GD: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_TLS_GOTTPREL: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_TLS_LDM: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_TLS_TPREL_HI16: ClassVar[RELOCATION_MIPS] = ...
    MIRCRO_MIPS_TLS_TPREL_LO16: ClassVar[RELOCATION_MIPS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_PPC:
    __members__: ClassVar[dict] = ...  # read-only
    ADDR14: ClassVar[RELOCATION_PPC] = ...
    ADDR14_BRNTAKEN: ClassVar[RELOCATION_PPC] = ...
    ADDR14_BRTAKEN: ClassVar[RELOCATION_PPC] = ...
    ADDR16: ClassVar[RELOCATION_PPC] = ...
    ADDR16_HA: ClassVar[RELOCATION_PPC] = ...
    ADDR16_HI: ClassVar[RELOCATION_PPC] = ...
    ADDR16_LO: ClassVar[RELOCATION_PPC] = ...
    ADDR24: ClassVar[RELOCATION_PPC] = ...
    ADDR32: ClassVar[RELOCATION_PPC] = ...
    DTPMOD32: ClassVar[RELOCATION_PPC] = ...
    DTPREL16: ClassVar[RELOCATION_PPC] = ...
    DTPREL16_HA: ClassVar[RELOCATION_PPC] = ...
    DTPREL16_HI: ClassVar[RELOCATION_PPC] = ...
    DTPREL16_LO: ClassVar[RELOCATION_PPC] = ...
    DTPREL32: ClassVar[RELOCATION_PPC] = ...
    GOT16: ClassVar[RELOCATION_PPC] = ...
    GOT16_HA: ClassVar[RELOCATION_PPC] = ...
    GOT16_HI: ClassVar[RELOCATION_PPC] = ...
    GOT16_LO: ClassVar[RELOCATION_PPC] = ...
    GOT_DTPREL16: ClassVar[RELOCATION_PPC] = ...
    GOT_DTPREL16_HA: ClassVar[RELOCATION_PPC] = ...
    GOT_DTPREL16_HI: ClassVar[RELOCATION_PPC] = ...
    GOT_DTPREL16_LO: ClassVar[RELOCATION_PPC] = ...
    GOT_TLSGD16: ClassVar[RELOCATION_PPC] = ...
    GOT_TLSGD16_HA: ClassVar[RELOCATION_PPC] = ...
    GOT_TLSGD16_HI: ClassVar[RELOCATION_PPC] = ...
    GOT_TLSGD16_LO: ClassVar[RELOCATION_PPC] = ...
    GOT_TLSLD16: ClassVar[RELOCATION_PPC] = ...
    GOT_TLSLD16_HA: ClassVar[RELOCATION_PPC] = ...
    GOT_TLSLD16_HI: ClassVar[RELOCATION_PPC] = ...
    GOT_TLSLD16_LO: ClassVar[RELOCATION_PPC] = ...
    GOT_TPREL16: ClassVar[RELOCATION_PPC] = ...
    GOT_TPREL16_HA: ClassVar[RELOCATION_PPC] = ...
    GOT_TPREL16_HI: ClassVar[RELOCATION_PPC] = ...
    GOT_TPREL16_LO: ClassVar[RELOCATION_PPC] = ...
    JMP_SLOT: ClassVar[RELOCATION_PPC] = ...
    LOCAL24PC: ClassVar[RELOCATION_PPC] = ...
    NONE: ClassVar[RELOCATION_PPC] = ...
    PLTREL24: ClassVar[RELOCATION_PPC] = ...
    REL14: ClassVar[RELOCATION_PPC] = ...
    REL14_BRNTAKEN: ClassVar[RELOCATION_PPC] = ...
    REL14_BRTAKEN: ClassVar[RELOCATION_PPC] = ...
    REL16: ClassVar[RELOCATION_PPC] = ...
    REL16_HA: ClassVar[RELOCATION_PPC] = ...
    REL16_HI: ClassVar[RELOCATION_PPC] = ...
    REL16_LO: ClassVar[RELOCATION_PPC] = ...
    REL24: ClassVar[RELOCATION_PPC] = ...
    REL32: ClassVar[RELOCATION_PPC] = ...
    RELATIVE: ClassVar[RELOCATION_PPC] = ...
    TLS: ClassVar[RELOCATION_PPC] = ...
    TLSGD: ClassVar[RELOCATION_PPC] = ...
    TLSLD: ClassVar[RELOCATION_PPC] = ...
    TPREL16: ClassVar[RELOCATION_PPC] = ...
    TPREL16_HA: ClassVar[RELOCATION_PPC] = ...
    TPREL16_HI: ClassVar[RELOCATION_PPC] = ...
    TPREL16_LO: ClassVar[RELOCATION_PPC] = ...
    TPREL32: ClassVar[RELOCATION_PPC] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_PPC64:
    __members__: ClassVar[dict] = ...  # read-only
    ADDR14: ClassVar[RELOCATION_PPC64] = ...
    ADDR14_BRNTAKEN: ClassVar[RELOCATION_PPC64] = ...
    ADDR14_BRTAKEN: ClassVar[RELOCATION_PPC64] = ...
    ADDR16: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_DS: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_HA: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_HI: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_HIGHER: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_HIGHERA: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_HIGHEST: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_HIGHESTA: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_LO: ClassVar[RELOCATION_PPC64] = ...
    ADDR16_LO_DS: ClassVar[RELOCATION_PPC64] = ...
    ADDR24: ClassVar[RELOCATION_PPC64] = ...
    ADDR32: ClassVar[RELOCATION_PPC64] = ...
    ADDR64: ClassVar[RELOCATION_PPC64] = ...
    DTPMOD64: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_DS: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_HA: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_HI: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_HIGHER: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_HIGHERA: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_HIGHEST: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_HIGHESTA: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_LO: ClassVar[RELOCATION_PPC64] = ...
    DTPREL16_LO_DS: ClassVar[RELOCATION_PPC64] = ...
    DTPREL64: ClassVar[RELOCATION_PPC64] = ...
    GOT16: ClassVar[RELOCATION_PPC64] = ...
    GOT16_DS: ClassVar[RELOCATION_PPC64] = ...
    GOT16_HA: ClassVar[RELOCATION_PPC64] = ...
    GOT16_HI: ClassVar[RELOCATION_PPC64] = ...
    GOT16_LO: ClassVar[RELOCATION_PPC64] = ...
    GOT16_LO_DS: ClassVar[RELOCATION_PPC64] = ...
    GOT_DTPREL16_DS: ClassVar[RELOCATION_PPC64] = ...
    GOT_DTPREL16_HA: ClassVar[RELOCATION_PPC64] = ...
    GOT_DTPREL16_HI: ClassVar[RELOCATION_PPC64] = ...
    GOT_DTPREL16_LO_DS: ClassVar[RELOCATION_PPC64] = ...
    GOT_TLSGD16: ClassVar[RELOCATION_PPC64] = ...
    GOT_TLSGD16_HA: ClassVar[RELOCATION_PPC64] = ...
    GOT_TLSGD16_HI: ClassVar[RELOCATION_PPC64] = ...
    GOT_TLSGD16_LO: ClassVar[RELOCATION_PPC64] = ...
    GOT_TLSLD16: ClassVar[RELOCATION_PPC64] = ...
    GOT_TLSLD16_HA: ClassVar[RELOCATION_PPC64] = ...
    GOT_TLSLD16_HI: ClassVar[RELOCATION_PPC64] = ...
    GOT_TLSLD16_LO: ClassVar[RELOCATION_PPC64] = ...
    GOT_TPREL16_DS: ClassVar[RELOCATION_PPC64] = ...
    GOT_TPREL16_HA: ClassVar[RELOCATION_PPC64] = ...
    GOT_TPREL16_HI: ClassVar[RELOCATION_PPC64] = ...
    GOT_TPREL16_LO_DS: ClassVar[RELOCATION_PPC64] = ...
    JMP_SLOT: ClassVar[RELOCATION_PPC64] = ...
    NONE: ClassVar[RELOCATION_PPC64] = ...
    REL14: ClassVar[RELOCATION_PPC64] = ...
    REL14_BRNTAKEN: ClassVar[RELOCATION_PPC64] = ...
    REL14_BRTAKEN: ClassVar[RELOCATION_PPC64] = ...
    REL16: ClassVar[RELOCATION_PPC64] = ...
    REL16_HA: ClassVar[RELOCATION_PPC64] = ...
    REL16_HI: ClassVar[RELOCATION_PPC64] = ...
    REL16_LO: ClassVar[RELOCATION_PPC64] = ...
    REL24: ClassVar[RELOCATION_PPC64] = ...
    REL32: ClassVar[RELOCATION_PPC64] = ...
    REL64: ClassVar[RELOCATION_PPC64] = ...
    RELATIVE: ClassVar[RELOCATION_PPC64] = ...
    TLS: ClassVar[RELOCATION_PPC64] = ...
    TLSGD: ClassVar[RELOCATION_PPC64] = ...
    TLSLD: ClassVar[RELOCATION_PPC64] = ...
    TOC: ClassVar[RELOCATION_PPC64] = ...
    TOC16: ClassVar[RELOCATION_PPC64] = ...
    TOC16_DS: ClassVar[RELOCATION_PPC64] = ...
    TOC16_HA: ClassVar[RELOCATION_PPC64] = ...
    TOC16_HI: ClassVar[RELOCATION_PPC64] = ...
    TOC16_LO: ClassVar[RELOCATION_PPC64] = ...
    TOC16_LO_DS: ClassVar[RELOCATION_PPC64] = ...
    TPREL16: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_DS: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_HA: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_HI: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_HIGHER: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_HIGHERA: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_HIGHEST: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_HIGHESTA: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_LO: ClassVar[RELOCATION_PPC64] = ...
    TPREL16_LO_DS: ClassVar[RELOCATION_PPC64] = ...
    TPREL64: ClassVar[RELOCATION_PPC64] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_PURPOSES:
    __members__: ClassVar[dict] = ...  # read-only
    DYNAMIC: ClassVar[RELOCATION_PURPOSES] = ...
    NONE: ClassVar[RELOCATION_PURPOSES] = ...
    OBJECT: ClassVar[RELOCATION_PURPOSES] = ...
    PLTGOT: ClassVar[RELOCATION_PURPOSES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_X86_64:
    __members__: ClassVar[dict] = ...  # read-only
    COPY: ClassVar[RELOCATION_X86_64] = ...
    DTPMOD64: ClassVar[RELOCATION_X86_64] = ...
    DTPOFF32: ClassVar[RELOCATION_X86_64] = ...
    DTPOFF64: ClassVar[RELOCATION_X86_64] = ...
    GLOB_DAT: ClassVar[RELOCATION_X86_64] = ...
    GOT32: ClassVar[RELOCATION_X86_64] = ...
    GOT64: ClassVar[RELOCATION_X86_64] = ...
    GOTOFF64: ClassVar[RELOCATION_X86_64] = ...
    GOTPC32: ClassVar[RELOCATION_X86_64] = ...
    GOTPC32_TLSDESC: ClassVar[RELOCATION_X86_64] = ...
    GOTPC64: ClassVar[RELOCATION_X86_64] = ...
    GOTPCREL: ClassVar[RELOCATION_X86_64] = ...
    GOTPCREL64: ClassVar[RELOCATION_X86_64] = ...
    GOTPCRELX: ClassVar[RELOCATION_X86_64] = ...
    GOTPLT64: ClassVar[RELOCATION_X86_64] = ...
    GOTTPOFF: ClassVar[RELOCATION_X86_64] = ...
    IRELATIVE: ClassVar[RELOCATION_X86_64] = ...
    JUMP_SLOT: ClassVar[RELOCATION_X86_64] = ...
    NONE: ClassVar[RELOCATION_X86_64] = ...
    PC16: ClassVar[RELOCATION_X86_64] = ...
    PC32: ClassVar[RELOCATION_X86_64] = ...
    PC32_BND: ClassVar[RELOCATION_X86_64] = ...
    PC64: ClassVar[RELOCATION_X86_64] = ...
    PC8: ClassVar[RELOCATION_X86_64] = ...
    PLT32: ClassVar[RELOCATION_X86_64] = ...
    PLT32_BND: ClassVar[RELOCATION_X86_64] = ...
    PLTOFF64: ClassVar[RELOCATION_X86_64] = ...
    R16: ClassVar[RELOCATION_X86_64] = ...
    R32: ClassVar[RELOCATION_X86_64] = ...
    R32S: ClassVar[RELOCATION_X86_64] = ...
    R64: ClassVar[RELOCATION_X86_64] = ...
    R8: ClassVar[RELOCATION_X86_64] = ...
    RELATIVE: ClassVar[RELOCATION_X86_64] = ...
    RELATIVE64: ClassVar[RELOCATION_X86_64] = ...
    REX_GOTPCRELX: ClassVar[RELOCATION_X86_64] = ...
    SIZE32: ClassVar[RELOCATION_X86_64] = ...
    SIZE64: ClassVar[RELOCATION_X86_64] = ...
    TLSDESC: ClassVar[RELOCATION_X86_64] = ...
    TLSDESC_CALL: ClassVar[RELOCATION_X86_64] = ...
    TLSGD: ClassVar[RELOCATION_X86_64] = ...
    TLSLD: ClassVar[RELOCATION_X86_64] = ...
    TPOFF32: ClassVar[RELOCATION_X86_64] = ...
    TPOFF64: ClassVar[RELOCATION_X86_64] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RELOCATION_i386:
    __members__: ClassVar[dict] = ...  # read-only
    COPY: ClassVar[RELOCATION_i386] = ...
    GLOB_DAT: ClassVar[RELOCATION_i386] = ...
    GOT32: ClassVar[RELOCATION_i386] = ...
    GOTOFF: ClassVar[RELOCATION_i386] = ...
    GOTPC: ClassVar[RELOCATION_i386] = ...
    IRELATIVE: ClassVar[RELOCATION_i386] = ...
    JUMP_SLOT: ClassVar[RELOCATION_i386] = ...
    NONE: ClassVar[RELOCATION_i386] = ...
    NUM: ClassVar[RELOCATION_i386] = ...
    PC16: ClassVar[RELOCATION_i386] = ...
    PC32: ClassVar[RELOCATION_i386] = ...
    PC8: ClassVar[RELOCATION_i386] = ...
    PLT32: ClassVar[RELOCATION_i386] = ...
    R16: ClassVar[RELOCATION_i386] = ...
    R32: ClassVar[RELOCATION_i386] = ...
    R32PLT: ClassVar[RELOCATION_i386] = ...
    R8: ClassVar[RELOCATION_i386] = ...
    RELATIVE: ClassVar[RELOCATION_i386] = ...
    TLS_DESC: ClassVar[RELOCATION_i386] = ...
    TLS_DESC_CALL: ClassVar[RELOCATION_i386] = ...
    TLS_DTPMOD32: ClassVar[RELOCATION_i386] = ...
    TLS_DTPOFF32: ClassVar[RELOCATION_i386] = ...
    TLS_GD: ClassVar[RELOCATION_i386] = ...
    TLS_GD_32: ClassVar[RELOCATION_i386] = ...
    TLS_GD_CALL: ClassVar[RELOCATION_i386] = ...
    TLS_GD_POP: ClassVar[RELOCATION_i386] = ...
    TLS_GD_PUSH: ClassVar[RELOCATION_i386] = ...
    TLS_GOTDESC: ClassVar[RELOCATION_i386] = ...
    TLS_GOTIE: ClassVar[RELOCATION_i386] = ...
    TLS_IE: ClassVar[RELOCATION_i386] = ...
    TLS_IE_32: ClassVar[RELOCATION_i386] = ...
    TLS_LDM: ClassVar[RELOCATION_i386] = ...
    TLS_LDM_32: ClassVar[RELOCATION_i386] = ...
    TLS_LDM_CALL: ClassVar[RELOCATION_i386] = ...
    TLS_LDM_POP: ClassVar[RELOCATION_i386] = ...
    TLS_LDM_PUSH: ClassVar[RELOCATION_i386] = ...
    TLS_LDO_32: ClassVar[RELOCATION_i386] = ...
    TLS_LE: ClassVar[RELOCATION_i386] = ...
    TLS_LE_32: ClassVar[RELOCATION_i386] = ...
    TLS_TPOFF: ClassVar[RELOCATION_i386] = ...
    TLS_TPOFF32: ClassVar[RELOCATION_i386] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Relocation(lief.Relocation):
    addend: int
    info: int
    purpose: lief.ELF.RELOCATION_PURPOSES
    symbol: lief.ELF.Symbol
    type: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arch: lief.ELF.ARCH) -> None: ...
    @overload
    def __init__(self, address: int, type: int = ..., addend: int = ..., is_rela: bool = ...) -> None: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def has_symbol(self) -> bool: ...
    @property
    def is_rel(self) -> bool: ...
    @property
    def is_rela(self) -> bool: ...
    @property
    def section(self) -> lief.ELF.Section: ...

class SECTION_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    ALLOC: ClassVar[SECTION_FLAGS] = ...
    EXECINSTR: ClassVar[SECTION_FLAGS] = ...
    GROUP: ClassVar[SECTION_FLAGS] = ...
    HEX_GPREL: ClassVar[SECTION_FLAGS] = ...
    INFO_LINK: ClassVar[SECTION_FLAGS] = ...
    LINK_ORDER: ClassVar[SECTION_FLAGS] = ...
    MASKOS: ClassVar[SECTION_FLAGS] = ...
    MASKPROC: ClassVar[SECTION_FLAGS] = ...
    MERGE: ClassVar[SECTION_FLAGS] = ...
    MIPS_STRING: ClassVar[SECTION_FLAGS] = ...
    NONE: ClassVar[SECTION_FLAGS] = ...
    OS_NONCONFORMING: ClassVar[SECTION_FLAGS] = ...
    SHF_CP_SECTION: ClassVar[SECTION_FLAGS] = ...
    STRINGS: ClassVar[SECTION_FLAGS] = ...
    TLS: ClassVar[SECTION_FLAGS] = ...
    WRITE: ClassVar[SECTION_FLAGS] = ...
    XCORE_SHF_CP_SECTION: ClassVar[SECTION_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SECTION_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    ANDROID_REL: ClassVar[SECTION_TYPES] = ...
    ANDROID_RELA: ClassVar[SECTION_TYPES] = ...
    ARM_ATTRIBUTES: ClassVar[SECTION_TYPES] = ...
    ARM_DEBUGOVERLAY: ClassVar[SECTION_TYPES] = ...
    ARM_EXIDX: ClassVar[SECTION_TYPES] = ...
    ARM_OVERLAYSECTION: ClassVar[SECTION_TYPES] = ...
    ARM_PREEMPTMAP: ClassVar[SECTION_TYPES] = ...
    DYNAMIC: ClassVar[SECTION_TYPES] = ...
    DYNSYM: ClassVar[SECTION_TYPES] = ...
    FINI_ARRAY: ClassVar[SECTION_TYPES] = ...
    GNU_ATTRIBUTES: ClassVar[SECTION_TYPES] = ...
    GNU_HASH: ClassVar[SECTION_TYPES] = ...
    GNU_VERDEF: ClassVar[SECTION_TYPES] = ...
    GNU_VERNEED: ClassVar[SECTION_TYPES] = ...
    GROUP: ClassVar[SECTION_TYPES] = ...
    HASH: ClassVar[SECTION_TYPES] = ...
    HIOS: ClassVar[SECTION_TYPES] = ...
    HIPROC: ClassVar[SECTION_TYPES] = ...
    HIUSER: ClassVar[SECTION_TYPES] = ...
    INIT_ARRAY: ClassVar[SECTION_TYPES] = ...
    LLVM_ADDRSIG: ClassVar[SECTION_TYPES] = ...
    LOOS: ClassVar[SECTION_TYPES] = ...
    LOPROC: ClassVar[SECTION_TYPES] = ...
    LOUSER: ClassVar[SECTION_TYPES] = ...
    NOBITS: ClassVar[SECTION_TYPES] = ...
    NOTE: ClassVar[SECTION_TYPES] = ...
    NULL: ClassVar[SECTION_TYPES] = ...
    PREINIT_ARRAY: ClassVar[SECTION_TYPES] = ...
    PROGBITS: ClassVar[SECTION_TYPES] = ...
    REL: ClassVar[SECTION_TYPES] = ...
    RELA: ClassVar[SECTION_TYPES] = ...
    RELR: ClassVar[SECTION_TYPES] = ...
    SHLIB: ClassVar[SECTION_TYPES] = ...
    STRTAB: ClassVar[SECTION_TYPES] = ...
    SYMTAB: ClassVar[SECTION_TYPES] = ...
    SYMTAB_SHNDX: ClassVar[SECTION_TYPES] = ...
    X86_64_UNWIND: ClassVar[SECTION_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SEGMENT_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    NONE: ClassVar[SEGMENT_FLAGS] = ...
    R: ClassVar[SEGMENT_FLAGS] = ...
    W: ClassVar[SEGMENT_FLAGS] = ...
    X: ClassVar[SEGMENT_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SEGMENT_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    ARM_ARCHEXT: ClassVar[SEGMENT_TYPES] = ...
    ARM_UNWIND: ClassVar[SEGMENT_TYPES] = ...
    DYNAMIC: ClassVar[SEGMENT_TYPES] = ...
    GNU_EH_FRAME: ClassVar[SEGMENT_TYPES] = ...
    GNU_PROPERTY: ClassVar[SEGMENT_TYPES] = ...
    GNU_RELRO: ClassVar[SEGMENT_TYPES] = ...
    GNU_STACK: ClassVar[SEGMENT_TYPES] = ...
    INTERP: ClassVar[SEGMENT_TYPES] = ...
    LOAD: ClassVar[SEGMENT_TYPES] = ...
    NOTE: ClassVar[SEGMENT_TYPES] = ...
    NULL: ClassVar[SEGMENT_TYPES] = ...
    PHDR: ClassVar[SEGMENT_TYPES] = ...
    SHLIB: ClassVar[SEGMENT_TYPES] = ...
    TLS: ClassVar[SEGMENT_TYPES] = ...
    UNWIND: ClassVar[SEGMENT_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_BINDINGS:
    __members__: ClassVar[dict] = ...  # read-only
    GLOBAL: ClassVar[SYMBOL_BINDINGS] = ...
    GNU_UNIQUE: ClassVar[SYMBOL_BINDINGS] = ...
    LOCAL: ClassVar[SYMBOL_BINDINGS] = ...
    WEAK: ClassVar[SYMBOL_BINDINGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_SECTION_INDEX:
    __members__: ClassVar[dict] = ...  # read-only
    ABS: ClassVar[SYMBOL_SECTION_INDEX] = ...
    COMMON: ClassVar[SYMBOL_SECTION_INDEX] = ...
    UNDEF: ClassVar[SYMBOL_SECTION_INDEX] = ...
    XINDEX: ClassVar[SYMBOL_SECTION_INDEX] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    COMMON: ClassVar[SYMBOL_TYPES] = ...
    FILE: ClassVar[SYMBOL_TYPES] = ...
    FUNC: ClassVar[SYMBOL_TYPES] = ...
    GNU_IFUNC: ClassVar[SYMBOL_TYPES] = ...
    NOTYPE: ClassVar[SYMBOL_TYPES] = ...
    OBJECT: ClassVar[SYMBOL_TYPES] = ...
    SECTION: ClassVar[SYMBOL_TYPES] = ...
    TLS: ClassVar[SYMBOL_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_VISIBILITY:
    __members__: ClassVar[dict] = ...  # read-only
    DEFAULT: ClassVar[SYMBOL_VISIBILITY] = ...
    HIDDEN: ClassVar[SYMBOL_VISIBILITY] = ...
    INTERNAL: ClassVar[SYMBOL_VISIBILITY] = ...
    PROTECTED: ClassVar[SYMBOL_VISIBILITY] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Section(lief.Section):
    class it_segments:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Segment: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Segment: ...
    alignment: int
    entry_size: int
    file_offset: int
    flags: int
    information: Any
    link: int
    type: lief.ELF.SECTION_TYPES
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, type: lief.ELF.SECTION_TYPES = ...) -> None: ...
    @overload
    def __init__(self, arg0: lief.ELF.Section, arg1: List[int], arg2: lief.ELF.ELF_CLASS) -> None: ...
    def add(self, flag: lief.ELF.SECTION_FLAGS) -> None: ...
    def as_frame(self) -> lief.ELF.Section: ...
    def clear(self, value: int = ...) -> lief.ELF.Section: ...
    @overload
    def has(self, flag: lief.ELF.SECTION_FLAGS) -> bool: ...
    @overload
    def has(self, segment: lief.ELF.Segment) -> bool: ...
    def remove(self, flag: lief.ELF.SECTION_FLAGS) -> None: ...
    @overload
    def __contains__(self, arg0: lief.ELF.SECTION_FLAGS) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.Segment) -> bool: ...
    def __iadd__(self, arg0: lief.ELF.SECTION_FLAGS) -> lief.ELF.Section: ...
    def __isub__(self, arg0: lief.ELF.SECTION_FLAGS) -> lief.ELF.Section: ...
    @property
    def flags_list(self) -> Set[lief.ELF.SECTION_FLAGS]: ...
    @property
    def is_frame(self) -> bool: ...
    @property
    def original_size(self) -> int: ...
    @property
    def segments(self) -> lief.ELF.Section.it_segments: ...

class Segment(lief.Object):
    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.Section: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Section: ...
    alignment: int
    content: memoryview
    file_offset: int
    flags: lief.ELF.SEGMENT_FLAGS
    physical_address: int
    physical_size: int
    type: lief.ELF.SEGMENT_TYPES
    virtual_address: int
    virtual_size: int
    def __init__(self) -> None: ...
    def add(self, flag: lief.ELF.SEGMENT_FLAGS) -> None: ...
    def from_raw(self, *args, **kwargs) -> Any: ...
    @overload
    def has(self, flag: lief.ELF.SEGMENT_FLAGS) -> bool: ...
    @overload
    def has(self, section: lief.ELF.Section) -> bool: ...
    @overload
    def has(self, section_name: str) -> bool: ...
    def remove(self, flag: lief.ELF.SEGMENT_FLAGS) -> None: ...
    @overload
    def __contains__(self, arg0: lief.ELF.SEGMENT_FLAGS) -> bool: ...
    @overload
    def __contains__(self, arg0: lief.ELF.Section) -> bool: ...
    @overload
    def __contains__(self, arg0: str) -> bool: ...
    def __iadd__(self, arg0: lief.ELF.SEGMENT_FLAGS) -> lief.ELF.Segment: ...
    def __isub__(self, arg0: lief.ELF.SEGMENT_FLAGS) -> lief.ELF.Segment: ...
    @property
    def sections(self) -> lief.ELF.Segment.it_sections: ...

class Symbol(lief.Symbol):
    binding: lief.ELF.SYMBOL_BINDINGS
    exported: bool
    imported: bool
    information: int
    other: int
    shndx: int
    size: int
    type: lief.ELF.SYMBOL_TYPES
    value: int
    visibility: lief.ELF.SYMBOL_VISIBILITY
    def __init__(self) -> None: ...
    @property
    def demangled_name(self) -> str: ...
    @property
    def has_version(self) -> bool: ...
    @property
    def is_function(self) -> bool: ...
    @property
    def is_static(self) -> bool: ...
    @property
    def is_variable(self) -> bool: ...
    @property
    def section(self) -> Any: ...
    @property
    def symbol_version(self) -> lief.ELF.SymbolVersion: ...

class SymbolVersion(lief.Object):
    global_: ClassVar[lief.ELF.SymbolVersion] = ...  # read-only
    local: ClassVar[lief.ELF.SymbolVersion] = ...  # read-only
    symbol_version_auxiliary: lief.ELF.SymbolVersionAux
    value: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    @property
    def has_auxiliary_version(self) -> bool: ...

class SymbolVersionAux(lief.Object):
    name: object
    def __init__(self, *args, **kwargs) -> None: ...

class SymbolVersionAuxRequirement(SymbolVersionAux):
    flags: int
    hash: int
    other: int
    def __init__(self) -> None: ...

class SymbolVersionDefinition(lief.Object):
    class it_version_aux:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.SymbolVersionAux: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersionAux: ...
    flags: int
    hash: int
    version: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def auxiliary_symbols(self) -> lief.ELF.SymbolVersionDefinition.it_version_aux: ...

class SymbolVersionRequirement(lief.Object):
    class it_aux_requirement:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.ELF.SymbolVersionAuxRequirement: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersionAuxRequirement: ...
    name: str
    version: int
    def __init__(self, *args, **kwargs) -> None: ...
    def add_auxiliary_requirement(self, arg0: lief.ELF.SymbolVersionAuxRequirement) -> lief.ELF.SymbolVersionAuxRequirement: ...
    def get_auxiliary_symbols(self) -> lief.ELF.SymbolVersionRequirement.it_aux_requirement: ...

class SysvHash(lief.Object):
    nchain: int
    def __init__(self) -> None: ...
    @property
    def buckets(self) -> List[int]: ...
    @property
    def chains(self) -> List[int]: ...
    @property
    def nbucket(self) -> int: ...

class VERSION:
    __members__: ClassVar[dict] = ...  # read-only
    CURRENT: ClassVar[VERSION] = ...
    NONE: ClassVar[VERSION] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

@overload
def parse(filename: str, dynsym_count_method: lief.ELF.DYNSYM_COUNT_METHODS = ...) -> lief.ELF.Binary | None: ...
@overload
def parse(raw: List[int], name: str = ..., dynsym_count_method: lief.ELF.DYNSYM_COUNT_METHODS = ...) -> lief.ELF.Binary | None: ...
@overload
def parse(io: object, name: str = ..., dynsym_count_method: lief.ELF.DYNSYM_COUNT_METHODS = ...) -> lief.ELF.Binary | None: ...
