'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var bytes = 'b';
var kiloBytes = 'k';
var megaBytes = 'm';
var gigaBytes = 'g';
var teraBytes = 't';

function isDefined(value) {
  return value !== undefined;
}

var ByteAssertion = function () {
  function ByteAssertion(number) {
    _classCallCheck(this, ByteAssertion);

    this.number = number;
  }

  _createClass(ByteAssertion, [{
    key: '_parse',
    value: function _parse(expression) {
      var matches = new RegExp('(<=|>=|<|>|==?)?\s*(.*?)\s*([kmgt])?b?\s*$').exec(expression);

      return {
        value: isDefined(matches[2]) ? parseInt(matches[2]) : 0,
        operator: matches[1] || '==',
        unit: matches[3] || bytes
      };
    }
  }, {
    key: '_magnify',
    value: function _magnify(value, unit) {
      if (unit === kiloBytes) return value *= 1024;
      if (unit === megaBytes) return value *= 1024 * 1024;
      if (unit === gigaBytes) return value *= 1024 * 1024 * 1024;
      if (unit === teraBytes) return value *= 1024 * 1024 * 1024 * 1024;

      return value;
    }
  }, {
    key: 'assert',
    value: function assert(expression) {
      var parts = this._parse(expression);

      if (parts.operator === '<') return this.lessThan(parts.value, parts.unit);
      if (parts.operator === '<=') return this.lessThanOrEqual(parts.value, parts.unit);
      if (parts.operator === '>') return this.greaterThan(parts.value, parts.unit);
      if (parts.operator === '>=') return this.greaterThanOrEqual(parts.value, parts.unit);

      return this.equalTo(parts.value, parts.unit);
    }
  }, {
    key: 'lessThan',
    value: function lessThan(unitNumber, unit) {
      var magnifiedValue = this._magnify(unitNumber, unit);
      return isDefined(this.number) && this.number < magnifiedValue;
    }
  }, {
    key: 'lessThanOrEqual',
    value: function lessThanOrEqual(unitNumber, unit) {
      var magnifiedValue = this._magnify(unitNumber, unit);
      return isDefined(this.number) && this.number <= magnifiedValue;
    }
  }, {
    key: 'equalTo',
    value: function equalTo(number, unit) {
      var magnifiedValue = this._magnify(number, unit);
      return isDefined(this.number) && this.number === magnifiedValue;
    }
  }, {
    key: 'greaterThan',
    value: function greaterThan(number, unit) {
      var magnifiedValue = this._magnify(number, unit);
      return isDefined(this.number) && this.number > magnifiedValue;
    }
  }, {
    key: 'greaterThanOrEqual',
    value: function greaterThanOrEqual(number, unit) {
      var magnifiedValue = this._magnify(number, unit);
      return isDefined(this.number) && this.number >= magnifiedValue;
    }
  }]);

  return ByteAssertion;
}();

exports.default = ByteAssertion;