module.exports = hoist

function hoist(ast){

  var parentStack = []
  var variables = []
  var functions = []

  if (Array.isArray(ast)){

    walkAll(ast)
    prependScope(ast, variables, functions)
    
  } else {
    walk(ast)
  }

  return ast

  // walk through each node of a program of block statement
  function walkAll(nodes){
    var result = null
    for (var i=0;i<nodes.length;i++){
      var childNode = nodes[i]
      if (childNode.type === 'EmptyStatement') continue
      var result = walk(childNode)
      if (result === 'remove'){
        nodes.splice(i--, 1)
      }
    }
  }

  function walk(node){
    var parent = parentStack[parentStack.length-1]
    var remove = false
    parentStack.push(node)

    var excludeBody = false
    if (shouldScope(node, parent)){
      hoist(node.body)
      excludeBody = true
    }

    if (node.type === 'VariableDeclarator'){
      variables.push(node)
    }

    if (node.type === 'FunctionDeclaration'){
      functions.push(node)
      remove = true
    }

    for (var key in node){
      if (key === 'type' || (excludeBody && key === 'body')) continue
      if (key in node && node[key] && typeof node[key] == 'object'){
        if (node[key].type){
          walk(node[key])
        } else if (Array.isArray(node[key])){
          walkAll(node[key])
        }
      }
    }

    parentStack.pop()
    if (remove){
      return 'remove'
    }
  }
}

function shouldScope(node, parent){
  if (node.type === 'Program'){
    return true
  } else if (node.type === 'BlockStatement'){
    if (parent && (parent.type === 'FunctionExpression' || parent.type === 'FunctionDeclaration')){
      return true
    }
  }
}

function prependScope(nodes, variables, functions){
  if (variables && variables.length){
    var declarations = []
    for (var i=0;i<variables.length;i++){
      declarations.push({
        type: 'VariableDeclarator', 
        id: variables[i].id,
        init: null
      })
    }
    
    nodes.unshift({
      type: 'VariableDeclaration', 
      kind: 'var', 
      declarations: declarations
    })

  }

  if (functions && functions.length){
    for (var i=0;i<functions.length;i++){
      nodes.unshift(functions[i]) 
    }
  }
}