/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.sql.lexer.syntax;

import com.jsql.view.swing.sql.lexer.syntax.Token;

public class SQLToken
extends Token {
    public static final int RESERVED_WORD = 256;
    public static final int IDENTIFIER = 512;
    public static final int LITERAL_STRING = 768;
    public static final int LITERAL_BIT_STRING = 784;
    public static final int LITERAL_INTEGER = 800;
    public static final int LITERAL_FLOAT = 816;
    public static final int SEPARATOR = 1024;
    public static final int OPERATOR = 1280;
    public static final int COMMENT_TRADITIONAL = 3328;
    public static final int COMMENT_END_OF_LINE = 3344;
    public static final int WHITE_SPACE = 3584;
    public static final int ERROR = 3840;
    public static final int ERROR_UNCLOSED_COMMENT = 3842;
    public static final int ERROR_UNCLOSED_STRING = 3843;
    public static final int ERROR_UNCLOSED_BIT_STRING = 3844;
    public static final int ERROR_BAD_BIT_STRING = 3845;
    private final int id;
    private final String contents;
    private final int lineNumber;
    private final int charBegin;
    private final int charEnd;
    private final int state;

    public SQLToken(int id, String contents, int lineNumber, int charBegin, int charEnd) {
        this(id, contents, lineNumber, charBegin, charEnd, -1);
    }

    public SQLToken(int id, String contents, int lineNumber, int charBegin, int charEnd, int state) {
        this.id = id;
        this.contents = contents;
        this.lineNumber = lineNumber;
        this.charBegin = charBegin;
        this.charEnd = charEnd;
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getContents() {
        return this.contents;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getCharBegin() {
        return this.charBegin;
    }

    @Override
    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isReservedWord() {
        return this.id >> 8 == 1;
    }

    public boolean isIdentifier() {
        return this.id >> 8 == 2;
    }

    public boolean isLiteral() {
        return this.id >> 8 == 3;
    }

    public boolean isSeparator() {
        return this.id >> 8 == 4;
    }

    public boolean isOperator() {
        return this.id >> 8 == 5;
    }

    @Override
    public boolean isComment() {
        return this.id >> 8 == 13;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.id >> 8 == 14;
    }

    @Override
    public boolean isError() {
        return this.id >> 8 == 15;
    }

    @Override
    public String getDescription() {
        if (this.isReservedWord()) {
            return "reservedWord";
        }
        if (this.isIdentifier()) {
            return "identifier";
        }
        if (this.isLiteral()) {
            return "literal";
        }
        if (this.isSeparator()) {
            return "separator";
        }
        if (this.isOperator()) {
            return "operator";
        }
        if (this.isComment()) {
            return "comment";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        if (this.isError()) {
            return "error";
        }
        return "unknown";
    }

    @Override
    public String errorString() {
        String s;
        if (this.isError()) {
            s = "Error on line " + this.lineNumber + ": ";
            switch (this.id) {
                case 3840: {
                    s = s + "Unexpected token: " + this.contents;
                    break;
                }
                case 3842: {
                    s = s + "Unclosed comment: " + this.contents;
                    break;
                }
                case 3843: {
                    s = s + "Unclosed string literal: " + this.contents;
                    break;
                }
                case 3844: {
                    s = s + "Unclosed bit-string literal: " + this.contents;
                    break;
                }
                case 3845: {
                    s = s + "Bit-strings can only contain 0 and 1: " + this.contents;
                }
            }
        } else {
            s = null;
        }
        return s;
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.id) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

