/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.view.swing.manager.Manager;
import com.jsql.view.swing.manager.util.CoderListener;
import com.jsql.view.swing.manager.util.MenuBarCoder;
import com.jsql.view.swing.panel.util.HTMLEditorKitTextPaneWrap;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.splitpane.JSplitPaneWithZeroSizeDivider;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JPopupTextPane;
import com.jsql.view.swing.text.JTextAreaPlaceholder;
import com.jsql.view.swing.text.listener.DocumentListenerEditing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ManagerCoder
extends JPanel
implements Manager {
    private final JTextArea textInput;
    private final JTextPane result;
    private JMenuItem menuMethod;
    private final transient CoderListener actionCoder = new CoderListener(this);

    public ManagerCoder() {
        super(new BorderLayout());
        this.textInput = (JTextArea)new JPopupTextArea(new JTextAreaPlaceholder("Type a string to convert")).getProxy();
        this.textInput.getCaret().setBlinkRate(500);
        this.textInput.setEditable(true);
        this.textInput.setLineWrap(true);
        this.textInput.setName("textInputManagerCoder");
        this.textInput.getDocument().addDocumentListener(new DocumentListenerEditing(){

            @Override
            public void process() {
                ManagerCoder.this.actionCoder.actionPerformed();
            }
        });
        JPanel topMixed = this.initializeTopPanel();
        this.result = (JTextPane)new JPopupTextPane("Result of conversion").getProxy();
        this.result.setContentType("text/html");
        this.result.setEditorKit(new HTMLEditorKitTextPaneWrap());
        this.result.setName("resultManagerCoder");
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)new LightScrollPane(0, 0, 0, 0, this.result), "Center");
        JSplitPaneWithZeroSizeDivider divider = new JSplitPaneWithZeroSizeDivider(0);
        divider.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        divider.setDividerSize(0);
        divider.setResizeWeight(0.5);
        divider.setTopComponent(topMixed);
        divider.setBottomComponent(bottom);
        this.add((Component)divider, "Center");
    }

    private JPanel initializeTopPanel() {
        JPanel topMixed = new JPanel(new BorderLayout());
        JPanel middleLine = new JPanel();
        middleLine.setLayout(new BorderLayout());
        middleLine.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1));
        MenuBarCoder comboMenubar = this.initializeMenuBarCoder();
        this.menuMethod.setText("Encode to Base64");
        middleLine.add(comboMenubar);
        topMixed.add((Component)new LightScrollPane(0, 0, 1, 0, this.textInput), "Center");
        topMixed.add((Component)middleLine, "South");
        return topMixed;
    }

    private MenuBarCoder initializeMenuBarCoder() {
        LinkedHashMap<String, JMenu> mapMenus = new LinkedHashMap<String, JMenu>();
        mapMenus.put("Base16", new JMenu("Base16"));
        mapMenus.put("Base32", new JMenu("Base32"));
        mapMenus.put("Base58", new JMenu("Base58"));
        mapMenus.put("Base64", new JMenu("Base64"));
        mapMenus.put("Hex", new JMenu("Hex"));
        mapMenus.put("Url", new JMenu("Url"));
        mapMenus.put("Unicode", new JMenu("Unicode"));
        JMenu menuHtml = new JMenu("Html");
        mapMenus.put("Html", menuHtml);
        mapMenus.put("Base64(zipped)", new JMenu("Base64(zipped)"));
        mapMenus.put("Hex(zipped)", new JMenu("Hex(zipped)"));
        JMenuItem menuEncodeHtmlDecimal = new JMenuItem("Encode to Html (decimal)");
        menuHtml.add(menuEncodeHtmlDecimal);
        menuEncodeHtmlDecimal.addActionListener(this.actionCoder);
        menuEncodeHtmlDecimal.addChangeListener(new ChangeMenuListener("Encode to Html (decimal)"));
        mapMenus.forEach((key, value) -> {
            JMenuItem menuEncode = new JMenuItem("Encode to " + key);
            menuEncode.addActionListener(this.actionCoder);
            menuEncode.addChangeListener(new ChangeMenuListener("Encode to " + key));
            menuEncode.setName("encodeTo" + key);
            JMenuItem menuDecode = new JMenuItem("Decode from " + key);
            menuDecode.addActionListener(this.actionCoder);
            menuDecode.addChangeListener(new ChangeMenuListener("Decode from " + key));
            menuDecode.setName("decodeFrom" + key);
            value.add(menuEncode);
            value.add(menuDecode);
            value.setName((String)key);
        });
        mapMenus.put("Hash", new JMenu("Hash"));
        ((JMenu)mapMenus.get("Hash")).setName("Hash");
        Stream.of("Adler32", "Crc16", "Crc32", "Crc64", "Md2", "Md4", "Md5", "Sha-1", "Sha-256", "Sha-384", "Sha-512", "Mysql").forEach(hash -> {
            JMenuItem menuEncode = new JMenuItem("Hash to " + hash);
            menuEncode.addActionListener(this.actionCoder);
            menuEncode.addChangeListener(new ChangeMenuListener("Hash to " + hash));
            menuEncode.setName("hashTo" + hash);
            ((JMenu)mapMenus.get("Hash")).add(menuEncode);
        });
        JMenu comboMenu = MenuBarCoder.createMenu("Choose method...");
        this.menuMethod = comboMenu;
        this.menuMethod.setName("menuMethodManagerCoder");
        for (JMenu menu : mapMenus.values()) {
            comboMenu.add(menu);
        }
        MenuBarCoder comboMenubar = new MenuBarCoder(comboMenu);
        comboMenubar.setOpaque(false);
        comboMenubar.setBorder(null);
        return comboMenubar;
    }

    public JTextArea getTextInput() {
        return this.textInput;
    }

    public JMenuItem getMenuMethod() {
        return this.menuMethod;
    }

    public JTextPane getResult() {
        return this.result;
    }

    private class ChangeMenuListener
    implements ChangeListener {
        private final String nameMethod;

        ChangeMenuListener(String nameMethod) {
            this.nameMethod = nameMethod;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JMenuItem item;
            if (e.getSource() instanceof JMenuItem && ((item = (JMenuItem)e.getSource()).isSelected() || item.isArmed())) {
                ManagerCoder.this.actionCoder.actionPerformed(this.nameMethod);
            }
        }
    }
}

