/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractListTransfertHandler
extends TransferHandler {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected transient List<ItemList> dragPaths = null;

    protected abstract String initializeTransferable();

    protected abstract void parseStringDrop(TransferHandler.TransferSupport var1, DnDList var2, DefaultListModel<ItemList> var3);

    protected abstract List<Integer> initializeStringPaste(String var1, int var2, DefaultListModel<ItemList> var3);

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        DnDList list = (DnDList)c;
        this.dragPaths = list.getSelectedValuesList();
        String stringTransferable = this.initializeTransferable();
        return new StringSelection(stringTransferable.trim());
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action == 2) {
            JList list = (JList)c;
            DefaultListModel model = (DefaultListModel)list.getModel();
            for (ItemList itemPath : this.dragPaths) {
                try {
                    model.remove(model.indexOf(itemPath));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
                }
            }
            this.dragPaths = null;
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.stringFlavor) || support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        DnDList list = (DnDList)support.getComponent();
        DefaultListModel listModel = (DefaultListModel)list.getModel();
        if (support.isDrop()) {
            if (support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                this.parseStringDrop(support, list, listModel);
            } else if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.parseFileDrop(support, list);
            }
        } else {
            Transferable transferableFromClipboard = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferableFromClipboard != null) {
                if (transferableFromClipboard.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    this.parseStringPaste(list, listModel, transferableFromClipboard);
                } else if (transferableFromClipboard.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    this.parseFilePaste(list, transferableFromClipboard);
                }
            }
        }
        return true;
    }

    private void parseFileDrop(TransferHandler.TransferSupport support, DnDList list) {
        JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
        int childIndex = dl.getIndex();
        try {
            list.dropPasteFile((List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor), childIndex);
        }
        catch (UnsupportedFlavorException | IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    private void parseStringPaste(DnDList list, DefaultListModel<ItemList> listModel, Transferable transferableFromClipboard) {
        try {
            String clipboardText = (String)transferableFromClipboard.getTransferData(DataFlavor.stringFlavor);
            int selectedIndexPaste = Math.max(list.getSelectedIndex(), 0);
            list.clearSelection();
            List<Integer> selectedIndexes = this.initializeStringPaste(clipboardText, selectedIndexPaste, listModel);
            int[] selectedIndexesPasted = new int[selectedIndexes.size()];
            int i = 0;
            for (Integer selectedIndex : selectedIndexes) {
                selectedIndexesPasted[i] = selectedIndex;
                ++i;
            }
            list.setSelectedIndices(selectedIndexesPasted);
            list.scrollRectToVisible(list.getCellBounds(list.getMinSelectionIndex(), list.getMaxSelectionIndex()));
        }
        catch (UnsupportedFlavorException | IOException | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    private void parseFilePaste(DnDList list, Transferable transferableFromClipboard) {
        try {
            int selectedIndex = Math.max(list.getSelectedIndex(), 0);
            list.clearSelection();
            list.dropPasteFile((List)transferableFromClipboard.getTransferData(DataFlavor.javaFileListFlavor), selectedIndex);
        }
        catch (UnsupportedFlavorException | IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

