/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.suspendable;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.model.bean.database.Table;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.AbstractSlidingException;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.LoopDetectedSlidingException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuspendableGetRows
extends AbstractSuspendable {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public SuspendableGetRows(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public String run(Object ... args) throws AbstractSlidingException {
        String initialSqlQuery = (String)args[0];
        String[] sourcePage = (String[])args[1];
        boolean isMultipleRows = (Boolean)args[2];
        int countRowsToFind = (Integer)args[3];
        AbstractElementDatabase elementDatabase = (AbstractElementDatabase)args[4];
        String metadataInjectionProcess = (String)args[5];
        this.injectionModel.getMediatorUtils().getThreadUtil().put(elementDatabase, this);
        AbstractStrategy strategy = this.injectionModel.getMediatorStrategy().getStrategy();
        if (strategy == null) {
            return "";
        }
        StringBuilder slidingWindowAllRows = new StringBuilder();
        StringBuilder slidingWindowCurrentRow = new StringBuilder();
        String previousChunk = "";
        int countAllRows = 0;
        int charPositionInCurrentRow = 1;
        int countInfiniteLoop = 0;
        String queryGetRows = this.getQuery(initialSqlQuery, countAllRows);
        while (true) {
            this.checkSuspend(strategy, slidingWindowAllRows, slidingWindowCurrentRow);
            sourcePage[0] = strategy.inject(queryGetRows, Integer.toString(charPositionInCurrentRow), this, metadataInjectionProcess);
            Matcher regexLeadFound = this.parseLeadFound(sourcePage[0], strategy.getPerformanceLength());
            Matcher regexTrailOnlyFound = this.parseTrailOnlyFound(sourcePage[0]);
            if ((!regexLeadFound.find() || regexTrailOnlyFound.find()) && isMultipleRows && StringUtils.isNotEmpty(slidingWindowAllRows.toString())) {
                this.sendProgress(countRowsToFind, countRowsToFind, elementDatabase);
                break;
            }
            try {
                String currentChunk = regexLeadFound.group(1);
                if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isUnicodeDecodeDisabled()) {
                    currentChunk = StringEscapeUtils.unescapeJava(currentChunk);
                }
                if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isUrlDecodeDisabled()) {
                    try {
                        currentChunk = URLDecoder.decode(currentChunk, StandardCharsets.UTF_8);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.log(LogLevelUtil.CONSOLE_JAVA, "URL decoding result failing, ignoring", (Throwable)e);
                    }
                }
                countInfiniteLoop = this.checkInfinite(countInfiniteLoop, previousChunk, currentChunk, slidingWindowCurrentRow, slidingWindowAllRows);
                previousChunk = currentChunk;
                slidingWindowCurrentRow.append(currentChunk);
                this.sendChunk(currentChunk);
            }
            catch (IllegalArgumentException | IllegalStateException | OutOfMemoryError e) {
                this.endInjection(elementDatabase, e);
            }
            int countChunkRows = this.getCountRows(slidingWindowCurrentRow);
            this.sendProgress(countRowsToFind, countAllRows + countChunkRows, elementDatabase);
            if (countChunkRows > 0 || slidingWindowCurrentRow.toString().matches("(?s).*\\x01\\x03\\x03\\x07.*")) {
                this.scrapeTrailJunk(slidingWindowCurrentRow);
                slidingWindowAllRows.append((CharSequence)slidingWindowCurrentRow);
                if (isMultipleRows) {
                    this.scrap(slidingWindowAllRows);
                    this.scrap(slidingWindowCurrentRow);
                    this.appendRowFixed(slidingWindowAllRows, slidingWindowCurrentRow);
                    countAllRows = this.getCountRows(slidingWindowAllRows);
                    this.sendProgress(countRowsToFind, countAllRows, elementDatabase);
                    if (countAllRows == countRowsToFind) break;
                    queryGetRows = this.getQuery(initialSqlQuery, countAllRows);
                    slidingWindowCurrentRow.setLength(0);
                } else {
                    this.sendProgress(countRowsToFind, countRowsToFind, elementDatabase);
                    break;
                }
            }
            charPositionInCurrentRow = slidingWindowCurrentRow.length() + 1;
        }
        this.injectionModel.getMediatorUtils().getThreadUtil().remove(elementDatabase);
        return slidingWindowAllRows.toString();
    }

    private String getQuery(String initialSqlQuery, int countAllRows) {
        return initialSqlQuery.replace("${limit}", this.injectionModel.getMediatorVendor().getVendor().instance().sqlLimit(countAllRows));
    }

    private void appendRowFixed(StringBuilder slidingWindowAllRows, StringBuilder slidingWindowCurrentRow) {
        Matcher regexAtLeastOneRow = Pattern.compile(String.format("%s[^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]%s%s%s[^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]+?$", "(?si)", "\\x04", "\\x06", "\\x04")).matcher(slidingWindowCurrentRow);
        Matcher regexRowIncomplete = Pattern.compile("(?si)\\x04[^\\x01-\\x03\\x05-\\x09\\x0B-\\x0C\\x0E-\\x1F]+?$").matcher(slidingWindowCurrentRow);
        if (regexAtLeastOneRow.find()) {
            String allLine = slidingWindowAllRows.toString();
            slidingWindowAllRows.setLength(0);
            slidingWindowAllRows.append(Pattern.compile("(?si)\\x04[^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]+?$").matcher(allLine).replaceAll(""));
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Chunk unreliable, reloading row part...");
        } else if (regexRowIncomplete.find()) {
            slidingWindowAllRows.append(StringUtil.hexstr("05")).append("1").append(StringUtil.hexstr("0804"));
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Chunk unreliable, keeping row parts only");
        }
    }

    private void scrapeTrailJunk(StringBuilder slidingWindowCurrentRow) {
        String currentRow = slidingWindowCurrentRow.toString();
        slidingWindowCurrentRow.setLength(0);
        slidingWindowCurrentRow.append(Pattern.compile("(?si)\\x01\\x03\\x03\\x07.*").matcher(currentRow).replaceAll(""));
    }

    private int getCountRows(StringBuilder slidingWindowCurrentRow) {
        Matcher regexAtLeastOneRow = Pattern.compile(String.format("%s(%s[^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*?%s[^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*?\\x08?%s)", "(?si)", "\\x04", "\\x05", "\\x04")).matcher(slidingWindowCurrentRow);
        int nbCompleteLine = 0;
        while (regexAtLeastOneRow.find()) {
            ++nbCompleteLine;
        }
        return nbCompleteLine;
    }

    private void endInjection(AbstractElementDatabase searchName, Throwable e) throws InjectionFailureException {
        if (searchName != null) {
            Request request = new Request();
            request.setMessage(Interaction.END_PROGRESS);
            request.setParameters(searchName);
            this.injectionModel.sendToViews(request);
        }
        StringBuilder messageError = new StringBuilder("Fetching fails: no data to parse");
        if (searchName != null) {
            messageError.append(" for ").append(StringUtil.detectUtf8(searchName.toString()));
        }
        if (searchName instanceof Table && searchName.getChildCount() > 0) {
            messageError.append(", check Network tab for logs");
        }
        throw new InjectionFailureException(messageError.toString(), e);
    }

    private void sendChunk(String currentChunk) {
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_CHUNK);
        request.setParameters(Pattern.compile("(?si)\\x01\\x03\\x03\\x07.*").matcher(currentChunk).replaceAll("").replace("\\n", "\\\\\\n").replace("\\r", "\\\\\\r").replace("\\t", "\\\\\\t"));
        this.injectionModel.sendToViews(request);
    }

    private int checkInfinite(int loop, String previousChunk, String currentChunk, StringBuilder slidingWindowCurrentRow, StringBuilder slidingWindowAllRows) throws LoopDetectedSlidingException {
        int infiniteLoop = loop;
        if (previousChunk.equals(currentChunk) && ++infiniteLoop >= 20) {
            this.stop();
            throw new LoopDetectedSlidingException(slidingWindowAllRows.toString(), slidingWindowCurrentRow.toString());
        }
        return infiniteLoop;
    }

    private Matcher parseTrailOnlyFound(String sourcePage) {
        String sourcePageUnicodeDecoded = sourcePage;
        if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isUnicodeDecodeDisabled()) {
            sourcePageUnicodeDecoded = StringEscapeUtils.unescapeJava(sourcePageUnicodeDecoded);
        }
        return Pattern.compile(String.format("(?s)%s(?i)%s", "SqLi", "\\x01\\x03\\x03\\x07")).matcher(sourcePageUnicodeDecoded);
    }

    private Matcher parseLeadFound(String sourcePage, String performanceLength) throws InjectionFailureException {
        Matcher regexAtLeastOneRow;
        try {
            regexAtLeastOneRow = Pattern.compile(String.format("(?s)%s(?i)(.{1,%s})", "SqLi", performanceLength)).matcher(sourcePage);
        }
        catch (PatternSyntaxException e) {
            throw new InjectionFailureException("Row parsing failed using capacity", e);
        }
        return regexAtLeastOneRow;
    }

    private void checkSuspend(AbstractStrategy strategy, StringBuilder slidingWindowAllRows, StringBuilder slidingWindowCurrentRow) throws StoppedByUserSlidingException, InjectionFailureException {
        if (this.isSuspended()) {
            throw new StoppedByUserSlidingException(slidingWindowAllRows.toString(), slidingWindowCurrentRow.toString());
        }
        if (strategy == null) {
            throw new InjectionFailureException("Undefined strategy");
        }
    }

    private void scrap(StringBuilder slidingWindowAllRows) {
        String allRowsLimit = slidingWindowAllRows.toString();
        slidingWindowAllRows.setLength(0);
        slidingWindowAllRows.append(Pattern.compile(String.format("%s(%s%s|%s\\d*)$", "(?si)", "\\x06", "\\x04", "\\x05")).matcher(allRowsLimit).replaceAll(""));
    }

    private void sendProgress(int numberToFind, int countProgress, AbstractElementDatabase searchName) {
        if (numberToFind > 0 && searchName != null) {
            Request request = new Request();
            request.setMessage(Interaction.UPDATE_PROGRESS);
            request.setParameters(searchName, countProgress);
            this.injectionModel.sendToViews(request);
        }
    }

    public static List<List<String>> parse(String rows) throws InjectionFailureException {
        Matcher regexSearch = Pattern.compile(String.format("%s%s([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*?)%s([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*?)(\\x08)?%s", "(?si)", "\\x04", "\\x05", "\\x04")).matcher(rows);
        if (!regexSearch.find()) {
            throw new InjectionFailureException();
        }
        regexSearch.reset();
        int rowsFound = 0;
        ArrayList<List<String>> listValues = new ArrayList<List<String>>();
        while (regexSearch.find()) {
            String values = regexSearch.group(1);
            int instances = Integer.parseInt(regexSearch.group(2));
            listValues.add(new ArrayList());
            ((List)listValues.get(rowsFound)).add(Integer.toString(rowsFound + 1));
            ((List)listValues.get(rowsFound)).add("x" + instances);
            for (String cellValue : values.split("\\x7F", -1)) {
                ((List)listValues.get(rowsFound)).add(cellValue);
            }
            ++rowsFound;
        }
        return listValues;
    }
}

