/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.suspendable;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.model.suspendable.callable.CallablePageSource;
import com.jsql.util.LogLevelUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuspendableGetIndexes
extends AbstractSuspendable {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public SuspendableGetIndexes(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public String run(Object ... args) throws JSqlException {
        int nbIndex;
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetIndexes");
        ExecutorCompletionService<CallablePageSource> taskCompletionService = new ExecutorCompletionService<CallablePageSource>(taskExecutor);
        String initialQuery = "";
        int countNormalIndex = this.injectionModel.getMediatorUtils().getPreferencesUtil().isLimitingNormalIndex() ? this.injectionModel.getMediatorUtils().getPreferencesUtil().countNormalIndex() : 50;
        for (nbIndex = 1; nbIndex <= countNormalIndex; ++nbIndex) {
            taskCompletionService.submit(new CallablePageSource(this.injectionModel.getMediatorVendor().getVendor().instance().sqlIndices(nbIndex), this.injectionModel, "normal#" + nbIndex));
        }
        try {
            for (nbIndex = 1; nbIndex <= countNormalIndex; ++nbIndex) {
                if (this.isSuspended()) {
                    throw new StoppedByUserSlidingException();
                }
                CallablePageSource currentCallable = (CallablePageSource)taskCompletionService.take().get();
                if (!Pattern.compile("(?s).*1337\\d+7331.*").matcher(currentCallable.getContent()).matches()) continue;
                this.injectionModel.getMediatorStrategy().getNormal().setSourceIndexesFound(currentCallable.getContent());
                initialQuery = currentCallable.getQuery().replace("0%2b1", "1");
                if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isPerfIndexDisabled()) {
                    initialQuery = initialQuery.replaceAll("1337(?!17331)\\d+7331", "1");
                    LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Calibrating indexes disabled, forcing to index [1]");
                }
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Normal strategy triggered with query [{}]", () -> currentCallable.getQuery().trim().replaceAll("1337(\\d*)7330%2b1", "$1"));
                break;
            }
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return initialQuery;
    }
}

