/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBoolean;
import com.jsql.model.injection.strategy.blind.AbstractInjectionMonobit;
import com.jsql.model.injection.strategy.blind.CallableBlind;
import com.jsql.model.injection.strategy.blind.patch.Diff;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionBlind
extends AbstractInjectionMonobit<CallableBlind> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String sourceReferencePage;
    private List<Diff> falseDiffs = new ArrayList<Diff>();

    public InjectionBlind(InjectionModel injectionModel, AbstractInjectionBoolean.BooleanMode blindMode) {
        super(injectionModel, blindMode);
        if (this.falseTests.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.sourceReferencePage = this.callUrl("", "blind#ref");
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindTagFalse");
        ArrayList<CallableBlind> callablesFalseTest = new ArrayList<CallableBlind>();
        for (String falseTest : this.falseTests) {
            callablesFalseTest.add(new CallableBlind(falseTest, injectionModel, this, blindMode, "blind#falsy"));
        }
        try {
            List futuresFalseTest = taskExecutor.invokeAll(callablesFalseTest);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future futureFalseTest : futuresFalseTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.falseDiffs.isEmpty()) {
                    this.falseDiffs = ((CallableBlind)futureFalseTest.get()).getDiffsWithReference();
                    continue;
                }
                this.falseDiffs.retainAll(((CallableBlind)futureFalseTest.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.cleanTrueDiffs(injectionModel, blindMode);
    }

    private void cleanTrueDiffs(InjectionModel injectionModel, AbstractInjectionBoolean.BooleanMode blindMode) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindTagTrue");
        ArrayList<CallableBlind> callablesTrueTest = new ArrayList<CallableBlind>();
        for (String trueTest : this.trueTests) {
            callablesTrueTest.add(new CallableBlind(trueTest, injectionModel, this, blindMode, "blind#truthy"));
        }
        try {
            List futuresTrueTest = taskExecutor.invokeAll(callablesTrueTest);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future futureTrueTest : futuresTrueTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                this.falseDiffs.removeAll(((CallableBlind)futureTrueTest.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableBlind getCallableBitTest(String sqlQuery, int indexCharacter, int bit) {
        return new CallableBlind(sqlQuery, indexCharacter, bit, this.injectionModel, this, this.booleanMode, "bit#" + indexCharacter + "~" + bit);
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableBlind blindTest = new CallableBlind(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTestBooleanInitialization(), this.injectionModel, this, this.booleanMode, "blind#confirm");
        try {
            blindTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return blindTest.isTrue() && !this.falseDiffs.isEmpty();
    }

    @Override
    public String getInfoMessage() {
        return "- Strategy Blind: query True when Diffs are matching " + this.falseDiffs + "\n\n";
    }

    public String getSourceReferencePage() {
        return this.sourceReferencePage;
    }

    public List<Diff> getFalseDiffs() {
        return this.falseDiffs;
    }
}

