/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBoolean;
import com.jsql.model.injection.strategy.blind.InjectionBlind;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategyInjectionBlind
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private InjectionBlind injectionBlind;

    public StrategyInjectionBlind(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() throws StoppedByUserSlidingException {
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isStrategyBlindDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy Blind disabled");
            return;
        }
        if (StringUtils.isEmpty(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBooleanBlind())) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "No Blind strategy known for {}", (Object)this.injectionModel.getMediatorVendor().getVendor());
            return;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} Blind with STACKED...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"));
        this.injectionBlind = new InjectionBlind(this.injectionModel, AbstractInjectionBoolean.BooleanMode.STACKED);
        this.isApplicable = this.injectionBlind.isInjectable();
        if (!this.isApplicable) {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} Blind with OR...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"));
            this.injectionBlind = new InjectionBlind(this.injectionModel, AbstractInjectionBoolean.BooleanMode.OR);
            this.isApplicable = this.injectionBlind.isInjectable();
            if (!this.isApplicable) {
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} Blind with AND...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"));
                this.injectionBlind = new InjectionBlind(this.injectionModel, AbstractInjectionBoolean.BooleanMode.AND);
                this.isApplicable = this.injectionBlind.isInjectable();
                if (this.isApplicable) {
                    LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} Blind injection with AND", () -> I18nUtil.valueByKey("LOG_VULNERABLE"));
                }
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} Blind injection with OR", () -> I18nUtil.valueByKey("LOG_VULNERABLE"));
            }
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} Blind injection with STACKED", () -> I18nUtil.valueByKey("LOG_VULNERABLE"));
        }
        if (this.isApplicable) {
            this.allow(new int[0]);
            Request requestMessageBinary = new Request();
            requestMessageBinary.setMessage(Interaction.MESSAGE_BINARY);
            requestMessageBinary.setParameters(this.injectionBlind.getInfoMessage());
            this.injectionModel.sendToViews(requestMessageBinary);
        } else {
            this.unallow(new int[0]);
        }
    }

    @Override
    public void allow(int ... i) {
        this.markVulnerability(Interaction.MARK_BLIND_VULNERABLE, new int[0]);
    }

    @Override
    public void unallow(int ... i) {
        this.markVulnerability(Interaction.MARK_BLIND_INVULNERABLE, new int[0]);
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) throws StoppedByUserSlidingException {
        return this.injectionBlind.inject(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBlind(sqlQuery, startPosition), stoppable);
    }

    @Override
    public void activateStrategy() {
        if (this.injectionBlind.getBooleanMode() == AbstractInjectionBoolean.BooleanMode.OR) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Using OR statement, database short-circuit may cause failure");
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Using {} statement", (Object)this.injectionBlind.getBooleanMode().name());
        }
        LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName);
        this.injectionModel.getMediatorStrategy().setStrategy(this.injectionModel.getMediatorStrategy().getBlind());
        Request requestMarkBlindStrategy = new Request();
        requestMarkBlindStrategy.setMessage(Interaction.MARK_BLIND_STRATEGY);
        this.injectionModel.sendToViews(requestMarkBlindStrategy);
    }

    @Override
    public String getPerformanceLength() {
        return "65565";
    }

    @Override
    public String getName() {
        return "Blind";
    }
}

